String  get_CALIBRATE_page()
{
  //NOTES:
  //Creates a string for HTML Page Load and Refresh. More difficult to read than
  //Using progmem string but more flexible
  //use escape(\) and quote(") for ClientToServer eg: \"ClientToServer('timeminus')\"
  //All other instances can use the single quote(')
  // escape and n before closing quotes  ...\n"; provides HTML line feed formatting

  String ht = "";

  ht += insertHTMLHead(""); //HTML Head Text and CSS Styles

  ht +=  "<body  id ='appBody'>\n";
  //ht +=  "<h3><span id = 'pagetitle'><span> </h3>\n";

  //Message Table
  ht += insertMessagesTable("Curve Tracer Messages:");
  ht += "<table><tr>\n";
  ht += insertButton( "mainview", "Main view", "Table");
  ht += insertButton( "version", "Version", "Table");
  ht += "</tr></table>\n";

  ht += "<table>\n";
  ht += "<th>DAC1 Base/Gate Count</th><th> Base uA</th>\n";
  ht += "<tr>\n";
  ht += insertSelect("", "dacbg", " Count", dac1Value , 255, 0, -1, "Table");
  ht += "<td>\n";
  ht += "<span id ='bua'></span>\n";
  ht += "</td>\n";
  ht += "</tr></table>\n";

  ht += "<table>\n";
  ht += "<th>bHiPin mV</th><th>bLoPin mV</th>\n";
  ht += "<tr>\n";
  ht += "<td><span id ='bhipinmv'></span></td>\n";
  ht += "<td><span id ='blopinmv'></span></td>\n";
  ht += "</tr><tr>\n";
  ht += "<td>bHi ScaleFactor</td><td>bLo ScaleFactor</td>\n";
  ht += "</tr><tr>\n";
  ht += "<td><span id ='vsfbhi'></span></td>\n";
  ht += "<td><span id ='vsfblo'></span></td>\n";
  ht += "</tr><tr>\n";
  ht += insertSelect("", "vsfbhiselect", "", vScaleFactorBHi , 900, 1100, 1, "Table");
  ht += insertSelect("", "vsfbloselect", "", vScaleFactorBLo , 900, 1100, 1, "Table");
  ht += "</tr>\n";
  ht += "</table>\n";

  ht += "<br>\n";

  ht += "<table>\n";
  ht += "<th>DAC2 Col / Drain Count </th> <th>N mA </th> <th>P mA </th> \n";
  ht += "<tr>\n";
  ht += insertSelect("", "daccd", " Count", dac2Value, 255, 0, -1, "Table");
  ht += "<td>\n";
  ht += "<span id = 'nma'> </span> \n";
  ht += "</td> \n";
  ht += "<td>\n";
  ht += "<span id = 'pma'> </span> \n";
  ht += " </td> \n";
  ht += " </tr> </table> \n";

  ht += "<table>\n";
  ht += "<th>nHiPin mV </th> <th>nLoPin mV </th> <th>pHiPin mV </th> <th>pLoPin mV </th> \n";
  ht += "<tr>\n";
  ht += "<td><span id = 'nhipinmv'> </span > </td > \n";
  ht += "<td><span id = 'nlopinmv'> </span > </td > \n";
  ht += "<td><span id = 'phipinmv'> </span > </td > \n";
  ht += "<td><span id = 'plopinmv'> </span > </td > \n";
  ht += "</tr>\n";
  ht += "<tr>\n";
  ht += "<td>nHi ScaleFactor</td><td>nLo ScaleFactor</td><td>pHi ScaleFactor</td><td>pLo ScaleFactor</td>\n";
  ht += "</tr><tr>\n";
  ht += "<td><span id ='vsfnhi'></span></td>\n";
  ht += "<td><span id ='vsfnlo'></span></td>\n";
  ht += "<td><span id ='vsfphi'></span></td>\n";
  ht += "<td><span id ='vsfplo'></span></td>\n";
  ht += "</tr><tr>\n";
  ht += insertSelect("", "vsfnhiselect", "", vScaleFactorNHi , 900, 1100, 1, "Table");
  ht += insertSelect("", "vsfnloselect", "", vScaleFactorNLo , 900, 1100, 1, "Table");
  ht += insertSelect("", "vsfphiselect", "", vScaleFactorPHi , 900, 1100, 1, "Table");
  ht += insertSelect("", "vsfploselect", "", vScaleFactorPLo , 900, 1100, 1, "Table");
  ht += "</tr>\n";
  ht += "</table>\n";
  ht += "<br>\n";

  ht += "<table>\n";
  ht += "<th>Emitter Diode Lo mV </th> <th>Emitter Diode Hi mV </th><th>Emitter Diode mV </th> <th>DAC Samples</th>\n";
  ht += "<tr>\n";
  ht += "<td><span id = 'ediodelomv'> </span> </td> \n";
  ht += "<td><span id = 'ediodehimv'> </span> </td> \n";
  ht += "<td><span id = 'nemittermv'> </span> </td> \n";
  ht += "<td><span id = 'adcsamples'> </span> </td> \n";
  ht += "</tr><tr>\n";
  ht += insertSelect("", "ediodeloupdate",  " mV", emitterDiodeLo, 300, 1000, 1, "Table");
  ht += insertSelect("", "ediodehiupdate",  " mV", emitterDiodeHi, 400, 1000, 1, "Table");
  ht += "<td></td>\n";
  ht += insertSelect("", "adcsampleupdate",  " samples", adcOverSampling, 1, 250, 1, "Table");

  ht += "</tr></table>\n";


  ht += "<table>\n";
  ht += "<th>Index</th><th>ADC Count</th><th>mV</th> <th>DAC1 Value </th> \n";
  ht += "<tr>\n";
  ht += "<td><span id = 'adccalindex'> </span> </td> \n";
  ht += "<td><span id = 'adccount'> </span> </td> \n";
  ht += "<td>" + insertTextBox("calmv", "", "", "Send, Next Index, Clear") + "</td>";
  ht += "<td><span id = 'dac1value'> </span> </td> \n";
  ht += "</tr><tr>\n";
  ht += "<td>\n";
  ht += insertButton( "prevcalindex", "Previous Index", "");//td /td added due to "Table"
  ht += insertButton( "nextcalindex", "Next Index", "");//td /td added due to "Table"
  ht += "</td>\n";
  ht += insertButton( "startadccal", "Start ADC Cal", "Table");
  ht += insertButton( "saveadccal", "Save ADC Cal", "Table");
  ht += insertButton( "increasedac1", "DAC1 + ", "Table");
  ht += " </tr>\n";
  ht += " </table>\n";

  //calibration data
  //insertTextArea(String cId, String bId, String sId, String tLText, String tAText, String bText, int rows, int cols)

  ht += insertTextArea("caltextarea", "buttontc", "spanId1", "ADC Calibration Array:", "calText", "No Btn", 15, 50);

  //Instructions
  ht += insertTextArea("textarea", "buttonta", "spanId", "Instructions: ", calInstructionsText, "Save Me", 15, 90);


  //Devices List
  String devicesList = "";
  for (int i = 0; i < 100; i++)
  {
    //if (devices[i] !="")
    //{
    devicesList += (devices[i] + char(13) + char (10) );
    //}
  }
  //String insertTextArea(String cId, String bId, String sId, String tLText, String tAText, String bText, int rows, int cols)
  ht += insertTextArea("devicetextarea", "buttondt", "spanId2", "Device List:", devicesList, "No Btn", 2, 50);
  ht += "<br>\n";


  //Client to Server
  ht +=  "<script>\n";
  ht +=  "function ClientToServer(out) \n";
  ht +=  " {\n";
  ht +=      "connection.send(out + ':'); \n";
  ht +=      "if (out.indexOf('devicelist=') > -1)\n";
  ht +=      "{\n";
  ht +=      "     document.getElementById('devicename').value = out.substring(out.indexOf('=') + 1); \n";
  //ht +=      "     alert('Gotcha'); \n";
  ht +=      "}\n";
  ht +=      "if (out.indexOf('mainview') > -1 || out.indexOf('devicename') > -1 )\n";
  ht +=      "{\n";
  ht +=        "location.reload(); \n"; //refresh the whole page if new HTML Web Page data is sent
  ht +=      "}\n";
  ht +=   "}\n";



  //Server to Client Web Socket Connection Data Comma Separated String
  ht +=  "var connection = new WebSocket('ws://' + location.hostname + ':81/', ['arduino']); \n";
  ht +=  "connection.onmessage = function (state) \n";
  ht +=  "{\n";
  ht +=  "  var str = state.data.split(','); \n";
  //State Array Items
  //htmlMode #0
  //pagetitle #1 not used
  //message #3
  //nhipinmv #4
  //nlopinmv #5
  //phipinmv #6
  //plopinmv #7
  //bhipinmv #8
  //blopinmv #9
  //n mA #10
  //p mA #11
  //b uA #12
  //emitterDiodeLo mV #13
  //emitterDiodeHi mV #14
  //adcRaw bLoPin #15
  // dac1value  dac1Value #16
  // vScaleFactorBHi #17
  // vScaleFactorBLo #18
  // vScaleFactorNHi #19
  // vScaleFactorNLo #20
  // vScaleFactorPHi #21
  // vScaleFactorPLo #22
  // adcCalIndex #23
  // adcCalArray as text #24
  // nEmitterVoltage scaled from diode drop #25
  // adcOverSampling #26


  ht +=  "  var htmlModeH = str[0]; \n";
  ht +=  "  if (htmlModeH.indexOf('Calibrate') > -1)\n";
  ht +=  "  {\n";
  //ht +=  "    var pT = document.getElementById('pagetitle'); \n";
  //ht +=  "    if (pT.innerHTML != str[1] ) pT.innerHTML = str[1]; \n";
  ht +=  "    document.getElementById('message').innerHTML = str[2]; \n";

  ht +=  "    document.getElementById('nhipinmv').innerHTML = str[4]; \n";
  ht +=  "    document.getElementById('nlopinmv').innerHTML = str[5]; \n";
  ht +=  "    document.getElementById('phipinmv').innerHTML = str[6]; \n";
  ht +=  "    document.getElementById('plopinmv').innerHTML = str[7]; \n";
  ht +=  "    document.getElementById('bhipinmv').innerHTML = str[8]; \n";
  ht +=  "    document.getElementById('blopinmv').innerHTML = str[9]; \n";
  ht +=  "    document.getElementById('nma').innerHTML = str[10]; \n";
  ht +=  "    document.getElementById('pma').innerHTML = str[11]; \n";
  ht +=  "    document.getElementById('bua').innerHTML = str[12]; \n";
  ht +=  "    document.getElementById('ediodelomv').innerHTML = str[13]; \n";
  ht +=  "    document.getElementById('ediodehimv').innerHTML = str[14]; \n";
  ht +=  "    document.getElementById('adccount').innerHTML = str[15]; \n";
  ht +=  "    document.getElementById('dac1value').innerHTML = str[16]; \n";

  ht +=  "    document.getElementById('vsfbhi').innerHTML = str[17]; \n";
  ht +=  "    document.getElementById('vsfblo').innerHTML = str[18]; \n";
  ht +=  "    document.getElementById('vsfnhi').innerHTML = str[19]; \n";
  ht +=  "    document.getElementById('vsfnlo').innerHTML = str[20]; \n";
  ht +=  "    document.getElementById('vsfphi').innerHTML = str[21]; \n";
  ht +=  "    document.getElementById('vsfplo').innerHTML = str[22]; \n";

  ht +=  "    document.getElementById('adccalindex').innerHTML = str[23]; \n";
  ht +=  "    document.getElementById('caltextarea').innerHTML = str[24]; \n";
  ht +=  "    document.getElementById('nemittermv').innerHTML = str[25]; \n";
  ht +=  "    document.getElementById('adcsamples').innerHTML = str[26]; \n";



  ht +=  "}\n";//If HTML Mode closing Brace
  ht +=  "}\n";//Function (state) closing Brace
  ht +=  " </script> \n";
  ht +=  " </body>\n";
  ht +=  " </html> \n";
  return ht;
}
