void webSocketEvent(uint8_t num, WStype_t type, uint8_t * payload, size_t length)
{
  IPAddress ip;
  uint16_t f;
  switch (type) 
  {
    case WStype_DISCONNECTED:
      Serial.printf("[%u] Disconnected!\n", num);
      delay(200);
      break;
    case WStype_CONNECTED:
      ip = webSocket.remoteIP(num);//num is websocket number 0,1 etc
      Serial.printf("[%u] Connected from %d.%d.%d.%d url: %s\n", num, ip[0], ip[1], ip[2], ip[3], payload);
      //ip[x] is the IP address (url) for the client associated with web socket x
      break;
    case WStype_TEXT:
      Serial.printf("Socket [%u] Received: % s\n", num, payload);
      String r_state = ""; //received state
      for (int i = 0; i < 100; i++)
      {
        if (char(payload[i] ) == ':' or payload[i] < 32)
        {
          break;
        }
        else
        {
          r_state += char(payload[i]);
          //Serial.println ("ip[0] =" + String (ip[0]) + " - " + "payload:" + String (i) + " = " + String (char(payload[i])));
        }
      }
      Serial.println(r_state);
      handleRequest(r_state);
      break;
  }
}
