String insertClock()
{
  String ht ="";
  ht +=  "<canvas id='clockcanvas' width='100' height='100'style='background-color:silver'></canvas>\n";
  ht +=  "<script>\n";
  ht +=  "var clockcanvas = document.getElementById('clockcanvas'); \n";
  ht +=  "var ctxc = clockcanvas.getContext('2d');\n";
  ht +=  "var radius = clockcanvas.height / 2; \n";
  ht +=  "ctxc.translate(radius, radius);\n";
  ht +=  "radius = radius * 0.90\n";
  ht +=  "setInterval(drawClock, 1000);\n";
  ht +=  "function drawClock() \n";
  ht +=  "{\n";
  ht +=  "drawFace(ctxc, radius); \n";
  ht +=  "drawNumbers(ctxc, radius);\n";
  ht +=  "drawTime(ctxc, radius); \n";
  ht +=  "}\n";

  ht +=  "function drawFace(ctxc, radius)\n";
  ht +=  "{\n";
  ht +=  "var grad; \n";
  ht +=  "ctxc.beginPath();\n";
  ht +=  "ctxc.arc(0, 0, radius, 0, 2 * Math.PI); \n";
  ht +=  "ctxc.fillStyle = 'white';\n";
  ht +=  "ctxc.fill(); \n";
  ht +=  "grad = ctxc.createRadialGradient(0,0,radius*0.95, 0,0,radius*1.05);\n";
  ht +=  "grad.addColorStop(0, '#333'); \n";
  ht +=  "grad.addColorStop(0.5, 'white');\n";
  ht +=  "grad.addColorStop(1, '#333'); \n";
  ht +=  "ctxc.strokeStyle = grad;\n";
  ht +=  "ctxc.lineWidth = radius * 0.1; \n";
  ht +=  "ctxc.stroke();\n";
  ht +=  "ctxc.beginPath(); \n";
  ht +=  "ctxc.arc(0, 0, radius*0.1, 0, 2*Math.PI);\n";
  ht +=  "ctxc.fillStyle = '#333'; \n";
  ht +=  "ctxc.fill();\n";
  ht +=  "}\n";

  ht +=  "function drawNumbers(ctxc, radius) \n";
  ht +=  "{\n";
  ht +=  "var ang;\n";
  ht +=  "var num; \n";
  ht +=  "ctxc.font = radius*0.28 + 'px arial';\n";
  ht +=  "ctxc.textBaseline = 'middle'; \n";
  ht +=  "ctxc.textAlign='center';\n";
  ht +=  "for (num = 1; num < 13; num++)\n";
  ht +=  "{\n";
  ht +=  "ang = num * Math.PI / 6; \n";
  ht +=  "ctxc.rotate(ang);\n";
  ht +=  "ctxc.translate(0, -radius * 0.80); \n";
  ht +=  "ctxc.rotate(-ang);\n";
  ht +=  "ctxc.fillText(num.toString(), 0, 0); \n";
  ht +=  "ctxc.rotate(ang);\n";
  ht +=  "ctxc.translate(0, radius * 0.80); \n";
  ht +=  "ctxc.rotate(-ang);\n";
  ht +=  "}\n";
  ht +=  "}\n";

  ht +=  "function drawTime(ctxc, radius)\n";
  ht +=  "{\n";
  ht +=  "var now = new Date(); \n";
  ht +=  "var hour = now.getHours();\n";
  ht +=  "var minute = now.getMinutes(); \n";
  ht +=  "var second = now.getSeconds();\n";
  //hour
  ht +=  "hour = hour % 12; \n";
  ht +=  "hour=(hour*Math.PI/6)+\n";
  ht +=  "(minute * Math.PI / (6 * 60)) + \n";
  ht +=  "(second*Math.PI/(360*60));\n";
  ht +=  "drawHand(ctxc, hour, radius * 0.5, radius * 0.07); \n";
  //minute
  ht +=  "minute = (minute * Math.PI / 30) + (second * Math.PI / (30 * 60)); \n";
  ht +=  "drawHand(ctxc, minute, radius*0.8, radius*0.07);\n";
  // second
  ht +=  "second = (second * Math.PI / 30); \n";
  ht +=  "drawHand(ctxc, second, radius*0.9, radius*0.02);\n";
  ht +=  "}\n";

  ht +=  "function drawHand(ctxc, pos, length, width)\n";
  ht +=  "{\n";
  ht +=  "ctxc.beginPath();\n";
  ht +=  "ctxc.lineWidth = width; \n";
  ht +=  "ctxc.lineCap = 'round';\n";
  ht +=  "ctxc.moveTo(0, 0); \n";
  ht +=  "ctxc.rotate(pos);\n";
  ht +=  "ctxc.lineTo(0, -length); \n";
  ht +=  "ctxc.stroke();\n";
  ht +=  "ctxc.rotate(-pos); \n";
  ht +=  "}\n";
  ht +=  "</script>\n";
  
return ht;
}
