int adjustEmitterVoltage (int current)
{
  //return 0;
  // uses current times 10 ie 300 = 30 mA
  // ESP32 ADCs return 0 count for 0 to about 180mV  equivalent to about 540MV
  //taking into account the 3 to 1 ADC input voltage dividers.
  //Thus an emitter Diode will push the ADCS into proper reading range 
  //emitter Diode increases the ADC readings by about 0.6 to 1 volt
  //Depending on the forward voltage drop versus forward current
  //This function calculates the forward voltage drop and returns it 
  //So that the Collector and base voltages can be accurate.
  //This formula is for a typical 1N4004 1A 400V silicon diode
  //590 mV at almost zero current rising to about 760mV at 50mA
  //return 590 + (34 * (current))/100;  //34 is ratio of ( 760-590/5)
  //emitterDiodeLo approx 590;   // at just forward biassed <1mA
  // emitterDiodeHi approx 760;   // at 50 mA
  int ratio = (emitterDiodeHi-emitterDiodeLo)/5;
 int retVal = emitterDiodeLo + ((ratio * current)/100);
  //Serial.println ("Emitter Diode mV = " + String (retVal));
  return retVal;//current measured is mA *10 eg 50mA =500

}
