void runNPN()
{
  //set a base current, then scan V Collector
  //set new base and then rescan
  long baseVoltage;
  long baseCurrent;
  int collectorCurrent;
  int collectorVoltage;
  sCounter = 0;
  //base current loop
  dacWrite(bSetPin, 0);
  dacWrite(cSetPin, 0);
  for (int i = 5; i <= 255; i += 50)// Base Current Ramp curves
  {
    dacWrite(bSetPin, i);
    delay (1);
    Serial.println ("Setting new Base current:" + String (i));
    baseVoltage = analogReadScaled(bLoPin);
    baseCurrent = (1000 * (analogReadScaled(bHiPin) - baseVoltage)) / 22000;//mA
    if (baseCurrent <0)
    {
      baseCurrent =0;
    }
    message = "Running NPN. Setting Base Current = " + String (baseCurrent ) + " uA";
    handleWebSocket();
    if (baseCurrent >0)
    {
    for (int j = 5; j < 240; j += 5) //Collector Voltage Ramp
    {
      dacWrite(cSetPin, j);
      delay (1);
      collectorVoltage = analogReadScaled(nLoPin);
      collectorCurrent = (analogReadScaled(nHiPin) - collectorVoltage) / 10; //100 OHM resitor thus ma times 10
      
      collectorVoltage = collectorVoltage -adjustEmitterVoltage (collectorCurrent);
      if (collectorVoltage <0)collectorVoltage =0;
      if (collectorCurrent < 0)
      {
        collectorCurrent = 0;
      }
       if (collectorCurrent > 500)//>50mA
      {
        break;
      }
      sCounter ++;
      if (collectorCurrent > 0)
      {
        cData[0][sCounter] = collectorCurrent;
      }
      else
      {
        cData[0][sCounter] = 0;

      }
      if (collectorVoltage > 0)
      {
        cData[1][sCounter] = collectorVoltage;
      }
      else
      {
        cData[1][sCounter] = 0;
      }
    }
    sCounter ++;
    Serial.println ("Writing 9999");
    cData[0][sCounter] = 9999;
    cData[1][sCounter] = baseCurrent;
    if (collectorCurrent > 500)
    {
      break;
    }
  }
  }
  drawGraph = true;
  dacWrite(bSetPin, 0);
  dacWrite(cSetPin, 0);
}
