void handleRequest(String request)
{
  //Handles request Strings sent from the Client
  Serial.println ("State Received is: " + request);
  if (request == "" )
  {
    return;
  }
  //Switch Web Page Views
  if (request.indexOf("mainview") > -1)
  {
    htmlMode = "Main";
  }
  if (request.indexOf("calibrateview") > -1)
  {
    dac1Value = 0;
    dac2Value = 0;
    dacWrite(bSetPin, dac1Value);
    dacWrite(cSetPin, dac2Value);
    htmlMode = "Calibrate";
  }
  else if (request == "version")
  {
    message = versionNum;
  }

  else if (request == "butreboot")
  {
    ESP.restart();
  }
  else if ( request.indexOf ("startadccal") > -1)
  {
    dac1Value = 0;
    dacWrite(bSetPin, dac1Value);
    adcCalIndex = 0; //Adc calibration array adcCal[2][50]// adcCal[0][0to49] = adc Count, adcCal[1][0 to 49] = mV
  }
  else if (request.indexOf("prevcalindex") > -1)//previous
  {
    if (adcCalIndex > 0)
    {
      adcCalIndex --;
      if (dac1Value > 5)
      {
        dac1Value -= 5;
      }
      else
      {
        dac1Value = 0;
      }
      dacWrite(bSetPin, dac1Value);
      message = ("ADC Cal Index = " + String (adcCalIndex));
    }
  }
  else if (request.indexOf("nextcalindex") > -1)//next
  {
    if (adcCalIndex < adcCalMax - 1)
    {
      adcCalIndex ++;
      if (dac1Value <= 250)
      {
        dac1Value += 5;
      }
      else
      {
        dac1Value = 255;
      }
      dacWrite(bSetPin, dac1Value);
      message = ("ADC Cal Index = " + String (adcCalIndex));
    }
  }

  else if (request.indexOf("calmv=") > -1)
  {
    if (request != "calmv=")//calmv= when clear button pressed
    {
      int tempmV = request.substring (request.indexOf("=") + 1).toInt();
      adcCal[0][adcCalIndex] = adcRaw;
      adcCal[1][adcCalIndex] = tempmV;
      Serial.println ("ADC Calibration Array Index " + String (adcCalIndex) + " is " + String (adcRaw) + "count " + String (tempmV) + "mV");
      if (adcCalIndex < adcCalMax - 1)
      {
        adcCalIndex++;
      }
      dac1Value += 5;
      dacWrite(bSetPin, dac1Value);
    }
  }

  else if (request.indexOf("saveadccal") > -1)
  {
    writeData();
    message = "Data File Saved";
  }
  else if (request == "npn")
  {
    runMode = "NPN Graph";
    graphType = "NPN Graph";
  }
  else if (request == "pnp")
  {
    runMode = "PNP Graph";
    graphType = "PNP Graph";
  }
  //N Mosfet Options
  else if ( request.indexOf("nmosfetoption=Id vs Vgs") > -1)
  {
    nMosfetOption = "Id vs Vgs";
  }
  else if ( request.indexOf("nmosfetoption=RdsOn vs Vgs") > -1)
  {
    nMosfetOption = "RdsOn vs Vgs";
  }

  //N Mosfet
  else if (request == "nmosfet")
  {
    runMode = "N Mosfet Graph";
    Serial.println ("nMosfetOption =" + nMosfetOption);
    if (nMosfetOption == "Id vs Vgs")
    {
      graphType = "N Mosfet Graph0";
    }
    else
    {
      graphType = "N Mosfet Graph1";
    }

  }
  //P Mosfet Options
  else if ( request.indexOf("pmosfetoption=Id vs Vgs") > -1)
  {
    pMosfetOption = "Id vs Vgs";
  }
  else if ( request.indexOf("pmosfetoption=RdsOn vs Vgs") > -1)
  {
    pMosfetOption = "RdsOn vs Vgs";
  }
  //P Mosfet
  else if (request == "pmosfet")
  {
    runMode = "P Mosfet Graph";
    Serial.println ("pMosfetOption =" + pMosfetOption);
    if (pMosfetOption == "Id vs Vgs")
    {
      graphType = "P Mosfet Graph0";
    }
    else
    {
      graphType = "P Mosfet Graph1";
    }
  }
  else if (request == "diode")
  {
    runMode = "Diode Graph";
    graphType = "Diode Graph";
  }
  else if (request == "led")
  {
    runMode = "LED Graph";
    graphType = "LED Graph";
  }
  else if (request == "zener")
  {
    runMode = "Zener Graph";
    graphType = "Zener Graph";
  }
  else if (request == "adctestnpn")
  {
    runMode = "ADC Test NPN";
    graphType = "";
  }
  else if (request == "adctestpnp")
  {
    runMode = "ADC Test PNP";
    graphType = "";
  }
  else if (request == "adctestbase")
  {
    runMode = "ADC Test Base";
    graphType = "";
  }
  else if (request.indexOf("devicename=") > -1)
  {
    String deviceName = request.substring(request.indexOf("=") + 1);
    if (deviceName == "")
    {
      return;
    }
    //check if deviceName is in list
    bool foundIt = false;
    for (int i = 0; i < 100; i ++)
    {
      if (devices[i] == "")
      {
        devices[i] = "~";
      }
    }
    for (int i = 0; i < 100; i ++)
    {

      if (deviceName == devices[i])
      {
        foundIt = true;
        break;
      }
    }
    if (!foundIt)
    {
      devices[99] = deviceName;
      //Sort the names
      sortDevices("LtoH");
      writeDevices();
      message = "Devices List Written:";
    }
  }
  else if (request.indexOf("devicelist=") > -1)
  {
    deviceSelected = request.substring(request.indexOf("=") + 1);
  }
  else if (request.indexOf("deletedevice") > -1)
  {
    for (int i = 0; i < 100; i ++)
    {
      if (devices[i] == deviceSelected)
      {
        Serial.println ("Device Found: " + deviceSelected + " at Number: " + String (i));
        devices[i] = "~";
        sortDevices("LtoH");
        writeDevices();
        message = "Device Name Deleted:" + deviceSelected;
        deviceSelected = "";
        break;
      }
    }
  }
  else if (request.indexOf("dacbg=") > -1)//DAC1 Base mA/Gate mV
  {
    int tempDAC1 = request.substring(request.indexOf("=") + 1).toInt();
    Serial.println ("Setting DAC1 to " + String (tempDAC1));
    dacWrite (bSetPin, tempDAC1); //Set Base
    dac1Value = tempDAC1;
    message = "Base/Gate DAC1 set to " + String (tempDAC1);
  }
  else if (request.indexOf("daccd=") > -1)//DAC2 Col/Drain mV
  {
    int tempDAC2 = request.substring(request.indexOf("=") + 1).toInt();
    Serial.println ("Settign DAC2 to " + String (tempDAC2));
    dacWrite (cSetPin, tempDAC2); //Set Collector
    dac2Value = tempDAC2;
    message = "Col/Drain DAC2 set to " + String (tempDAC2);
  }
  else if (request.indexOf("ediodehiupdate") > -1)
  {
    emitterDiodeHi = request.substring(request.indexOf("=") + 1).toInt();
    writeData();
  }
  else if (request.indexOf("ediodeloupdate") > -1)
  {
    emitterDiodeLo = request.substring(request.indexOf("=") + 1).toInt();
    writeData();
  }
  else if (request.indexOf("increasedac1") > -1)//DAC1 increase
  {
    dac1Value ++;
    if (dac1Value > 255)
    {
      dac1Value = 0;
    }
    dacWrite(bSetPin, dac1Value);
  }
  else if (request.indexOf("vsfbhiselect") > -1)
  {
    vScaleFactorBHi = request.substring(request.indexOf("=") + 1).toInt();
    message = " bHi pin Scale factor now: " + String (vScaleFactorBHi);
    writeData();
  }
  else if (request.indexOf("vsfbloselect") > -1)
  {
    vScaleFactorBLo = request.substring(request.indexOf("=") + 1).toInt();
    message = " bLO pin Scale factor now: " + String (vScaleFactorBLo);
    writeData();
  }
  else if (request.indexOf("vsfnhiselect") > -1)
  {
    vScaleFactorNHi = request.substring(request.indexOf("=") + 1).toInt();
    message = " nHi pin Scale factor now: " + String (vScaleFactorNHi);
    writeData();
  }
  else if (request.indexOf("vsfnloselect") > -1)
  {
    vScaleFactorNLo = request.substring(request.indexOf("=") + 1).toInt();
    message = " nLo pin Scale factor now: " + String (vScaleFactorNLo);
    writeData();
  }
  else if (request.indexOf("vsfphiselect") > -1)
  {
    vScaleFactorPHi = request.substring(request.indexOf("=") + 1).toInt();
    message = " pHi pin Scale factor now: " + String (vScaleFactorPHi);
    writeData();
  }
  else if (request.indexOf("vsfploselect") > -1)
  {
    vScaleFactorPLo = request.substring(request.indexOf("=") + 1).toInt();
    message = " pLo pin Scale factor now: " + String (vScaleFactorPLo);
    writeData();
  }
  else if (request.indexOf("adcsampleupdate") > -1)     //adcsampleupdate=147
  {
    adcOverSampling = request.substring(request.indexOf("=") + 1).toInt();
    message = " ADC Sampling is now: " + String (adcOverSampling);
    writeData();
  }



}
