String assembleStateArray()
{
  //This function creates a string called state,
  //that is the data that is sent from the Server to the Client
  //it is a comma separated data stream
  //At the client the data is parsed into a string array called str[]
  //With the index number the same as the sent parameter or data.
  //These strings are used to populate the web page using
  //HTML span controls as well as .InnerHTML , .value and .style properties.
  //In general each control has a control ID that is unique and permits
  //the updating of control text,value,colours from the web Socket State Array sent to the client.

  String state = "";//the data String
  String sep = ",";//the comma separator
  //Serial.println("****************************");
  //Serial.println ("HTML Mode is: " + htmlMode);
  if (htmlMode == "Main" )
  {
    state += htmlMode + sep; //0
    state += "" + sep; //1  //Was used for Page Title Now Spare
    //message = String (random(20));
    state += message + sep; //2
    state += graphType + sep;//3
    state += String (drawGraph) + sep; //4
    state += deviceSelected + sep;//5
    state += sep;//6
    state += sep;//7
    state += sep;//8
    state += String (sCounter + 1) + sep; //9
    if (drawGraph)
    {
      for (int i = 0; i < sCounter + 1; i++)
      {
        state += String (cData[0][i]) + sep;//
        state += String (cData[1][i]) + sep;
      }
    }
    if (drawGraph)
    {
      drawGraph = false;
    }
  }
  if (htmlMode == "Calibrate" )
  {
    state += htmlMode + sep; //0
    state += "Calibrate" + sep;//1
    state += message + sep;//2
    state += "" + sep;//3
    int nVHi = analogReadScaled(nHiPin);
    state += String (nVHi) + sep;//4
    int nVLo = analogReadScaled(nLoPin);
    state += String (nVLo) + sep;//5
    int pVHi = analogReadScaled(pHiPin);
    state += String (pVHi) + sep;//6
    int pVLo = analogReadScaled(pLoPin);
    state += String (pVLo) + sep;//7
    int bVHi = analogReadScaled(bHiPin);
    state += String (bVHi) + sep;//8
    int bVLo = analogReadScaled(bLoPin);
    state += String (bVLo) + sep;//9
    if (nVHi < nVLo)
    {
      state += "0.0" + sep; //10  n col mA
    }
    else
    {
      state += String (format2Dp(nVHi - nVLo)) + sep; //10  n col mA
    }
    if (pVHi < pVLo)
    {
      state += "0.0" + sep;  //11 p col mA
    }
    else
    {
      state += "-" + String (format2Dp(pVHi - pVLo)) + sep; //11 p col mA
    }
    state += String ((bVHi - bVLo) / 22) + sep; //12 base uA
    state += String (emitterDiodeLo) + sep;//13
    state += String (emitterDiodeHi)  + sep;//14
    state += String (adcRaw)  + sep;   //15
    state += String (dac1Value) + sep; //16
    state += String (vScaleFactorBHi) + sep; //17
    state += String (vScaleFactorBLo) + sep; //18
    state += String (vScaleFactorNHi) + sep; //19
    state += String (vScaleFactorNLo) + sep; //20
    state += String (vScaleFactorPHi) + sep; //21
    state += String (vScaleFactorPLo) + sep; //22
    state += String (adcCalIndex) + sep; //23

    String tempText = "";
    for (int i = 0 ; i < adcCalMax; i++) //0 to 51
    {
      tempText += String (i) + " " + String (adcCal[0][i]) + " count  " + String (adcCal[1][i]) + " mV" + char(13) + char(10); ;
    }
    state += tempText + sep; //24
    state += String (adjustEmitterVoltage((nVHi - nVLo) / 10)) + sep; //25
    state += String (adcOverSampling) + sep; //26

  }

  if (htmlMode == "AP" )
  {
    state += htmlMode + sep; //0
    state += "Network Settings" + sep;//1
    state += ssid + sep;//2
    state += password + sep;//3
    state += ipToString(ipAdd) + sep;//4
    state += ipToString(ipGw) + sep;//5
    state += ipToString(ipDns) + sep;//6
    state += ipToString(ipSnm) + sep;//7
  }
  return state;
}
