/*
     Curve Tracer
     Board: ESP32 Dev Module
*/

String versionNum = "(C) P J Webb Ver 1.5.1 13/01/2024 ESP32 Dev Kit";
//Board: ESP32 Dev Kit - ESP32 Dev Module

//********IMPORTANT********
//Set both the OP Amp Feedback Pots to mid points to give a starting gain of 2.
//or alternatively 7500 Ohm at the ground end and 12500 Ohm at the feedback end for a gain of 2.7
//Then adjust later as per user manual.
//Set the Network credentials in the //WiFi Network Variables section below.
//********IMPORTANT********


//Boards Manager
//In Versions 2.x.x of the Arduino IDE, install the ESP32 by Espressif boards using the Boards Manager Tab 
//at the Left Hand side Panel.
//Filter for ESP32 then install the ESP32 by Espressif Boards.
//
//In earlier versions of the IDE use the Preferences window as follows.
//In File/Preferences Menu select the text box Additional Boards Manager URLs :
//To the right of the text box is an Icon to click to open up the box.
//Install by pasting the following link into File/Preferences Menu Additional Boards Manager URLs.
//Unfortunately when you click on the link it opens the json file but you need to just get the link text.
//When the site opens, click the address box to highlight(select) the whole URL.
//Then right mouse to copy and then you can paste it into the Additional Boards Manager URL text box.
//https://raw.githubusercontent.com/espressif/arduino-esp32/gh-pages/package_esp32_index.json


//Libraries
//Install by clicking on the Link below, when opened, click the Green Code Button then Download .ZIP.  Install from the IDE menu Sketch/Include Library/Add .ZIP Library,
//Navigate to the downloaded file , select it and click Open.
//ArduinoWebSockets  https://github.com/Links2004/arduinoWebSockets  (arduinoWebsockets-master.zip)
//If any Library errors pop up you may have to search for a specific library and install.
//Search for "Help with installing Arduino Libraries" 

#include <WiFi.h>
#include <WebSocketsServer.h>
#include <WebServer.h>
#include "FS.h"
#include <LittleFS.h>
#include "calInstructions.h"

//ADC
#define nHiPin 36  //ADC
#define nLoPin 39  //ADC
#define pHiPin 34  //ADC
#define pLoPin 35 //ADC
#define bHiPin 33  //ADC
#define bLoPin 32  //ADC
//DAC
#define bSetPin 26 //DAC1
#define cSetPin 25 //DAC2

int adcRaw =0;
int dac1Value =0;
int dac2Value =0;
const int adcCalMax = 52;//index 0 to 51  51 *5 = 255
int adcCal[2][adcCalMax]; //[0][x] = count; [1][x] = mV
int adcOverSampling = 150;//number of ADC samples per mV reading

//
#define onboardLed 2

//Emitter Diode Defaults - Corrent in Calibrate
int emitterDiodeLo = 670;//mV forward biassed approx 10mA with D1
int emitterDiodeHi = 790; //mV at 50mA + D1 pre-bias.
int nEmitterVoltage =0; //mV derived from n current and diode voltage drop calibration

//WiFi Network Variables
//The next 6 lines must be modified to suit your network connection
String ssid = "";        // REPLACE_WITH_YOUR_WIFI_SSID
String password = "";  //REPLACE_WITH_YOUR_WIFI_PASSWORD
IPAddress ipAdd(10, 0, 0, 85);      //REPLACE with The fixed IP Address you want for your ESP32 **** IMPORTANT **** put this IP Address in the next line also! doneString with dots as separators
IPAddress ipGw(10, 0, 0, 138);     //The GateWay Address. The IP Address of your Router     eg "192,168,1,150";
IPAddress ipDns(10, 0, 0, 138);    //The DNS Address.     The IP Address of your Router     eg "192,168,1,150";
IPAddress ipSnm(255, 255, 255, 0); //SubNet Mask - Usually 255,255,255,0
int wifiTimeout= 30;
//Server Variables
const unsigned int serverPort = 85;
WebServer server(serverPort);//Server on port 85
WebSocketsServer webSocket = WebSocketsServer(81);
String hostName = "CurveTracer";

//ADC Scaling ESP ADC is non Linear, cannot resolve below 0.2V and above 3.1V
int vScaleFactorNHi =  1000;  //9V to 3.1 V scaling: 1000 * 9/3.1
int vScaleFactorNLo =  1000; 
int vScaleFactorPHi =  1000; 
int vScaleFactorPLo =  1000; 
int vScaleFactorBHi =  1000; 
int vScaleFactorBLo =  1000; 
//Graph Variables
unsigned int sCounter = 0; //Sample Counter
unsigned int cData[2][2000];//curve Data

//Control Modes
String runMode = "";
String htmlMode = "Main";//or "Calibrate"
String graphType = "NPN Graph";//default
bool drawGraph = false;
String nMosfetOption = "Id vs Vgs";//"RdsOn vs Vgs";
String pMosfetOption = "Id vs Vgs";//"RdsOn vs Vgs";
int adcCalIndex =0;

//Timers and time variables
unsigned int webSocketRun = 1000;//run webSocket Loop milliseconds
unsigned int webSocketTimerStart;//Start Time for Web Socket Data Response

//Messages
String message = "Curve Tracer."; // General operation messages

//Colours
String buttonBackColour = "green";
String buttonTextColour = "white";
String sliderKnobColour = "white";
String sliderBackColour = "green";

//Device List Variables
String devices[100];
String deviceSelected = "";

//LittleFS Variables
volatile bool filesystemOK = false;

void setup()
{
  pinMode (onboardLed, OUTPUT);
  dacWrite(bSetPin, dac1Value);
  dacWrite(cSetPin, dac2Value);
  Serial.begin (115200);
  Serial.println ("Booting Curve tracer");
  Serial.println (versionNum);
  //analogSetAttenuation(ADC_11db);
  //analogSetWidth(11);               // 11Bit resolution
  initFileSystem();
  readDataFile();
  readDevices();
  Serial.println (" ");
  Serial.println ("**********Configuring WiFi*********** ");
  ipDns = ipGw;//set to router address
  WiFi.config(ipAdd, ipGw, ipSnm, ipDns);
  WiFi.setHostname(hostName.c_str()); //define hostname
  //Convert String ssid and password to char arays for WiFi.begin
  WiFi.begin(ssid.c_str(), password.c_str());
  Serial.println ("SSID: " + ssid);
  Serial.println ("Password: " + password);
  Serial.print ("IP Add: ");
  Serial.println (ipAdd );
  Serial.print ("GW: ");
  Serial.println (ipGw);
  Serial.print ("DNS: ");
  Serial.println (ipDns);
  Serial.print ("SNM: ");
  Serial.println (ipSnm);
  Serial.println("");

  // Wait for connection
  Serial.println ("**********Connecting WiFi*********** ");
  int counter = 0;
  while (WiFi.status() != WL_CONNECTED)
  {
    digitalWrite (onboardLed,HIGH);
    delay (1000);
    Serial.print(".");
    counter ++;
    digitalWrite (onboardLed,LOW);
    if (counter > wifiTimeout)
    {
      Serial.println ("Cannot find WiFi network.");
      counter =0;
    }
  }
  Serial.println("");
  Serial.println("WiFi connected..!");
  Serial.print("Got IP: ");
  Serial.println(WiFi.localIP());
  for (int i = 0;i <5;i++)
  {
    digitalWrite (onboardLed,HIGH);
    delay (500);
    digitalWrite (onboardLed,LOW);
  }

  Serial.println ("**********Starting Web Socket*********** ");
  webSocket.begin();
  webSocket.onEvent(webSocketEvent);
  server.on("/", handlePage);
  server.begin();
  Serial.println("HTTP server started");

}

void loop()
{
  handleWebSocket();
  checkRunMode();
}
