
#include <SPI.h>
#include <SdFat.h>
#include <DHT.h>
#include <VirtualWire.h>
#include <Time.h>


const int switchpin=4;
const int numberOfAnalogPins = 6; 
int data[numberOfAnalogPins];
const int dataBytes = numberOfAnalogPins * sizeof(int); 
#define DHTPIN 3     // what pin we're connected to
#define DHTTYPE DHT22   // DHT 22  (AM2302)

int switchval=1;
int id1=7938;
int chk=0;
int dl=5000;    //Delay set time, Change it as per your requirements
DHT dht(DHTPIN, DHTTYPE);

//button clock
const int buttonHr = A0; 
const int buttonMin = A1; 
int secs =0;
int secs2 = 0;
int mins = 0;
int hrs = 12;

boolean switchpress = false;

//button clock

const uint8_t chipSelect = SS;
const uint32_t SAMPLE_INTERVAL_MS = 200;
#define FILE_BASE_NAME "Data"
SdFat sd;
SdFile file;
uint32_t logTime;
const uint8_t ANALOG_COUNT = 4;

void send (byte *data, int nbrOfBytes) {
vw_send(data, nbrOfBytes);
vw_wait_tx(); // Wait until the whole message is gone
}

//collect data
void collect() {
  float h = dht.readHumidity();
  float t = dht.readTemperature();
  float f = dht.readTemperature(true);
  data[0]=id1;
  data[1]=h*100;
  data[2]=t*100;
  data[3]=chk;
  chk=chk+dl/1000;
  if(chk>59) chk=0;
  data[4]=hrs;
  data[5]=mins;
}

// Write data header.
void writeHeader() {
  file.print(F(":1 Time Date   "));
    file.print(F("Chk-ID "));
    file.print(F("Humidity "));
    file.print(F("Temp-C "));
    file.print(F("   Inc."));
  //  file.print(i, DEC);
  file.println();
}

// Log a data record.
void logData() {
String dataString = "";
//  collect();
  dataString = String(hour())+String(":")+String(minute())+String(":")+String(second())+String(" ")+String(day()) +String("-")+String(month())+String("-")+String(year()-2000)+String(" ");
  file.print(dataString);
  dataString= String(data[0])+String("   ")+String(data[1])+String("     ")+String(data[2])+String("    ")+String(data[3]);
  file.println(dataString);
 }

// Error messages stored in flash.
#define error(msg) sd.errorHalt(F(msg))

void setup() {

  pinMode(buttonHr, INPUT);
  pinMode(buttonMin, INPUT);
  setTime(00,00,0,8,7,15);
  pinMode(switchpin, INPUT);

//  const uint8_t BASE_NAME_SIZE = sizeof(FILE_BASE_NAME) - 1;
//  char fileName[13] = FILE_BASE_NAME "00.csv";
  
  
  dht.begin();
//  Serial.begin(9600);
  vw_set_tx_pin(2);    //Tx. Data pin connected on D2
  vw_setup(2000); // Bits per sec
  delay(2000); 

  const uint8_t BASE_NAME_SIZE = sizeof(FILE_BASE_NAME) - 1;
  char fileName[13] = FILE_BASE_NAME "00.csv";

  if (!sd.begin(chipSelect, SPI_FULL_SPEED)) sd.initErrorHalt();
   // Find an unused file name.
  if (BASE_NAME_SIZE > 6) error("FILE_BASE_NAME too long");
  while (sd.exists(fileName)) {
    if (fileName[BASE_NAME_SIZE + 1] != '9') {
      fileName[BASE_NAME_SIZE + 1]++;
    } else if (fileName[BASE_NAME_SIZE] != '9') {
      fileName[BASE_NAME_SIZE + 1] = '0';
      fileName[BASE_NAME_SIZE]++;
    } else {
      error("Can't create file name");
    }
  }
  if (!file.open(fileName, O_CREAT | O_WRITE | O_EXCL)) {
    error("file.open");
  }
  writeHeader();

}

//------------------------------------------------------------------------------

void loop() {
  switchval=digitalRead(switchpin);
  collect();
  send((byte*)data, dataBytes);
//clock
//detect button pressing
      if(digitalRead(buttonHr) == HIGH) {
              switchpress=true;
              delay(25);
              hrs = hrs+1;
              updateHrs();
              setTime(hrs,mins,0,6,7,15);
                         }

      if(digitalRead(buttonMin) == HIGH) {
              switchpress=true;
              delay(25);
              mins = mins + 1;
              updateMin();
              setTime(hrs,mins,0,6,7,15);
              }    

//clock
  logData();
   delay(dl);
 
  // Force data to SD and update the directory entry to avoid data loss.
  if (!file.sync() || file.getWriteError()) {
    error("write error");
  }

    if(switchval==0){
     // Close file and stop.
    file.close();
    Serial.println(F("Done"));
    while(1) {}
      }

}

//loop ends 



//clock functions
  void updateMin(){
      if(mins > 59){
        hrs = hrs+1;
        updateHrs();  //update hours then
        mins = 0;  //reset mins
      }
  }
  
  void updateHrs(){
 //      if(hrs> 12) hrs = 1;
         if(hrs> 23) hrs = 0;
  }


