//UV Monitor

#include "TinyWireM.h"
#include "Tiny4kOLED.h"

uint8_t width = 128;
uint8_t height = 64; 

int Vout = 0;
int UVI =0;
int OUVI=0;
int UVraw = 0;
int UVpix = 0;
int value = 0;
int average = 0;
int UVrad = 0;

void setup() {
  oled.begin(width, height, sizeof(tiny4koled_init_128x64br), tiny4koled_init_128x64br);

  #define PIEZO 1
  pinMode(PIEZO, OUTPUT);
  pinMode(A2, INPUT);
  int analogPin = A2;  // UVM-30A output mV
  #define analogPin A2

  oled.setFont(FONT6X8);
  oled.on();
  oled.clear();
  oled.setCursor(0, 0);
  oled.print("     UV Monitor");
  oled.setCursor(0, 1);
  oled.fillToEOL(0x10);
  oled.setFont(FONT6X8);
  oled.setCursor(0, 2);
  oled.print("0   2   4   6   8  10");
  oled.setCursor(0, 3);
  oled.fillToEOL(0x10);
  
}

void loop() {
  for(int i = 0; i<10; i++){
    average = average + (analogRead(A2));
  }
  average = average/10;
  UVraw = average;
  Vout = UVraw*(5000/1023);
  
  if(UVraw <= 41){
    UVpix = (2*UVraw/7);
  }
  else if(UVraw > 41 && UVraw <= 280){
   UVpix  = 5*UVraw/10 - 14;
  }
  else if (UVraw >280){
    UVpix = 127;
  }
  if(Vout <= 200){
    UVrad = Vout/10;
  }
  if(Vout > 200){
    UVrad = (Vout - 100)/4;
  }
  oled.setCursor(0, 4);
  oled.fillLength(30, UVpix);
  oled.setCursor(UVpix, 4);
  oled.fillLength(0, 128-UVpix);
  
  oled.setCursor(0, 5);
  oled.fillLength(30, UVpix);
  oled.setCursor(UVpix, 5);
  oled.fillLength(0, 128-UVpix);
  if(Vout <= 100){
    UVI = 0;
  }
  else if(Vout > 100 && Vout <=275){
    UVI = 1;
  }
  if(Vout>275){
    UVI = (Vout - 50)/100;
  }
  oled.setFont(FONT6X8);
  oled.setCursor(0, 7);
  oled.print("INDEX ");
  oled.print(UVI);
  oled.print("    ");
  oled.print("mW/m2 ");

  if(UVI != OUVI){
    oled.print("    ");
  } else {
    oled.print(UVrad);
  }
  OUVI = UVI;
  

  delay(100);
 /*
  if(UVI != OUVI){
  oled.print("    ");
  }
  else{
  oled.print(UVpix);
  }
  OUVI = UVI;
 */
  if (UVI > 8){  // Alarm above UV Index 8
    digitalWrite(PIEZO, HIGH);
  } else {
    digitalWrite(PIEZO, LOW);
  }
}
