#define ENABLE_GxEPD2_GFX 1
#include <GxEPD2_BW.h>
#include <GxEPD2_3C.h>
#include <GxEPD2_7C.h>
#include <Fonts/FreeMonoBold9pt7b.h>
#include "GxEPD2_display_selection.h"
#include <Time.h>

#include <Wire.h>
#include <RtcDS3231.h>
RtcDS3231<TwoWire> Rtc(Wire);

#define DS3231_I2C_ADDR             0x68
#define DS3231_TEMPERATURE_ADDR     0x11

/* ESP32 Connections
CS=5, DC=2, RST=4, BUSY=15, CSK=18. Din=23
E-paper display=GDEW075T7 800x480
*/

uint16_t width;
uint16_t height;
uint16_t ccenterx,ccentery;//center x,y of the clock
const uint16_t cradius = 2.65*63*1.5;//radius of the clock
const float scosConst = 0.0174532925;
float sx = 0, sy = 1, mx = 1, my = 0, hx = -1, hy = 0;
float sdeg=0, mdeg=0, hdeg=0;
uint16_t osx,osy,omx,omy,ohx,ohy;
uint16_t x0 = 0, x1 = 0, yy0 = 0, yy1 = 0;
int vshift=0;  //8
int thick=4;
int h_thick=8;
int m_thick=6;
int s_thick=4;
String dg;
int st=40;
String dow[7]  = {"Sunday","Monday","Tuesday","Wednesdy","Thursday","Friday","Saturday"};  // Sunday is dayOfWeek 0
String moy[12] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"}; // January is month 0
int p,q,p1,q1,hr;
int hshift=155;
int pl=0;
#define I2C_SDA 16    
#define I2C_SCL 17    

  int startDay = 0; // Sunday's value is 0, Saturday is 6
  String week1 ="";
  String week2 ="";
  String week3 ="";
  String week4 ="";
  String week5 ="";
  int newWeekStart = 0; // used to show start of next week of the month
  char monthString2[37]= {"JanFebMarAprMayJunJulAugSepOctNovDec"};
  int  monthIndex2[122] ={0,3,6,9,12,15,18,21,24,27,30,33};
  char monthName2[3]="";
  int monthLength = 0;

void setup() {
Serial.begin(115200);    Serial.print("compiled: ");
    Serial.print(__DATE__);
    Serial.println(__TIME__);

    //--------RTC SETUP ------------
    // if you are using ESP-01 then uncomment the line below to reset the pins to
    // the available pins for SDA, SCL
    Wire.begin(I2C_SDA, I2C_SCL);  
   // Wire.begin(16,17); // due to limited pins, use pin 0 and 2 for SDA, SCL
    Rtc.Begin();
   RtcDateTime compiled = RtcDateTime(__DATE__, __TIME__);
    printDateTime(compiled);
    Serial.println();

    if (!Rtc.IsDateTimeValid())     {
        // Common Cuases:
        //    1) first time you ran and the device wasn't running yet
        //    2) the battery on the device is low or even missing

        Serial.println("RTC lost confidence in the DateTime!");

        // following line sets the RTC to the date & time this sketch was compiled
        // it will also reset the valid flag internally unless the Rtc device is
        // having an issue

        Rtc.SetDateTime(compiled);
    }

    if (!Rtc.GetIsRunning()) {
        Serial.println("RTC was not actively running, starting now");
        Rtc.SetIsRunning(true);
    }

    RtcDateTime now = Rtc.GetDateTime();
    if (now < compiled)     {
        Serial.println("RTC is older than compile time!  (Updating DateTime)");
        Rtc.SetDateTime(compiled);
    }
    else if (now > compiled)  {
        Serial.println("RTC is newer than compile time. (this is expected)");
    }
    else if (now == compiled) 
    {
        Serial.println("RTC is the same as compile time! (not expected but all is fine)");
    }

    // never assume the Rtc was last configured by you, so
    // just clear them to your needed state
    Rtc.Enable32kHzPin(false);
    Rtc.SetSquareWavePin(DS3231SquareWavePin_ModeNone); 
  delay(100);
  //display.init(115200); // default 10ms reset pulse, e.g. for bare panels with DESPI-C02
  display.init(115200, true, 2, false); // USE THIS for Waveshare boards with "clever" reset circuit, 2ms reset pulse
  width = display.width();
  height =display.height();
  ccenterx = width/2;
  ccentery = height/2+10;
}

void loop() {
if (display.epd2.hasPartialUpdate)  {
     showPartialUpdate();
  }
}


int k=0;
void showPartialUpdate() {
  uint16_t box_x = 10;
  uint16_t box_y = 15;
  uint16_t box_w = width;  //70;
  uint16_t box_h = height;  //20;
  uint16_t incr = display.epd2.hasFastPartialUpdate ? 1 : 3;
  display.setFont(&FreeMonoBold9pt7b);
  display.setTextColor(GxEPD_WHITE);
    display.setRotation(0);
    display.setTextSize(2);   //1
    display.setPartialWindow(box_x, box_y, box_w, box_h);
    for (;;){  
      RtcDateTime t = Rtc.GetDateTime(); 
      //RtcTemperature temp = Rtc.GetTemperature();
      float tempC = DS3231_get_treg(); 
      display.firstPage();
      do  {
        display.fillRect(0,0, box_w, box_h, GxEPD_BLACK);
        drawClockFace();
        drawClockHands(t.Hour(),t.Minute(),t.Second());
        display.setCursor(width-270,55);  //29.  //cursor_y);
        display.setTextSize(3);   //1
        display.print( printDigits(t.Hour())+":"+printDigits(t.Minute())+":"+printDigits(t.Second()) );
        display.setCursor(width-270,105);  //29.  //cursor_y);
        display.print( dow[t.DayOfWeek()] );
        display.setCursor(width-270,155);
        display.print( printDigits(t.Day())+"'"+moy[t.Month()-1] );
        display.setCursor(width-270,205);
        display.print(String(tempC)+"C" );
 
//*************************** Calendar code starts here **********************
 if (t.Month() == 1 || t.Month() == 3 || t.Month() == 5 || t.Month() == 7 || t.Month() == 8 || t.Month() == 10 || t.Month() == 12){
    monthLength = 31;
  }
  else {monthLength = 30;}
  if(t.Month() == 2){monthLength = 28;}
  startDay = startDayOfWeek(t.Year(),t.Month(),1); // Sunday's value is 0
  // now build first week string
  switch (startDay){
    case 0:
      // Sunday
      week1 = " 1  2  3  4  5  6  7";
      break;
    case 1:
      // Monday
      week1 = "    1  2  3  4  5  6";
      break;      
     case 2:
      // Tuesday
      week1 = "       1  2  3  4  5";
      break;           
     case 3:
      // Wednesday
      week1 = "          1  2  3  4";
      break;  
     case 4:
      // Thursday
      week1 = "             1  2  3";
      break; 
     case 5:
      // Friday
      if(monthLength == 28 || monthLength == 30){week1 = "                1  2";}      
      if(monthLength == 31){week1 = "31              1  2";}      
      break; 
     case 6:
      // Saturday
      if(monthLength == 28){week1 = "                   1";}
      if(monthLength == 30){week1 = "30                 1";}      
      if(monthLength == 31){week1 = "30 31              1";}       
      
      break;           
  } // end first week
  newWeekStart = (7-startDay)+1;
  const char* newWeek1 = (const char*) week1.c_str();  
   // display week 2
  week2 ="";
  for (int f = newWeekStart; f < newWeekStart + 7; f++){
    if(f<10){
      week2 = week2 +  " " + String(f) + " ";
    }  
    else{week2 = week2 + String(f) + " ";}    
  }
  const char* newWeek2 = (const char*) week2.c_str();  
  newWeekStart = (14-startDay)+1; 
  week3 ="";
  for (int f = newWeekStart; f < newWeekStart + 7; f++){
    if(f<10){
      week3 = week3 +  " " + String(f) + " ";
    }  
    else{week3 = week3 + String(f) + " ";}    
  }
  const char* newWeek3 = (const char*) week3.c_str();  
  newWeekStart = (21-startDay)+1; 
  week4 ="";
  for (int f = newWeekStart; f < newWeekStart + 7; f++){
    if(f<10){
      week4 = week4 +  " " + String(f) + " ";
    }  
    else{week4 = week4 + String(f) + " ";}    
    }
   const char* newWeek4 = (const char*) week4.c_str();  
   week5="";
   newWeekStart = (28-startDay)+1;   
   // is is February?
   if(newWeekStart > 28 && t.Month() == 2){
   // do nothing unless its a leap year
     if (t.Year()==(t.Year()/4)*4){ // its a leap year
       week5 = "29";
     }       
   }
   else{ // print up to 30 anyway
     if(t.Month() == 2){  // its February
       for (int f = newWeekStart; f < 29; f++){
         week5 = week5 + String(f) + " ";  
       }  
       // is it a leap year
       if (t.Year()==(t.Year()/4)*4){ // its a leap year
         week5 = week5 + "29";
       }        
     }
     else{
       for (int f = newWeekStart; f < 31; f++){
         week5 = week5 + String(f) + " ";
       }
       // are there 31 days
       if (monthLength == 31 && week5.length() <7){
         week5 = week5 + "31"; 
       } 
     } 
   }
   const char* newWeek5 = (const char*) week5.c_str();  
   /*
   Serial.println("Su Mo Tu We Th Fr Sa");
   Serial.println(week1);  
   Serial.println(week2);  
   Serial.println(week3); 
   Serial.println(week4);    
   Serial.println(week5); 
   */ 
  display.setTextSize(1); 
  int x1=535;   //width=800; height=480
  int y1=280;
  display.setCursor(width-265,250);
  display.print("Su Mo Tu We Th Fr Sa");
  display.setCursor(x1,y1);
  display.print(newWeek1);  
  display.setCursor(x1,y1+30);
  display.print(newWeek2);  
  display.setCursor(x1,y1+60);
  display.print(newWeek3);  
  display.setCursor(x1,y1+90);
  display.print(newWeek4);  
  display.setCursor(x1,y1+120);
  display.print(newWeek5); 
int r = startDay;   
int p = (r+t.Day())/7;
int q = (r+t.Day())%7;
int s = r+q;    //week row
int th = t.DayOfWeek()+1;        // day of week
int gp = th*30-15;  //gap between two date positions
if(q==0) thickcircle(x1+gp+13,y1+5+30*(p-1)-10,15, 1,GxEPD_WHITE);
if(q>0)  thickcircle(x1+gp-2,y1+5+30*p-10,15, 1,GxEPD_WHITE);
//Serial.println(r);
/************************************* Calendar code ends here     *******************/
        display.setTextSize(2);  
      }
      while (display.nextPage());
     }
    //delay(100);
    display.firstPage();
    do {
      display.fillRect(0,0, box_w, box_h, GxEPD_BLACK);
      }
    while (display.nextPage());
}

void thickRect(int x0,int y0, int x1, int y1, int thk,int clr, int color){
thickline(x0,y0+clr+clr/2,x1-clr,y0+clr+clr/2,thk,color);
thickline(x1-clr,y0+clr,x1-clr,y1-clr,thk,color);
thickline(x1-clr,y1-clr,x0+clr,y1-clr,thk,color);
thickline(x0+clr,y1-clr,x0+clr,y0+clr,thk,color);
}

void thickline(int x, int y, int x1, int y1, int size, int color) {
  float dx = (size / 2.0) * (y - y1) / sqrt(sq(x - x1) + sq(y - y1));
  float dy = (size / 2.0) * (x - x1) / sqrt(sq(x - x1) + sq(y - y1));
  display.fillTriangle(x + dx, y - dy, x - dx,  y + dy,  x1 + dx, y1 - dy, color);
  display.fillTriangle(x - dx, y + dy, x1 - dx, y1 + dy, x1 + dx, y1 - dy, color);
}
void thickcircle(int16_t x0, int16_t y0, int16_t r, int pixel, uint16_t color) {
  for(int i=r;i<=r+pixel;i++){
   display.drawCircle(x0, y0, i, color);
  }
}

 void drawClockFace(){
  display.fillCircle(ccenterx - hshift, ccentery-vshift, cradius-10, GxEPD_WHITE);  //blue
  display.fillCircle(ccenterx - hshift, ccentery-vshift, cradius-14, GxEPD_BLACK); //black
  // Draw 12 lines
  for(int i = 0; i<360; i+= 30) {
    hr = i/30;
    if(hr==0) hr=12;
    // Serial.println(hr);
    sx = cos((i-90)*scosConst);
    sy = sin((i-90)*scosConst);
    x0 = sx*(cradius-4-10)+ccenterx;
    yy0 = sy*(cradius-4-10)+ccentery;
    x1 = sx*(cradius-11-10)+ccenterx;
    yy1 = sy*(cradius-11-10)+ccentery;
    display.drawLine(x0, yy0-vshift, x1, yy1-vshift, GxEPD_WHITE);  //blue
    display.setTextColor(GxEPD_WHITE,GxEPD_BLACK);
   int x00 = sx*(cradius-4-10-10)+ccenterx;
   int yy00 = sy*(cradius-4-10-10)+ccentery;
   int x11 = sx*(cradius-11-10-10)+ccenterx;
   int yy11 = sy*(cradius-11-10-10)+ccentery;
 
 p = (x00+x11)/2;
 q = (yy11+yy00)/2-vshift-11+4;
  display.setTextColor(GxEPD_WHITE,GxEPD_BLACK);
    display.setCursor(p-hshift-15,q+20);
    display.print(String(hr));
    }
}
String printDigits(int digits){
  if(digits < 10)
  dg= "0"+String(digits);
  else dg = String(digits);
  return dg;
}

void drawClockHands(uint8_t h,uint8_t m,uint8_t s){
  // Pre-compute hand degrees, x & y coords for a fast screen update
  sdeg = s * 6;                  // 0-59 -> 0-354
  mdeg = m * 6 + sdeg * 0.01666667;  // 0-59 -> 0-360 - includes seconds
  hdeg = h * 30 + mdeg * 0.0833333;  // 0-11 -> 0-360 - includes minutes and seconds
  hx = cos((hdeg-90)*scosConst);    
  hy = sin((hdeg-90)*scosConst);
  mx = cos((mdeg-90)*scosConst);    
  my = sin((mdeg-90)*scosConst);
  sx = cos((sdeg-90)*scosConst);    
  sy = sin((sdeg-90)*scosConst);
// Erase just old hand positions

  thickline(ohx-hshift, ohy, ccenterx+1-hshift, ccentery+1-vshift,h_thick, GxEPD_BLACK);  
  thickline(omx-hshift, omy, ccenterx+1-hshift, ccentery+1-vshift,m_thick, GxEPD_BLACK);
  thickline(osx-hshift, osy, ccenterx+1-hshift, ccentery+1-vshift,s_thick, GxEPD_BLACK);

// Draw new hand positions  
  thickline(hx*(cradius-28-st)-hshift+ccenterx+1, hy*(cradius-28-st)+ccentery+1-vshift, ccenterx+1-hshift, ccentery+1-vshift,h_thick, GxEPD_WHITE);  //white
  thickline(mx*(cradius-17-st)-hshift+ccenterx+1, my*(cradius-17-st)+ccentery+1-vshift, ccenterx+1-hshift, ccentery+1-vshift,m_thick, GxEPD_WHITE);
  thickline(sx*(cradius-54)+ccenterx+1-hshift, sy*(cradius-54)+ccentery+1-vshift, ccenterx+1-hshift, ccentery+1-vshift,s_thick, GxEPD_WHITE);
  display.fillCircle(ccenterx+1, ccentery+1-vshift, 3, GxEPD_WHITE);

  osx = sx*(cradius-14-st)+ccenterx+1;
  osy = sy*(cradius-14-st)+ccentery+1-vshift;
  omx = mx*(cradius-17-st)+ccenterx+1;
  omy = my*(cradius-17-st)+ccentery+1-vshift;
  ohx = hx*(cradius-28-st)+ccenterx+1;
  ohy = hy*(cradius-28-st)+ccentery+1-vshift;
}

#define countof(a) (sizeof(a) / sizeof(a[0]))
void printDateTime(const RtcDateTime& dt){
    char datestring[20];
    snprintf_P(datestring, 
            countof(datestring),
            PSTR("%02u/%02u/%04u %02u:%02u:%02u"),
            dt.Month(),
            dt.Day(),
            dt.Year(),
            dt.Hour(),
            dt.Minute(),
            dt.Second() );
    Serial.print(datestring);
}

// calculate first day of month
int startDayOfWeek(int y, int m, int d){
  static int t[] = {0, 3, 2, 5, 0, 3, 5, 1, 4, 6, 2, 4};
  y -= m < 3;
  return (y +y/4 -y/100 + y/400 + t[m-1] + d)% 7; 
} 

float DS3231_get_treg(){
 //   int rv;  // Reads the temperature as an int, to save memory
    float rv;
    uint8_t temp_msb, temp_lsb;
    int8_t nint;

    Wire.beginTransmission(DS3231_I2C_ADDR);
    Wire.write(DS3231_TEMPERATURE_ADDR);
    Wire.endTransmission();

    Wire.requestFrom(DS3231_I2C_ADDR, 2);
    temp_msb = Wire.read();
    temp_lsb = Wire.read() >> 6;

    if ((temp_msb & 0x80) != 0)
        nint = temp_msb | ~((1 << 8) - 1);      // if negative get two's complement
    else
        nint = temp_msb;

    rv = 0.25 * temp_lsb + nint;
    return rv;
}

