// mapping example for AVR, UNO, NANO etc.
// BUSY -> 7, RST -> 9, DC -> 8, C S-> 10, CLK -> 13, DIN -> 11

// include library, include base class, make path known
#include <GxEPD.h>
#include <GxGDEH0154D67/GxGDEH0154D67.h>
#include <GxIO/GxIO_SPI/GxIO_SPI.h>
#include <GxIO/GxIO.h>

// FreeFonts from Adafruit_GFX
#include <Fonts/FreeMonoBold24pt7b.h>

GxIO_Class io(SPI, /*CS=*/ SS, /*DC=*/ 8, /*RST=*/ 9); // arbitrary selection of 8, 9 selected for default of GxEPD_Class
GxEPD_Class display(io /*RST=9*/ /*BUSY=7*/); // default selection of (9), 7

uint32_t  days;
long x=0;

void setup(void)
{
  display.init(); 
  display.setTextColor(GxEPD_BLACK);  
  display.setFont(&FreeMonoBold24pt7b);  
  display.setRotation(1);  
}

void loop()
{
  days = x++; 
  showPartialUpdate_AVR();
}

void drawCallback()
{
  uint16_t box_x = 10;
  uint16_t box_y = 10;
  uint16_t box_w = 170;
  uint16_t box_h = 170;
  uint16_t cursor_y = box_y + 30;
  display.fillRect(box_x, box_y, box_w, box_h, GxEPD_WHITE);
  display.setCursor(box_x, cursor_y);
  display.print(days); 
}

void showPartialUpdate_AVR()
{
  uint16_t box_x = 10;
  uint16_t box_y = 10;
  uint16_t box_w = 170;
  uint16_t box_h = 170;
  uint16_t cursor_y = box_y + 30;
  display.drawPagedToWindow(drawCallback, box_x, box_y, box_w, box_h);
}