/**************
  TCS230 colour sensing module checking sketch, adapted from a sketch by
  Rui Santos at http://randomnerdtutorials.com, by Jim Rowe for Silicon Chip
  last revised 7/11/2023 at 3:00 pm

  Note that since the pulseIn(SensorOut, LOW) function measures the duration
  (in microseconds) of the negative pulses from the SensorOut pin of the TCS230
  rather than the output frequency, in order to obtain the frequency we need
  to divide 1000000 by 2x the duration -- because the waveform is a square
  wave, and its period is twice the pulse duration.
**************/

// set module pin wiring to Arduino
#define S0 4
#define S1 5
#define S2 6
#define S3 7
#define SensorOut 8

// stores output frequency of the TCS230
unsigned int redPeriod = 0;
unsigned int redFrequency = 0;
unsigned int greenPeriod = 0;
unsigned int greenFrequency = 0;
unsigned int bluePeriod = 0;
unsigned int blueFrequency = 0;
unsigned int clearPeriod = 0;
unsigned int clearFrequency = 0;
unsigned long FreqNumero = 1000000;

void setup()
{
  // setting the outputs and input
  pinMode(S0, OUTPUT);
  pinMode(S1, OUTPUT);
  pinMode(S2, OUTPUT);
  pinMode(S3, OUTPUT);
  pinMode(SensorOut, INPUT);

  // set the frequency scaling to 20%
  digitalWrite(S0, HIGH);
  digitalWrite(S1, LOW);

  // begin serial communication
  Serial.begin(9600);
}

void loop()
{
  // set the RED filtered photodiodes to be read
  digitalWrite(S2, LOW);
  digitalWrite(S3, LOW);
  delay(10); // pause for 10ms to stabilise
  
  // Then read the RED output period, work out frequency
  redPeriod = 2*pulseIn(SensorOut, LOW);
  redFrequency = FreqNumero/redPeriod;

  // then print out the RED frequency value
  Serial.print("Red = ");
  Serial.print(redFrequency);
  delay(100);

  // now set the GREEN filtered photodiodes to be read
  digitalWrite(S2, HIGH);
  digitalWrite(S3, HIGH);
  delay(10);  // pause for 10ms to stabilise
  
  // and read the GREEN output period, work out frequency
  greenPeriod = 2*pulseIn(SensorOut, LOW);
  greenFrequency = FreqNumero/greenPeriod;

  // and print out the GREEN frequency value
  Serial.print(" Green = ");
  Serial.print(greenFrequency);
  delay(100);

  // then set the BLUE filtered photodiodes to be read
  digitalWrite(S2, LOW);
  digitalWrite(S3, HIGH);
  delay(10);  // pause for 10ms
  
  // read the BLUE output period, work out frequency
  bluePeriod = 2*pulseIn(SensorOut, LOW);
  blueFrequency = FreqNumero/bluePeriod;

  // and print out the BLUE frequency value
  Serial.print(" Blue = ");
  Serial.print(blueFrequency);
  delay(100);
  
  //then set the CLEAR (unfiltered) photodiodes to be read
  digitalWrite(S2, HIGH);
  digitalWrite(S3, LOW);
  delay(10);  // pause for 10ms 

  // read the CLEAR output period, work out frequency
  clearPeriod = 2*pulseIn(SensorOut, LOW);
  clearFrequency = FreqNumero/clearPeriod;

  // and print out the CLEAR value
  Serial.print(" Clear = ");
  Serial.println(clearFrequency);
  Serial.println("     ");  // then blank line for separation
  delay(10000);  // pause before looping back
}
