
; Fingerprint scanner (fps) (GT-511C1R from Sparkfun (USA), LittleBird Electronics (Australia))
	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; EEPROM locations
; store serial No. to identify connected fps. It will not work with a swapped fps scanner GT-511C1R unless re-read using S5
EEPROM0		equ	H'00'	; non-volatile storage Use EEPROM0 to EEPROM29 (a hex count)
;| | | | | |			; EEPROM1-EEPROM28 not shown but in here between EEPROM0 and 29
EEPROM29	equ	H'29'	; last EEPROM to store serial number and data

EEPROM2A	equ	H'2A'	; door strike period
EEPROM2B	equ	H'2B'	; high/low resolution scan
EEPROM2C	equ	H'2C'	; enrol counter
EEPROM2D	equ	H'2D'	; AVAILable enrolments (1-20 default)optional 200	
; bank 0 RAM 

BCD_0			equ	H'20'	; MS bcd value
BCD_1			equ	H'21'	; LS binary coded decimal value
BIN_0			equ	H'22'	; 8-bit binary value
TEMP			equ	H'23'	; data storage 
CNT_8			equ	H'24'	; counter in BCD routine
OUT1			equ	H'25'	; ASCII byte
OUT2			equ	H'26'	; ASCII byte
OUT3			equ	H'27'	; ASCII byte	
STORE1			equ	H'28'	; delay counter	
STORE2			equ	H'29'	; delay counter
STORE3			equ	H'2A'	; delay counter
D_STO			equ	H'2B'	; data storage during LCD drive
PORTA_STO		equ	H'2C'	; portA store during LCD data transfer
EEPROM_CNT		equ	H'2D'	; EEPROM address counter
MODE			equ	H'2E'	; operating mode
IDENTITY		equ	H'2F'	; fingerprint identity number
PARAM			equ	H'30'	; parameter (ls byte)
PARAM1			equ	H'31'	; parameter next byte
COMM			equ	H'32'	; command (ls byte)
C_SUM			equ	H'33'	; checksum (ls byte) assumes 01 for msb
OPEN			equ	H'34'	; open flag for serial number extraction
FREE_ID			equ	H'35' 	; enrol ID
BACK_LIGHT		equ	H'36'	; backlight timer
DOOR_STRIKE		equ	H'37'	; door strike period
SWITCHER		equ	H'38'	; to allow < and > switches to be used to cycle ID
REG_COUNT		equ	H'39'	; Register counter
SW_FLAG			equ	H'3A'	; switch delay extension
DELAY_EXTN		equ	H'3B'	; extension
ID_STO			equ	H'3C'	; ID value stored for display 
DOWN_FLG		equ	H'3D'	; down flag
RETURN_COUNTER	equ	H'3E'	; counter to return to home (scanning for finger pressed)
HI_RES			equ	H'3F'	; high resolution scan
SPACE_COUNT		equ	H'40'	; space counter for LCD
; all banks ram
W_TMP			equ	H'70'	; temporary store for w in interrupt
STATUS_TMP		equ	H'71'	; temporary store of status in interrupt 
INT_FLG 		equ H'72'	; interrupt flag
TEMP1			equ	H'73'	; temporary
ID_TOTAL_MINUS1	equ	H'74'	; number of IDs for the fps scanner eg 19 (for 0-19 = 20)
ID_TOTAL		equ	H'75'	; Total IDs plus 1 eg 20 (for 0-19 count stop if goes over 19)
ENROLX			equ	H'76'	; enrol1,2,3
SW_OPEN			equ	H'77'	; switch open flag	
RECAPTURE		equ	H'78'	; retry fingerprint
ENROL_COUNT		equ	H'79'	; enrolment counter
FPS_OPEN		equ	H'7A'	; timeout counter for if FPS is disconnected

; Bank1

; fps received data 
RECEIVE0		equ	H'A0'	; received data H55					0
RECEIVE1		equ	H'A1'	; received data HAA
RECEIVE2		equ	H'A2'	; received data 01 device ID lsb
RECEIVE3		equ	H'A3'	; received data 00 device ID msb

RECEIVE4		equ	H'A4'	; received data Parameter lsb
RECEIVE5		equ	H'A5'	; received data
RECEIVE6		equ	H'A6'	; received data
RECEIVE7		equ	H'A7'	; received data Parameter msb

RECEIVE8		equ	H'A8'	; received data Response lsb
RECEIVE9		equ	H'A9'	; received data	Response msb

RECEIVEA		equ	H'AA'	; received data Check sum lsb
RECEIVEB		equ	H'AB'	; received data	check sum msb		11

; continuation for devinfo firmware/serial number 
; start bytes
RECEIVEC		equ	H'AC'	; received data 5A (note; differs from previous H55)
RECEIVED		equ	H'AD'	; received data A5 (note; differs from previous HAA)
RECEIVEE		equ	H'AE'	; received data 01 device ID lsb
RECEIVEF		equ	H'AF'	; received data 00 device ID msb
; Firmware version
RECEIVE10		equ	H'B0'	; received data lsb
RECEIVE11		equ	H'B1'	; received data
RECEIVE12		equ	H'B2'	; received data
RECEIVE13		equ	H'B3'	; received data msb					19
; 0kB
RECEIVE14		equ	H'B4'	; received data 00
RECEIVE15		equ	H'B5'	; received data	00
RECEIVE16		equ	H'B6'	; received data 00
RECEIVE17		equ	H'B7'	; received data 00
; serial number	
RECEIVE18		equ	H'B8'	; received data	serial No. lsb
RECEIVE19		equ	H'B9'	; received data 	
RECEIVE1A		equ	H'BA'	; received data 
RECEIVE1B		equ	H'BB'	; received data 
RECEIVE1C		equ	H'BC'	; received data 
RECEIVE1D		equ	H'BD'	; received data 
RECEIVE1E		equ	H'BE'	; received data
RECEIVE1F		equ	H'BF'	; received data						31
RECEIVE20		equ	H'C0'	; received data 
RECEIVE21		equ	H'C1'	; received data 
RECEIVE22		equ	H'C2'	; received data	
RECEIVE23		equ	H'C3'	; received data 
RECEIVE24		equ	H'C4'	; received data	 
RECEIVE25		equ	H'C5'	; received data		
RECEIVE26		equ	H'C6'	; received data 
RECEIVE27		equ	H'C7'	; received data	serial No. msb
; check sum
RECEIVE28		equ	H'C8'	; received data check sum lsb
RECEIVE29		equ	H'C9'	; received data	check sum msb		41

; ******************************************************************
; 
	ORG     212A
	DE		D'5'		; Preload doorstrike period @ 5 seconds
	DE		D'0'		; high res scan
	DE		D'0'		; enrolment tally
	DE		D'20'		; fps enrolments available

; start program at memory 0
	org		0			; start at address 0000h
	goto	MAIN		; normal service routines from Reset vector
	org     4			; interrupt vector 0004h, start interrupt routine here

; start interrupt by saving w and status registers before altered by interrupt routine

INTERRUPT
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp  
	bcf		STATUS,RP0	; select memory bank 0
	bcf		STATUS,RP1
	bcf		STATUS,IRP

; initialise timeout for if FPS is disconnected
	movlw	D'2'
	movwf	FPS_OPEN	; 2 x 0.55s (timer1) to timeout if FPS is disconnected = ~1.1s

; check receive interrupt
RECEIVE_INT
	btfss	PIR1,RCIF	; if flag set
	goto	END_OF_INT
; check for errors
	btfss	RCSTA,OERR
	goto	RECEIVE_DATA
	bcf		RCSTA,CREN	; clear OERR
	bsf		RCSTA,CREN	; enable reception

RECEIVE_DATA
	movlw	RECEIVE0
	movwf	FSR
	movf	REG_COUNT,w	; pointer ; Register counter shows data position
	addwf	FSR,f
	movf	RCREG,w		; read value clear RCIF in PIR1
	movwf	INDF		; place in memory
	incf	REG_COUNT,f	; ready for next memory
	
	movlw	D'42'
	btfss	OPEN,0		; if bit is set, then the OPEN command is running and so use extended memory for retrieval of serial number	
	movlw	D'12'		; memory length 0-B (0-D11)
	xorwf	REG_COUNT,w
	btfsc	STATUS,Z
	goto	END_OF_DATA
; wait for next data
DATA_WAIT
; check Timer1 interrupt and count down FPS_OPEN for a timeout count for data wait
	btfss	PIR1,TMR1IF
	goto	WAIT_D
	bcf		PIR1,TMR1IF
LATCH_UP
	movf	FPS_OPEN,w
	btfsc	STATUS,Z	; if zero no decrement
	goto	LATCH_UP	; stop program as FPS is disconnected
	decf	FPS_OPEN,f	; reduce with timer1 timeout
WAIT_D
	btfss	PIR1,RCIF
	goto	DATA_WAIT
	goto	RECEIVE_DATA

END_OF_DATA
	movf	RCREG,w		; read value clear RCIF in PIR1
	btfsc	PIR1,RCIF
	goto	END_OF_DATA	
	
	bsf		INT_FLG,0	; flag to indicate that data is ready

END_OF_INT
; check Timer1 interrupt
	btfss	PIR1,TMR1IF
	goto	RECLAIM
	bcf		PIR1,TMR1IF
	movf	RETURN_COUNTER,w
	btfss	STATUS,Z			; if zero no decrement 
	decf	RETURN_COUNTER,f	; reduce with timer1 timeout
RECLAIM
; end of interrupt reclaim w and status 
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

;_________________________________________________________________________________________

MAIN
	bsf		STATUS,RP0	; select memory bank 1
; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'10111111'	; port B inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'00100000'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000000'	; settings (pullups enabled)  
	movwf	OPTION_REG
	movlw	B'00000000' ; digital I/O
	movwf	ANSEL
	movlw	B'01101000'	; 0110 for 4MHz
	movwf	OSCCON		; 
	
; serial output set to FPS default 9600 baud
	
; 9600 baud (serial port) 
	movlw	D'25' 		; '25' for 4MHz	and 9600 baud plus set BRGH  
	movwf	SPBRG		; set baud rate
	bcf		TXSTA,SYNC	; enable asynchronous serial port
	bsf		TXSTA,BRGH	; set high baud rate 
	bsf		TXSTA,TXEN	; enable transmission
	bcf		STATUS,RP0	; select memory bank 0
	bsf		RCSTA,SPEN	; enable receive asynchronous port
	bsf		RCSTA,CREN	; enable reception

; Timer 1
	movlw	B'00110001'
	movwf	T1CON		; set for /8 prescaler 0.55s

; initial conditions
	clrf	RETURN_COUNTER	; counter for return to home (scan for finger pressed)
	clrf	INT_FLG
	clrf	OPEN
	clrf	PORTA
	clrf	PORTB
	clrf	MODE
	clrf	PARAM1		; parameter next byte
	bsf		PORTB,6		; back light on

; Set number of enrolment IDs available for the fps

; if Up switch is pressed at power up, set at 200
; if Down switch is pressed at power up set 20

	btfss	PORTB,4		; down switcj
	goto 	SET_20
	btfsc	PORTB,3		; up switch
	goto	RECALL_ID

; set at 200
	movlw	EEPROM2D	; enrolments available
	call	EEREAD		; sets EEADR
	movlw	D'200'	
	call	EEWRITE
	goto	RECALL_ID
	
SET_20
	movlw	EEPROM2D	; enrolments available
	call	EEREAD		; sets EEADR
	movlw	D'20'	
	call	EEWRITE	
RECALL_ID
; recall ID_TOTAL
; set ID_TOTAL for the number of ID enrolments available (20 for the fps scanner used)Change the 20 for a different number where available
	movlw	EEPROM2D	; enrolments available
	call	EEREAD		; sets EEADR
	movwf	ID_TOTAL	; Total IDs eg 20  0-19 
	decf	ID_TOTAL,w
	movwf	ID_TOTAL_MINUS1	; number of IDs for the fps scanner minus 1 eg 19 

; load enrolment counter value (increases and decreases with enrolment and enrolment deletion)
	movlw	EEPROM2C	; enrolment counter
	call	EEREAD		; sets EEADR
	movwf	ENROL_COUNT

; load DOOR_STRIKE_PERIOD
	movlw	EEPROM2A	; door strike period 
	call	EEREAD		; sets EEADR
	movwf	DOOR_STRIKE	; period

; load High/Low resolution scan
	movlw	EEPROM2B
	call	EEREAD
	andlw	B'00000001'	; just bit 0
	movwf	HI_RES		; high resolution scan
	
; interrupt enable 
INTERRUPT_ENABLE
	bsf		STATUS,RP0	; select memory bank 1
	bsf		PIE1,RCIE	; enable receive interrupt
	bsf		PIE1,TMR1IE	; timer 1 interrupt enable
	bcf		STATUS,RP0	; select memory bank 0
	movf	RCREG,w		; clear RCIF in PIR1
	bcf		PIR1,TMR1IF	; timer 1 flag
	bsf		INTCON,PEIE	; allow interrupts
	bsf		INTCON,GIE	; set global interrupt enable 

; initialise LCD
	movlw	H'FF'		; start up delay
	call	DELAYX
	call	INIT_LC	
	movlw	H'FF'		; start up delay
	call	DELAYX
	call	INIT_LC
	call	DELAYms
	call	INIT_LC
	call	DELAYms

	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x8 dots)
	call	LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call	LOAD
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	H'FF'		; delay 
	call	DELAYX		; 
	movlw	B'00000110'	; entry mode. cursor moves right, display not shifted
	call	LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call	LOAD
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x8 dots)
	call	LOAD		; 
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	H'FF'		; delay 
	call	DELAYX

; character generator
	call	CHARACTR_GEN ;generate specific characters (No., return, up and down symbols)

;__________________________________________

; Baud rate set
; default at power up is 9600 baud  
; Change baud rate 
; This can add security if the FPS is connected without the correct baud rate change implemented in a hot wire exchange
; load values for 19200 BAUD_RATE in fps
	movlw	H'00'		; lsb
	movwf	PARAM
	movlw	H'4B'		; next significant byte (for H'4B00' ; D'19200')
	movwf	PARAM1
	movlw	H'04'		; command for change baud
	movwf	COMM
	movlw	H'4F'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps (for H'4B00'; D19200 baud)
	clrf	PARAM1		; keep clear normally for other parameter use

; Change BAUD rate in PIC16F88
	bsf		STATUS,RP0	; select memory bank 1
	movlw	D'12'	 	; 19200 baud plus BRGH set 
	movwf	SPBRG		; set baud rate
	bcf		STATUS,RP0	; select memory bank 0
; _________________________________________________________________________________________

; check if EEPROM locations are not programmed ie all FF. If not read device information (devinfo)
; including serial number and store in EEPROM

	movlw	EEPROM0
	movwf	EEPROM_CNT	; counter for EEPROM addresses H'0' to H'29'
LOOP_READ
	movf	EEPROM_CNT,w; required for the loop to load w	
	call	EEREAD		; get EEPROM value
	xorlw	H'FF'		; compare with unprogrammed value
	btfss	STATUS,Z
	goto	SCAN1		; if not FF then programmed
	incf	EEPROM_CNT,f
	movf	EEPROM_CNT,w
	xorlw	H'2A'		; end of EEPROM
	btfss	STATUS,Z
	goto	LOOP_READ
; all FF so read serial data on fps
EEP	
	call	LOAD_SERIAL_No ; show on display

	bsf		OPEN,0		; set flag to indicate that OPEN is required with serial number data received
; load values for OPEN	; initialise to get serial number
	movlw	H'01'
	movwf	PARAM
	movlw	H'01'
	movwf	COMM
	movlw	H'02'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps
	clrf	OPEN

; program EEPROM
	movlw	EEPROM0
	movwf	EEPROM_CNT	; counter for EEPROM addresses H0 to H29
	clrf	REG_COUNT	; start at 0
PROG
	movlw	RECEIVE0
	movwf	FSR

	movf	REG_COUNT,w	; pointer ; Register counter shows data position
	addwf	FSR,f
	movf	EEPROM_CNT,w
	call	EEREAD		; sets EEADR
	movf	INDF,w		; place RECEIVEXX data in memory
	call	EEWRITE
	incf	REG_COUNT,f	; ready for next memory
	incf	EEPROM_CNT,f
	movlw	D'42'		; H'2A'
	xorwf	REG_COUNT,w
	btfss	STATUS,Z
	goto	PROG

; delay for LCD screen
	movlw 	D'9'
	movwf	DELAY_EXTN
LOOP_DEL_SERIAL
	movlw	D'255'
	call	DELAYX
	decfsz	DELAY_EXTN,f
	goto	LOOP_DEL_SERIAL
;	goto	SCAN1
; _________________________________________________________________________________________

SCAN1; 'home' scan for finger
; drive display
	call	OPEN_WORDS	; write Fingerprint Security Access
	clrf	MODE
	movlw	D'5'
	movwf	BACK_LIGHT	; backlight timer counts number of LED on /finger on scans
	call	SW_DELAY
WAIT_S1_E1
; wait for S1 to open
	btfss	PORTB,1
	goto	WAIT_S1_E1	
	goto	SCAN
;-------------------------------------------

; Note: returns to this fingerprint scan after a period due to timeout when the mode has changed. Also LCD backlight goes off.
SCAN
	movf	BACK_LIGHT,w; backlight timer counts number of LED on /finger on scans
	btfsc	STATUS,Z	; when zero clear backlight
	goto	BACK_OFF
	decf	BACK_LIGHT,f
	goto	READ7
BACK_OFF ; backlight off
	bcf		PORTB,6		; LCD backlight off

READ7
; re read devinfo if S5 pressed. This reads fps serial number (unique to each fps)
	btfss	PORTB,7
	goto	EEP			; read and store FPS Serial No.
	
; wait for switch to open
S5_OP
	btfsc	PORTB,7
	goto	CK_FINGER
	movlw	D'255'
	call	DELAYX
	goto	S5_OP

; switch on LED check for finger press
CK_FINGER
; load values for LED_ON
	movlw	H'01'
	movwf	PARAM
	movlw	H'12'
	movwf	COMM
	movlw	H'13'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps

; load values for FINGER (is finger pressed)
	movlw	H'00'
	movwf	PARAM
	movlw	H'26'
	movwf	COMM
	movlw	H'26'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps
	
; check data for finger pressed. Parameter at RECEIVE4 & RECEIVE5 H1012 for not pressed

	bsf		STATUS,RP0	; select memory bank 1
	movf	RECEIVE4,w
	xorlw	H'12'		; compare with H12 for Finger error
	btfsc	STATUS,Z
	goto	SET_LED_OFF	; not pressed

; keep LED on	
	bcf		STATUS,RP0	; select memory bank 0
	goto	FINGER_ON
SET_LED_OFF
	bcf		STATUS,RP0	; select memory bank 0
; load values for LED_OFF
	movlw	H'00'
	movwf	PARAM
	movlw	H'12'
	movwf	COMM
	movlw	H'12'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps

; LED off for a period
	movlw 	D'90'
	movwf	DELAY_EXTN

LOOP_DEL

; check for Menu switch closure

	btfss	PORTB,1		; switch S1 MENU
	goto	MENU	

LOOP_CONT
	movlw	D'25'
	call	DELAYX
	decfsz	DELAY_EXTN,f
	goto	LOOP_DEL
	goto	SCAN	
; _________________________________________________________
FINGER_ON
	bsf		PORTB,6		; LCD backlight on
; test for mismatch enrolment count ie compare ENROL_COUNT with get enrol count from fps
; load values for enrol count 
	movlw	H'00'
	movwf	PARAM
	movlw	H'20'		;  
	movwf	COMM
	movlw	H'20'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps
; receive 4 has count
	bsf		STATUS,RP0	; select memory bank 1
	movf	RECEIVE4,w
	bcf		STATUS,RP0	; bank 0

	xorwf	ENROL_COUNT,w
	btfsc	STATUS,Z
	goto	CK_CAPT		; check captured against database

; error mismatch for enrol count
; write enrolment tamper
	movlw	H'80'
	call	LOAD
	call	WRITE_ENROL
	movlw	A'm'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	call	SPACE1
	call	WRITE_TAMPER ; writes Enrolment Tamper Press ENTER
	call	PRESS_ENTER
;	bcf		PORTB,6		; LCD backlight off
; load values for LED_OFF
	movlw	H'00'
	movwf	PARAM
	movlw	H'12'
	movwf	COMM
	movlw	H'12'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps

; wait for Menu switch
TAMPER_REPORT	
	btfsc	PORTB,0		; enter switch
	goto	TAMPER_REPORT
	goto	SCAN1

CK_CAPT
; on delay for ensuring finger placement is ready
	movlw 	D'1'
	movwf	DELAY_EXTN
LOOP_DEL_ON1
	movlw	D'255'
	call	DELAYX
	decfsz	DELAY_EXTN,f
	goto	LOOP_DEL_ON1

; Do  isfinger/capture/identify several repeat times if need be
	clrf	RECAPTURE	; retry fingerprint repeat counter, start at 0 (shown on LCD)
; limit of 6 see repeat count value below

IDENTIFY_LOOP
; load values for FINGER (is finger pressed)
	movlw	H'00'
	movwf	PARAM
	movlw	H'26'
	movwf	COMM
	movlw	H'26'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps
	call	IS_FINGER	; finger pressed?
	bcf		STATUS,RP0
	xorlw	D'00'
	btfsc	STATUS,Z	; if pressed
	goto	CAPTURE_N
; error
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	D'16'		; clear line 1
	call	SPACE_NO
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	call	FINGER_OFF	; show error
	goto 	FLASH_DELAY

CAPTURE_N	
; load values for CaptureFinger
	clrf	PARAM		; low resolution
	movf	PARAM,w
	btfss	HI_RES,0	; when set low resolution
	movlw	H'01'		; hi resolution	
	movwf	PARAM		; best image when not 0
	movlw	H'60'
	movwf	COMM
	movlw	H'60'
	addwf	PARAM,w		; add PARAM and COMMand	for checksum
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps

	movlw	D'5'
	movwf	BACK_LIGHT	; backlight timer counts number of LED on /finger on scans
	bsf		PORTB,6		; backlight on

	call	IDENTIFICATION	; write 'Fingerprint Identification' on LCD screen

; check captured against database to Identify
; compare captured fingerprint against database
	movlw	H'00'
	movwf	PARAM
	movlw	H'51'		; 51 for identify 
	movwf	COMM
	movlw	H'51'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps

; RECEIVE8 has Ack/NAck. H30 = Ack. 
	bsf		STATUS,RP0	; select memory bank 1
	movf	RECEIVE8,w
	bcf		STATUS,RP0	; bank 0
	xorlw	H'30'		; if an acknowledge then allow entry
	btfsc	STATUS,Z
	goto	ENTRY

; redo capture 
	incf	RECAPTURE,f
	movf	RECAPTURE,w

; repeat count value
	sublw	D'5'		; recapture repeat times (shown on LCD with 1x= check once)
; 
	btfsc	STATUS,C	; when Recapture is greater than repeat value, end and show error
	goto	IDENTIFY_LOOP

	bcf		PORTA,4		; make sure Q2 is off

; non acknowledge, check error code	
; H31 Non ack
; RECEIVE4 and RECEIVE5 have errors codes (eg. 0A and 10 respectively for DB empty,	08 and 10 for No ID match)
	call	ACCESS
	call	DENIED
	bsf		STATUS,RP0	; select memory bank 1
	movf	RECEIVE4,w
	bcf		STATUS,RP0	; bank 0
	xorlw	H'0A'
	btfss	STATUS,Z
	goto	ID_FAIL_CK
	call	DB_EMPTY
	goto	FLASH_DELAY		
ID_FAIL_CK
	call	ID_FAIL

; fast flash delay
FLASH_DELAY

	movlw 	D'9'
	movwf	DELAY_EXTN
; fast flash
LOOP_DEL3
; load values for LED_ON
	movlw	H'01'
	movwf	PARAM
	movlw	H'12'
	movwf	COMM
	movlw	H'13'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps
	movlw	D'255'
	call	DELAYX
; load values for LED_OFF
	movlw	H'00'
	movwf	PARAM
	movlw	H'12'
	movwf	COMM
	movlw	H'12'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps
	movlw	D'255'
	call	DELAYX
	decfsz	DELAY_EXTN,f
	goto	LOOP_DEL3

	call	OPEN_WORDS	; write Fingerprint scanner
	goto	SCAN
;__________________________________________________

;allow entry with RA4 high to drive door strike via Q2
ENTRY
	bsf		STATUS,RP0	; select memory bank 1
	incf	RECEIVE4,w	; ID number 1-20 (rather than 0-19)
	bcf		STATUS,RP0	; bank 0
	movwf	ID_STO		; get ID value 
; first check fps serial number with stored
; read serial number
	bsf		OPEN,0		; set flag to indicate that OPEN is required with serial number data received
; load values for OPEN	; initialise to get serial number
	movlw	H'01'
	movwf	PARAM
	movlw	H'01'
	movwf	COMM
	movlw	H'02'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps
		
	clrf	OPEN
; serial number is RECEIVE18 to RECEIVE27 inclusive
; stored serial number is at EEPROM18 to EEPROM27 inclusive

	movlw	H'18'
	movwf	EEPROM_CNT	; counter for EEPROM addresses H0 to H29
	movlw	H'18'
	movwf	REG_COUNT	; start at H18
COMPARE
	movlw	RECEIVE0
	movwf	FSR

	movf	REG_COUNT,w	; pointer ; Register counter shows data position
	addwf	FSR,f
	movf	EEPROM_CNT,w
	call	EEREAD		; get value
	xorwf	INDF,w		; compare RECEIVEXX data with EEPROM memory
	btfss	STATUS,Z
	goto	SERIAL_ERR
	incf	REG_COUNT,f	; ready for next memory
	incf	EEPROM_CNT,f
	movlw	H'28'
	xorwf	REG_COUNT,w
	btfss	STATUS,Z
	goto	COMPARE		; compare loop

; serial number checks out as correct
	
; write access allowed to LCD	
	call	ACCESS		; access allowed
	call	ALLOWED		; shows Identity number
	bsf		PORTA,4		; drive Q2 for doorstrike

; fps acknowledge
; switch fps LED off and on
; load values for LED_OFF
	movlw	H'00'
	movwf	PARAM
	movlw	H'12'
	movwf	COMM
	movlw	H'12'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps
	movlw	D'250'
	call	DELAYX
	movlw	D'250'
	call	DELAYX
; load values for LED_ON
	movlw	H'01'
	movwf	PARAM
	movlw	H'12'
	movwf	COMM
	movlw	H'13'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps

; doorstrike on delay
; setup so door strike value is 1=1s, 1=10s etc

	movlw	D'10'
	movwf	SW_FLAG
LOOP_DEL6D
	movf	DOOR_STRIKE,w	; door strike period
	btfsc	STATUS,Z		; avoid a 0
	movlw	D'1'			; set at 1 minimum
	movwf	DELAY_EXTN	
LOOP_DEL6
	movlw	D'187'
	call	DELAYX
	decfsz	DELAY_EXTN,f
	goto	LOOP_DEL6
	decfsz	SW_FLAG,f
	goto	LOOP_DEL6D
	bcf		PORTA,4		; Q2 off
	call	OPEN_WORDS	; write Fingerprint scanner
	goto	SCAN

SERIAL_ERR ; serial number error (mismatch)
	bcf		PORTA,4		; make sure Q2 is off

; write Serial No error press Enter on LCD	
	call	SERIAL_No_ERR
;	bcf		PORTB,6		; LCD backlight off
; load values for LED_OFF
	movlw	H'00'
	movwf	PARAM
	movlw	H'12'
	movwf	COMM
	movlw	H'12'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps
	
SERIAL_ERR_REPORT	
	btfsc	PORTB,0		; wait for Enter switch
	goto	SERIAL_ERR_REPORT
	goto	SCAN1
	
;____________________________________________________
MENU
	bsf		PORTB,6		; backlight on
	movlw	D'50'
	movwf	RETURN_COUNTER	; timer for return to home (scan for finger pressed) decreased in interrupt

; increase MODE (0=home, 1=NEW_ENROL, 2= ENROL Delete, 3= DOOR_STRIKE PERIOD, 4 Hi/Lo resolution scan)
	incf	MODE,f
	movf	MODE,w
	sublw	D'6'		; limit to 5
	btfss	STATUS,C
	clrf	MODE 

; check Mode
	movf	MODE,w
	btfsc	STATUS,Z
	goto	SCAN1		; 'home' scan for finger
	movf	MODE,w
	xorlw	D'1'		; New Enrol
	btfsc	STATUS,Z
	goto	NEW_ENROL_MENU
	movf	MODE,w
	xorlw	D'2'		; Enrol Delete
	btfsc	STATUS,Z
	goto	ENROL_DELETE_MENU
	movf	MODE,w
	xorlw	D'3'		; Enrol All-Delete
	btfsc	STATUS,Z
	goto	ENROL_DELETE_ALL_MENU
	movf	MODE,w
	xorlw	D'4'		; Hi/Lo resolution scan
	btfsc	STATUS,Z
	goto	RESOLUTION
	movf	MODE,w
	xorlw	D'5'		; set door strike period
	btfsc	STATUS,Z
	goto	DOOR_STRIKE_PERIOD
	goto	SCAN1
;------------------------------------------------------------
NEW_ENROL_MENU
	movlw	D'50'
	movwf	RETURN_COUNTER	; timer for return to home (scan for finger pressed)
	call	CLEAR_DISPLAY; wait for a response
	clrf	FREE_ID		; start with 0 and look for first unused Enrol ID
	clrf	SWITCHER	; to allow < and > switches to be used to cycle ID
	clrf	DOWN_FLG
; find a free ID otherwise show DB full (Enrolments Full)
; load values for CheckEnrolled
NEW_ENROL_ID
	movlw	D'50'
	movwf	RETURN_COUNTER	; timer for return to home (scan for finger pressed) decreased in interrupt
	movf	FREE_ID,w
	movwf	PARAM		; ID number
	movlw	H'21'
	movwf	COMM
	movlw	H'21'
	addwf	FREE_ID,w	; checksum add parameter and command
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps
	call	CHECK_ERROR
	xorlw	D'00'		; compare with 00 enrolled if 0
	btfss	STATUS,Z
	goto	FOUND_ID	; found the first available ID
; check up or down
	btfss	DOWN_FLG,0
	goto	UP_FREE
	movlw	D'1'
	subwf	FREE_ID,w	; decrease by 1
	btfss	STATUS,C	; if FREE_ID was zero set at 19
	movf	ID_TOTAL_MINUS1,w
	movwf	FREE_ID
	goto	NEW_ENROL_ID
UP_FREE
; next FREE_ID
	incf	FREE_ID,f
	movf	FREE_ID,w
	xorwf	ID_TOTAL,w		; if 20, then no free IDs
	btfss	STATUS,Z
	goto	NEW_ENROL_ID
; no free enrolment IDs
	movf	SWITCHER,w
	btfss	STATUS,Z	; if zero show enrolments full
	goto	NEW_ENROL_MENU
	call	ENROLMENTS_FULL; LCD showing full
WAIT_S1_NF1
;(next 2 lines stops menu changes with Menu switch held on)
; wait for S1 to open 

;	btfss	PORTB,1
;	goto	WAIT_S1_NF1
; time for S1 to open
	call	DELAYms
ENROL_FULL
; check for RETURN_COUNTER timer ended (decreased in interrupt) 
	movf	RETURN_COUNTER,w
	btfsc	STATUS,Z
	goto	SCAN1
; if S1 closes again change Mode 
	btfss	PORTB,1		; MENU switch
	goto 	MENU
	goto	ENROL_FULL
		
FOUND_ID
	call	NEW_ENROL ; show on LCD 'NEW ENROL' ID value
	call	SW_DELAY
WAIT_S1_1
;(next 2 lines stops menu changes with Menu switch held on)
; wait for S1 to open
;	btfss	PORTB,1
;	goto	WAIT_S1_1
; time for S1 to open
	call	DELAYms
NEW_ENROL_MODE
	movlw	D'1'
	movwf	SWITCHER	; set at other than 0
; if S1 closes again change Mode 
	btfss	PORTB,1		; MENU switch
	goto 	MENU
	btfss 	PORTB,0		; switch S2 Enter
	goto	SETUP		; enrol the ID
	btfss 	PORTB,4		; switch S3 Down
	goto	DEC_NEWENROL
	btfss	PORTB,3		; switch S4 UP
	goto	INC_NEWENROL
; check for RETURN_COUNTER timer ended (decreased in interrupt) 
	movf	RETURN_COUNTER,w
	btfss	STATUS,Z
	goto	NEW_ENROL_MODE	; wait for switches
	clrf	MODE
	goto	SCAN1
DEC_NEWENROL
	bsf		DOWN_FLG,0	; set for down
	movlw	D'1'
	subwf	FREE_ID,w	; decrease by 1
	btfss	STATUS,C	; if FREE_ID was zero set at 19
	movf	ID_TOTAL_MINUS1,w
	movwf	FREE_ID
	goto	NEW_ENROL_ID	; next available
INC_NEWENROL
	clrf	DOWN_FLG		; set for up counting
	incf	FREE_ID,f
	movf	FREE_ID,w
	xorwf	ID_TOTAL,w		; if 20, clear
	btfsc	STATUS,Z
	clrf	FREE_ID
; test next ID
	goto	NEW_ENROL_ID	; next available
		
;----------------------------------------------
ENROL_DELETE_MENU
	movlw	D'50'
	movwf	RETURN_COUNTER	; timer for return to home (scan for finger pressed)
	call	CLEAR_DISPLAY; wait for a response
	clrf	FREE_ID		; start with 0 and look for first Enrolled ID
	clrf	SWITCHER	; used to allow ID cycling with < and > switches
	clrf	DOWN_FLG
; find a free ID otherwise show DB full (Enrolments Full)
; load values for CheckEnrolled
DELETE_ENROL_ID
	movlw	D'50'
	movwf	RETURN_COUNTER	; timer for return to home (scan for finger pressed) decreased in interrupt
	movf	FREE_ID,w
	movwf	PARAM		; ID number
	movlw	H'21'
	movwf	COMM
	movlw	H'21'
	addwf	FREE_ID,w	; checksum add parameter and command
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps
	call	CHECK_ERROR
	xorlw	D'00'		; compare with 00 enrolled if 0
	btfsc	STATUS,Z
	goto	DELETE_FOUND_ID	; found the first available ID
; check for up or down
	btfss	DOWN_FLG,0	; if set for down
	goto	UP_DEL
	movlw	D'1'
	subwf	FREE_ID,w	; decrease by 1
	btfss	STATUS,C	; if FREE_ID was zero set at 19
	movf	ID_TOTAL_MINUS1,w
	movwf	FREE_ID
	goto	DELETE_ENROL_ID
UP_DEL
; next FREE_ID
	incf	FREE_ID,f
	movf	FREE_ID,w
	xorwf	ID_TOTAL,w		; if 20, then all free IDs
	btfss	STATUS,Z
	goto	DELETE_ENROL_ID
; no enrolments
	movf	SWITCHER,w
	btfss	STATUS,Z	; if zero show enrolments full
	goto	ENROL_DELETE_MENU
	call	NO_ENROLMENTS; LCD showing 'no enrolments to delete'
WAIT_S1_DE1
;(next 2 lines stops menu changes with Menu switch held on)
; wait for S1 to open
;	btfss	PORTB,1
;	goto	WAIT_S1_DE1
; time for S1 to open
	call	DELAYms
ENROL_EMPTY
; check for RETURN_COUNTER timer ended (decreased in interrupt) 
	movf	RETURN_COUNTER,w
	btfsc	STATUS,Z
	goto	SCAN1
; if S1 closes again change Mode 
	btfss	PORTB,1		; MENU switch
	goto 	MENU
	goto	ENROL_EMPTY
	
DELETE_FOUND_ID
	call	ENROL_DELETE ; show on LCD Delete Enrolment ID value
	call	SW_DELAY
WAIT_S1_D1
	bsf		SWITCHER,1	; set at other than 0
;(next 2 lines stops menu changes with Menu switch held on)
; wait for S1 to open
;	btfss	PORTB,1
;	goto	WAIT_S1_D1
	call	DELAYms
DEL_ENROL_MODE
; if S1 closes again change Mode 
	btfss	PORTB,1		; MENU switch
	goto 	MENU
	btfss 	PORTB,0		; switch S2 Enter
	goto	DEL_ENROL
	btfss 	PORTB,4		; switch S3 Down
	goto	DEC_ENROL
	btfss	PORTB,3		; switch S4 UP
	goto	INC_ENROL
; check for RETURN_COUNTER timer ended (decreased in interrupt) 
	movf	RETURN_COUNTER,w
	btfss	STATUS,Z
	goto	DEL_ENROL_MODE	; wait for switches
	clrf	MODE
	goto	SCAN1
DEC_ENROL
	bsf		DOWN_FLG,0	; set for down
	movf	FREE_ID,w	; if zero
	btfsc	STATUS,Z
	incf	FREE_ID,f
	movlw	D'1'
	subwf	FREE_ID,f	; decrease by 1
	goto	DELETE_ENROL_ID	; next available
INC_ENROL
	clrf	DOWN_FLG	; set for up
	incf	FREE_ID,f
	movf	FREE_ID,w
	xorwf	ID_TOTAL,w	; if 20, set at 19
	btfss	STATUS,Z
	
; test next ID
	goto	DELETE_ENROL_ID
	movf	ID_TOTAL_MINUS1,w
	movwf	FREE_ID
	goto	DELETE_ENROL_ID
DEL_MODE
	call	SW_DELAY
	goto	DEL_ENROL_MODE

DEL_ENROL
; delete the enrolled ID

	movf	FREE_ID,w
	movwf	PARAM		; ID=0-19
	movlw	H'40'
	movwf	COMM
	movlw	H'40'
	addwf	FREE_ID,w	; checksum add parameter and command
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps

	call	WRITE_DELETED		; show on LCD

; decrease enrol counter
	decf	ENROL_COUNT,f
; load enrolment counter value
	movlw	EEPROM2C	; enrolment counter
	call	EEREAD		; sets EEADR
	movf	ENROL_COUNT,w
	call	EEWRITE		; write to EEPROM

; on delay
	movlw 	D'9'
	movwf	DELAY_EXTN
LOOP_DEL_DE
	movlw	D'255'
	call	DELAYX
	decfsz	DELAY_EXTN,f
	goto	LOOP_DEL_DE
	goto	ENROL_DELETE_MENU	
;---------------------------------------------------
ENROL_DELETE_ALL_MENU
	movlw	D'50'
	movwf	RETURN_COUNTER	; timer for return to home (scan for finger pressed)
	call	ENROLL_ALL_DELETE; show ENROL Delete all
	call	SW_DELAY
WAIT_S1_AD1
	bsf		SWITCHER,1	; set at other than 0
;(next 2 lines stops menu changes with Menu switch held on)
; wait for S1 to open
;	btfss	PORTB,1
;	goto	WAIT_S1_AD1
; time for S1 to open
	call	DELAYms
ALL_DEL_ENROL_MODE
; if S1 closes again change Mode 
	btfss	PORTB,1		; MENU switch
	goto 	MENU
	btfss 	PORTB,0		; switch S2 Enter
	goto	LOAD_DEL
; check for RETURN_COUNTER timer ended (decreased in interrupt) 
	movf	RETURN_COUNTER,w
	btfss	STATUS,Z
	goto	ALL_DEL_ENROL_MODE
	clrf	MODE
	goto	SCAN1
LOAD_DEL		
; load values for DeleteAll
	clrf	PARAM		; ID=all
	movlw	H'41'
	movwf	COMM
	movlw	H'41'
; checksum ; command
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps
	call	CHECK_ERROR
	xorlw	D'00'			; compare with 00
	btfss	STATUS,Z
	goto	ALL_DEL_ERR 
	call	WRITE_DELETED		; show on LCD

; clear enrol counter
	clrf	ENROL_COUNT
; load enrolment counter value
	movlw	EEPROM2C	; enrolment counter
	call	EEREAD		; sets EEADR
	movf	ENROL_COUNT,w
	call	EEWRITE		; write to EEPROM

; on delay
DELETE_GENERIC
	movlw 	D'9'
	movwf	DELAY_EXTN
LOOP_DEL_EC
	movlw	D'255'
	call	DELAYX
	decfsz	DELAY_EXTN,f
	goto	LOOP_DEL_EC
	call	OPEN_WORDS
	goto	SCAN1

ALL_DEL_ERR
	call	NO_ENROLMENTS; LCD showing 'no enrolments to delete'
	goto	DELETE_GENERIC
;--------------------------------------------------

DOOR_STRIKE_PERIOD
	movlw	D'50'
	movwf	RETURN_COUNTER	; timer for return to home (scan for finger pressed)
	call	WRITE_DOOR_STRIKE ; show on LCD door strike period setting
	call	SW_DELAY
WAIT_S1_3
;(next 2 lines stops menu changes with Menu switch held on)
; wait for S1 to open
;	btfss	PORTB,1
;	goto	WAIT_S1_3
; time for S1 to open
	call	DELAYms
DOOR_MODE
; if S1 closes again change Mode 
	btfss	PORTB,1
	goto 	MENU
; enter switch is not used
	btfss 	PORTB,4		; switch S3 Down
	goto	DEC_DELAY
	btfss	PORTB,3		; switch S4 UP
	goto	INC_DELAY
; check for RETURN_COUNTER timer ended (decreased in interrupt) 
	movf	RETURN_COUNTER,w
	btfss	STATUS,Z
	goto	DOOR_MODE	; wait for switches
	clrf	MODE
	goto	SCAN1

DEC_DELAY
	movf	DOOR_STRIKE,w
	btfsc	STATUS,Z
	goto	DOOR_BY		; bypass decreasing if 0
	decf	DOOR_STRIKE,f
	movf	DOOR_STRIKE,w
	btfsc	STATUS,Z
	movlw	D'1'		; minimum of 1
	movwf	DOOR_STRIKE
	goto	STO_DEL		; store value
INC_DELAY
	movf	DOOR_STRIKE,w
	xorlw	D'255'
	btfsc	STATUS,Z
	goto	DOOR_BY		; bypass increasing if 255
	incf	DOOR_STRIKE,f
;	goto	STO_DEL		; store value
STO_DEL
	movlw	D'50'
	movwf	RETURN_COUNTER	; timer for return to home (scan for finger pressed) decreased in interrupt
	movlw	EEPROM2A	; door strike period 
	call	EEREAD		; sets EEADR
	movf	DOOR_STRIKE,w	; period
	call	EEWRITE		; store in EEPROM
DOOR_BY
	call	WRITE_DOOR_STRIKE ; show on LCD door strike period setting
	call	SW_DELAY
	goto	DOOR_MODE
;--------------------------------------------------------

RESOLUTION
	movlw	D'50'
	movwf	RETURN_COUNTER	; timer for return to home (scan for finger pressed)
	call	RESOLUTION_SHOW ; show on LCD resolution setting
	call	SW_DELAY
WAIT_S1_R3
;(next 2 lines stops menu changes with Menu switch held on)
; wait for S1 to open
;	btfss	PORTB,1
;	goto	WAIT_S1_R3
; time for S1 to open
	call	DELAYms
RES_MODE
; if S1 closes again change Mode 
	btfss	PORTB,1
	goto 	MENU
; enter switch is not used
	btfss 	PORTB,4		; switch S3 Down
	goto	DEC_RES
	btfss	PORTB,3		; switch S4 UP
	goto	INC_RES
; check for RETURN_COUNTER timer ended (decreased in interrupt) 
	movf	RETURN_COUNTER,w
	btfss	STATUS,Z
	goto	RES_MODE	; wait for switches
	clrf	MODE
	goto	SCAN1
INC_RES		; toggle bit 0
DEC_RES
	incf	HI_RES,f
	andlw	B'00000001'	; just bit 0
	movlw	D'50'
	movwf	RETURN_COUNTER	; timer for return to home (scan for finger pressed) decreased in interrupt
	movlw	EEPROM2B	; resolution 
	call	EEREAD		; sets EEADR
	movf	HI_RES,w	; 
	call	EEWRITE		; store in EEPROM

	call	RESOLUTION_SHOW ; show on LCD resolution setting
	call	SW_DELAY
	goto	RES_MODE

;______________________________________________________

CHECK_ERROR ; check for errors
	bsf		STATUS,RP0	; select memory bank 1
	movf	RECEIVE8,w
	bcf		STATUS,RP0	; bank 0
	xorlw	H'30'		; if an acknowledge then no error
	btfsc	STATUS,Z
	retlw	H'00'		; no error
	retlw	H'FF'		; error
ENROL_ERR
; check for fail or bad finger	
 	call	ENROL_ERROR
GEN_ERR	; generic error code
	clrf	MODE
	movlw 	D'9'
	movwf	DELAY_EXTN
LOOP_DEL_E
	movlw	D'255'
	call	DELAYX
	decfsz	DELAY_EXTN,f
	goto	LOOP_DEL_E
	goto	NEW_ENROL_ID ;MENU
;-------------------------------------------------

; ENROL
SETUP ; set up mode for enrolment
	movf	FREE_ID,w
	movwf	PARAM		; ID=0-19
; enrol start with an unused ID
; load values for EnrolStart
	
	movlw	H'22'
	movwf	COMM
	movlw	H'22'
	addwf	FREE_ID,w	; checksum add ID value
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps
	call	CHECK_ERROR
	xorlw	D'00'		; compare with 00
	btfss	STATUS,Z
	goto	ENROL_ERR
; switch on LED

; load values for LED_ON
	movlw	H'01'
	movwf	PARAM
	movlw	H'12'
	movwf	COMM
	movlw	H'13'
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps

; drive display
	call	NEW_ENROL		; show on LCD line 1 (shows ID number)
	call	PRESS_FINGER	; show on LCD line 2

	movlw	D'255'
	movwf	RETURN_COUNTER	; decreased in interrupt

; check for pressed finger (IsPressFinger)

; load values for FINGER (is finger pressed)
	movlw	H'00'
	movwf	PARAM
	movlw	H'26'
	movwf	COMM
	movlw	H'26'
	movwf	C_SUM
CK_FING1; wait for finger pressed
	call	FPS_SERIAL	; drive fps
	call	IS_FINGER	; pressed or not
	bcf		STATUS,RP0	; bank 0
	xorlw	D'00'
	btfsc	STATUS,Z
	goto	CAPTURE1	; finger is pressed

; check for RETURN_COUNTER timer ended (decreased in interrupt) 
	movf	RETURN_COUNTER,w
	btfss	STATUS,Z
	decfsz	RETURN_COUNTER,f
	goto	CK_MENU_SW1	; wait for switches
	clrf	MODE
	goto	SCAN1
CK_MENU_SW1
; check MENU switch
	btfsc	PORTB,1
	goto	CK_FING1
	movlw	D'255'
	call	DELAYX
	clrf	MODE
	call	OPEN_WORDS	; write Fingerprint scanner
	goto	SCAN
	
;________________________________________________________
;subroutine
IS_FINGER ;(read parameter data for if finger pressed or not) Must reset to bank zero on after return
; check data for finger pressed. Parameter at RECEIVE4 & RECEIVE5 H1012 for not pressed

	bsf		STATUS,RP0	; select memory bank 1
	movf	RECEIVE4,w
	xorlw	H'12'		; compare with H12 for Finger pressed
	btfsc	STATUS,Z
	retlw	D'1'		; not pressed
	retlw	D'0'		; is pressed
;___________________________________________________________	

; CaptureFinger
	
CAPTURE1
	movlw	H'23'		; ENROL1 value, H'24' ENROL2, H'25 'ENROL3. Enrolx incremented to do 3 enrols
	movwf	ENROLX
CAPTUREX
	movlw	D'50'
	movwf	RETURN_COUNTER	; timer for return to home (scan for finger pressed) decreased in interrupt

	call	DELAYms
	call	DELAYms
; load values for CaptureFinger
	movlw	H'01'		; hi resolution	
	movwf	PARAM		; best image when not 0
	movlw	H'60'
	movwf	COMM
	movlw	H'60'
	addwf	PARAM,w	; add PARAM and COMMand	
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps
	call	CHECK_ERROR
	xorlw	D'00'
	btfss	STATUS,Z
	goto	ENROL_ERR
;Enrol
; load values for Enrol
	movlw	H'00'
	movwf	PARAM		; 
	movf	ENROLX,w	; enrol1,2,3
	movwf	COMM
	movwf	C_SUM
	call	FPS_SERIAL	; drive fps
	call	CHECK_ERROR
	xorlw	D'00'			; compare with 00
	btfss	STATUS,Z
	goto	ENROL_ERR

; check if last enrolment
	movf	ENROLX,w
	xorlw	H'25'		; third enrolment	
	btfsc	STATUS,Z
	goto	END_ENROL
;_____________________________________________________________________
; take off finger, wait till off
	call	REMOVE_FINGER	; show on LCD
	movlw	D'255'
	movwf	RETURN_COUNTER	; decreased each finger press check
; load values for FINGER (is finger pressed)
	movlw	H'00'
	movwf	PARAM
	movlw	H'26'
	movwf	COMM
	movlw	H'26'
	movwf	C_SUM
CK_FING_OFF2
	call	FPS_SERIAL	; drive fps
	call	IS_FINGER	; pressed or not
	bcf		STATUS,RP0	; bank 0
	xorlw	D'01'
	btfsc	STATUS,Z
	goto	REPRESS2	; finger is not pressed
; wait for finger pressed
	
; check for RETURN_COUNTER timer ended (decreased in interrupt) 
	movf	RETURN_COUNTER,w
	btfss	STATUS,Z
	decfsz	RETURN_COUNTER,f
	goto	CK_MENU_SW2	; wait for switches
	clrf	MODE
	goto	SCAN1
CK_MENU_SW2
; check MENU switch
	btfsc	PORTB,1
	goto	CK_FING_OFF2
	movlw	D'255'
	call	DELAYX
	clrf	MODE
	call	OPEN_WORDS	; write Fingerprint scanner
	goto	SCAN

; repress finger (IsPressFinger)
REPRESS2
; wait for finger pressed
	call	PRESS_FINGER	; show on LCD
	movlw	D'255'
	movwf	RETURN_COUNTER
; load values for FINGER (is finger pressed)
	movlw	H'00'
	movwf	PARAM
	movlw	H'26'
	movwf	COMM
	movlw	H'26'
	movwf	C_SUM
CK_FING2
	call	FPS_SERIAL	; drive fps
	call	IS_FINGER	; pressed or not
	bcf		STATUS,RP0	; bank 0
	xorlw	D'00'
	btfsc	STATUS,Z
	goto	CAPTURE2	; finger is pressed
; wait for finger pressed
	
; check for RETURN_COUNTER timer ended (decreased in interrupt) 
	movf	RETURN_COUNTER,w
	btfss	STATUS,Z
	decfsz	RETURN_COUNTER,f
	goto	CK_MENU_SW3	; wait for switches
	clrf	MODE
	goto	SCAN1
CK_MENU_SW3
; check ENROL switch
	btfsc	PORTB,1
	goto	CK_FING2
	movlw	D'255'
	call	DELAYX
	clrf	MODE
	call	OPEN_WORDS	; write Fingerprint scanner
	goto	SCAN
	
; CaptureFinger
CAPTURE2
	incf	ENROLX,f
	goto	CAPTUREX	; loop for 3 captures/enrolments

END_ENROL
	call	WRITE_ENROLLED		; show on LCD

; increase enrol counter
	incf	ENROL_COUNT,f
; load enrolment counter value
	movlw	EEPROM2C	; enrolment counter
	call	EEREAD		; sets EEADR
	movf	ENROL_COUNT,w
	call	EEWRITE		; write to EEPROM

; on delay
	movlw 	D'9'
	movwf	DELAY_EXTN
LOOP_DEL_C
	movlw	D'255'
	call	DELAYX
	decfsz	DELAY_EXTN,f
	goto	LOOP_DEL_C
	call	OPEN_WORDS
	clrf	MODE
	goto 	SCAN

;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

; Subroutines

; send data and wait till data sent

; fps codes
; initial start and device
FPS_SERIAL ; use PARAM, COMM and C_SUM for codes to fps
; start codes
	clrf	REG_COUNT	; Register counter	
	movlw	H'55'	; initialise bits and identification to FPS
	call	SEND
	movlw	H'AA'	
	call	SEND
;Device ID
	movlw	H'01'	
	call	SEND
	movlw	H'00'	
	call	SEND
; checksum H100 so far

; Parameter
	movf	PARAM,w	; ls byte
	call	SEND
	movf	PARAM1,w ; normally set at 0 but can be otherwise (eg for Baud rate change)	
	call	SEND
	movlw	H'00'	
	call	SEND
	movlw	H'00'	
	call	SEND
; Command
	movf	COMM,w	; ls byte
	call	SEND
	movlw	H'00'	
	call	SEND
;CHECK sum of all bytes so far
	movf	C_SUM,w	; ls byte
	call	SEND
	movlw	H'01'	; ms bit due to AA and 55 and 01 addition in start codes and device ID
	call	SEND

; wait for detection of sent signal and response from fps
WAIT
	clrf	TMR1L	; clear timer 1
	clrf	TMR1H
	bcf		PIR1,TMR1IF; flag cleared
WAIT1
	btfss	INT_FLG,0	; set in interrupt
	goto	WAIT1
TIMED_OUT
	clrf	INT_FLG
	return

SEND ;
WAIT_CLEAR
	btfss	PIR1,TXIF	; wait till flag is set	
	goto	WAIT_CLEAR
	movwf	TXREG		; transmit register
	return

; ___________________________________________________________________
; display routines
CLEAR_DISPLAY
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	D'6'
	call	SPACE_NO	; number of spaces
	movlw	A'W'		; 
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	D'6'
	call	SPACE_NO	; number of spaces
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movlw	D'16'
	call	SPACE_NO	; number of spaces
	return
OPEN_WORDS ; write Fingerprint Security Access
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	D'2'
	call	SPACE_NO
	call	WRITE_FINGER
	call	WRITE_PRINT
	movlw	D'3'
	call	SPACE_NO	; number of spaces
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movlw	A'S'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'c'		; 
	call	DRV_LCD
	movlw	A'u'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A'y'		; 
	call	DRV_LCD
	call	SPACE1
	call	WRITE_ACCESS
	call	SPACE1
	return
LOAD_SERIAL_No ; show on display 'Loading FPS Serial No.'
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A'd'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'g'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'P'		; 
	call	DRV_LCD
	movlw	A'S'		; 
	call	DRV_LCD
	movlw	D'6'
	call	SPACE_NO	; number of spaces
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	call	WRITE_SERIAL
	call	SPACE1
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	H'00'		; No. (generated character)
	call	DRV_LCD
	movlw	D'8'
	call	SPACE_NO	; number of spaces
	return
ACCESS ; write Access
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	call	WRITE_ACCESS
	call	SPACE1
	return
ALLOWED
	movlw	H'87'		; address line 1 pos 7
	call	LOAD
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	movlw	A'w'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'd'		; 
	call	DRV_LCD
	movlw	D'2'
	call	SPACE_NO	; number of spaces
	movlw	H'C0'		; remark out address line 2 pos 12
	call	LOAD
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'd'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A'y'		; 
	call	DRV_LCD
	call	SPACE1
	movf	ID_STO,w
	call	TWO_DIGITS
	
; show number of repeat ID checks 
	call	SPACE1		; 
	incf	RECAPTURE,w	; uses incf so 0 is shown as a 1 
	call	TWO_DIGITS	; 
	movlw	H'CC'		; address line 2 pos 12
	call	LOAD		; 
	movlw	A'['		;  
	call	DRV_LCD		; 
	movlw	H'CE'		; address line 1 pos 15
	call	LOAD		; 
	movlw	A'x'		; 
	call	DRV_LCD		; 
	movlw	A']'		; 
	call	DRV_LCD		; 
	return				; 	
; lines required if number of repeat ID checks is remarked out
;	movlw	D'6'
;	call	SPACE_NO	; number of spaces
;	return

DENIED
	movlw	H'87'		; address line 1 pos 7
	call	LOAD
	movlw	A'D'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'd'		; 
	call	DRV_LCD
	movlw	D'3'
	call	SPACE_NO	; number of spaces
	return
SERIAL_No_ERR
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	call	WRITE_SERIAL
	call	SPACE1
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	H'00'		; o. generated character
	call	DRV_LCD
	call	SPACE1
	call	WRITE_ERROR
	call	SPACE1
PRESS_ENTER
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	call	WRITE_PRESS
	call	SPACE1
	movlw	H'01'		; enter symbol 
	call	DRV_LCD
	movlw	D'9'
	call	SPACE_NO	; number of spaces
	return
DB_EMPTY; no enrolments
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	call 	SPACE1
	call	WRITE_ENROL
	call	WRITE_MENTS	; end of ENROL MENTS
	movlw	D'3'
	call	SPACE_NO	; number of spaces
	return		
ID_FAIL ; No ID Match
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'D'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'M'		; 
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A'c'		; 
	call	DRV_LCD
	movlw	A'h'		; 
	call	DRV_LCD
	movlw	D'6'
	call	SPACE_NO	; number of spaces
	return		
NEW_ENROL
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'w'		; 
	call	DRV_LCD
	call	WRITE_ENROL
	call	SPACE1
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'D'		; 
	call	DRV_LCD	
	incf	FREE_ID,w	; show enrol ID 1-20
	call	THREE_DIGITS
	movlw	H'2'		; down symbol
	call	DRV_LCD
	movlw	H'3'		; up symbol	
	call	DRV_LCD
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	call	WRITE_PRESS
	movlw	H'01'		; enter symbol 
	call	DRV_LCD
	call	SPACE1
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	call	SPACE1
	call	WRITE_ENROL
	call	SPACE1
	return
PRESS_FINGER
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	call	WRITE_PRESS
	call	SPACE1
	call	WRITE_FINGER
	movlw	D'4'
	call	SPACE_NO	; number of spaces
	return
REMOVE_FINGER
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movlw	A'R'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	movlw	A'v'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	call	SPACE1
	call	WRITE_FINGER
	movlw	D'4'
	call	SPACE_NO	; number of spaces
	return
WRITE_DELETED
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	call	WRITE_DELETE
	movlw	A'd'		; 
	call	DRV_LCD
	movlw	D'9'
	call	SPACE_NO	; number of spaces
	return
WRITE_ENROLLED
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	call	WRITE_ENROL
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'd'		; 
	call	DRV_LCD
	movlw	D'8'
	call	SPACE_NO	; number of spaces
	return
ID_ERROR
ENROL_ERROR
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
; get error
	bsf		STATUS,RP0	; select memory bank 1
	movf	RECEIVE4,w
	bcf		STATUS,RP0
	movwf	TEMP1
; select error type
	movf	TEMP1,w
	xorlw	H'C'		; bad finger
	btfsc	STATUS,Z
	goto	BAD_FINGER
	movf	TEMP1,w
	xorlw	H'D'
	btfss	STATUS,Z
	goto	FAIL
; Finger not pressed
FINGER_OFF
	call	WRITE_FINGER
	call	SPACE1
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'f'		; 
	call	DRV_LCD
	movlw	A'f'		; 
	call	DRV_LCD
	call	SPACE1
	call	WRITE_ERROR
	return
FAIL
; Enrolment Fail
	call	WRITE_ENROL
	movlw	A'm'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	call 	SPACE1
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	D'2'
	call	SPACE_NO	; number of spaces
	return
BAD_FINGER ; poor fingerprint
	movlw	A'P'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	call	SPACE1
	call	WRITE_FINGER
	call	WRITE_PRINT
	return

WRITE_DOOR_STRIKE; (Door Strike period)
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	A'D'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'S'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'k'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'T'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	D'3'
	call	SPACE_NO	; number of spaces
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movf	DOOR_STRIKE,w	; show door strike period
	call	THREE_DIGITS
	movlw	A's'		; seconds
	call	DRV_LCD	
	movlw	D'2'
	call	SPACE_NO	; number of spaces
	call	WRITE_PRESS	
	movlw	D'3'
	call	SPACE_NO	; number of spaces
	movlw	H'02'		; down
	call	DRV_LCD
	movlw	H'3'		; up
	call	DRV_LCD
	return
ENROL_DELETE ;  Enrolment ID Enter to Delete
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	call	WRITE_ENROL
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'd'		; 
	call	DRV_LCD
	call	SPACE1		; number of spaces
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'D'		; 
	call	DRV_LCD
	incf	FREE_ID,w	; show enrol ID 1-20
	call	THREE_DIGITS
	movlw	H'2'		; down symbol
	call	DRV_LCD
	movlw	H'3'		; up symbol	
	call	DRV_LCD
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	call	WRITE_PRESS
	movlw	H'01'		; enter symbol 
	call	DRV_LCD
	call	SPACE1
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	call	SPACE1
	call	WRITE_DELETE
	movlw	D'2'
	call	SPACE_NO	; number of spaces
	return
ENROLMENTS_FULL
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	call	WRITE_ENROL
	call	WRITE_MENTS	; end of elrol
	call	SPACE1
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'u'		; 
	call	DRV_LCD	
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'l'		; 
	call	DRV_LCD	
	call	SPACE1
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movlw	D'16'
	call	SPACE_NO	; number of spaces
	return
NO_ENROLMENTS
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	call	SPACE1
	call	WRITE_ENROL
	call	WRITE_MENTS	
	movlw	D'4'
	call	SPACE_NO	; number of spaces
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	call	SPACE1
	call	WRITE_DELETE
	movlw	D'8'
	call	SPACE_NO	; number of spaces
	return
ENROLL_ALL_DELETE
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	call	WRITE_DELETE
	call	SPACE1
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'l'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'D'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	movlw	D'2'
	call	SPACE_NO	;' number of spaces
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	call	WRITE_PRESS
	movlw	H'01'		; enter symbol 
	call	DRV_LCD
	call	SPACE1
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	call	SPACE1
	call	WRITE_DELETE
	return
RESOLUTION_SHOW
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	A'S'		; 
	call	DRV_LCD
	movlw	A'c'		; 
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'R'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD		
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'u'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD		
	movlw	A'n'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	btfss	HI_RES,0
; if bit is set, then low resolution
	goto	HI_SHOW	
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	movlw	A'w'		; 
	call	DRV_LCD
	movlw	A':'		; 
	call	DRV_LCD
	call	SPACE1
	goto	END_RES
HI_SHOW
	movlw	A'H'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD		
	movlw	A'g'		; 
	call	DRV_LCD
	movlw	A'h'		; 
	call	DRV_LCD
	movlw	A':'		; 
	call	DRV_LCD
END_RES
	call	SPACE1
	call	WRITE_PRESS
	movlw	D'3'
	call	SPACE_NO	; number of spaces
	movlw	H'2'		; down symbol
	call	DRV_LCD
	movlw	H'3'		; up symbol	
	call	DRV_LCD
	return
IDENTIFICATION
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	call	SPACE1		; number of spaces
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'd'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD		
	movlw	A'f'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'c'		; 
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	call	SPACE1		; number of spaces
	return
;--------------------------------------------------------
WRITE_FINGER
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'g'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	return
WRITE_PRINT ; (added to end of finger for fingerprint)
	movlw	A'p'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	return
WRITE_ACCESS
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'c'		; 
	call	DRV_LCD
	movlw	A'c'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	return
WRITE_SERIAL
	movlw	A'S'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A'l'		; 
	call	DRV_LCD
	return
WRITE_ERROR
	movlw	A'E'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	return
WRITE_ENROL	
	movlw	A'E'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD		
	movlw	A'l'		; 
	call	DRV_LCD
	return
WRITE_DELETE
	movlw	A'D'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD		
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	return
WRITE_PRESS
	movlw	A'P'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	return
WRITE_MENTS ; end or ENROL MENTS
	movlw	A'm'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A's'	
	call	DRV_LCD
	return
WRITE_TAMPER
	movlw	A'T'		; 
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD
	movlw	A'p'		; 
	call	DRV_LCD		
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	return
;______________________________________________________________________________
; character generation 
CHARACTR_GEN
; write o. as part of No. for number with full stop within the o character
	movlw	B'01000000'	; address 0
	call	LOAD		; character gen 1 
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00001100'
	call	DRV_LCD
	movlw	B'00010010'
	call	DRV_LCD
	movlw	B'00010010'
	call	DRV_LCD
	movlw	B'00001101'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD

; write enter character
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000001'
	call	DRV_LCD
	movlw	B'00000001'
	call	DRV_LCD
	movlw	B'00001001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00001000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD

; down symbol
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00001010'
	call	DRV_LCD
	movlw	B'00000100'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD

; up symbol
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000100'
	call	DRV_LCD
	movlw	B'00001010'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	
	return
;__________________________________________________________________________________	
THREE_DIGITS; drives display with 3-digits
	movwf	BIN_0		; binary value

	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT1,w		; ms value
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOAD1
	call	SPACE1		; leading 0's to space
	movf	OUT2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOAD2
	call	SPACE1		; leading 0's to space
	goto	LOAD3
LOAD1
	movf	OUT1,w
	call	DRV_LCD
LOAD2
	movf	OUT2,w
	call	DRV_LCD
LOAD3
	movf	OUT3,w
	call	DRV_LCD
	return

TWO_DIGITS; drives display with 2-digits
	movwf	BIN_0		; binary value
	bcf		BIN_0,7		; bit 7 cleared (-sign in degrees C)

	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT2,w		; ms value
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOAD11
	call	SPACE1		; leading 0 to space
	goto	SPACE22	
LOAD11
	movf	OUT2,w
	call	DRV_LCD
SPACE22
	movf	OUT3,w
	call	DRV_LCD
	return

; add space/spaces in display

SPACE_NO
	movwf	SPACE_COUNT
SPACE_NO_LOOP
	movlw	H'20'		; space
	call	DRV_LCD
	decfsz	SPACE_COUNT,f
	goto	SPACE_NO_LOOP
	return
SPACE1
	movlw	H'20'		; space
	call	DRV_LCD
	return

; switch delay 0.5s
SW_DELAY 
	clrf	SW_OPEN		; switch open flag

	movlw	D'4'
	movwf	SW_FLAG
SW_LOOP
; if switch opens then closes during delay return from delay early
; set flag when open

; check for switch to open
	movlw	B'00011011'		; isolate S1-S4
	andwf	PORTB,w		; look at Switches
	xorlw	B'00011011'		; if switch inputs all high no switch closed
	btfsc	STATUS,Z
	bsf		SW_OPEN,0		; set flag when open
; if a switch is pressed return
	btfsc	SW_OPEN,0
	goto	RET_EARLY		
	call	DELAYms
	decfsz	SW_FLAG,f	; decrease until zero
	goto	SW_LOOP
	return
RET_EARLY
	call	DELAYms
	return

; delay loop 

DELAYms ; 120ms
	movlw	D'223'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	H'B0'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

DELAY1
	movlw	D'4'		; delay value (188=100ms)
DELAYXX
	movwf	STORE1		; STORE1 is number of loops value
LOOPA	
	movlw	D'7'
	movwf	STORE2		; STORE2 is internal loop value	
LOOPB
	decfsz	STORE2,f
	goto	LOOPB
	decfsz	STORE1,f
	goto	LOOPA		; decrease till STORE1 is zero
	return


;DELAY
;	movlw	D'30'		;30
;DELAY_SET
;	movwf	STORE1
;LOOP0
;	decfsz	STORE1,f
;	goto	LOOP0
;	return

; initialise display

INIT_LC
	movlw	B'00001001'	; DB4 and DB5 high (via RA0,RA3) to initialise module
	movwf	PORTA
	nop
	bsf		PORTA,7		; enable high
	nop
	bcf		PORTA,7		; low
	return

; preload display commands (4-bit) 

LOAD
	movwf	D_STO		; store data	
	movf	D_STO,w
	andlw	H'F0'		; get upper bits
; place ms bits of display commands in portA
	movwf	PORTA_STO
	clrf	PORTA		; data lines low	
	btfsc	PORTA_STO,7
	bsf		PORTA,1		; set data lines if required
	btfsc	PORTA_STO,6
	bsf		PORTA,2	
	btfsc	PORTA_STO,5
	bsf		PORTA,0	
	btfsc	PORTA_STO,4
	bsf		PORTA,3	
	bcf		PORTA,6		; register select low
	nop
	bsf		PORTA,7		; enable set
	nop
	bcf		PORTA,7		; enable clear
	swapf	D_STO,w
	andlw	H'F0'		; get lower bits

; place ls 4-bits display commands in portA
	movwf	PORTA_STO
	clrf	PORTA
	btfsc	PORTA_STO,7
	bsf		PORTA,1		; set data lines if required
	btfsc	PORTA_STO,6
	bsf		PORTA,2	
	btfsc	PORTA_STO,5
	bsf		PORTA,0	
	btfsc	PORTA_STO,4
	bsf		PORTA,3	
	bcf		PORTA,6		; register select low
	nop
	bsf		PORTA,7		; enable set
	nop
	bcf		PORTA,7		; enable clear
	goto	BUS_CK		; check busy flag
	
; driving the LCD module with display data

DRV_LCD	
	movwf	D_STO		; store data
	andlw	H'F0'		; upper bits
	movwf	PORTA_STO
	clrf	PORTA
	btfsc	PORTA_STO,7
	bsf		PORTA,1		; set data lines if required
	btfsc	PORTA_STO,6
	bsf		PORTA,2	
	btfsc	PORTA_STO,5
	bsf		PORTA,0	
	btfsc	PORTA_STO,4
	bsf		PORTA,3	
	bsf		PORTA,6		; register select
	bsf		PORTA,7		; enable high
	nop
	bcf		PORTA,7		; enable low
	swapf	D_STO,w
	andlw	H'F0'		; lower bits
	movwf	PORTA_STO
	clrf	PORTA
	btfsc	PORTA_STO,7
	bsf		PORTA,1		; set data lines if required
	btfsc	PORTA_STO,6
	bsf		PORTA,2	
	btfsc	PORTA_STO,5
	bsf		PORTA,0	
	btfsc	PORTA_STO,4
	bsf		PORTA,3	
	bsf		PORTA,6		; register select
	bsf		PORTA,7		; enable high
	nop
	bcf		PORTA,7		; enable low

BUS_CK ; time for display to finish updating data
	movlw 	D'2'		; 
	movwf	STORE1		; delay values
	movlw	D'255'		; delay for busy flag to clear
	goto	DELDSP

; subroutine to read EEPROM memory 

EEREAD
	bcf		STATUS,RP0	; select bank 0
	bsf 	STATUS,RP1	; select memory bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM
EWRITE
EEWRITE	
	bcf 	STATUS,RP0	; bank 0
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf 	STATUS,RP0	; select memory bank 3
WR3	
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR3			; not written yet
	bcf		INTCON,GIE	; disable interrupts
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
	bsf 	INTCON,GIE	; enable interrupts
WRITE
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 	STATUS,RP0	; select memory bank 0
	return				; value written 

; Subroutine to convert from 8-bit binary to 2-digit BCD (packed)
; Binary value is in BIN_0  
; Result in BCD is in BCD_0 & BCD_1.  
; BCD_0 is MSB, BCD_1 is LSB
; converts to unpacked ASCII in OUT1, OUT2, OUT3 (out1 is ms byte, out3 is ls byte)

BCD_ASCII
	bcf		STATUS,C	; clear carry bit
	movlw	D'8'
	movwf	CNT_8		; 8 in count
	clrf	BCD_0
	clrf	BCD_1		; set BCD registers to 0 
LOOPBCD
	rlf		BIN_0,f		; shift left binary registers
	rlf		BCD_1,f		; MSB shift left

	rlf		BCD_0,f		; LSB shift left BCD registers
	decfsz	CNT_8,f		; reduce count value return when 0
	goto	DECADJ		; continue decimal adjust

; completed decimal to BCD operation, convert to unpacked ASCII
	
	movf	BCD_1,w		; ls decimal
	andlw	H'0F'		; ls
	addlw	H'30'		; convert to ASCII
	movwf	OUT3
	swapf	BCD_1,w 	; mid decimal value
	andlw	H'0F'
	addlw	H'30'		; convert to ASCII
	movwf	OUT2
	movf	BCD_0,w
	addlw	H'30'		; convert to ASCII
	movwf	OUT1		; ms decimal value
	return				; ASCII values returned in OUT1, OUT2, OUT3 

; subroutine decimal adjust

DECADJ
	movlw	BCD_1		; BCD LSB address
	movwf	FSR			; pointer for BCD1
	call	ADJBCD		; subroutine to adjust BCD
	movlw	BCD_0		; BCD MS address
	movwf	FSR			; pointer for BCD0
	call	ADJBCD
	goto	LOOPBCD

; subroutine adjust BCD

ADJBCD	
	movlw	H'03'		; w has 03 
	addwf	INDF,w		; add 03 to BCDx register (x is 0-1)
	movwf	TEMP		; store w
	btfsc	TEMP,3		; test if >7
	movwf	INDF		; save as LS digit
	movlw	H'30'		; 3 for MSbyte
	addwf	INDF,w		; add 30 to BCDx register
	movwf	TEMP		; store w in temp
	btfsc	TEMP,7		; test if >7
	movwf	INDF		; save as MS digit
	return				; end subroutine




	end
