
; Pulse Width Modifier 

	list P=16F628A
	#include p16f628A.inc

	__config _HS_OSC & _WDT_ON & _PWRTE_ON & _BOREN_ON & _MCLRE_OFF & _LVP_OFF

; Define variables at memory locations

EEPROM1		equ	H'00'	; non-volatile storage for data 0  
EEPROM2		equ	H'01'	; non-volatile storage for data 1
EEPROM3		equ	H'02'	; non-volatile storage for data 2
EEPROM4		equ	H'03'	; non-volatile storage for data 3
EEPROM5		equ	H'04'	; non-volatile storage for data 4	
EEPROM6		equ	H'05'	; non-volatile storage for data 5
EEPROM7		equ	H'06'	; non-volatile storage for data 6 		
EEPROM8		equ	H'07'	; non-volatile storage for data 7 
EEPROM9		equ	H'08'	; non-volatile storage for data 8 
EEPROM10	equ	H'09'	; non-volatile storage for data 9
EEPROM11	equ	H'0A'	; non-volatile storage for data 10
EEPROM12	equ	H'0B'	; non-volatile storage for data 11
EEPROM13	equ	H'0C'	; non-volatile storage for data 12
EEPROM14	equ	H'0D'	; non-volatile storage for data 13
EEPROM15	equ	H'0E'	; non-volatile storage for data 14
EEPROM16	equ	H'0F'	; non-volatile storage for data 15
EEPROM17	equ	H'10'	; non-volatile storage for data 16
EEPROM18	equ	H'11'	; non-volatile storage for data 17
EEPROM19	equ	H'12'	; non-volatile storage for data 18  
EEPROM20	equ	H'13'	; non-volatile storage for data 19  
EEPROM21	equ	H'14'	; non-volatile storage for data 20
EEPROM22	equ	H'15'	; non-volatile storage for data 21 
EEPROM23	equ	H'16'	; non-volatile storage for data 22
EEPROM24	equ	H'17'	; non-volatile storage for data 23
EEPROM25	equ	H'18'	; non-volatile storage for data 24
EEPROM26	equ	H'19'	; non-volatile storage for data 25 
EEPROM27	equ	H'1A'	; non-volatile storage for data 26
EEPROM28	equ	H'1B'	; non-volatile storage for data 27
EEPROM29	equ	H'1C'	; non-volatile storage for data 28
EEPROM30	equ	H'1D'	; non-volatile storage for data 29
EEPROM31	equ	H'1E'	; non-volatile storage for data 30
EEPROM32	equ	H'1F'	; non-volatile storage for data 31 
EEPROM33	equ	H'20'	; non-volatile storage for data 32
EEPROM34	equ	H'21'	; non-volatile storage for data 33
EEPROM35	equ	H'22'	; non-volatile storage for data 34 
EEPROM36	equ	H'23'	; non-volatile storage for data 35
EEPROM37	equ	H'24'	; non-volatile storage for data 36
EEPROM38	equ	H'25'	; non-volatile storage for data 37
EEPROM39	equ	H'26'	; non-volatile storage for data 38 
EEPROM40	equ	H'27'	; non-volatile storage for data 39
EEPROM41	equ	H'28'	; non-volatile storage for data 40
EEPROM42	equ	H'29'	; non-volatile storage for data 41  
EEPROM43	equ	H'2A'	; non-volatile storage for data 42 
EEPROM44	equ	H'2B'	; non-volatile storage for data 43
EEPROM45	equ	H'2C'	; non-volatile storage for data 44
EEPROM46	equ	H'2D'	; non-volatile storage for data 45
EEPROM47	equ	H'2E'	; non-volatile storage for data 46
EEPROM48	equ	H'2F'	; non-volatile storage for data 47
EEPROM49	equ	H'30'	; non-volatile storage for data 48 
EEPROM50	equ	H'31'	; non-volatile storage for data 49
EEPROM51	equ	H'32'	; non-volatile storage for data 50
EEPROM52	equ	H'33'	; non-volatile storage for data 51
EEPROM53	equ	H'34'	; non-volatile storage for data 52
EEPROM54	equ	H'35'	; non-volatile storage for data 53
EEPROM55	equ	H'36'	; non-volatile storage for data 54
EEPROM56	equ	H'37'	; non-volatile storage for data 55
EEPROM57	equ	H'38'	; non-volatile storage for data 56
EEPROM58	equ	H'39'	; non-volatile storage for data 57 
EEPROM59	equ	H'3A'	; non-volatile storage for data 58 
EEPROM60	equ	H'3B'	; non-volatile storage for data 59 
EEPROM61	equ	H'3C'	; non-volatile storage for data 60
EEPROM62	equ	H'3D'	; non-volatile storage for data 61
EEPROM63	equ	H'3E'	; non-volatile storage for data 62
EEPROM64	equ	H'3F'	; non-volatile storage for data 63
EEPROM65	equ	H'40'	; non-volatile storage for data 64  
EEPROM66	equ	H'41'	; non-volatile storage for data 65
EEPROM67	equ	H'42'	; non-volatile storage for data 66
EEPROM68 	equ	H'43'	; non-volatile storage for data 67
EEPROM69	equ	H'44'	; non-volatile storage for data 68	
EEPROM70	equ	H'45'	; non-volatile storage for data 69
EEPROM71	equ	H'46'	; non-volatile storage for data 70 		
EEPROM72	equ	H'47'	; non-volatile storage for data 71 
EEPROM73	equ	H'48'	; non-volatile storage for data 72 
EEPROM74	equ	H'49'	; non-volatile storage for data 73
EEPROM75	equ	H'4A'	; non-volatile storage for data 74
EEPROM76	equ	H'4B'	; non-volatile storage for data 75
EEPROM77	equ	H'4C'	; non-volatile storage for data 76
EEPROM78	equ	H'4D'	; non-volatile storage for data 77
EEPROM79	equ	H'4E'	; non-volatile storage for data 78
EEPROM80	equ	H'4F'	; non-volatile storage for data 79
EEPROM81	equ	H'50'	; non-volatile storage for data 80
EEPROM82	equ	H'51'	; non-volatile storage for data 81
EEPROM83	equ	H'52'	; non-volatile storage for data 82  
EEPROM84	equ	H'53'	; non-volatile storage for data 83  
EEPROM85	equ	H'54'	; non-volatile storage for data 84
EEPROM86	equ	H'55'	; non-volatile storage for data 85 
EEPROM87	equ	H'56'	; non-volatile storage for data 86
EEPROM88	equ	H'57'	; non-volatile storage for data 87
EEPROM89	equ	H'58'	; non-volatile storage for data 88
EEPROM90    equ	H'59'	; non-volatile storage for data 89 
EEPROM91	equ	H'5A'	; non-volatile storage for data 90
EEPROM92	equ	H'5B'	; non-volatile storage for data 91
EEPROM93	equ	H'5C'	; non-volatile storage for data 92
EEPROM94	equ	H'5D'	; non-volatile storage for data 93
EEPROM95	equ	H'5E'	; non-volatile storage for data 94
EEPROM96	equ	H'5F'	; non-volatile storage for data 95 
EEPROM97	equ	H'60'	; non-volatile storage for data 96
EEPROM98	equ	H'61'	; non-volatile storage for data 97
EEPROM99	equ	H'62'	; non-volatile storage for data 98 
EEPROM100	equ	H'63'	; non-volatile storage for data 99
EEPROM101	equ	H'64'	; non-volatile storage for data 100
EEPROM102	equ	H'65'	; non-volatile storage for data 101
EEPROM103	equ	H'66'	; non-volatile storage for data 102 
EEPROM104	equ	H'67'	; non-volatile storage for data 103
EEPROM105	equ	H'68'	; non-volatile storage for data 104
EEPROM106	equ	H'69'	; non-volatile storage for data 105  
EEPROM107	equ	H'6A'	; non-volatile storage for data 106 
EEPROM108	equ	H'6B'	; non-volatile storage for data 107
EEPROM109	equ	H'6C'	; non-volatile storage for data 108
EEPROM110	equ	H'6D'	; non-volatile storage for data 109
EEPROM111	equ	H'6E'	; non-volatile storage for data 110
EEPROM112	equ	H'6F'	; non-volatile storage for data 111
EEPROM113	equ	H'70'	; non-volatile storage for data 112 
EEPROM114	equ	H'71'	; non-volatile storage for data 113
EEPROM115	equ	H'72'	; non-volatile storage for data 114
EEPROM116	equ	H'73'	; non-volatile storage for data 115
EEPROM117	equ	H'74'	; non-volatile storage for data 116
EEPROM118	equ	H'75'	; non-volatile storage for data 117
EEPROM119	equ	H'76'	; non-volatile storage for data 118
EEPROM120	equ	H'77'	; non-volatile storage for data 119
EEPROM121	equ	H'78'	; non-volatile storage for data 120
EEPROM122	equ	H'79'	; non-volatile storage for data 121 
EEPROM123	equ	H'7A'	; non-volatile storage for data 122 
EEPROM124	equ	H'7B'	; non-volatile storage for data 123 
EEPROM125	equ	H'7C'	; non-volatile storage for data 124
EEPROM126	equ	H'7D'	; non-volatile storage for data 125
EEPROM127	equ	H'7E'	; non-volatile storage for data 126
EEPROM128	equ	H'7F'	; non-volatile storage for data 127

; Bank 0 RAM

BCD_0		equ	H'20'	; MS bcd value
BCD_1		equ	H'21'	; LS binary coded decimal value
BIN_0		equ	H'22'	; 8-bit binary value
TEMP		equ	H'23'	; data storage (BCD convert)
CNT_8		equ	H'24'	; counter in BCD routine
TEMP1		equ	H'25'	; delay storage value
OUTPUT		equ	H'26'	; output offset value
OUT1		equ	H'27'	; ms decimal display value
OUT2		equ	H'28'	; mid decimal display value
OUT3		equ	H'29'	; ls decimal display value
STORE1		equ	H'2A'	; delay counter	
STORE2		equ	H'2B'	; delay counter
STORE3		equ	H'2C'	; delay counter
IN_STO		equ	H'2D'	; input store	
D_STO		equ	H'2E'	; display data storage
ADDRESS		equ	H'2F'	; LCD address position
 
; warning! do not change designated addresses 31 to 3F below as these are used in the clearing routine
; at start of Main program

SW_CHNG		equ	H'31'	; switch changed flag
COUNTX		equ	H'32'	; counter for timeout
COUNTY		equ	H'33'	; counter for timeout
COUNT1		equ	H'34'	; counter for high pulse ls byte
COUNT2		equ	H'35'	; counter for high pulse ms byte
COUNT3		equ	H'36'	; counter for low pulse ls byte
COUNT4		equ	H'37'	; counter for low pulse ms byte	
FLAG_1		equ	H'38'	; 1, high pulse started; 2, low pulse started; 3, finished
FLAG_0		equ	H'39'	; bit 0 overrange flag
PWM_VAL		equ	H'3A'	; PWM value
VIEW		equ	H'3B'	; input viewing value
SW_FLG		equ	H'3C'	; switch closed flag
SW_CK		equ	H'3D'	; clock counter switch
INPUT		equ	H'3E'	; input value
MODE		equ	H'3F'	; run or view mode

SW_VAL		equ	H'42'	; switch value
CUR_DA		equ	H'43'  	; current data applied to up/down counters
REQ_VAL		equ	H'44'	; required value for output
STEP		equ	H'45'	; step increment or decrement value
E_COUNT		equ	H'46'	; counter to provide default settings in all EEPROM locations
OUT_SIDE	equ	H'47'	; output value for side values
ADD_STO		equ	H'48'	; address storage for EEADR fo side value changes
COUNT5		equ	H'49'	; latched counter for high pulse ls byte
COUNT6 		equ	H'4A'	; latched counter for high pulse ms byte
COUNT7		equ	H'4B'	; latched counter for low pulse ls byte
COUNT8		equ	H'4C'	; latched counter for low pulse ms byte	
COUNT_5		equ	H'4D'	; latched counter for high pulse ls byte store
COUNT_6 	equ	H'4E'	; latched counter for high pulse ms byte store
STORE4		equ	H'4F'	; delay counter	
STORE5		equ	H'50'	; delay counter
STORE6		equ	H'51'	; delay counter
STORE7		equ	H'52'	; delay counter	
VW_FLAG		equ	H'53'	; view run flag to add delay 

; math routines

TEMPB1      equ 0x61
TEMPB0      equ 0x62
TEMPD       equ 0x63    ; temporary storage
AARGB3		equ	0x64
AARGB2      equ 0x65
AARGB1      equ 0x66
AARGB0      equ 0x67
AARG        equ 0x67    ; most significant byte of argument A
BARGB1      equ 0x68
BARGB0      equ 0x69
BARG        equ 0x69    ; most significant byte of argument B
REMB1       equ 0x6A
REMB0       equ 0x6B    ; most significant byte of remainder
LOOPCOUNT   equ 0x6C    ; loop counter
STO1		equ	0x6D	; AARGB1 storage
STO2		equ	0x6E	; AARGB2 storage

; All Banks RAM
ST_ADR		equ	H'70'	; storage of EEPROM Address during interrupt
EDTA_ST		equ	H'71'	; EEPROM data store
W_TMP		equ	H'72'	; storage of w before interrupt
STATUS_TMP	equ	H'73'	; status storage before interrupt

; preprogram EEPROM DATA all at centre 0V position
	
	ORG     2100
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'

; start at memory 0

	org	0
	goto	MAIN
	org     4			; interrupt vector 0004h, start interrupt routine here
;	goto	INTRUPT		

;******************************************************************************************* 

; INTERRUPT

; start interrupt by saving w and status registers before altered by interrupt routine

INTRUPT	
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp  
	bsf		STATUS,RP0	; bank 1
	movf	EEADR,w		; EEPROM address 
	movwf	ST_ADR		; keep address
	movf	EEDATA,w	; EEPROM data
	movwf	EDTA_ST		; store value
	bcf		STATUS,RP0	; select bank 0
	bcf		INTCON,T0IF	; clear TMRO interrupt flag
	movlw	D'190'
	addwf	TMR0,f		; speed interrupt rate

; measure pulse widths
; FLAG_1 bit 3 is set when positive edge detected so start counting
; bit1 set when started counting, bit 2 set when negative edge detected,
; bit 3 set when next positive edge detected. Transfer data to memory when finished

PWMCNT	
	btfsc	FLAG_1,1	; has counter sequence started
	goto	COUNT_P		; count positive edge start

	btfss	FLAG_1,3	; if flag set then set flag_1,1 when RB0 high
	goto	CHK_LOW
	btfsc	PORTA,0		; is RA0 high
	bsf		FLAG_1,1
	goto	TIMEOUT

CHK_LOW
	btfss	PORTA,0		; is RA0 low
	bsf		FLAG_1,3	; set flag when RB0 is low
	goto	TIMEOUT
	
COUNT_P	
	incfsz	COUNT1,f	; if zero increment most significant byte
	goto	COUNT_T		; count test
	incfsz	COUNT2,f	; if zero flag overrange
	goto	COUNT_T
	bsf		FLAG_0,0
	
COUNT_T	
	btfsc 	FLAG_1,2	; has second counter started
	goto	COUNT_N
	btfsc	PORTA,0		; is level low
	goto	TIMEOUT
	bsf		FLAG_1,2
	goto	N_UP		; count when flag set
	
COUNT_N	
	btfsc	PORTA,0		; check if high again
	goto	END_CNT
N_UP
	incfsz	COUNT3,f	; if zero increment most significant byte
	goto	TIMEOUT		; end
	incfsz	COUNT4,f	; if zero flag overrange
	goto	TIMEOUT
	bsf		FLAG_0,0	; overrange ie always high
	goto	TIMEOUT

; check if counters have reached enough counts otherwise count for more sets of pulses
	
END_CNT	
	movf	COUNT2,w
	sublw	B'00000001'	; compare with 512 for ms counter
	btfss	STATUS,C	; if still less, not enough counts so continue
	goto	CLEAR_C		; clear counters
	bcf		FLAG_1,2	; clear negative edge flag to stop counting the pulse till edge
						; occurs again
	goto	TIMEOUT
			
CLEAR_C	
	clrf	FLAG_1		; clear flags
	clrf	FLAG_0
	movf	COUNT1,w
	movwf	COUNT5
	movf	COUNT2,w
	movwf	COUNT6
	movf	COUNT3,w
	movwf	COUNT7
	movf	COUNT4,w
	movwf	COUNT8
	clrf	COUNT1
	clrf	COUNT2
	clrf	COUNT3
	clrf	COUNT4
	clrf	COUNTX		; overrange counter
	clrf	COUNTY		; overrange counter
TIMEOUT
	incfsz	COUNTX,f	; increase ls timeout counter
	goto	SW_10	
	incf	COUNTY,f
	btfss	COUNTY,4	; if set then timeout flag set
	goto	SW_10	
	bsf		FLAG_0,1	; timeout ie frequency too low or always low

; check switches closed from 0-10 count 
; when one is found closed, set flag and store in SW_VAL.
; clear flag after closed switch is open

SW_10	
	movf	SW_FLG,w	; check switch flag
	btfss	STATUS,Z	; if zero check switches
	goto	WAIT_SW
	btfss	PORTB,5		; check switch input
	goto	SW_SCAN		; switch open
SWITCH	
	movf	SW_CK,w		; SW clock value
	movwf	SW_VAL		; switch value 
	bsf		SW_FLG,0	; set switch closed flag
	bcf		SW_CHNG,0	; switch changed flag cleared
	movlw	0x01
	movwf	STORE1		; speed up delay 
	movwf	STORE2
	movwf	STORE3
	goto	SW_SCAN		; scan switches
WAIT_SW
	movf	SW_CK,w		; current SW clock
	subwf	SW_VAL,w	; compare with closed switch value
	btfss	STATUS,Z	; if the same check if switch closed
	goto	SW_SCAN
	btfss	PORTB,5		; switch
	clrf	SW_FLG		; switch closed flag cleared when switch open

; scan switches 

SW_SCAN	
	movf	SW_CK,w		; clock counter
	btfsc	STATUS,Z	; if zero start new cycle 	
	goto	NEW_CYC		; clock out new value
	bcf		PORTA,2		; clock low
	sublw	0x08		; clock to 10 for 4017 switch selector
	btfss	STATUS,C	; if c = 0 then clear SW_CK
	goto	END_1		; end of 10 switch scan so reset
		
INC_AC	
	incf	SW_CK,f		; next bit
	bsf		PORTA,2		; clock high
	goto	RECLAIM

END_1		
	clrf	SW_CK
	bcf		PORTA,2		; clock low
	bsf		PORTA,1		; reset high 
	goto	RECLAIM

NEW_CYC		
	bcf		PORTA,1		; bring RA1 (reset) low 
	movf	PWM_VAL,w	; PWM value
	movwf	INPUT		; current input value
	bsf		PORTA,2		; clock; high
	incf	SW_CK,f		; address clock

; drive PWM converter
	
DRV_DA	
	movf	INPUT,w		; current input value
	call	EEREAD		; get required output value
	movwf	REQ_VAL		; store value
	subwf	CUR_DA,w	; current data 
	btfsc	STATUS,Z	; if zero then the same value so no action required
	goto	RST_CNT		; reset counters if 128
	btfss	STATUS,C	; c = 0 then increase counters
	goto	INC_CNT
	movf	CUR_DA,w	; check current data value
	btfsc	STATUS,Z	; if zero stop
	goto	RECLAIM
	bcf		PORTA,4		; decrease count
	bsf		PORTA,4		; clock counter down
	decf	CUR_DA,f	; decrease current data value
	goto	RECLAIM		; if zero stop

INC_CNT	
	incfsz	CUR_DA,w	; increase current data value
	goto	DRV_UP		; check values again
	goto	RECLAIM		; already at maximum
DRV_UP
	bcf		PORTA,3		; increase count
	bsf		PORTA,3		; clock counter up
	incf	CUR_DA,f
	goto	RECLAIM

RST_CNT
	movf	REQ_VAL,w	; check value
	xorlw	D'128'		; is it 128 (this will show as 0 (dD) on display)
	btfss	STATUS,Z	; if z set then reset counters
	goto	RECLAIM
	bcf		PORTB,6		; reset counters
	bsf		PORTB,6

; end of interrupt reclaim w and status 

RECLAIM
	bsf		STATUS,RP0	; select bank 1
	movf	ST_ADR,w	; EEPROM address store
	movwf	EEADR		; return to original address
	movf	EDTA_ST,w	; EEPROM data store 
	movwf	EEDATA
	bcf		STATUS,RP0	; select bank 0
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

; ******************************************************************************************

MAIN	
	bcf		STATUS,RP0	; memory bank 0
	bcf		STATUS,RP1	; memory bank 0	
	clrwdt				; clear watchdog timer as set as default at power up
	
; clear values below
;SW_CHNG	equ	H'31'	; switch changed flag
;COUNTX		equ	H'32'	; counter for timeout
;COUNTY		equ	H'33'	; counter for timeout
;COUNT1		equ	H'34'	; counter for high pulse ls byte
;COUNT2		equ	H'35'	; counter for high pulse ms byte
;COUNT3		equ	H'36'	; counter for low pulse ls byte
;COUNT4		equ	H'37'	; counter for low pulse ms byte	
;FLAG_1		equ	H'38'	; 1, high pulse started; 2, low pulse started; 3, finished
;FLAG_0		equ	H'39'	; bit 0 overrange flag
;PWM_VAL	equ	H'3A'	; PWM value
;VIEW		equ	H'3B'	; input viewing value
;SW_FLG		equ	H'3C'	; switch closed flag
;SW_CK		equ	H'3D'	; clock counter switch
;INPUT		equ	H'3E'	; input value
;MODE		equ	H'3F'	; run or view mode	
	
	movlw	0x31		; start address
	movwf	FSR			; pointer
CLEAR_A
	clrf	INDF		; clear value	
	incf	FSR,f		; next pointer
	btfss	FSR,6		; check if increased from 3F to 40
	goto	CLEAR_A		; clear all
	movlw	D'128'		;
	movwf	CUR_DA		; current value to up/down counters

	clrf	VW_FLAG		; clear view run flag to allow extra delay

; initialise ports

	movlw	B'00011010'	; RA1,3,4 high
	movwf	PORTA
	movlw	0x07		; comparators off
	movwf	CMCON		; I/O pins
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00100000'	; port B outputs and RB5 input
	movwf	TRISB		; port B data direction register
	movlw	B'11100001'	; RA "0's" outputs, RA "1's" input
	movwf	TRISA		; port A data direction register
	movlw	B'10000000'	; prescaler internal clock 
	movwf	OPTION_REG	; port B pullups disabled
	bcf		STATUS,RP0	; memory bank 0	
	movlw	B'00011010'	; RA1,3,4 high
	movwf	PORTA

; set up initial conditions for display
	
SETUP
	clrf	PORTB		; RS, R/W, E low (RA6 reset counters)
	call	INIT_LC	
	movlw	0xFF		; start up delay
	call	DELAYX
	call	INIT_LC
	call	DELAYms
	call	INIT_LC

; set 4-bit operation

	movlw	B'01000010'
	movwf	PORTB		; place display commands in portB
	bcf		PORTB,7		; register select low
	nop
	bsf		PORTB,4		; enable set
	nop
	bcf		PORTB,4		; enable clear
	
	call	DELAYms
	
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x10 dots)
	call	LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call	LOAD
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	0xFF		; delay 
	call	DELAYX		; 
	movlw	B'00000110'	; entry mode. cursor moves right, display not shifted
	call	LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call	LOAD
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x10 dots)
	call	LOAD		; 
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	0xFF		; delay 
	call	DELAYX

; release reset on counters

	bsf		PORTB,6

; allow interrupts

	bsf		INTCON,T0IE	; set interrupt enable for TMR0 
	bsf		INTCON,GIE	; set global interrupt enable for above

	movlw	0xFF		; start up delay
	call	DELAYX
	
; check switch closed flag

SW_CSD
	movf	SW_FLG,w	; switch closed flag
	btfsc	STATUS,Z	; if zero shorter delay
	goto	DRV_DSP		; drive display

; find closed switch 
; place delay and check sw flag again 
	
	movlw	D'120'
	call	DELAYY		; delay to ensure switch is not a glitch
	movf	SW_FLG,w	; switch closed flag
	btfsc	STATUS,Z	; if zero bypass switch select
	goto	DRV_DSP		; drive display
	bsf		SW_CHNG,0
	movlw	D'20'
	call	DELAYY		; delay to ensure switch is not a glitch
	btfss	SW_CHNG,0	; if switch has not changed continue
	goto	SW_CSD
	bcf		SW_CHNG,0	; switch change flag cleared when switch open

	movf	SW_VAL,w
	btfsc	STATUS,Z	; 
	goto	RT_VIEW		; right view switch
	decf	SW_VAL,w	
	btfsc	STATUS,Z
	goto	UP_VARY		; up variation switch
	movf	SW_VAL,w
	xorlw	0x02
	btfsc	STATUS,Z
	goto	RT_VW2		; right view larger step
	movf	SW_VAL,w
	xorlw	0x03
	btfsc	STATUS,Z
	goto	DN_VRY2		; down variation larger step
	movf	SW_VAL,w
	xorlw	0x04
	btfsc	STATUS,Z
	goto	VW_DTA		; view/run modes
	movf	SW_VAL,w
	xorlw	0x05
	btfsc	STATUS,Z
	goto	UP_VRY2		; up variation larger step
	movf	SW_VAL,w
	xorlw	0x06
	btfsc	STATUS,Z
	goto	LF_VIEW		; left view
	movf	SW_VAL,w
	xorlw	0x07
	btfsc	STATUS,Z
	goto	LF_VW2		; left view larger step
	movf	SW_VAL,w
	xorlw	0x08
	btfsc	STATUS,Z
	goto	DN_VARY		; down variation
	movf	SW_VAL,w
	xorlw	0x09
	btfsc	STATUS,Z
	goto	DEF_LT		; default
	goto	DRV_DSP

; switch operations

; right view

RT_VIEW	
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; bypass if mode in run mode	
	goto	DRV_DSP		; run mode so do not alter
	incf	VIEW,w		; view position
	sublw	D'127' 		; maximum
	btfss	STATUS,C	; if c = 0 then at maximum
	goto	SET_MX0
	incf	VIEW,f		; increase value
	goto	DRV_DSP
SET_MX0
	movlw	D'127'
	movwf	VIEW		; ensure value doesn't go above 127
	goto	DRV_DSP

; right view larger step

RT_VW2
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; bypass if mode in run mode	
	goto	DRV_DSP		; run mode so do not alter
	movlw	0x04		; step increment
	movwf	STEP
INC_VW2
	incf	VIEW,w		; view position
	sublw	D'127' 		; maximum
	btfss	STATUS,C	; if c = 0 then at maximum
	goto	SET_MX2
	incf	VIEW,f		; increase value
	decfsz	STEP,f		; next step
	goto	INC_VW2
	goto	DRV_DSP
SET_MX2
	movlw	D'127'
	movwf	VIEW		; ensure value doesn't go above 127
	goto	DRV_DSP

; left view

LF_VIEW
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; bypass if mode in run mode	
	goto	DRV_DSP		; run mode so do not alter
	movf	VIEW,w		; view position
	btfsc	STATUS,Z	; check for 0 or minimum
	goto	DRV_DSP
	decf	VIEW,f		; decrease value
	goto	DRV_DSP

; left view larger step

LF_VW2
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; bypass if mode in run mode	
	goto	DRV_DSP		; run mode so do not alter
	movlw	0x04		; step increment
	movwf	STEP
DEC_VW7
	movf	VIEW,w		; view position
	btfsc	STATUS,Z	; check for 0 or minimum
	goto	DRV_DSP
	decf	VIEW,f		; decrease value
	decfsz	STEP,f		; next step
	goto	DEC_VW7
	goto	DRV_DSP
	
; VIEW/RUN

VW_DTA
	movf	MODE,w		; check mode value
	btfss	STATUS,Z	; if zero change to 1
	goto	CLR_MD9		; clear mode
	incf	MODE,f		; change to a 1
	movf	INPUT,w		; transfer current input value
	movwf	VIEW		; to the view load site
	goto	SW_DY
CLR_MD9
	clrf	MODE
SW_DY
	bsf		VW_FLAG,0	; set view run flag
	goto	DRV_DSP
				
; up variation switch					

UP_VARY
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; if zero run mode
	goto	RUN_MD1
	movf	VIEW,w		; viewing input value (1 to 128)
	goto	IN_VW1
RUN_MD1
	movf	INPUT,w		; get current input value (1 to 128)
IN_VW1
	call	EEREAD		; get output value (routine sets EEADR)
	movwf	OUTPUT		; output variation value
	sublw	D'254' 		; maximum
	btfss	STATUS,C	; if c = 0 then at maximum
	goto	SET_MX1
	incf	OUTPUT,w	; increase value
	goto	WRI_UP1
SET_MX1
	 movlw	D'255'		; ensure value doesn't go above 255
WRI_UP1
	call	EEWRITE		
	goto	DRV_DSP			

; up variation larger step

UP_VRY2
	movlw	0x05		; step increment
	movwf	STEP
MODE_1
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; if zero run mode
	goto	RUN_MD5
	movf	VIEW,w		; viewing input value (1 to 128)
	goto	IN_VW5
RUN_MD5
	movf	INPUT,w 	; get current input value (1 to 128)
IN_VW5
	call	EEREAD		; get output value (routine sets EEADR)
	movwf	OUTPUT		; output variation value
NXT5
	movf	OUTPUT,w
	sublw	D'254' 		; maximum
	btfss	STATUS,C	; if c = 0 then at maximum
	goto	SET_MX5
	incf	OUTPUT,f	; increase value
	decfsz	STEP,f
	goto	NEXT5
	decf	OUTPUT,f
	goto	DRV_DSP		; 
NEXT5
	movf	OUTPUT,w
	call	EEWRITE
	goto	MODE_1
SET_MX5
	movlw	D'255'		; ensure value doesn't go above 255
	call	EEWRITE		
	goto	DRV_DSP	

; down variation

DN_VARY
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; if zero run mode
	goto	RUN_MD8
	movf	VIEW,w		; viewing input value (1 to 128)
	goto	IN_VW8
RUN_MD8
	movf	INPUT,w 	; get current input value (1 to 128)
IN_VW8
	call	EEREAD		; get output value (routine sets EEADR)
	movwf	OUTPUT
	decf	OUTPUT,w	; output variation value
	btfsc	STATUS,Z	; check if zero 
	goto	DRV_DSP		; already zero so bypass
	decf	OUTPUT,w
	call	EEWRITE
	goto	DRV_DSP

; down variation larger step	

DN_VRY2
	movlw	0x04		; step increment
	movwf	STEP
MODE_3
	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; if zero run mode
	goto	RUN_MD3
	movf	VIEW,w		; viewing input value (1 to 128)
	goto	IN_VW3
RUN_MD3
	movf	INPUT,w 	; get current input value (1 to 128)
IN_VW3
	call	EEREAD		; get output value (routine sets EEADR)
	movwf	OUTPUT
NXT_3
	decf	OUTPUT,w	; output variation value
	btfsc	STATUS,Z	; check if zero 
	goto	DRV_DSP		; already zero so bypass
	decf	OUTPUT,w
	call	EEWRITE
	decfsz	STEP,f
	goto	MODE_3		; next step
	decf	OUTPUT,f
	goto	DRV_DSP	

; default of 0 offset
	
DEF_LT
	bsf		SW_CHNG,0	;  switch changed flag
	movlw	D'20'		;  2.5s delay
	movwf	STORE6
ROTAT
	movlw	D'200'
	call	DELAYY		;  delay
	decfsz	STORE6,f
	goto	ROTAT
	movf	SW_FLG,w	;  check switch flag
	btfsc	STATUS,Z	; 
	goto	DRV_DSP		;  bypass if switch off
	movf	SW_VAL,w	;  check value
	xorlw	0x09		;  reset switch
	btfss	STATUS,Z	;  if the same
	goto	DRV_DSP		;  bypass if switch not the reset
	btfss	SW_CHNG,0	;  check if switch has changed
	goto	DRV_DSP		; 
	bcf		SW_CHNG,0	;  clear switch changed flag

; check lock
	btfss	PORTA,5		; RA5 low = lock
	goto	DRV_DSP		; no reset on lock
	movlw	0x80		; address line 1
	call	LOAD
	movlw	A'R'		; R
	call	DRV_LCD
	movlw	A'E'		; E
	call	DRV_LCD
	movlw	A'S'		; S
	call	DRV_LCD
	movlw	A'E'		; E
	call	DRV_LCD
	movlw	A'T'		; T
	call	DRV_LCD
	call	SPACE4		; 4 spaces
	call	SPACE1		; 1 spaces
	
	bcf		INTCON,GIE	; clear global interrupt enable 
	movlw	0x80
	movwf	E_COUNT		; EEPROM counter
	movlw	0x00
	bsf		STATUS,RP0	; select bank 1
	movwf	EEADR		; set EEPROM1 address
	bcf		STATUS,RP0	; select bank 0
EE_LD	
	movlw	D'128'		; no offset
	call	EWRITE		; set at 0 offset
	decfsz	E_COUNT,f
	goto	NXT_EE
	bsf		INTCON,GIE	; set global interrupt enable 
	goto	DRV_DLY
NXT_EE
	bsf		STATUS,RP0	; select bank 1	
	incf	EEADR,f		; next EEPROM location
	bcf		STATUS,RP0	; select bank 0
	goto	EE_LD

DRV_DLY
	movlw	0xFF
	call	DELAYX
	movlw	0xFF
	call	DELAYX
	movlw	0xFF
	call	DELAYX

; drive display with values

DRV_DSP
	movlw	0x80		; address line 1
	call	LOAD
	movlw	A'O'		; O
	call	DRV_LCD
	movlw	A'U'		; U
	call	DRV_LCD
	movlw	A'T'		; T
	call	DRV_LCD
	movlw	A'P'		; P
	call	DRV_LCD
	movlw	A'U'		; U
	call	DRV_LCD
	movlw	A'T'		; T
	call	DRV_LCD
	call	SPACE1		; 1 space
	
; get output value

	movf	MODE,w		; check mode
	btfsc	STATUS,Z	; if zero run mode
	goto	RN_MD
	movf	VIEW,w		; viewing input value (1 to 128)
	goto	IN_VW

RN_MD
	movf	INPUT,w 	; 
IN_VW
	movwf	IN_STO		; input store
	call	EEREAD		; get EEPROM value
	movwf	OUTPUT
	btfsc	OUTPUT,7	; if bit 7 set then +
	goto	PLUS
	movf	OUTPUT,w
	sublw	0x80		; display shows offset from 128
	movwf	OUTPUT		; 
	movlw	A'-'		; minus sign
	call	DRV_LCD
	goto	VALU
PLUS
	movf	OUTPUT,w
	xorlw	B'10000000'
	btfsc	STATUS,Z	; if zero add space and bypass + sign
	goto	ADDSPCE
	movlw	A'+'		; + sign
	call	DRV_LCD
	goto	VALU
ADDSPCE
	call	SPACE1		; space instead of +
	
VALU
	movf	OUTPUT,w	; output value
	andlw	B'01111111'	; extract only 7 bits (bit 7 is sign)	
	movwf	BIN_0		;
	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT1,w		; ms value
	xorlw	0x30		; check if 0
	btfss	STATUS,Z
	goto	LOAD1
	call	SPACE1		; leading 0's to space

; mid digit

	movf	OUT2,w
	xorlw	0x30		; is it zero
	btfss	STATUS,Z
	goto	LOAD2
	call	SPACE1		; leading 0's to space
	goto	LOAD3
LOAD1
	movf	OUT1,w
	call	DRV_LCD
LOAD2
	movf	OUT2,w
	call	DRV_LCD
LOAD3
	movf	OUT3,w
	call	DRV_LCD
	movlw	0x8B		; address line 1 position 11
	call	LOAD
	call	SPACE1
; check lock
	btfss	PORTA,5		; RA5 low = lock
	goto	LOCK_EE
	movlw	A'('		; (
	call	DRV_LCD
	movlw	A'd'		; d
	call	DRV_LCD
	movlw	A'D'		; Duty 
	call	DRV_LCD
	movlw	A')'		; )
	call	DRV_LCD
	call	SPACE1		; 1 space
	goto	LN2

; lock EEPROM indicator
LOCK_EE
	movlw	A'L'		; L
	call	DRV_LCD
	movlw	A'O'		; o
	call	DRV_LCD
	movlw	A'C'		; c 
	call	DRV_LCD
	movlw	A'K'		; k
	call	DRV_LCD
	call	SPACE1		; 1 space

; line 2
LN2
	movlw	B'11000000'	; address line 2
	call	LOAD
	movlw	A'I'		; I
	call	DRV_LCD
	movlw	A'N'		; N
	call	DRV_LCD
	movlw	A'P'		; P
	call	DRV_LCD
	movlw	A'U'		; U
	call	DRV_LCD
	movlw	A'T'		; T
	call	DRV_LCD
	call	SPACE2		;  spaces
	
; get input value

RUN_MDX
	incf	IN_STO,w 	; get stored input value (1 to 128)
	movwf	BIN_0		;
	call	BCD_ASCII	; get ASCII values
	movf	OUT1,w		; ms digit (1 to 128 range)
	
; most significant digit check for leading 0 blanking

	xorlw	0x30		; is it zero
	btfss	STATUS,Z
	goto	LOAD4
	call	SPACE1		; zero so add space
	goto	LOAD7		; load middle digit
LOAD4
	movf	OUT1,w		; not zero
	call	DRV_LCD
	goto	LOAD8		; if ms digit not zero end blanking of 0
LOAD7
	movf	OUT2,w		; middle digit
	xorlw	0x30		; is it 0
	btfss	STATUS,Z
	goto	LOAD8
	call	SPACE1 
	goto	LOAD5
LOAD8	
	movf	OUT2,w		; not zero so load value
	call 	DRV_LCD
LOAD5
	movf	OUT3,w
	call	DRV_LCD

; check mode for run or view
	
	movf	MODE,w
	btfss	STATUS,Z	; if zero run mode
	goto	VIEW_M		; view mode
	call	SPACE1		; 1 space
	movlw	A'/'		; /
	call	DRV_LCD
	movlw	A'R'		; R
	call	DRV_LCD
	movlw	A'U'		; U
	call	DRV_LCD
	movlw	A'N'		; N	
	call	DRV_LCD
	movlw	A'/'		; /
	call	DRV_LCD
	goto	SW_DEL

VIEW_M
	movlw	A'<'		; <
	call	DRV_LCD
	movlw	A'V'		; V
	call	DRV_LCD
	movlw	A'I'		; I
	call	DRV_LCD
	movlw	A'E'		; E
	call	DRV_LCD
	movlw	A'W'		; W
	call	DRV_LCD
	movlw	A'>'		; >
	call	DRV_LCD
	goto	SW_DEL

; delay between display updates and switch operations

SW_DEL
	btfss	VW_FLAG,0	; if set more delay between switching View/Run
	goto	ST_DLY
	movlw	0xFF
	call	DELAYX
	movlw	0xFF
	call	DELAYX
	clrf	VW_FLAG		; clear 
ST_DLY
	movlw	0x03
	movwf	STORE1
AGN_DEL
	movlw	D'150'		; DELAY value
	movwf	STORE2
MOR_DEL
	call	CALCUL		; calculation routine
	clrwdt				; keep watchdog timer clear
	decfsz	STORE2,f
	goto	MOR_DEL
	decfsz	STORE1,f
	goto	AGN_DEL
	goto	SW_CSD

;***************************************************************************
; subroutines

; calculation of input value of PWM 1-128 in value

CALCUL
	clrwdt				; watchdog cleared
	clrf	AARGB0		; clear
	movlw	D'128'		; 0-128 = represents 0-100%
	movwf	AARGB1

; stop interrupt
	bcf		INTCON,GIE	; clear global interrupt enable for above
	movf	COUNT5,w
	movwf	COUNT_5
	movf	COUNT6,w
	movwf	COUNT_6
	movf	COUNT7,w	; counted value
	movwf	BARGB1
	movf	COUNT8,w
	movwf	BARGB0
	bsf		INTCON,GIE	; set global interrupt enable for above
; allow interrupt

	call	FXM1616U	; multiply by 128
	clrwdt				; watchdog cleared

; shift answer
	movf	AARGB2,w	; second ls byte of result
	movwf	STO1
	movf	AARGB3,w
	movwf	AARGB2
	movf	AARGB1,w
	movwf	AARGB0
	movf	STO1,w
	movwf	AARGB1
	
; load denominator

	movf	COUNT_5,w
	movwf	BARGB1
	movf	COUNT_6,w
	movwf	BARGB0
	call	FXD2416U	; divide for % (0-128 = 0-100% percent)
	clrwdt				; watchdog cleared

; increase percentage if over half way at remainder

	movlw	0x7F
	addwf	REMB0,w		; add to remainder
	btfsc	STATUS,C	; increase if carry set
	incf	AARGB2,f

; load new PWM input value	

	movf	AARGB2,w
	btfss	FLAG_0,1	; if set overrange
	goto	LD_PWM 
	btfss	PORTA,0		; if clear then input is 128
	goto	SET_128
	movlw	0x00
LD_PWM	
	movwf	PWM_VAL
	return
SET_128
	movlw	D'127'
	goto	LD_PWM
	
; add space in display

SPACE4
	movlw	0x20		; space
	call	DRV_LCD
SPACE3
	movlw	0x20		; space
	call	DRV_LCD
SPACE2
	movlw	0x20		; space
	call	DRV_LCD
SPACE1
	movlw	0x20		; space
	call	DRV_LCD
	return

; delay loop

DELAYms
	movlw	D'23'		; delay 
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP1
	clrwdt			; clear watchdog timer 
	movlw	0xA0
	movwf	STORE2		; STORE2 is internal loop value	
LOOP2
	decfsz	STORE2,f
	goto	LOOP2
	decfsz	STORE1,f
	goto	LOOP1		; decrease till STORE1 is zero
	return

; delay that is not altered when switch pressed

DELAYY
	movwf	STORE4		; STORE is number of loops value
LOOPY
	clrwdt			; clear watchdog
	movlw	0xFF
DELDSP
	movwf	STORE5		; STORE is internal loop value	
LOOPA
	decfsz	STORE5,f
	goto	LOOPA
	decfsz	STORE4,f
	goto	LOOPY		; decrease till STORE is zero
	clrwdt
	return

; initialise display

INIT_LC
	movlw	B'01000011'	; initialise module
	movwf	PORTB
	nop
	bsf		PORTB,4		; enable high
	nop
	bcf		PORTB,4		; low
	return

; preload display commands (4-bit) 

LOAD
	movwf	D_STO		; store data	
	swapf	D_STO,w
	andlw	0x0F		; get upper bits
	iorlw	B'01000000'	; keep bit 6 high
	movwf	PORTB		; place display commands in portB
	bcf		PORTB,7		; register select low
	nop
	bsf		PORTB,4		; enable set
	nop
	bcf		PORTB,4		; enable clear

	movf	D_STO,w
	andlw	0x0F		; get lower bits
	iorlw	B'01000000'	; keep bit 6 high
	movwf	PORTB		; place display commands in portB
	bcf		PORTB,7		; register select low
	nop
	bsf		PORTB,4		; enable set
	nop
	bcf		PORTB,4		; enable clear
	goto	BUS_CK		; check busy flag
	
; driving the LCD module with display data

DRV_LCD	
	movwf	D_STO		; store data
	swapf	D_STO,w
	andlw	0x0F		; upper bits
	iorlw	B'01000000'	; keep bit 6 high	
	movwf	PORTB		; w to portb
	bsf		PORTB,7		; register select
	
	bsf		PORTB,4		; enable high
	nop
	bcf		PORTB,4		; enable low
	movf	D_STO,w
	andlw	0x0F		; lower bits
	iorlw	B'01000000'	; keep bit 6 high
	movwf	PORTB		; w to portb
	bsf		PORTB,7		; register select
	
	bsf		PORTB,4		; enable high
	nop
	bcf		PORTB,4		; enable low

BUS_CK
	movlw 	0x01		; 
	movwf	STORE4		; delay values
	movlw	D'255'		; delay for busy flag to clear
	goto	DELDSP		; 
	
	
; subroutine to read EEPROM memory 

EEREAD
	bsf 	STATUS,RP0	; select memory bank 1
	movwf 	EEADR		; indirect special function register
	bsf		EECON1,RD	; read EEPROM
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP0	; select bank 0
	clrwdt				; watchdog cleared
	return

; subroutine to write to EEPROM

EEWRITE	
; check lock
	btfss	PORTA,5		; RA5 low = lock
	return	
	bsf		STATUS,RP0	; select bank 1
	movwf	EEDATA		; data register
WR3	clrwdt
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR3			; not written yet
	bcf		INTCON,GIE	; disable interrupts
	bsf		EECON1,WREN	; enable write
; check lock
	btfss	PORTA,5		; RA5 low = lock
	goto	LK_OUT
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
	bsf		INTCON,GIE	; enable interrupts
WRITE
	clrwdt				; watchdog cleared	
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0	; bank 0 
	return				; value written 
LK_OUT					; bypass write
	bcf		EECON1,WREN	; clear WREN bit
	bcf		STATUS,RP0	; bank 0 
	bsf		INTCON,GIE	; enable interrupts
	return				; value not written

; EEPROM write with interrupts disabled

EWRITE
; check lock
	btfss	PORTA,5		; RA5 low = lock
	return	
	bsf		STATUS,RP0	; select bank 1
	movwf	EEDATA		; data register
WR4	clrwdt
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR4			; not written yet
	bsf		EECON1,WREN	; enable write
; check lock
	btfss	PORTA,5		; RA5 low = lock
	goto	LK_OUT		
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
WRITE1	
	clrwdt				; watchdog cleared
	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE1		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0	; bank 0 
	return				; value written 

; Subroutine to convert from 8-bit binary to 2-digit BCD (packed)
; Binary value is in BIN_0  
; Result in BCD is in BCD_0 & BCD_1.  
; BCD_0 is MSB, BCD_1 is LSB
; converts to unpacked ASCII in OUT1, OUT2, OUT3 (out1 is ms byte, out3 is ls byte)

BCD_ASCII
	bcf		STATUS,C	; clear carry bit
	movlw	D'8'
	movwf	CNT_8		; 8 in count
	clrf	BCD_0
	clrf	BCD_1		; set BCD registers to 0 
LOOPBCD	
	rlf	BIN_0,f			; shift left binary registers
	rlf	BCD_1,f			; MSB shift left

	rlf	BCD_0,f			; LSB shift left BCD registers
	decfsz	CNT_8,f		; reduce count value return when 0
	goto	DECADJ		; continue decimal adjust

; completed decimal to BCD operation, convert to unpacked ASCII
	
	movf	BCD_1,w		; ls decimal
	andlw	0x0F		; ls
	addlw	0x30		; convert to ASCII
	movwf	OUT3
	swapf	BCD_1,w 	; mid decimal value
	andlw	0x0F
	addlw	0x30		; convert to ASCII
	movwf	OUT2
	movf	BCD_0,w
	addlw	0x30		; convert to ASCII
	movwf	OUT1		; ms decimal value

	return				; ASCII values returned in OUT1, OUT2, OUT3 

; subroutine decimal adjust

DECADJ
	movlw	BCD_1		; BCD LSB address
	movwf	FSR			; pointer for BCD1
	call	ADJBCD		; subroutine to adjust BCD
	movlw	BCD_0		; BCD MS address
	movwf	FSR			; pointer for BCD0
	call	ADJBCD
	goto	LOOPBCD

; subroutine adjust BCD

ADJBCD
	movlw	0x03		; w has 03 
	addwf	INDF,w		; add 03 to BCDx register (x is 0-1)
	movwf	TEMP		; store w
	btfsc	TEMP,3		; test if >7
	movwf	INDF		; save as LS digit
	movlw	0x30		; 3 for MSbyte
	addwf	INDF,w		; add 30 to BCDx register
	movwf	TEMP		; store w in temp
	btfsc	TEMP,7		; test if >7
	movwf	INDF		; save as MS digit
	return				; end subroutine

; 24/16 Bit Unsigned Fixed Point Divide 

;       Input:  24 bit unsigned fixed point dividend in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point divisor in BARGB0, BARGB1

;       Use:    CALL    FXD2416U

;       Output: 24 bit unsigned fixed point quotient in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point remainder in REMB0, REMB1

;       Result: AARG, REM  <--  AARG / BARG


FXD2416U        CLRF            REMB0
                CLRF            REMB1
                CLRF            TEMPD
                RLF             AARGB0,W
                RLF             REMB1, F
                MOVF            BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                RLF             AARGB0, F
                MOVLW           7
                MOVWF           LOOPCOUNT
LOOPU2416A      RLF             AARGB0,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46LA
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46LA
UADD46LA        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46LA		 	RLF             AARGB0, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416A
                RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46L8
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46L8
UADD46L8        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46L8         RLF             AARGB1, F
                MOVLW           7
                MOVWF           LOOPCOUNT
LOOPU2416B      RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46LB
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46LB
UADD46LB        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46LB         RLF             AARGB1, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416B
                RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46L16
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46L16
UADD46L16       ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46L16        RLF             AARGB2, F
                MOVLW           7
                MOVWF           LOOPCOUNT
LOOPU2416C      RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB2,0
                GOTO            UADD46LC
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46LC
UADD46LC        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46LC 		RLF             AARGB2, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416C
                BTFSC           AARGB2,0
                GOTO            UOK46L
                MOVF            BARGB1,W
	        	ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
UOK46L			RETURN
	
; multiply
;
;       Input:  fixed point arguments in AARG and BARG
;
;       Output: product AARGxBARG in AARG
;

;       16x16 Bit Unsigned Fixed Point Multiply 

;       Input:  16 bit unsigned fixed point multiplicand in AARGB0
;               16 bit unsigned fixed point multiplier in BARGB0

;       Use:    CALL    FXM1616U

;       Output: 32 bit unsigned fixed point product in AARGB0



FXM1616U        CLRF    AARGB2          ; clear partial product
                CLRF    AARGB3
                MOVF    AARGB0,W
                MOVWF   TEMPB0
                MOVF    AARGB1,W
                MOVWF   TEMPB1
                MOVLW   0x08
                MOVWF   LOOPCOUNT
LOOPUM1616A     RRF     BARGB1, F
                BTFSC   STATUS,C
                GOTO    ALUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616A
                MOVWF   LOOPCOUNT
LOOPUM1616B     RRF     BARGB0, F
                BTFSC   STATUS,C
                GOTO    BLUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616B
                CLRF    AARGB0
                CLRF    AARGB1
                RETLW   0x00
BLUM1616NAP     BCF     STATUS,C
                GOTO    BLUM1616NA
ALUM1616NAP     BCF     STATUS,C
                GOTO    ALUM1616NA
ALOOPUM1616     RRF     BARGB1, F
                BTFSS   STATUS,C
                GOTO    ALUM1616NA
                MOVF    TEMPB1,W
                ADDWF   AARGB1, F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0, F
ALUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                DECFSZ LOOPCOUNT, F
                GOTO   ALOOPUM1616
                MOVLW  0x08
                MOVWF  LOOPCOUNT
BLOOPUM1616     RRF    BARGB0, F
                BTFSS  STATUS,C
                GOTO   BLUM1616NA
                MOVF   TEMPB1,W
                ADDWF  AARGB1, F
                MOVF   TEMPB0,W
                BTFSC  STATUS,C
                INCFSZ TEMPB0,W
                ADDWF  AARGB0, F
BLUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                RRF    AARGB3, F
                DECFSZ LOOPCOUNT, F
                GOTO   BLOOPUM1616
                RETURN

; subroutine subtract AARGB1 AARGB2 - BARGB0 BARGB1 = AARGB
	
D_SUB	
	movlw	0x00		; 00
	movwf	AARGB1 
	movlw	D'100'		; 100
	movwf	AARGB2 
D_RSUB
	call	NEG_A		; complement of A

	movf	BARGB1,w 
	addwf	AARGB2,f 	; add lsb
	btfsc	STATUS,C	; add carry
	incf	AARGB1,f 
	movf	BARGB0,w 
	addwf	AARGB1,f 
	return

NEG_A
	comf	BARGB1,f 
	incf	BARGB1,f 
	btfsc	STATUS,Z
	decf	BARGB0,f 
	comf	BARGB0,f 
	return	

	end
