; Processor pin allocations are as follows:
; digital speedometer corrector
; outputs an altered frequency by a factor of between
; 0% and 99% in 1% steps 

; CPU configuration
; 	
	list P=16F84
	#include "p16f84.inc"

	__config _HS_OSC & _WDT_OFF & _PWRTE_ON

; Define variables at memory locations

; RAM


STATUS_TMP 	equ H'10'	; temp storage for status during interrupt
W_TMP		equ	H'11'	; temporary storage for w during interrupt
FLAG_0		equ	H'12'	; overrange flag
FLAG_I		equ	H'13'	; recount flag

TEMP_1		equ	H'15'	; temporary working storage
TEMP_2		equ	H'16'	; temp storage


COUNT1		equ	H'17'	; input counter ls byte
COUNT2		equ	H'18'	; input counter ms byte
COUNT3		equ	H'19'	; latched input counter ls byte
COUNT4		equ	H'1A'	; latched input counter ms byte

COUNT5		equ	H'1B'	; half way ls byte High Level
COUNT6		equ	H'1C'	; half way ms byte High Level
COUNT7		equ	H'1D'	; halfway counter ls byte Low Level from count5
COUNT8		equ	H'1E'	; halfway counter ms byte Low Level from count6
COUNT9		equ	H'1F'	; output counter ls byte Low Level from calc1
COUNT10		equ	H'20'	; output counter ms byte Low Level from calc2
CALC1		equ	H'21'	; calculated value ls byte
CALC2		equ	H'22'	; calculated value ms byte
COUNTA		equ	H'23'	; 1/4 way ls byte High Level
COUNTB		equ	H'24'	; 1/4 way ms byte High Level
COUNT11		equ	H'25'	; 1/4 way counter ls byte Low Level from counta
COUNT12		equ	H'26'	; 1/4 way counter ms byte Low Level from countb
COUNTC		equ	H'27'	; 3/4 way ls byte High Level
COUNTD		equ	H'28'	; 3/4 way ms byte High Level
COUNT13		equ	H'29'	; 3/4 way counter ls byte Low Level from countc
COUNT14		equ	H'2A'	; 3/4 way counter ms byte Low Level from countd
COUNTE		equ	H'2B'	; output running counter ls
COUNTF		equ	H'2C'	; output running counter ms
; math routines

TEMPB1      equ     0x31
TEMPB0      equ     0x32
TEMPD       equ     0x33    ; temporary storage
AARGB3		equ		0x34
AARGB2      equ     0x35
AARGB1      equ     0x36
AARGB0      equ     0x37
AARG        equ     0x37    ; most significant byte of argument A
BARGB1      equ     0x38
BARGB0      equ     0x39
BARG        equ     0x39    ; most significant byte of argument B
REMB1       equ     0x3A
REMB0       equ     0x3B    ; most significant byte of remainder
LOOPCOUNT   equ     0x3C    ; loop counter
STO1	    equ		0x3D	; AARGB1 storage
STO2		equ		0x3E	; AARGB2 storage



; define reset and interrupt vector start addresses

	org	0	 		 	; start at address 0000h
	goto	MAIN		; normal service routines from Reset vector
	org     4			; interrupt vector 0004h, start interrupt routine here
	goto	INTRUPT		; go to start of interrupt routine, bypass subroutines

; subroutine to get multiplier/divisor depending on fast or slow rate

DIVSR
	addwf	PCL,f		; add value of switch settings to program counter
	retlw	D'100'		; 0 0% rate (fast) or 0% (slow)
	retlw	D'101'		; 1 1% fast or 1% slow
	retlw	D'102'		; 2 2%
	retlw	D'103'		; 3 3% rate
	retlw	D'104'		; 4 4% rate
	retlw	D'105'		; 5 5% rate
	retlw	D'106'		; 6 6% rate
	retlw	D'107'		; 7 7% rate
	retlw	D'108'		; 8 8% rate
	retlw	D'109'		; 9 9% rate

	retlw	D'109'		; A not part of 0 to 9 coded switch
	retlw	D'109'		; B 
	retlw	D'109'		; C
	retlw	D'109'		; D
	retlw	D'109'		; E
	retlw	D'109'		; F

	retlw	D'110'		; 10 10% rate
	retlw	D'111'		; 11 11% rate
	retlw	D'112'		; 12 12% rate
	retlw	D'113'		; 13 13% rate
	retlw	D'114'		; 14 14% rate
	retlw	D'115'		; 15 15% rate
	retlw	D'116'		; 16 16% rate
	retlw	D'117'		; 17 17% rate
	retlw	D'118'		; 18 18% rate
	retlw	D'119'		; 19 19% rate

	retlw	D'119'		; 1A 
	retlw	D'119'		; 1B 
	retlw	D'119'		; 1C 
	retlw	D'119'		; 1D 
	retlw	D'119'		; 1E 
	retlw	D'119'		; 1F 

	retlw	D'120'		; 20 20% rate
	retlw	D'121'		; 21 21% rate
	retlw	D'122'		; 22 22% rate
	retlw	D'123'		; 23 23% rate
	retlw	D'124'		; 24 24% rate
	retlw	D'125'		; 25 25% rate
	retlw	D'126'		; 26 26% rate
	retlw	D'127'		; 27 27% rate
	retlw	D'128'		; 28 28% rate
	retlw	D'129'		; 29 29% rate

	retlw	D'129'		; 2A 
	retlw	D'129'		; 2B 
	retlw	D'129'		; 2C
	retlw	D'129'		; 2D
	retlw	D'129'		; 2E
	retlw	D'129'		; 2F

	retlw	D'130'		; 30 30% rate
	retlw	D'131'		; 31 31% rate
	retlw	D'132'		; 32 32% rate
	retlw	D'133'		; 33 33% rate
	retlw	D'134'		; 34 34% rate
	retlw	D'135'		; 35 35% rate
	retlw	D'136'		; 36 36% rate
	retlw	D'137'		; 37 37% rate
	retlw	D'138'		; 38 38% rate
	retlw	D'139'		; 39 39% rate

	retlw	D'139'		; 3A 
	retlw	D'139'		; 3B 	
	retlw	D'139'		; 3C 	
	retlw	D'139'		; 3D 
	retlw	D'139'		; 3E 
	retlw	D'139'		; 3F

	retlw	D'140'		; 40 40% rate
	retlw	D'141'		; 41 41% rate
	retlw	D'142'		; 42 42% rate
	retlw	D'143'		; 43 43% rate
	retlw	D'144'		; 44 44% rate
	retlw	D'145'		; 45 45% rate
	retlw	D'146'		; 46 46% rate
	retlw	D'147'		; 47 47% rate
	retlw	D'148'		; 48 48% rate
	retlw	D'149'		; 49 49% rate

	retlw	D'149'		; 4A 
	retlw	D'149'		; 4B 	
	retlw	D'149'		; 4C 	
	retlw	D'149'		; 4D 
	retlw	D'149'		; 4E 
	retlw	D'149'		; 4F

	retlw	D'150'		; 50 50% rate
	retlw	D'151'		; 51 51% rate
	retlw	D'152'		; 52 52% rate
	retlw	D'153'		; 53 53% rate
	retlw	D'154'		; 54 54% rate
	retlw	D'155'		; 55 55% rate
	retlw	D'156'		; 56 56% rate
	retlw	D'157'		; 57 57% rate
	retlw	D'158'		; 58 58% rate
	retlw	D'159'		; 59 59% rate

	retlw	D'159'		; 5A 
	retlw	D'159'		; 5B 	
	retlw	D'159'		; 5C 	
	retlw	D'159'		; 5D 
	retlw	D'159'		; 5E 
	retlw	D'159'		; 5F
	
	retlw	D'160'		; 60 60% rate
	retlw	D'161'		; 61 61% rate
	retlw	D'162'		; 62 62% rate
	retlw	D'163'		; 63 63% rate
	retlw	D'164'		; 64 64% rate
	retlw	D'165'		; 65 65% rate
	retlw	D'166'		; 66 66% rate
	retlw	D'167'		; 67 67% rate
	retlw	D'168'		; 68 68% rate
	retlw	D'169'		; 69 69% rate

	retlw	D'169'		; 6A 
	retlw	D'169'		; 6B 	
	retlw	D'169'		; 6C 	
	retlw	D'169'		; 6D 
	retlw	D'169'		; 6E 
	retlw	D'169'		; 6F

	retlw	D'170'		; 70 70% rate
	retlw	D'171'		; 71 71% rate
	retlw	D'172'		; 72 72% rate
	retlw	D'173'		; 73 73% rate
	retlw	D'174'		; 74 74% rate
	retlw	D'175'		; 75 75% rate
	retlw	D'176'		; 76 76% rate
	retlw	D'177'		; 77 77% rate
	retlw	D'178'		; 78 78% rate
	retlw	D'179'		; 79 79% rate

	retlw	D'179'		; 7A 
	retlw	D'179'		; 7B 	
	retlw	D'179'		; 7C 	
	retlw	D'179'		; 7D 
	retlw	D'179'		; 7E 
	retlw	D'179'		; 7F
	
	retlw	D'180'		; 80 80% rate
	retlw	D'181'		; 81 81% rate
	retlw	D'182'		; 82 82% rate
	retlw	D'183'		; 83 83% rate
	retlw	D'184'		; 84 84% rate
	retlw	D'185'		; 85 85% rate
	retlw	D'186'		; 86 86% rate
	retlw	D'187'		; 87 87% rate
	retlw	D'188'		; 88 88% rate
	retlw	D'189'		; 89 89% rate

	retlw	D'189'		; 8A 
	retlw	D'189'		; 8B 	
	retlw	D'189'		; 8C 	
	retlw	D'189'		; 8D 
	retlw	D'189'		; 8E 
	retlw	D'189'		; 8F
	
	retlw	D'190'		; 90 90% rate
	retlw	D'191'		; 91 91% rate
	retlw	D'192'		; 92 92% rate
	retlw	D'193'		; 93 93% rate
	retlw	D'194'		; 94 94% rate
	retlw	D'195'		; 95 95% rate
	retlw	D'196'		; 96 96% rate
	retlw	D'197'		; 97 97% rate
	retlw	D'198'		; 98 98% rate
	retlw	D'199'		; 99 99% rate

	retlw	D'200'		; 9A 100% 
	retlw	D'200'		; 9B 	
	retlw	D'200'		; 9C 	
	retlw	D'200'		; 9D 
	retlw	D'200'		; 9E 
	retlw	D'200'		; 9F	
;******************************************************************************************* 

; INTERRUPT
; counts time between pulses
; start interrupt by saving w and status registers before altered by interrupt routine

INTRUPT	
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp  
	bcf		INTCON,T0IF	; clear timer interrupt flag
				; freq is approx 10MHz/4/256-220/(2) ~ 40kHz
	
	movlw	D'220'		; speed up timer interrupt rate 
	movwf	TMR0	
	
; count between positive edges

CNT_P
	btfss	INTCON,INTF	; Intcon INTF flag set on edge detect on RB0 (see option register)
	goto	COUNT		; not so bypass
	bcf		INTCON,INTF	; clear bit to wait for next edge

; 2 counts for sufficient resolution at higher frequencies

	btfss	FLAG_I,0	; counted two cycles
	goto	COUNT_S

RES_T
	btfss	FLAG_0,0
	goto	XFER
	clrf	COUNT3
	clrf	COUNT4
	goto	CLR_CNT		; don't transfer on overrange
XFER
	movf	COUNT1,w
	movwf	COUNT3		; latch value for processing
	movf	COUNT2,w
	movwf	COUNT4		; latch value for processing
CLR_CNT
	clrf	FLAG_I		; count repeat flag
	clrf	COUNT1
	incf	COUNT1,f
	clrf	COUNT2		; clear for recount
	bcf		FLAG_0,0	; clear overrange flag
	goto	CHEK_CT

COUNT_S
	bsf	FLAG_I,0	; increment to indicate next count
COUNT
	incfsz	COUNT1,f	; increment least significant byte
	goto	CHEK_CT 	; check count value
	incf	COUNT2,f	; if zero flag overrange
	btfss	COUNT2,7	; overrange if bit 7 set
	goto	CHEK_CT 	; check count value
	bsf		FLAG_0,0	; flag set if overrange	
	bsf		FLAG_0,1	; set valid flag
	goto	RECLAIM

; check counter
 
; one counter gives the low output and second gives high output duration
 
CHEK_CT
	btfsc	FLAG_0,1	; valid flag
	goto	RECLAIM		; not valid so out

DIV_2
	incfsz	COUNTE,f	; increment least significant byte
	goto	COMP	 	; check count value
	incf	COUNTF,f	; 
	bsf		PORTA,0		; tracer
COMP
	movf	COUNTE,w	; ls counter
	xorwf	COUNT9,w
	btfss	STATUS,Z	; if the same check ms byte
	goto	CHK_HL2
	movf	COUNTF,w	; ms counter
	xorwf	COUNT10,w
	btfss	STATUS,Z	; if equal reset values
	goto	CHK_HL2
	
	movlw	B'00001100'	; RA2 and RA3 high	
	movwf	PORTA		; output high

; transfer calculated values

	clrf	COUNTE		; reset counter
	clrf	COUNTF
	movf	CALC2,w 	; ms counter byte full output
	movwf	COUNT10
	movf	CALC1,w
	movwf	COUNT9
	
	movf	COUNT6,w	; ms counter byte halfway count
	movwf	COUNT8
	movf	COUNT5,w
	movwf	COUNT7

	movf	COUNTB,w	; ms counter byte 1/4 way count
	movwf	COUNT12
	movf	COUNTA,w
	movwf	COUNT11

	movf	COUNTD,w	; ms counter byte 3/4 way count
	movwf	COUNT14
	movf	COUNTC,w
	movwf	COUNT13
	goto	RECLAIM

; 1/2, 1/4 and 3/4 check tests

CHK_HL2	

	movf	COUNTE,w	; ls counter
	xorwf	COUNT7,w
	btfss	STATUS,Z	; if the same check ms byte
	goto	CHK_HL4
	movf	COUNTF,w	; ms counter
	xorwf	COUNT8,w
	btfss	STATUS,Z	; if equal reset values
	goto	CHK_HL4
	movlw	B'00001100'	; RA2 and RA3 high	
	movwf	PORTA		; output high

CHK_HL4	
	movf	COUNTE,w	; ls counter
	xorwf	COUNT11,w
	btfss	STATUS,Z	; if the same check ms byte
	goto	CK_34
	movf	COUNTF,w	; ms counter
	xorwf	COUNT12,w
	btfss	STATUS,Z	; if equal reset values
	goto	CK_34	
	clrf	PORTA		; output low

CK_34
	movf	COUNTE,w	; ls counter
	xorwf	COUNT13,w
	btfss	STATUS,Z	; if the same check ms byte
	goto	RECLAIM
	movf	COUNTF,w	; ms counter
	xorwf	COUNT14,w
	btfss	STATUS,Z	; if equal reset values
	goto	RECLAIM
	clrf	PORTA

; end of interrupt reclaim w and status 

RECLAIM	
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

;********************************************************************************************** 
  	
; RESET		
; Set ports A & B

MAIN
	clrf	COUNT1
	clrf	COUNT2
	clrf	COUNT3
	clrf	COUNT4
	clrf	COUNT5
	clrf	COUNT6
	bsf		FLAG_0,0	; overrange flag
	bsf		FLAG_0,1	; valid flag
	clrf	FLAG_I		; extra count flag

	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'11111111'	; RB0 - RB7 inputs
	movwf	TRISB		; port B data direction register
	movlw	B'01000000'	; 
	movwf	OPTION_REG	; TMRO prescaler 2 division, PORTB pullups enabled
	movlw   B'00010010'	; RA1,RA4 inputs, RA0,2,3 ouputs
	movwf   TRISA		; A port data direction register
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00000000'
	movwf	PORTA		; portA outputs low 

; allow interrupts

	bsf		INTCON,T0IE	; set interrupt enable for timer
	bsf		INTCON,GIE	; set global interrupt enable 

; if overrange flag set then bypass calc
	
FLG_CK
	btfss	FLAG_0,0
	goto	RD_SW
	goto	FLG_CK

; read switch inputs 


RD_SW 
	clrf	TEMP_1		; start by clearing TEMP_1
; bit 0
	btfss	PORTB,6		; for ls bit of switches
	bsf		TEMP_1,0	; if low set bit 0 in TEMP_1
; bit 1	
	btfss	PORTB,4		; for bit 1 of switches
	bsf		TEMP_1,1	; if low set bit1 in TEMP_1
; bit 2	
	btfss	PORTB,5		; for bit 2 of switches
	bsf		TEMP_1,2	; if low set bit2 in TEMP_1
; bit 3	
	btfss	PORTB,7		; for bit 3 of switches
	bsf		TEMP_1,3	; if low set bit3 in TEMP_1
; bit 4	
	btfss	PORTB,2		; for bit 4 of switches
	bsf		TEMP_1,4	; if low set bit4 in TEMP_1
; bit 5	
	btfss	PORTB,1		; for bit 5 of switches
	bsf		TEMP_1,5	; if low set bit5 in TEMP_1
; bit 6	
	btfss	PORTA,4		; for bit 6 of switches
	bsf		TEMP_1,6	; if low set bit6 in TEMP_1
; bit 7	
	btfss	PORTB,3		; for bit 7 of switches
	bsf		TEMP_1,7	; if low set bit7 in TEMP_1

	movf	TEMP_1,w	; 
	call	DIVSR		; get divisor value
	movwf	TEMP_1		; store

; update value
; multiply by 100 or percentage depending on if for faster or slower output rate
; divide by percentage or 100
; 
	
CALC
	clrf	AARGB0		; clear
	btfss	PORTA,1		; if set faster rate
	goto	SLWR
	movlw	D'100'		; %
	movwf	AARGB1
	goto	STP_INT
SLWR
	movf	TEMP_1,w	; divisor
	movwf	AARGB1
	
; check if interrupt about to occur

STP_INT	
	movf	TMR0,w		; look at timer 
	sublw	D'240'		; only proceed when timer less than 240 as interrupt could occur 	
						; when transferring data
	btfss	STATUS,C	; if c = 0 then timer greater than 240
	goto	STP_INT		;
	movf	COUNT3,w	; latched counted value
	movwf	BARGB1
	movf	COUNT4,w
	movwf	BARGB0
	call	FXM1616U	; multiply 

; shift answer
	movf	AARGB2,w	; second ls byte of result
	movwf	STO1
	movf	AARGB3,w
	movwf	AARGB2
	movf	AARGB1,w
	movwf	AARGB0
	movf	STO1,w
	movwf	AARGB1
	
; load denominator

	btfsc	PORTA,1		; if set faster rate
	goto	SLOWR
	movlw	D'100'		; %
	goto	FSTER
SLOWR
	movf	TEMP_1,w	; divisor
FSTER
	movwf	BARGB1
	clrf	BARGB0
	call	FXD2416U	; divide 

SOP_INT
	movf	TMR0,w		; look at timer 
	sublw	D'240'		; only proceed when timer less than 240 as interrupt could occur 	
						; when transferring data
	btfss	STATUS,C	; if c = 0 then timer greater than 240
	goto	SOP_INT		;

	movf	AARGB2,w	; move values
	movwf	CALC1
	movf	AARGB1,w
	movwf	CALC2

	bcf		STATUS,C
	rrf		CALC2,w 	; ms counter byte (find halfway count)
	movwf	COUNT6
	rrf		CALC1,w
	movwf	COUNT5

	bcf		STATUS,C
	rrf		COUNT6,w 	; ms counter byte (1/4 way count)
	movwf	COUNTB
	rrf		COUNT5,w
	movwf	COUNTA
	
	movf	COUNTA,w	; subtract 1/4 way from CALC1,2 for 3/4 way
	movwf	BARGB1
	movf	COUNTB,w
	movwf	BARGB0		
	call	D_RSUB		; subtract answer in AARGB	
	
	movf	AARGB2,w	; move values
	movwf	COUNTC
	movf	AARGB1,w
	movwf	COUNTD		; count C & D have 3/4 count
		
; after calculation, 
; clear valid flag

	bcf		FLAG_0,1	
	goto	FLG_CK

; ********************************************************************************

	
; 24/16 Bit Unsigned Fixed Point Divide 

;       Input:  24 bit unsigned fixed point dividend in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point divisor in BARGB0, BARGB1

;       Use:    CALL    FXD2416U

;       Output: 24 bit unsigned fixed point quotient in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point remainder in REMB0, REMB1

;       Result: AARG, REM  <--  AARG / BARG


FXD2416U        CLRF            REMB0
                CLRF            REMB1
                CLRF            TEMPD
                RLF             AARGB0,W
                RLF             REMB1, F
                MOVF            BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                RLF             AARGB0, F
                MOVLW           7
                MOVWF           LOOPCOUNT
LOOPU2416A      RLF             AARGB0,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46LA
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46LA
UADD46LA        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46LA 		RLF             AARGB0, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416A
                RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46L8
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46L8
UADD46L8        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46L8         RLF             AARGB1, F
                MOVLW           7
                MOVWF           LOOPCOUNT
LOOPU2416B      RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46LB
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46LB
UADD46LB        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46LB         RLF             AARGB1, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416B
                RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46L16
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46L16
UADD46L16       ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46L16        RLF             AARGB2, F
                MOVLW           7
                MOVWF           LOOPCOUNT
LOOPU2416C      RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB2,0
                GOTO            UADD46LC
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46LC
UADD46LC        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46LC 		RLF             AARGB2, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416C
                BTFSC           AARGB2,0
                GOTO            UOK46L
                MOVF            BARGB1,W
	        	ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
UOK46L			RETURN
	
; multiply
;
;       Input:  fixed point arguments in AARG and BARG
;
;       Output: product AARGxBARG in AARG
;

;       16x16 Bit Unsigned Fixed Point Multiply 

;       Input:  16 bit unsigned fixed point multiplicand in AARGB0
;               16 bit unsigned fixed point multiplier in BARGB0

;       Use:    CALL    FXM1616U

;       Output: 32 bit unsigned fixed point product in AARGB0



FXM1616U        CLRF    AARGB2          ; clear partial product
                CLRF    AARGB3
                MOVF    AARGB0,W
                MOVWF   TEMPB0
                MOVF    AARGB1,W
                MOVWF   TEMPB1
                MOVLW   0x08
                MOVWF   LOOPCOUNT
LOOPUM1616A     RRF     BARGB1, F
                BTFSC   STATUS,C
                GOTO    ALUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616A
                MOVWF   LOOPCOUNT
LOOPUM1616B     RRF     BARGB0, F
                BTFSC   STATUS,C
                GOTO    BLUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616B
                CLRF    AARGB0
                CLRF    AARGB1
                RETLW   0x00
BLUM1616NAP     BCF     STATUS,C
                GOTO    BLUM1616NA
ALUM1616NAP     BCF     STATUS,C
                GOTO    ALUM1616NA
ALOOPUM1616     RRF     BARGB1, F
                BTFSS   STATUS,C
                GOTO    ALUM1616NA
                MOVF    TEMPB1,W
                ADDWF   AARGB1, F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0, F
ALUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                DECFSZ LOOPCOUNT, F
                GOTO   ALOOPUM1616
                MOVLW  0x08
                MOVWF  LOOPCOUNT
BLOOPUM1616     RRF    BARGB0, F
                BTFSS  STATUS,C
                GOTO   BLUM1616NA
                MOVF   TEMPB1,W
                ADDWF  AARGB1, F
                MOVF   TEMPB0,W
                BTFSC  STATUS,C
                INCFSZ TEMPB0,W
                ADDWF  AARGB0, F
BLUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                RRF    AARGB3, F
                DECFSZ LOOPCOUNT, F
                GOTO   BLOOPUM1616
                RETURN

; subroutine subtract AARGB1 AARGB2 - BARGB0 BARGB1 = AARGB
	
	
D_RSUB
	call	NEG_A		; complement of A
	movf	BARGB1,w 
	addwf	AARGB2,f 	; add lsb
	btfsc	STATUS,C	; add carry
	incf	AARGB1,f 
	movf	BARGB0,w 
	addwf	AARGB1,f 
	return

NEG_A
	comf	BARGB1,f 
	incf	BARGB1,f 
	btfsc	STATUS,Z
	decf	BARGB0,f 
	comf	BARGB0,f 
	return	

	
	
	end	
