
; Pulse Width Modifier (connects in line between PWM input and PWM output)
; the second PIC (running PWMadjst.asm) measures PWM and provides the output change required
; as an 8-bit value to the pwmmod PIC. 

	list P=16F628A
	#include p16f628A.inc

	__config _HS_OSC & _WDT_OFF & _PWRTE_ON & _BOREN_ON & _MCLRE_ON & _LVP_OFF

; EEPROM
EEPROM0	    equ	H'00'	; non-volatile storage for COUNT6 
EEPROM1		equ	H'01'	; non-volatile storage for COUNT5
EEPROM2	    equ	H'02'	; non-volatile storage for COUNT6 
EEPROM3		equ	H'03'	; non-volatile storage for COUNT5

; Bank 0 RAM

STORE1		equ	H'20'	; delay counter	
STORE2		equ	H'21'	; delay counter
STRT_FLG	equ	H'22'	; start flag for reading portB
STRT_CNT0	equ	H'23'	; start counter
STRT_CNT1	equ	H'24'   ; start counter
COUNTx		equ	H'25'	; counter for pwm cycle ls byte output
COUNTy		equ	H'26'	; counter for pwm cycle ms byte output
RED_WRT		equ	H'27'	; ready to write flag
STRT_FG		equ	H'28'	; start flag
WRITN		equ	H'29' 	; EEPROM written flag
COUNT_5		equ	H'2A'	; stored latched counter for pwm cycle ls byte
COUNT1		equ	H'2B'	; counter for pwm cycle ls byte input
COUNT2		equ	H'2C'	; counter for pwm cycle ms byte input
COUNT3		equ	H'2D'	; counter for high pulse length ls byte
COUNT4		equ	H'2E'	; counter for high pulse length ms byte
COUNT5		equ	H'2F'	; latched counter for pwm cycle ls byte
COUNT6 		equ	H'30'	; latched counter for pwm cycle pulse ms byte
COUNT7		equ	H'31'	; latched counter for high pulse ls byte
COUNT8		equ	H'32'	; latched counter for high pulse ms byte	
COUNT_7		equ	H'33'	; latched counter for high pulse ls byte store during calculations
COUNT_8 	equ	H'34'	; latched counter for high pulse ms byte store during calculations
COUNT_1		equ	H'35'	; divided by 2 counter for pwm cycle ls byte
COUNT_2		equ	H'36'	; divided by 2 counter for pwm cycle ms byte
COUNT9		equ	H'37'	; latched counter for high pulse ls byte for output
COUNT10		equ	H'38'	; latched counter for high pulse ms byte for output
DEL_FLG		equ	H'39'	; delay flag
ASTOR		equ	H'3A'	; storage of data at PORTA
BSTOR		equ	H'3B'	; storage of data at PORTB
FLAG_0		equ	H'3C'	; bit 0 overrange flag
DATA_RD		equ	H'3D'	; data read register
CH_VAL		equ	H'3E'	; altered data read value (removes sign and offset from 80)
SIGN		equ	H'3F'	; sign bit for data read value
INT_CNT1	equ	H'40'	; interrupt counter
INT_CNT2	equ	H'41'	; interrupt counter
INT_CNT3	equ	H'42'	; interrupt counter
COUNT_6		equ	H'43'	; stored count6
EDGE_2		equ	H'44'	; edge counter

; math routines

TEMPB1      equ 0x45
TEMPB0      equ 0x46
TEMPD       equ 0x47    ; temporary storage
AARGB3		equ	0x48
AARGB2      equ 0x49
AARGB1      equ 0x4A
AARGB0      equ 0x4B
AARG        equ 0x4B    ; most significant byte of argument A
BARGB1      equ 0x4C
BARGB0      equ 0x4D
BARG        equ 0x4D    ; most significant byte of argument B
REMB1       equ 0x4E
REMB0       equ 0x4F    ; most significant byte of remainder
LOOPCOUNT   equ 0x50    ; loop counter
STO1		equ	0x51	; AARGB1 storage
STO2		equ	0x52	; AARGB2 storage

; All Banks RAM
ST_ADR		equ	H'70'	; storage of EEPROM Address during interrupt
EDTA_ST		equ	H'71'	; EEPROM data store
W_TMP		equ	H'72'	; storage of w before interrupt
STATUS_TMP	equ	H'73'	; status storage before interrupt

; preprogram EEPROM DATA for initial PWM frequency
	
	ORG     2100
	DE	H'01', H'90'	; count of D400 about 250Hz
	DE	H'01', H'90'	; count of D400 about 250Hz

; start at memory 0

	org	0
	goto	MAIN
	org     4			; interrupt vector 0004h, start interrupt routine here
	goto	INTRUPT		

;******************************************************************************************* 

; INTERRUPT

; start interrupt by saving w and status registers before altered by interrupt routine

INTRUPT
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp  
	bsf		STATUS,RP0	; bank 1
	movf	EEADR,w		; EEPROM address 
	movwf	ST_ADR		; keep address
	movf	EEDATA,w	; EEPROM data
	movwf	EDTA_ST		; store value
	bcf		STATUS,RP0	; select bank 0

	bcf		INTCON,T0IF	; clear TMRO interrupt flag
	movlw	D'220'		; 220
	addwf	TMR0,f		; speed interrupt rate

	incfsz	INT_CNT1,f	; increase each interrupt
	goto	CK_RIS
	incfsz	INT_CNT2,f
	goto	CK_RIS
	incf	INT_CNT3,f
	btfss	INT_CNT3,1	; check bit
	goto	CK_RIS
	bsf		DEL_FLG,0	; after first 256 x 2 interrupts set flag so ports can change

; check for rising edge

CK_RIS
	btfsc	INTCON,INTF	; has edge gone high
	goto	END_EDG		; end of PWM cycle

; drive output

OUT_DV
	movf	COUNT6,w	; ms byte of latched full pwm counter (last remembered pulse rate)
	subwf	COUNTy,w	; ms byte of full pwm cycle counter
	btfss	STATUS,C	; when equal or greater C = 1 and output should go subject to ls count
	goto	OUT_CL
	movf	COUNT5,w	; ls byte of latched full pwm counter
	subwf	COUNTx,w	; ls byte of full pwm cycle counter
	btfss	STATUS,C	; when + or > then output set low (C=1)
	goto	OUT_CL		
	clrf	COUNTx		; output full pwm counters
	clrf	COUNTy
	btfss	DEL_FLG,0	; if set change PORT outputs
	goto	OUT_CL		; bypass port drive if flag not set
	bsf		PORTB,1		; output high
	bcf		PORTB,2		; inverted output
OUT_CL	
	movf	COUNT10,w	; ms byte of output counter
	subwf	COUNTy,w	; ms byte of full pwm cycle counter
	btfss	STATUS,C	; when equal or greater C = 1 and output should go subject to ls count
	goto	COUNT_P
	movf	COUNT9,w	; ls byte of output counter
	subwf	COUNTx,w	; ls byte of full pwm cycle counter
	btfss	STATUS,C	; when + or > then RB1 output set low (C=1)
	goto	COUNT_P
	btfss	DEL_FLG,0	; if set change PORT outputs
	goto	COUNT_P		; bypass port drive if flag not set
	bcf		PORTB,1		; output low
	bsf		PORTB,2		; inverted output

; measure pulse widths

COUNT_P	
	incfsz	COUNT1,f	; if zero increment most significant byte
	goto	COUNT_L		; count low test
	incf	COUNT2,f	; most significant byte 
	btfss	COUNT2,7	; if bit high overrange  
	goto	COUNT_L
	bsf		FLAG_0,0	; overrange ie input signal always high or low
	btfss	PORTB,0
	goto	CLR_78		; clear count7,8 so output goes high

; load stored values
	
	movlw	EEPROM2		; EEPROM location for COUNT6
	call	EEREAD		; read stored value
	movwf	COUNT6
	movwf	COUNT8
	movlw	EEPROM3		; EEPROM location for COUNT5
	call	EEREAD
	movwf	COUNT5
	movwf	COUNT7
	bsf		EDGE_2,0	; edge count detector
	goto	RECLAIM
CLR_78	
	movlw	EEPROM2		; EEPROM location for COUNT6
	call	EEREAD		; read stored value
	movwf	COUNT6
	movlw	EEPROM3		; EEPROM location for COUNT5
	call	EEREAD
	movwf	COUNT5	
	clrf	COUNT7
	clrf	COUNT8
	bsf		EDGE_2,0	; edge count detector
	goto	RECLAIM
	
COUNT_L
	incfsz	COUNTx,f	; if zero increment most significant byte
	goto	STOP_L		; count low test
	incf	COUNTy,f	; most significant byte 
STOP_L
	btfss	PORTB,0		; second counter stopped when RB0 low
	goto	RECLAIM

N_UP
	incfsz	COUNT3,f	; if zero increment most significant byte
	goto	RECLAIM	
	incf	COUNT4,f	; ms byte
	goto	RECLAIM

; positive edge (end of PWM cycle so get new values of counts)
	
END_EDG
	bcf		INTCON,INTF	; clear edge detect flag
	btfss	DEL_FLG,0	; if set change PORT outputs
	goto	CK_FLG0
; if 0 clear to 0
	movf	COUNT10,w
	btfss	STATUS,Z	; if ms byte 0 check ls byte
	goto 	ST_OUT
	movf	COUNT9,w
	btfss	STATUS,Z	; if zero 
	goto	ST_OUT
	bcf		PORTB,1		; output low
	bsf		PORTB,2		; inverted output
	goto	CK_FLG0
ST_OUT
	bsf		PORTB,1		; output high
	bcf		PORTB,2		; inverted output

CK_FLG0
	btfsc	FLAG_0,0	; if set then only clear COUNT1,2,3,4
	goto	CL_CNTS	

; transfer count values to latched storage

	movf	COUNT1,w
	movwf	COUNT5
	movf	COUNT2,w
	movwf	COUNT6
	movf	COUNT3,w
	movwf	COUNT7
	movf	COUNT4,w
	movwf	COUNT8
	
	incf	RED_WRT,f	; increment ready to write flag for EEPROM
	clrf	STRT_FG		; clear start flag

; clear counters

CL_CNTS	
	btfss	EDGE_2,0	; if only the first edge bypass clearing FLAG_0
	clrf	FLAG_0		; overrange flag
	clrf	EDGE_2		; edge detect flag
	clrf	COUNT1		; clear counters	
	clrf	COUNT2
	clrf	COUNT3
	clrf	COUNT4
	clrf	COUNTx
	clrf	COUNTy
	
; end of interrupt reclaim w and status 

RECLAIM
	bsf		STATUS,RP0	; select bank 1
	movf	ST_ADR,w	; EEPROM address store
	movwf	EEADR		; return to original address
	movf	EDTA_ST,w	; EEPROM data store 
	movwf	EEDATA
	bcf		STATUS,RP0	; select bank 0
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

; ******************************************************************************************

MAIN
	bcf		STATUS,RP0	; memory bank 0	
	bcf		STATUS,RP1	; memory bank 0	
	clrwdt				; clear watchdog timer as set as default at power up
	bsf		FLAG_0,0	; overrange flag
	clrf	INT_CNT1	; clear interrupt counter ls byte
	clrf	INT_CNT2	; clear interrupt counter ms byte
	clrf	INT_CNT3	; clear interrupt counter ms byte
	clrf	DEL_FLG		; delay flag
	clrf	COUNTx
	clrf	COUNTy
	clrf	COUNT1
	clrf	COUNT2
	clrf	COUNT3
	clrf	COUNT4
	clrf	COUNT10
	clrf	COUNT9
	clrf	RED_WRT		; clear ready to write flag
	bsf		STRT_FG,0	; start flag
	bsf		EDGE_2,0	; edge detect flag
	clrf	WRITN		; EEPROM written flag
	clrf	STRT_FLG	; start flag for reading portB
	movlw	B'10000000'	; 127
	movwf	DATA_RD		; initial zero value for portB output offset value
	clrf	STRT_CNT0	; start counter
	movlw	0x80
	movwf	STRT_CNT1	; start counter initial offset

; initialise ports

	bcf		PORTB,1		; clear output
	bcf		PORTB,2		; clear invert output

 	movlw	0x07		; comparators off
	movwf	CMCON		; I/O pins
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'11111001'	; port B inputs and RB1,2 output
	movwf	TRISB		; port B data direction register
	movlw	B'11111111'	; RA inputs
	movwf	TRISA		; port A data direction register
	movlw	B'11000000'	; prescaler internal clock, rising edge select 
	movwf	OPTION_REG	; port B pullups disabled
	bcf		STATUS,RP0	; memory bank 0	
	bcf		INTCON,INTF	; clear edge detect flag
	
; read stored data

	movlw	EEPROM2		; EEPROM location for COUNT6
	call	EEREAD		; read stored value
	movwf	COUNT6
	movlw	EEPROM3		; EEPROM location for COUNT5
	call	EEREAD
	movwf	COUNT5
		
; check RB0 input
	
	btfss	PORTB,0		; if input low set output low
	goto	S_LOW
	movf	COUNT6,w	; full pwm latched counter ms byte
	movwf	COUNT8		; high time ms byte
	movf	COUNT5,w	; full pwm latched counter ls byte
	movwf	COUNT7		; high time ls byte
	goto	ALL_INT	
S_LOW	
	clrf	COUNT7		; high time counters
	clrf	COUNT8

; allow interrupts

ALL_INT	
	bsf		INTCON,T0IE	; set interrupt enable for TMR0 
	bsf		INTCON,GIE	; set global interrupt enable for above

; read data values etc. Normal program loop starts here

RD_DATA
	btfss	STRT_FG,0	; if start flag set check inputs
	goto	STR_DTA		; store data

; until start flag cleared keep monitoring input

	bcf		INTCON,GIE	; clear global interrupt enable
	btfss	PORTB,0		; if input low set output low
	goto	P_LOW
	movf	COUNT6,w	; full pwm latched counter ms byte
	movwf	COUNT8		; high time ms byte
	movf	COUNT5,w	; full pwm latched counter ls byte
	movwf	COUNT7		; high time ls byte
	goto	STR_DTA
P_LOW	
	clrf	COUNT7		; high time counters
	clrf	COUNT8

; store data 

STR_DTA
	bsf		INTCON,GIE	; set global interrupt enable
	btfsc	PORTB,3		; if set then bypass
	goto	RD_PRT
	btfss	RED_WRT,5	; ready to write flag ready when bit 5 high 
	goto	RD_PRT
	btfsc	WRITN,0		; already written flag
	goto	RD_PRT
	movlw	EEPROM0		; COUNT6 storage
	bsf		STATUS,RP0	; bank 1
	movwf	EEADR		; eeprom address location
	bcf		STATUS,RP0	; bank 0

 	bcf		INTCON,GIE	; clear global interrupt enable
	movf	COUNT5,w	; value in COUNT5
	movwf	COUNT_5		; temp store
	movf	COUNT6,w
	movwf	COUNT_6		; temp store
	bsf		INTCON,GIE	; set global interrupt enable
	call	EEWRITE		; write to EEPROM
	bsf		STATUS,RP0	; bank 1
	incf	EEADR,f		; next address
	bcf		STATUS,RP0	; bank 0

	movf	COUNT_5,w	; value in COUNT5
	call	EEWRITE

	bsf		STATUS,RP0	; bank 1
	incf	EEADR,f		; next address
	bcf		STATUS,RP0	; bank 0

	movf	COUNT_6,w	; value in COUNT6
	call	EEWRITE
	bsf		STATUS,RP0	; bank 1
	incf	EEADR,f		; next address
	bcf		STATUS,RP0	; bank 0

	movf	COUNT_5,w	; value in COUNT5
	call	EEWRITE

	bsf		WRITN,0		; set written flag

; check if start timeout expired

RD_PRT
	btfsc	STRT_FLG,0	; only read portB when initial timeout expired	
	goto	B_READ		; portB read
	incfsz	STRT_CNT0,f	; counter for initial timeout
	goto	TST_DTA
	incfsz	STRT_CNT1,f
	goto	TST_DTA
	bsf		STRT_FLG,0	; set flag after timeout

; read ports

B_READ	
	movf	PORTB,w		; portB values (Ls byte) at RB4,5,7,6 (RB4 Ms bit RB6 Ls bit)
	andlw	B'11110000'	; extract ms bits
	movwf	BSTOR		; store 
	movf	PORTA,w		; portA values Ms byte (RA1,0,3,2 ms bit to ls bit)
	andlw	B'00001111'	; extract ls bits
	movwf	ASTOR		; store

; check if data changed

	movf	PORTB,w		; get data again
	andlw	B'11110000'	; extract ms bits
	xorwf	BSTOR,w		; check with old data
	btfss	STATUS,Z	; if the same check A port
	goto	RD_PRT		; check again till data is constant
	movf	PORTA,w		; get portA data again
	andlw	B'00001111'	; extract ms bits
	xorwf	ASTOR,w		; check with old data
	btfss	STATUS,Z
	goto	RD_PRT		; data changed so check again

; rearrange data into register (DATA_RD)

	clrf	DATA_RD		; initially clear
	btfsc	BSTOR,6		; check bit 6
	bsf		DATA_RD,0	; set if RB6 was set
	btfsc	BSTOR,7		; check bit 7
	bsf		DATA_RD,1	; set if RB7 was set
	btfsc	BSTOR,5		; check bit 5
	bsf		DATA_RD,2	; set if RB5 was set
	btfsc	BSTOR,4		; check bit 4
	bsf		DATA_RD,3	; set if RB4 was set
	btfsc	ASTOR,2		; check bit 2
	bsf		DATA_RD,4	; set if RA2 was set
	btfsc	ASTOR,3		; check bit 3
	bsf		DATA_RD,5	; set if RA3 was set
	btfsc	ASTOR,0		; check bit 0
	bsf		DATA_RD,6	; set if RA0 was set
	btfsc	ASTOR,1		; check bit 1
	bsf		DATA_RD,7	; set if RA1 was set

; test DATA_RD. If set at zero then bypass calculation

TST_DTA
	movf	DATA_RD,w	; read change data value
	xorlw	B'10000000'	; check if 127 or zero change value
	btfss	STATUS,Z	; if zero bypass calculation
	goto	CALC		; not zero change so calculate

RN	bcf		INTCON,GIE	; stop interrupt
	movf	COUNT8,w	; ms of high input level counter
	movwf	COUNT10
	movf	COUNT7,w	; ls of high input level counter
	movwf	COUNT9	
	bsf		INTCON,GIE	; set global interrupt enable
	goto	RD_DATA		; read data again 

; calculate required PWM negative position
; CH_VAL (DATA_RD with offset from 80 removed)
; x PWM count (COUNT6, COUNT5) divided by 127 then add or subtract from high level 
; counter (COUNT8, COUNT7). Add or subtract depends on sign bit at DATA_RD,7 and 
; +/- input at RA4 

CALC
	clrf	SIGN		; sign on change data	
	movf	DATA_RD,w	; get data
	movwf	CH_VAL
	btfsc	CH_VAL,7	; if bit 7 set then +
	goto	PLUS
	bsf		SIGN,0		; set sign bit for (-)
	sublw	0x80		; display shows offset from 128
	movwf	CH_VAL		; 
PLUS
	bcf		CH_VAL,7	; extract only 7 bits (bit 7 is sign)

; calculation and then check if beyond COUNT_6, COUNT_5 or less than zero

	clrf	AARGB0		; clear
	movf	CH_VAL,w	; data change value
	btfsc	STATUS,Z	; if zero bypass multiply
	goto	RD_DATA	
	movwf	AARGB1

; stop interrupt to transfer data

	bcf		INTCON,GIE	; clear global interrupt enable 
	movf	COUNT5,w	; ls byte for multiply
	movwf	BARGB1
	movf	COUNT6,w	; ms byte for multiply
	movwf	BARGB0
	movf	COUNT7,w	; ls high pulse counted value
	movwf	COUNT_7		; maintain value during calculation
	movf	COUNT8,w	; ls high pulse counted value
	movwf	COUNT_8		; maintain value during calculation
	bsf		INTCON,GIE	; set global interrupt enable 
	clrwdt

; multiply

MTPLY	call	FXM1616U	; multiply by CH_VAL

; shift answer
	movf	AARGB2,w	; second ls byte of result
	movwf	STO1
	movf	AARGB3,w
	movwf	AARGB2
	movf	AARGB1,w
	movwf	AARGB0
	movf	STO1,w
	movwf	AARGB1
	
; load denominator

	movlw	D'127'		; divide by 127
	movwf	BARGB1
	clrf	BARGB0
	clrwdt
	call	FXD2416U	; divide 

; increase value if over half way at remainder

;	movlw	0x7F
;	addwf	REMB0,w		; add to remainder
;	btfsc	STATUS,C	; increase if carry set
;	incf	AARGB2,f

; add or subtract value to COUNT_7, COUNT_8, place in COUNT9,COUNT10 (hold interrupt when doing)	

	btfss	SIGN,0		; if set, then negative
	goto	CLR_SGN
	btfss	PORTA,4		; if set then negative 
	goto	SUBTR		; subtract as one negative
	goto	ADDN		; two negatives so add
CLR_SGN	
	btfss	PORTA,4		; if set then negative
	goto	ADDN		; 
	goto	SUBTR		; portA,4 sets as negative so subtract	

SUBTR
	movf	AARGB2,w	; ls result of calculations so far
	movwf	BARGB1
	movf	AARGB1,w	; ms result of calculations so far
	movwf	BARGB0
	movf	COUNT_8,w	; pwm cycle length ms byte
	movwf	AARGB1
	movf	COUNT_7,w	; pwm cycle length ls byte
	movwf	AARGB2
	call	D_SUB
TRANSF

	bcf		INTCON,GIE	; clear global interrupt enable to stop errors in transfer
	movf	AARGB1,w	; ms result
	movwf	COUNT10
	movf	AARGB2,w	; ls result
	movwf	COUNT9
	bsf		INTCON,GIE	; set global interrupt enable
	goto	RD_DATA		; check data input	

ADDN
	movf	COUNT_8,w	; pwm cycle length ms byte
	movwf	BARGB0
	movf	COUNT_7,w	; pwm cycle length ls byte
	movwf	BARGB1
	call	D_ADD
	btfss	STATUS,C	; if carry set then overrange so set at FF
	goto	TRANSF		; place in count9,10
	movlw	0xFF
	movwf	AARGB2
	movwf	AARGB1
	goto	TRANSF

; duty cycle  calculation ends
	

;***************************************************************************
; subroutines

DELAY
	movlw	0x0A		; delay 
	movwf	STORE1		; STORE1 is number of loops value
LOOP1
	clrwdt
	movlw	0xA0
	movwf	STORE2		; STORE2 is internal loop value	
LOOP2
	decfsz	STORE2,f
	goto	LOOP2
	decfsz	STORE1,f
	goto	LOOP1		; decrease till STORE1 is zero
	return

; subroutine to read EEPROM memory

EEREAD
	bsf 	STATUS,RP0	; select memory bank 1
	movwf 	EEADR		; indirect special function register
	bsf		EECON1,RD	; read EEPROM
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP0	; select bank 0
	clrwdt				; watchdog cleared
	return

; subroutine to write to EEPROM

EEWRITE	
	bsf		STATUS,RP0	; select bank 1
	movwf	EEDATA		; data register
WR3	clrwdt
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR3			; not written yet
	bcf		INTCON,GIE	; disable interrupts
	bsf		EECON1,WREN	; enable write
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
	bsf		INTCON,GIE	; enable interrupts
WRITE
	clrwdt				; watchdog cleared	
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0	; bank 0 
	return				; value written 


; subroutine to subtract AARGB1 AARGB2 - BARGB0 BARGB1 = AARGB
	
D_SUB	
; check if BARGB > AARGB if so make value zero

	movf	AARGB1,w
	subwf	BARGB0,w
	btfss	STATUS,C	; check if = or >
	goto	NEG_SUB		; negative so can subtract
	btfss	STATUS,Z	; if equal check ls byte
	goto	CLR_VAL		; is > so clear
	movf	AARGB2,w
	subwf	BARGB1,w
	btfss	STATUS,C	; if = or >
	goto	NEG_SUB
CLR_VAL
	clrf	AARGB1
	clrf	AARGB2
	return

NEG_SUB	
	call	NEG_A		; complement of A

; subroutine to add

D_ADD
	movf	BARGB1,w 
	addwf	AARGB2,f 	; add lsb
	btfsc	STATUS,C	; add carry
	incf	AARGB1,f 
	movf	BARGB0,w 
	addwf	AARGB1,f 
	return

NEG_A
	comf	BARGB1,f 
	incf	BARGB1,f 
	btfsc	STATUS,Z
	decf	BARGB0,f 
	comf	BARGB0,f 
	return	


; 24/16 Bit Unsigned Fixed Point Divide 

;       Input:  24 bit unsigned fixed point dividend in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point divisor in BARGB0, BARGB1

;       Use:    CALL    FXD2416U

;       Output: 24 bit unsigned fixed point quotient in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point remainder in REMB0, REMB1

;       Result: AARG, REM  <--  AARG / BARG


FXD2416U        CLRF            REMB0
                CLRF            REMB1
                CLRF            TEMPD
                RLF             AARGB0,W
                RLF             REMB1, F
                MOVF            BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                RLF             AARGB0, F
                MOVLW           7
                MOVWF           LOOPCOUNT
LOOPU2416A      RLF             AARGB0,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46LA
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46LA
UADD46LA        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46LA 		RLF             AARGB0, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416A
                RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46L8
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46L8
UADD46L8        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46L8         RLF             AARGB1, F
                MOVLW           7
                MOVWF           LOOPCOUNT
LOOPU2416B      RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46LB
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46LB
UADD46LB        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46LB         RLF             AARGB1, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416B
                RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46L16
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46L16
UADD46L16       ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46L16        RLF             AARGB2, F
                MOVLW           7
                MOVWF           LOOPCOUNT
LOOPU2416C      RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB2,0
                GOTO            UADD46LC
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46LC
UADD46LC        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMPD, F
UOK46LC 		RLF             AARGB2, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416C
                BTFSC           AARGB2,0
                GOTO            UOK46L
                MOVF            BARGB1,W
	      		ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
UOK46L			RETURN
	
; multiply
;
;       Input:  fixed point arguments in AARG and BARG
;
;       Output: product AARGxBARG in AARG
;

;       16x16 Bit Unsigned Fixed Point Multiply 

;       Input:  16 bit unsigned fixed point multiplicand in AARGB0
;               16 bit unsigned fixed point multiplier in BARGB0

;       Use:    CALL    FXM1616U

;       Output: 32 bit unsigned fixed point product in AARGB0



FXM1616U        CLRF    AARGB2          ; clear partial product
                CLRF    AARGB3
                MOVF    AARGB0,W
                MOVWF   TEMPB0
                MOVF    AARGB1,W
                MOVWF   TEMPB1
                MOVLW   0x08
                MOVWF   LOOPCOUNT
LOOPUM1616A     RRF     BARGB1, F
                BTFSC   STATUS,C
                GOTO    ALUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616A
                MOVWF   LOOPCOUNT
LOOPUM1616B     RRF     BARGB0, F
                BTFSC   STATUS,C
                GOTO    BLUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616B
                CLRF    AARGB0
                CLRF    AARGB1
                RETLW   0x00
BLUM1616NAP     BCF     STATUS,C
                GOTO    BLUM1616NA
ALUM1616NAP     BCF     STATUS,C
                GOTO    ALUM1616NA
ALOOPUM1616     RRF     BARGB1, F
                BTFSS   STATUS,C
                GOTO    ALUM1616NA
                MOVF    TEMPB1,W
                ADDWF   AARGB1, F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0, F
ALUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                DECFSZ LOOPCOUNT, F
                GOTO   ALOOPUM1616
                MOVLW  0x08
                MOVWF  LOOPCOUNT
BLOOPUM1616     RRF    BARGB0, F
                BTFSS  STATUS,C
                GOTO   BLUM1616NA
                MOVF   TEMPB1,W
                ADDWF  AARGB1, F
                MOVF   TEMPB0,W
                BTFSC  STATUS,C
                INCFSZ TEMPB0,W
                ADDWF  AARGB0, F
BLUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                RRF    AARGB3, F
                DECFSZ LOOPCOUNT, F
                GOTO   BLOOPUM1616
                RETURN


	end
