#pragma once

namespace JimsECGSamplerMk10 
{

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace System::Globalization;	// added manually, to fix Parse() function 
	using namespace System::Threading;	// added manually, to fix serial port operations
	using namespace System::IO::Ports;	// added manually, to fix serial port operations
	using namespace System::Drawing::Printing;	// added manually to enable form printing
	using namespace System::IO;			// added manually to enable file I/O

	/// <summary>
	/// Summary for Form1
	/// </summary>
	public ref class Form1 : public System::Windows::Forms::Form
	{
	public: PrintDocument ^printDocument1 = gcnew PrintDocument();		// added to get form print going
	private: System::Windows::Forms::PictureBox^  pictureBox1;
	private: System::Threading::Thread^ samplingThread;
	private: System::Timers::Timer^ samplingTimer;
	public:
		array<Int16> ^intSampleArray = gcnew array<Int16>(5000);	// declare sample storage array (managed)

	public:
		Form1(void)
		{
			// Silicon Chip ECG Sampler program Mk10
			// Written by Jim Rowe -- with a great deal
			// of help from my colleague Nicholas Vinen.
			// Last revised 21/08/2015 at 7:45am

			InitializeComponent();
			findPorts();
		}

	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Form1()
		{
			if (this->samplingThread && this->samplingThread->IsAlive)
				this->samplingThread->Abort();
			delete components;
		}
	private: System::Windows::Forms::ComboBox^  comboBox1;	// baudrate selection box
	protected: 
	private: System::Windows::Forms::Label^  label1;
	private: System::Windows::Forms::ComboBox^  comboBox2;  // COM port selection box
	private: System::Windows::Forms::Label^  label2;
	private: System::Windows::Forms::ComboBox^  comboBox3;  // sample rate selection box
	private: System::Windows::Forms::Label^  label3;
	private: System::Windows::Forms::Label^  label4;		// label for sampling progress bar
	private: System::Windows::Forms::Button^  button1;			// Open Port button

	private: System::Windows::Forms::ProgressBar^  progBar1;	// sampling progress bar

	private: System::IO::Ports::SerialPort^  serialPort1;


	private: System::ComponentModel::IContainer^  components;

	private:
		/// <summary>
		/// Required designer variables
			Int16 intSamplingTime;			// total sampling time in seconds (5,10 or 20)
			Int16 intScaledSmplValue;		// scaled sample value variable (0-613)
			volatile Int32 intCurArrayCntr;			// counter for current sample in array
			Int32 intNumofSamples;			// number of samples to be taken (5 or 10 or 20 times 242)
			Int16 GainSwSetting;			// ECG sampler's switch setting value (0 or 1)
			bool bSwitchPos;				// position flag for S1 (gain) on ECG sampler
			volatile bool samplingActive;
			int samplingLastShownPoint;
			PointF point1;					// point1 for graph plot line drawing
			PointF point2;					// point2 for graph plot line drawing

			System::Drawing::Graphics ^FormGraphic;	// handle to manage form's drawing activities
			System::Drawing::Pen ^myBlackPen, ^myRedPen;
			System::Drawing::SolidBrush ^myBrush = gcnew System::Drawing::SolidBrush(System::Drawing::Color::White);
			System::Drawing::Point ptStart, ptEnd;	// variables to manage drawing coordinates
	private: System::Windows::Forms::MenuStrip^  menuStrip1;
	private: System::Windows::Forms::ToolStripMenuItem^  toolStripMenuItem1;
	private: System::Windows::Forms::ToolStripMenuItem^  saveToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  openToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  printToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  exitToolStripMenuItem;
	private: System::Windows::Forms::SaveFileDialog^  saveFileDialog1;
	private: System::Windows::Forms::OpenFileDialog^  openFileDialog1;
	private: System::Windows::Forms::PrintDialog^  printDialog1;
	private: System::Windows::Forms::TextBox^  textBox1;
	private: System::Windows::Forms::ToolStripMenuItem^  aboutToolStripMenuItem;


		/// </summary>

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->components = (gcnew System::ComponentModel::Container());
			System::ComponentModel::ComponentResourceManager^  resources = (gcnew System::ComponentModel::ComponentResourceManager(Form1::typeid));
			this->comboBox1 = (gcnew System::Windows::Forms::ComboBox());
			this->label1 = (gcnew System::Windows::Forms::Label());
			this->comboBox2 = (gcnew System::Windows::Forms::ComboBox());
			this->label2 = (gcnew System::Windows::Forms::Label());
			this->comboBox3 = (gcnew System::Windows::Forms::ComboBox());
			this->label3 = (gcnew System::Windows::Forms::Label());
			this->button1 = (gcnew System::Windows::Forms::Button());
			this->serialPort1 = (gcnew System::IO::Ports::SerialPort(this->components));
			this->progBar1 = (gcnew System::Windows::Forms::ProgressBar());
			this->label4 = (gcnew System::Windows::Forms::Label());
			this->menuStrip1 = (gcnew System::Windows::Forms::MenuStrip());
			this->toolStripMenuItem1 = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->saveToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->openToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->printToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->exitToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->aboutToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->saveFileDialog1 = (gcnew System::Windows::Forms::SaveFileDialog());
			this->openFileDialog1 = (gcnew System::Windows::Forms::OpenFileDialog());
			this->printDialog1 = (gcnew System::Windows::Forms::PrintDialog());
			this->textBox1 = (gcnew System::Windows::Forms::TextBox());
			this->pictureBox1 = (gcnew System::Windows::Forms::PictureBox());
			this->menuStrip1->SuspendLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->pictureBox1))->BeginInit();
			this->SuspendLayout();
			// 
			// comboBox1
			// 
			this->comboBox1->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
			this->comboBox1->FormattingEnabled = true;
			this->comboBox1->Items->AddRange(gcnew cli::array< System::Object^  >(4) { L"9600", L"19200", L"38400", L"115200" });
			this->comboBox1->Location = System::Drawing::Point(400, 33);
			this->comboBox1->Margin = System::Windows::Forms::Padding(4);
			this->comboBox1->Name = L"comboBox1";
			this->comboBox1->Size = System::Drawing::Size(160, 24);
			this->comboBox1->TabIndex = 0;
			// 
			// label1
			// 
			this->label1->AutoSize = true;
			this->label1->Location = System::Drawing::Point(317, 36);
			this->label1->Margin = System::Windows::Forms::Padding(4, 0, 4, 0);
			this->label1->Name = L"label1";
			this->label1->Size = System::Drawing::Size(75, 16);
			this->label1->TabIndex = 1;
			this->label1->Text = L"Baud Rate:";
			// 
			// comboBox2
			// 
			this->comboBox2->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
			this->comboBox2->FormattingEnabled = true;
			this->comboBox2->Location = System::Drawing::Point(658, 34);
			this->comboBox2->Margin = System::Windows::Forms::Padding(4);
			this->comboBox2->Name = L"comboBox2";
			this->comboBox2->Size = System::Drawing::Size(135, 24);
			this->comboBox2->TabIndex = 2;
			// 
			// label2
			// 
			this->label2->AutoSize = true;
			this->label2->Location = System::Drawing::Point(582, 37);
			this->label2->Margin = System::Windows::Forms::Padding(4, 0, 4, 0);
			this->label2->Name = L"label2";
			this->label2->Size = System::Drawing::Size(68, 16);
			this->label2->TabIndex = 3;
			this->label2->Text = L"COM Port:";
			// 
			// comboBox3
			// 
			this->comboBox3->AutoCompleteCustomSource->AddRange(gcnew cli::array< System::String^  >(3) { L"100", L"500", L"1000" });
			this->comboBox3->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
			this->comboBox3->FormattingEnabled = true;
			this->comboBox3->Items->AddRange(gcnew cli::array< System::Object^  >(3) { L"5", L"10", L"20" });
			this->comboBox3->Location = System::Drawing::Point(954, 34);
			this->comboBox3->Margin = System::Windows::Forms::Padding(4);
			this->comboBox3->Name = L"comboBox3";
			this->comboBox3->Size = System::Drawing::Size(95, 24);
			this->comboBox3->TabIndex = 4;
			// 
			// label3
			// 
			this->label3->AutoSize = true;
			this->label3->Location = System::Drawing::Point(811, 37);
			this->label3->Margin = System::Windows::Forms::Padding(4, 0, 4, 0);
			this->label3->Name = L"label3";
			this->label3->Size = System::Drawing::Size(135, 16);
			this->label3->TabIndex = 5;
			this->label3->Text = L"Sampling Time (sec):";
			// 
			// button1
			// 
			this->button1->Location = System::Drawing::Point(141, 66);
			this->button1->Margin = System::Windows::Forms::Padding(4);
			this->button1->Name = L"button1";
			this->button1->Size = System::Drawing::Size(164, 31);
			this->button1->TabIndex = 10;
			this->button1->Text = L"Click to Start Sampling";
			this->button1->UseVisualStyleBackColor = true;
			this->button1->Click += gcnew System::EventHandler(this, &Form1::button1_Click);
			// 
			// progBar1
			// 
			this->progBar1->ForeColor = System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(0)), static_cast<System::Int32>(static_cast<System::Byte>(192)),
				static_cast<System::Int32>(static_cast<System::Byte>(0)));
			this->progBar1->Location = System::Drawing::Point(451, 71);
			this->progBar1->Margin = System::Windows::Forms::Padding(4);
			this->progBar1->Name = L"progBar1";
			this->progBar1->Size = System::Drawing::Size(394, 22);
			this->progBar1->Step = 1;
			this->progBar1->TabIndex = 16;
			// 
			// label4
			// 
			this->label4->AutoSize = true;
			this->label4->Location = System::Drawing::Point(317, 73);
			this->label4->Margin = System::Windows::Forms::Padding(4, 0, 4, 0);
			this->label4->Name = L"label4";
			this->label4->Size = System::Drawing::Size(126, 16);
			this->label4->TabIndex = 17;
			this->label4->Text = L"Sampling Progress:";
			// 
			// menuStrip1
			// 
			this->menuStrip1->AllowMerge = false;
			this->menuStrip1->Items->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(2) {
				this->toolStripMenuItem1,
					this->aboutToolStripMenuItem
			});
			this->menuStrip1->Location = System::Drawing::Point(0, 0);
			this->menuStrip1->Name = L"menuStrip1";
			this->menuStrip1->Padding = System::Windows::Forms::Padding(8, 2, 0, 2);
			this->menuStrip1->Size = System::Drawing::Size(1069, 24);
			this->menuStrip1->TabIndex = 18;
			this->menuStrip1->Text = L"menuStrip1";
			// 
			// toolStripMenuItem1
			// 
			this->toolStripMenuItem1->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(4) {
				this->saveToolStripMenuItem,
					this->openToolStripMenuItem, this->printToolStripMenuItem, this->exitToolStripMenuItem
			});
			this->toolStripMenuItem1->Name = L"toolStripMenuItem1";
			this->toolStripMenuItem1->Size = System::Drawing::Size(37, 20);
			this->toolStripMenuItem1->Text = L"&File";
			// 
			// saveToolStripMenuItem
			// 
			this->saveToolStripMenuItem->Name = L"saveToolStripMenuItem";
			this->saveToolStripMenuItem->Size = System::Drawing::Size(103, 22);
			this->saveToolStripMenuItem->Text = L"&Save";
			this->saveToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::saveToolStripMenuItem_Click);
			// 
			// openToolStripMenuItem
			// 
			this->openToolStripMenuItem->Name = L"openToolStripMenuItem";
			this->openToolStripMenuItem->Size = System::Drawing::Size(103, 22);
			this->openToolStripMenuItem->Text = L"&Open";
			this->openToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::openToolStripMenuItem_Click);
			// 
			// printToolStripMenuItem
			// 
			this->printToolStripMenuItem->Name = L"printToolStripMenuItem";
			this->printToolStripMenuItem->Size = System::Drawing::Size(103, 22);
			this->printToolStripMenuItem->Text = L"&Print";
			this->printToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::printToolStripMenuItem_Click);
			// 
			// exitToolStripMenuItem
			// 
			this->exitToolStripMenuItem->Name = L"exitToolStripMenuItem";
			this->exitToolStripMenuItem->Size = System::Drawing::Size(103, 22);
			this->exitToolStripMenuItem->Text = L"E&xit";
			this->exitToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::exitToolStripMenuItem_Click);
			// 
			// aboutToolStripMenuItem
			// 
			this->aboutToolStripMenuItem->Name = L"aboutToolStripMenuItem";
			this->aboutToolStripMenuItem->Size = System::Drawing::Size(52, 20);
			this->aboutToolStripMenuItem->Text = L"&About";
			this->aboutToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::aboutToolStripMenuItem_Click);
			// 
			// openFileDialog1
			// 
			this->openFileDialog1->FileName = L"openFileDialog1";
			// 
			// textBox1
			// 
			this->textBox1->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
			this->textBox1->Location = System::Drawing::Point(867, 71);
			this->textBox1->Margin = System::Windows::Forms::Padding(4);
			this->textBox1->Name = L"textBox1";
			this->textBox1->Size = System::Drawing::Size(182, 22);
			this->textBox1->TabIndex = 19;
			this->textBox1->TextAlign = System::Windows::Forms::HorizontalAlignment::Center;
			// 
			// pictureBox1
			// 
			this->pictureBox1->BackColor = System::Drawing::Color::White;
			this->pictureBox1->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
			this->pictureBox1->Location = System::Drawing::Point(20, 111);
			this->pictureBox1->Name = L"pictureBox1";
			this->pictureBox1->Size = System::Drawing::Size(1028, 500);
			this->pictureBox1->TabIndex = 20;
			this->pictureBox1->TabStop = false;
			this->pictureBox1->Paint += gcnew System::Windows::Forms::PaintEventHandler(this, &Form1::pictureBox1_Paint);
			// 
			// Form1
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(8, 16);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->BackColor = System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(255)), static_cast<System::Int32>(static_cast<System::Byte>(224)),
				static_cast<System::Int32>(static_cast<System::Byte>(192)));
			this->ClientSize = System::Drawing::Size(1069, 662);
			this->Controls->Add(this->pictureBox1);
			this->Controls->Add(this->textBox1);
			this->Controls->Add(this->label4);
			this->Controls->Add(this->progBar1);
			this->Controls->Add(this->button1);
			this->Controls->Add(this->label3);
			this->Controls->Add(this->comboBox3);
			this->Controls->Add(this->label2);
			this->Controls->Add(this->comboBox2);
			this->Controls->Add(this->label1);
			this->Controls->Add(this->comboBox1);
			this->Controls->Add(this->menuStrip1);
			this->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point,
				static_cast<System::Byte>(0)));
			this->Icon = (cli::safe_cast<System::Drawing::Icon^>(resources->GetObject(L"$this.Icon")));
			this->MainMenuStrip = this->menuStrip1;
			this->Margin = System::Windows::Forms::Padding(4);
			this->Name = L"Form1";
			this->StartPosition = System::Windows::Forms::FormStartPosition::CenterScreen;
			this->Text = L"Silicon Chip ECG Sampler Mk2";
			this->Load += gcnew System::EventHandler(this, &Form1::Form1_Load);
			this->menuStrip1->ResumeLayout(false);
			this->menuStrip1->PerformLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->pictureBox1))->EndInit();
			this->ResumeLayout(false);
			this->PerformLayout();

		}
#pragma endregion
//	-----------------------------------------------------------------
// program code itself follows

	// Form1 load event
	private: System::Void Form1_Load(System::Object^  sender, System::EventArgs^  e)
		 {
		 }
//	-----------------------------------------------------------------

	// function to display the graticule
	private: void ShowGraticule(Graphics^ FormGraphic, Rectangle bounds)
		 {
			 int gratLeft = bounds.Left + 50;
			 int gratRight = bounds.Width - 18;
			 int gratTop = bounds.Top + 20;
			 int gratBottom = bounds.Height - 80;

			 // in case we are going to be replacing an existing graticule & plot
			 FormGraphic->FillRectangle(myBrush, bounds/*Rectangle(0, 0, 1028, 500)*/);	// first wipe box clean
			 if( !myBlackPen )
				myBlackPen = gcnew System::Drawing::Pen(System::Drawing::Color::Black);	// now set pen colour
			 myBlackPen->Width = 2.0F;	// and its size to 2.0 pixels, for the bolder axis lines
			 FormGraphic->DrawLine(myBlackPen, gratLeft, gratTop, gratLeft, gratBottom);  // now draw the vertical axis line
			 FormGraphic->DrawLine(myBlackPen, gratLeft, (gratTop+gratBottom)/2, gratRight, (gratTop+gratBottom) / 2);	// and the centre '0V' axis line

			 myBlackPen->Width = 1.0F;	// now reset pen width to 1 pixel for drawing lighter lines
			 FormGraphic->DrawRectangle(myBlackPen, Rectangle(gratLeft, gratTop, gratRight-gratLeft, gratBottom-gratTop)); // and draw graticule box

			 // then draw the horizontal 'signal mV' lines
			 for (int iHlineCtr = 1; iHlineCtr < 10; iHlineCtr++)
				 FormGraphic->DrawLine(myBlackPen, gratLeft, gratTop + iHlineCtr*(gratBottom-gratTop)/10, gratRight, gratTop + iHlineCtr*(gratBottom - gratTop) / 10);

			 // and the vertical 'time lines' (intSamplingTime = total time in seconds)
			 for (int iVlineCtr = 1; iVlineCtr < 20; iVlineCtr++)
				 FormGraphic->DrawLine(myBlackPen, gratLeft + iVlineCtr*(gratRight - gratLeft) / 20, gratTop, gratLeft + iVlineCtr*(gratRight - gratLeft) / 20, gratBottom);

			 // and finally, add the text legends...
			 System::Drawing::Font^drawFont = gcnew System::Drawing::Font("Arial", 10);	// set the font & size
			 System::Drawing::SolidBrush^ drawBrush = gcnew System::Drawing::SolidBrush(System::Drawing::Color::Black);	// set the brush
			 System::Drawing::StringFormat^ drawFormat = gcnew System::Drawing::StringFormat(); // set the format

			 String^ drawString = "SECONDS";	// now here's the first text string -- the time units
			 float x = (float)((gratLeft + gratRight) / 2);	// its starting X position
			 float y = (float)(gratBottom + 30);	// and Y position
			 drawFormat->Alignment = StringAlignment::Center;
			 FormGraphic->DrawString(drawString, drawFont, drawBrush, x, y, drawFormat); // so draw it

			 // now we'll draw the time legends
			 drawFont = gcnew System::Drawing::Font("Arial", 8);	// reduce the font size
			 if (intSamplingTime) {
				 int iTLegendCtr;
				 for (iTLegendCtr = 0; iTLegendCtr <= intSamplingTime; iTLegendCtr++) {
					 drawString = iTLegendCtr.ToString();
					 x = (float)(gratLeft + (gratRight - gratLeft) * iTLegendCtr / intSamplingTime);
					 y = (float)(gratBottom + 5);
					 drawFormat->Alignment = iTLegendCtr < intSamplingTime ? StringAlignment::Center : StringAlignment::Far;
					 if (iTLegendCtr == intSamplingTime)
						 x += 6; // fudge to move the text closer to edge alignment
					 FormGraphic->DrawString(drawString, drawFont, drawBrush, x, y, drawFormat); // draw them
				 }
			 }

			 // finally, show the mV legends -- starting with the 0mV centre legend
			 drawString = "0mV";
			 x = (float)(gratLeft - 5);
			 y = (float)((gratBottom+gratTop)/2);
			 drawFormat->Alignment = StringAlignment::Far;
			 drawFormat->LineAlignment = StringAlignment::Center;
			 FormGraphic->DrawString(drawString, drawFont, drawBrush, x, y, drawFormat);
			 // then the max and min legends
			 if (bSwitchPos == true)
				{	// high gain setting, so legends will be for +/-1.0mV
					drawString = "+1.0mV";
					y = (float)gratTop;
//					drawFormat->LineAlignment = StringAlignment::Near;
					FormGraphic->DrawString(drawString, drawFont, drawBrush, x, y, drawFormat);

					drawString = "-1.0mV";
					y = (float)gratBottom;
//					drawFormat->LineAlignment = StringAlignment::Far;
					FormGraphic->DrawString(drawString, drawFont, drawBrush, x, y, drawFormat);
				}
			 else
				{	// low gain setting, so legends will be for +/-2.0mV
					drawString = "+2.0mV";
					y = (float)gratTop;
//					drawFormat->LineAlignment = StringAlignment::Near;
					FormGraphic->DrawString(drawString, drawFont, drawBrush, x, y, drawFormat);

					drawString = "-2.0mV";
					y = (float)gratBottom;
//					drawFormat->LineAlignment = StringAlignment::Far;
					FormGraphic->DrawString(drawString, drawFont, drawBrush, x, y, drawFormat);
				}
		 }	// end of show graticule function

//	------------------------------------------------------------------

	private: Point getSampleXY(Rectangle bounds, int samplePos, int rawSampleValue) {
		int gratLeft = bounds.Left + 50;
		int gratRight = bounds.Width - 18;
		int gratTop = bounds.Top + 20;
		int gratBottom = bounds.Height - 80;

		int intScaledSmplValue = (rawSampleValue - 205);	// scale back sample value to start at 205
		if (intScaledSmplValue > 613)
			intScaledSmplValue = 613;	// clamp the maximum to 613
		else if (intScaledSmplValue < 0)
			intScaledSmplValue = 0;		// and the minimum to zero

		float x = (float)(gratLeft + ((double)(gratRight - gratLeft) * samplePos) / intNumofSamples);	// now get new point's X position
		float y = (float)(gratBottom - (((double)(gratBottom - gratTop) * intScaledSmplValue) / 613.0));		// and its Y position
		return Point((int)x, (int)y);
	}
	// function to plot the current sample as a line between this sample and the previous one
	private: void PlotSample(Graphics^ FormGraphic, Rectangle bounds, float lineWidth, int samplePos)
			 {
				 if (!myRedPen)
					 myRedPen = gcnew System::Drawing::Pen(System::Drawing::Color::Red);
				 myRedPen->Width = lineWidth;

				 if (samplePos == 0)
					 point1 = getSampleXY(bounds, 0, 512);
				 else
					 point1 = getSampleXY(bounds, samplePos, intSampleArray[samplePos-1]);

				 point2 = getSampleXY(bounds, samplePos+1, intSampleArray[samplePos]);

				 FormGraphic->DrawLine(myRedPen, point1, point2); // now plot the line
	}	// end of plot the current sample function

//	------------------------------------------------------------------

    // find available serial ports and make visible in comboBox2 list
	private: void findPorts(void)
		{
		// get the names of available ports
		array<Object^>^ objectArray = System::IO::Ports::SerialPort::GetPortNames();
		// add string array to combobox2 items list
		this->comboBox2->Items->AddRange( objectArray );
		}

//	-----------------------------------------------------------------

#define ENABLE_SERIAL true

	// "Start Sampling" button click event
	private: System::Void button1_Click(System::Object^  sender, System::EventArgs^  e)
		{
			if (this->samplingTimer && this->samplingTimer->Enabled) {
				// clicked cancel button
				this->samplingActive = false;
				return;
			}
			// first make sure both comboBoxes have been set up (and neither is empty)

		if (this->comboBox1->Text == String::Empty || this->comboBox2->Text == String::Empty)
			{
				MessageBox::Show("Please Select Port Settings!",
					"Port Settings Not Made", MessageBoxButtons::OK);
				return;
			}
		else
			{
#ifdef ENABLE_SERIAL
			// port settings must have been made, so we can proceed to open it
			try{
				// but first make sure port isn't already open	
				if(!this->serialPort1->IsOpen)
					{
					// set the serial port's PortName property
					this->serialPort1->PortName = this->comboBox2->Text;
					// then set the serial port's BaudRate property
					this->serialPort1->BaudRate = Int32::Parse(this->comboBox1->Text);
					// (works only if no commas in comboBox1 text string)
					// and open the serial port 
						this->serialPort1->Open();
					}
				}
				catch(UnauthorizedAccessException^){
					MessageBox::Show("Unauthorised Access",
							"Unauthorised Access", MessageBoxButtons::OK);
				}
			// next fetch ECG sampler's switch position
			this->serialPort1->WriteLine("s");	// send cmd char for sw posn and then listen
			try{
				GainSwSetting = Int16::Parse(this->serialPort1->ReadLine());
				}
				catch(TimeoutException^)
					{
						MessageBox::Show("Port not responding",
							"Timeout exception", MessageBoxButtons::OK);
					}
			// use response to set Gain switch position flag
			// (which is used in ShowGraticule & SaveFile functions)
			if(GainSwSetting == 1)
				this->bSwitchPos = true;		// true (1) = high gain
			else
				this->bSwitchPos = false;		// false (0) = low gain)

#endif
			}	// end of port opening sequence

		// continue by getting selected sampling time period from comboBox3
		if (this->comboBox3->Text == String::Empty)
		{
			MessageBox::Show("Please Select Sampling Time!",
				"Sampling time not selected", MessageBoxButtons::OK);
			return; // bail out if sampling time not selected yet
		}
		else
		this->intSamplingTime = Int16::Parse(this->comboBox3->Text);
		intNumofSamples = 242 * (this->intSamplingTime);	// work out number of samples to take
		// one sample time = 4.33ms, so there will be about 242 Sa/sec

		for (int intCurArrayCntr = 0; intCurArrayCntr < 5000; intCurArrayCntr++)
			intSampleArray[intCurArrayCntr] = 0;

		// now get the date & time, and display in textBox1
		this->textBox1->Text = DateTime::Now.ToString();

		// now go display the graticule
		if( !FormGraphic )
			FormGraphic = this->pictureBox1->CreateGraphics();	// set up for graphics drawing in pictureBox1

		ShowGraticule(FormGraphic, Rectangle(0, 0, this->pictureBox1->Bounds.Width, this->pictureBox1->Bounds.Height));
		this->button1->Text = "Click to Cancel Sampling";

		// then initialise the progress bar
		this->progBar1->Visible = true;
		this->progBar1->Minimum = 1;
		this->progBar1->Maximum = intNumofSamples;	// set progbar maximum
		this->progBar1->Step = 1; // set the progress bar step value
		this->progBar1->Value = 1;	// set progBar1's initial value

		this->saveToolStripMenuItem->Enabled = false;
		this->openToolStripMenuItem->Enabled = false;
		this->printToolStripMenuItem->Enabled = false;
		this->exitToolStripMenuItem->Enabled = false;

		this->samplingActive = true;
		this->samplingLastShownPoint = 0;
		if (!this->samplingTimer) {
			this->samplingTimer = gcnew System::Timers::Timer;
			this->samplingTimer->Interval = 100;
			this->samplingTimer->AutoReset = true;
			this->samplingTimer->Elapsed += gcnew System::Timers::ElapsedEventHandler(this, &Form1::SamplingUpdateGUI);
			this->samplingTimer->SynchronizingObject = this;
		}
//		if( !this->samplingThread )
		this->samplingThread = gcnew System::Threading::Thread(gcnew System::Threading::ThreadStart(this, &Form1::SamplingThread));
		this->samplingThread->Start();
		this->samplingTimer->Enabled = true;
	}		// end of 'Start Sampling' button click event

	private: System::Void SamplingUpdateGUI(Object^ source, System::Timers::ElapsedEventArgs^ e)
		{
		int counter = intCurArrayCntr;
		if( intCurArrayCntr > this->samplingLastShownPoint)
			{
			Rectangle bounds = Rectangle(0, 0, this->pictureBox1->Bounds.Width, this->pictureBox1->Bounds.Height);
			this->progBar1->Increment(intCurArrayCntr - this->samplingLastShownPoint);
			Point pt1 = getSampleXY(bounds, this->samplingLastShownPoint, 0);
			Point pt2 = getSampleXY(bounds, intCurArrayCntr+1, 1023);
			this->samplingLastShownPoint = intCurArrayCntr;
			this->pictureBox1->Invalidate(Rectangle(pt1.X, pt1.Y, pt2.X - pt1.X, pt2.Y - pt1.Y));
			}
		if( !this->samplingThread->IsAlive )
			{
			this->samplingTimer->Enabled = false;
			this->button1->Text = "Click to Start Sampling";
			this->progBar1->Value = 1;
			this->saveToolStripMenuItem->Enabled = true;
			this->openToolStripMenuItem->Enabled = true;
			this->printToolStripMenuItem->Enabled = true;
			this->exitToolStripMenuItem->Enabled = true;
			this->samplingActive = false;
			}
		}

	private: System::Void SamplingThread()
	{
		bool timeout = false;

		// begin collecting a new set of samples
		for (intCurArrayCntr = 0; this->samplingActive && intCurArrayCntr < intNumofSamples; intCurArrayCntr++)
		{
#ifdef ENABLE_SERIAL
			this->serialPort1->WriteLine("t");	// send cmd char & then listen for sample
#endif
			try {
#ifdef ENABLE_SERIAL
				intSampleArray[intCurArrayCntr] = Int16::Parse(this->serialPort1->ReadLine()); // save in array
#else
				System::Threading::Thread::Sleep(4); // wait 4ms
				intSampleArray[intCurArrayCntr] = 512;
#endif
			}
			catch (TimeoutException^)
			{
				timeout = true;
				break;
			}
		}	//now loop back for getting the next sample, until we've done them all

		// and finally close serialPort
#ifdef ENABLE_SERIAL
		this->serialPort1->Close();
#endif
		if( timeout )
			MessageBox::Show("Port not responding", "Timeout exception", MessageBoxButtons::OK);
	}

	//	-----------------------------------------------------------------

	// "File>Save" menu item click event
private: System::Void saveToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
	{
		SaveFileDialog^ saveFileDialog1 = gcnew SaveFileDialog;
		saveFileDialog1->CreatePrompt = true;
		saveFileDialog1->OverwritePrompt = true;
		saveFileDialog1->FileName = "MyECGSample1";
		saveFileDialog1->DefaultExt = "ecg";
		saveFileDialog1->Filter = "ECG files (*.ecg)|*.ecg|All files (*.*)|*.*";
	    DialogResult = saveFileDialog1->ShowDialog();	// show the saveFile dialog box
		if (DialogResult == System::Windows::Forms::DialogResult::OK)  //check if result = OK
			{
				String^ filename = saveFileDialog1->FileName;
				StreamWriter^ sw = gcnew StreamWriter(filename);
					sw->WriteLine(this->textBox1->Text);	// save the date & time first
					sw->WriteLine(this->comboBox1->Text);	// then the baud rate
					sw->WriteLine(this->comboBox2->Text);	// the COM port currently being used
					sw->WriteLine(intSamplingTime);			// the sampling time
					sw->WriteLine(bSwitchPos);				// the gain switch position
					sw->WriteLine(intNumofSamples);			// the number of samples
					// and finally the samples themselves
					for (int intCurArrayCntr = 0; intCurArrayCntr < intNumofSamples; intCurArrayCntr++)
						sw->WriteLine(intSampleArray[intCurArrayCntr]);
					sw->Close();	// before closing the file
			}
	}

//	-----------------------------------------------------------------

		 // "File>Open" menu item click event
	private: System::Void openToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
	{
		OpenFileDialog^ openFileDialog1 = gcnew OpenFileDialog;
		//	openFileDialog1->CreatePrompt = true;
		//	openFileDialog1->OverwritePrompt = true;
		openFileDialog1->FileName = "MyECGSample1";
		openFileDialog1->DefaultExt = "ecg";
		openFileDialog1->Filter = "ECG files (*.ecg)|*.ecg|All files (*.*)|*.*";
		DialogResult = openFileDialog1->ShowDialog();	// show the saveFile dialog box
		if (DialogResult == System::Windows::Forms::DialogResult::OK)  //check if result = OK
		{
			String^ filename = openFileDialog1->FileName;
			StreamReader^ sr = gcnew StreamReader(filename);
			this->textBox1->Text = sr->ReadLine();	// get the file sampling date &time
			this->comboBox1->Text = sr->ReadLine();	// then the baud rate
			this->comboBox2->Text = sr->ReadLine();	// the COM port used
			intSamplingTime = Int16::Parse(sr->ReadLine());	// then the sampling time
			bSwitchPos = Boolean::Parse(sr->ReadLine());	// the gain switch position
			intNumofSamples = Int16::Parse(sr->ReadLine()); // the number of samples
			// and finally the samples themselves
			for (int intCurArrayCntr = 0; intCurArrayCntr < intNumofSamples; intCurArrayCntr++)
				intSampleArray[intCurArrayCntr] = Int16::Parse(sr->ReadLine());
			sr->Close();	// before closing the stream

			// now replace the text in comboBox 3
			this->comboBox3->Text = intSamplingTime.ToString();
			this->pictureBox1->Invalidate();
		}
	}	// end of file>open menu item click event

//	-----------------------------------------------------------------

private: System::Void drawPrintoutText(Graphics^ pGraphics, Rectangle bounds)
	{
	System::Drawing::Font^titleFont = gcnew System::Drawing::Font("Arial Bold", 14);	// set the font & size
	System::Drawing::Font^textFont = gcnew System::Drawing::Font("Arial", 10);	// set the font & size
	System::Drawing::SolidBrush^ drawBrush = gcnew System::Drawing::SolidBrush(System::Drawing::Color::Black);	// set the brush
	System::Drawing::StringFormat^ drawFormat = gcnew System::Drawing::StringFormat(); // set the format

	String^ drawString = "Silicon Chip ECG Plotter, " + this->textBox1->Text;
	float x = (float)(bounds.Left + bounds.Right) / 2.0f;
	float y = (float)bounds.Top + 10;
	drawFormat->Alignment = StringAlignment::Center;
	pGraphics->DrawString(drawString, titleFont, drawBrush, x, y, drawFormat); // so draw it

	drawString = "Baud Rate: " + this->comboBox1->Text + ",    COM Port: " + this->comboBox2->Text + ",    Sampling Time: " + intSamplingTime + " seconds";
	x = (float)(bounds.Left + bounds.Right) / 2.0f;
	y = (float)bounds.Top + 40;
	drawFormat->Alignment = StringAlignment::Center;
	pGraphics->DrawString(drawString, textFont, drawBrush, x, y, drawFormat); // so draw it
	}

	// "File>Print" menu item click event
private: System::Void printToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
	{
		printDocument1->PrintPage += gcnew System::Drawing::Printing::PrintPageEventHandler(this, &JimsECGSamplerMk10::Form1::PrintDocument1_PrintPage);
		// now set up the print dialog box
		printDialog1->AllowSomePages = true;
		printDialog1->ShowHelp = true;
		printDialog1->AllowSelection = true;
		printDialog1->AllowCurrentPage = true;
		printDialog1->Document = printDocument1;
		printDialog1->PrinterSettings->DefaultPageSettings->Landscape = true;

		// show the print dialog box & allow user to select,etc
		System::Windows::Forms::DialogResult result = printDialog1->ShowDialog();

		// if the result from the print dialog box is OK, print the document
		if (result == System::Windows::Forms::DialogResult::OK)
			printDocument1->Print();		// finally works
	}

		// function to create image for printing
private: System::Void PrintDocument1_PrintPage(System::Object ^sender, System::Drawing::Printing::PrintPageEventArgs ^e)
			{
			 Rectangle bounds = e->PageBounds;

			 // create some blank space in the margins
			 bounds.Width -= 40;
			 bounds.Height -= 40;
			 bounds.X += 20;
			 bounds.Y += 20;

			 // reserve some space for a title and extra info at the top
			 Rectangle textBounds = bounds;
			 textBounds.Height = 60;
			 bounds.Y = bounds.Y + 60;
			 bounds.Height = bounds.Height - 60;

			 // now draw that text
			 drawPrintoutText(e->Graphics, textBounds);

			 // ensure graph isn't too tall
			 int max_bottom = bounds.Top + bounds.Width * 9 / 16;
			 if (bounds.Bottom > max_bottom)
				 bounds.Height = max_bottom - bounds.Top;
			 RedrawGraticuleandPlot(e->Graphics, bounds, 1.0f);
			}

//	-----------------------------------------------------------------

		 // function to redraw graticule and plot
	private: void RedrawGraticuleandPlot( Graphics^ pGraphics, Rectangle bounds, float lineWidth )
	{
		ShowGraticule(pGraphics, bounds);
		int numSamples = this->samplingTimer && this->samplingTimer->Enabled ? this->intCurArrayCntr : this->intNumofSamples;
		for (int intCurArrayCntr = 0; intCurArrayCntr < numSamples; intCurArrayCntr++)
			PlotSample(pGraphics, bounds, lineWidth, intCurArrayCntr);			// then go plot it
	}
//	-----------------------------------------------------------------

		// "File>Exit" menu item click event
private: System::Void exitToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
	{
		System::Windows::Forms::DialogResult buttonClicked;
		buttonClicked = MessageBox::Show("Sure you want to Exit?", "Verify Exit", MessageBoxButtons::YesNo);
		if (buttonClicked == System::Windows::Forms::DialogResult::Yes)
			delete myRedPen;		// now save system resources before leaving
			delete myBlackPen;		// now save system resources before leaving
			delete FormGraphic;
			delete myBrush;
			this->Close();
	}

//	-----------------------------------------------------------------

		 // "About" menu item click event
private: System::Void aboutToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
	{
		String^message = "Silicon Chip ECG Sampler App V2.0" + "\nWritten by Jim Rowe and" + "\nNicholas Vinen, August 2015";
		MessageBox::Show(message, "Silicon Chip ECG Sampler", MessageBoxButtons::OK);
	}

private: System::Void pictureBox1_Paint(System::Object^  sender, System::Windows::Forms::PaintEventArgs^  e)
	{
		RedrawGraticuleandPlot(e->Graphics, Rectangle(0, 0, this->pictureBox1->Bounds.Width, this->pictureBox1->Bounds.Height), 2.0f);
	}
	protected: virtual void OnResize(EventArgs^ e) override
	{
		Rectangle bounds = this->Bounds;
		this->pictureBox1->Size = System::Drawing::Size(Bounds.Width - 57, Bounds.Height - 200);
		this->pictureBox1->Invalidate();
	}
};		// end of public ref class Form1 : public System::Windows::Forms::Form
}		// end of JimsECGSamplerMk10 namespace

