/* sketch for ECG Sampler's firmware
   written by Jim Rowe (Silicon Chip)
   Final version, updated 24/08/2015 at 11.40am */

void setup()
{
  pinMode(8, OUTPUT); // declares D8 as a digital output pin
  pinMode(7, INPUT);  // declares D7 as a digital input pin

  Serial.begin(115200); // starts up serial comms to PC at 115200 baud
}

void loop()
{
  int analogPin = 0;  // declares AD0 as the ADC input pin
  int S1bPin = 7;     // gives D7 the label 'S1bPin'  
  int led2Pin = 8;    // gives D8 the label 'led2Pin'
  int incomingByte = 0;  // for incoming serial data (command) from PC
  int invalT = 0x74;  // 0x (zero+x) is prefix for hex values
  int invalS = 0x73;
  
  if (Serial.available() > 0)
  {
    incomingByte = Serial.read();
    
    if (incomingByte == invalT)
    {
      digitalWrite(led2Pin, HIGH);          // turn on Led2
      int reading = analogRead(analogPin);  // read the analog volts
      Serial.println(reading);              // and send them to the PC
      digitalWrite(led2Pin, LOW);           // then turn Led2 off again
    }
    
    if (incomingByte == invalS)
    {
      int sw1bReading = digitalRead(S1bPin);
      Serial.println(sw1bReading);
    }
     }     
  }

