//Tim Blythman
#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "portbits.h"

//pinout:
//SDA   RA4
//SCL   RA5
//RESW  RC5
//REA   RC4
//REB   RC3
//CS    RA2
//MOSI  RC0
//MISO  RC1
//SCK   RC2

#define ADC_OS (16)
#define RE_A c4
#define RE_B c3
#define SW1 c5
#define SW_DIVIDER (4)
#define SW_LIMIT (20)
#define SW_FLAG_VALUE (0x33)

extern char reState,reStateOld;
extern volatile signed char reAccum;    //grab result from here
extern const signed char reRes[];
extern char buttonState, buttonPress;

void ioinit(void);
int getADC(unsigned char c); //get result from c
void reInit(void);           //rotary encoder
signed char getRE(void);     //get accum
void buttonInit(void);       //setup
char buttonDown(void);       //report if press-down has happened

#endif	/* IO_H */

