'        STEPPING MAINS TIMER (steptimer_20m2.bas)

'Notes to customize step times.:

'You may alter the various step times listed in "set_up"
'w3 to w6 are the "run" and "test" step times in seconds.
'The odd and even steps may be set the same or different. 
'Changing step times effects the total lamp cycle time
'Make changes before loading the program into the micro.


set_up:
w3 = 1800' odd steps - run (30min)
w4 = 1800' even steps - run (30min) 
w5 = 3'    odd steps - test (3sec)
w6 = 3'    even steps - test (3sec)
b1 = 120'  dark trip point (max 255)
b2 = 140'  light trip point (max 255)
let dirsB=%00000000:let pinsB=%00000000
let dirsC=%10000000:let pinsC=%00000000
pullup %0111111111111110
goto dark_test


dark_test:
if pinB.1 = 0 then: goto step_1: endif 
readadc B.0,b4
if b4 < b1 then: inc b0 : else b0 = 0: endif
if b0 > 10 then: goto step_1: endif
pause 100
goto dark_test

step_1:
if pinB.7 = 0 then: high C.7: else low C.7: endif
gosub odd_step
goto step_2

step_2:
if pinB.6 = 0 then: high C.7: else low C.7: endif
gosub even_step
goto step_3

step_3:
if pinB.5 = 0 then: high C.7: else low C.7: endif
gosub odd_step
goto step_4

step_4:
if pinB.4 = 0 then: high C.7: else low C.7: endif
gosub even_step
goto step_5

step_5:
if pinB.3 = 0 then: high C.7: else low C.7: endif
gosub odd_step
goto step_6

step_6:
if pinB.2 = 0 then: high C.7: else low C.7: endif
gosub even_step
goto step_7

step_7:
if pinC.0 = 0 then: high C.7: else low C.7: endif
gosub odd_step
goto step_8

step_8:
if pinC.1 = 0 then: high C.7: else low C.7: endif
gosub even_step
goto step_9

step_9:
if pinC.2 = 0 then: high C.7: else low C.7: endif
gosub odd_step
goto step_10

step_10:
if pinC.3 = 0 then: high C.7: else low C.7: endif
gosub even_step
goto step_11

step_11:
if pinC.4 = 0 then: high C.7: else low C.7: endif
gosub odd_step
goto step_12

step_12:
if pinC.5 = 0 then: high C.7: else low C.7: endif
gosub even_step
goto light_test

light_test:
if pinB.1 = 0 then: goto dark_test: endif
readadc B.0,b4
if b4 > b2 then: inc b0 : else b0 = 0: endif
if b0 > 10 then: goto dark_test: endif
pause 100
goto light_test


odd_step:
b0 = 0
let time = 0
if pinC.6 = 0 then: w8 = w5 else: w8 = w3: endif
if pinB.1 = 1 then: goto time_loop: endif
pause 100
goto odd_step


even_step:
b0 = 0
let time = 0
if pinC.6 = 0 then: w8 = w6 else: w8 = w4: endif 
if pinB.1 = 1 then: goto time_loop: endif
pause 100
goto even_step


time_loop:
if pinB.1 = 0 then: goto jump_out: endif
if time > w8 then: return: endif
pause 100
goto time_loop


jump_out:
low C.7
b0 = 0
if pinB.1 = 1 then: goto light_test: endif
pause 100
goto jump_out   
              



'Definition of Varibles

'b0 temporary variable.
'b1 dark trip point 
'b2 light trip point
'b4 analog LDR input.
'w3 odd steps - run .
'w4 even steps - run 
'w5 odd steps - test .
'w6 even steps - test
'w8 remaining step time   