//put all pin defines and globals here to be included in respective IO files

#ifndef GLOBAL_PINS_H
#define	GLOBAL_PINS_H

#include <xc.h> // include processor files - each processor file is guarded.  

#define _XTAL_FREQ (32000000UL)
#define delay __delay_ms

//OLED
#define I2C_SDA c2
#define I2C_SCL c1
#define OLEDPWR c0
//IO
#define S1 b6
#define S2 b5
#define S3 b4
#define REGEN a5
//analog
#define AN_A b7 //VBUS with 15:1 divider
#define AN_C c5 //A5_1
#define AN_D c3 //B5_1
#define AN_E c6 //A5_2
#define AN_F c4 //B5_2
#define VREF a2 
#define AN_I a4 //current
#define AN_J c7 //amplified current
//RA0/RA1 PGD/PGC only
#define PGD_PIN a0
#define PGC_PIN a1

#define PWM1S1PIN a0

#endif	/* GLOBAL_PINS_H */

