#ifndef UTIL_H
#define	UTIL_H

#include "io.h"
#include "oled.h"

#define DOWN_BUTTON 1
#define UP_BUTTON 2
#define MODE_BUTTON 3

//OSCCON presets
#define CLOCK_LFINTOSC 0x50
#define CLOCK_HFINTOSC 0x60
//OSCFRQ presets
#define HFOSC_FRQ_32 5
#define HFOSC_FRQ_16 4
//1:256 doze with ROI
#define CPU_DOZE_ROI (0x67)
//normal
#define CPU_DOZE_OFF (0x00)

typedef enum {
    SCREEN_MAIN=0,
    SCREEN_STATUS_SLEEP,
    SCREEN_CC_DETECT,
    SCREEN_TRIM_OFFSET,
    SCREEN_DUMMY
} screen_t;

typedef enum {
    SETTINGS_BRIGHTNESS=0,     
    SETTINGS_UNITS,
    SETTINGS_A_FACTOR,
    SETTINGS_I_FACTOR,
    SETTINGS_J_FACTOR,
    SETTINGS_I_OFFSET,
    SETTINGS_J_OFFSET,
    SETTINGS_TIMEOUT,
    SETTINGS_SAVE_RESTORE,
    SETTINGS_DUMMY
} settings_t;

typedef enum {
    UNITS_JOULES=1,
    UNITS_WATTHOURS,
    UNITS_DUMMY
} energyUnits_t;

typedef struct {
    unsigned int anAfactor;
    unsigned int anIfactor;
    unsigned int anJfactor;
    int anIoffset;
    int anJoffset;
    energyUnits_t units;
    unsigned char brightness;
    unsigned int timeOut;
} saveData_t;

extern saveData_t cur;  //live settings
extern __eeprom saveData_t sav;  //save settings
const saveData_t backup;    //backup for restore
extern screen_t screen;
extern settings_t settings;
extern char ccTesting;
extern unsigned long tCount;
extern char toggleFlag;
extern char settingsFlag;
extern char settingsButton;
extern unsigned int countDown;
#define S_TITLE_LEN (16)
extern const char settingsTitle[][S_TITLE_LEN];

//full-scale in 10mV
#define AN_A_FACTOR (6554)
#define AN_A_FACTOR_MIN (0.9*AN_A_FACTOR)
//#define AN_A_FACTOR_MAX (1.1*AN_A_FACTOR)
#define AN_A_FACTOR_MAX (65000)
#define AN_A_FACTOR_INC (1)
//#define AN_A_FACTOR_INC (AN_A_FACTOR/1000)
//shunt is 15m#, INA282 gain is 50 => 1A => 750mV; (1/0.75)*4096, x2 is scaling due to differential mode, result in mA
#define AN_I_FACTOR (5461*2)
#define AN_I_FACTOR_MIN (0.9*AN_I_FACTOR)
#define AN_I_FACTOR_MAX (1.1*AN_I_FACTOR)
#define AN_I_FACTOR_INC (AN_I_FACTOR/1000)
//gain is 101,but measured in 10uA so similar factor
#define AN_J_FACTOR (5515*2)
#define AN_J_FACTOR_MIN (0.9*AN_J_FACTOR)
#define AN_J_FACTOR_MAX (1.1*AN_J_FACTOR)
#define AN_J_FACTOR_INC (AN_J_FACTOR/1000)
//inamp offset
#define ANI_OFFSET (0)
#define ANJ_OFFSET (0)
#define OFFSET_MIN (-10000)
#define OFFSET_MAX (10000)
//checkDAC limits/parameters
#define DAC_LOWER (16)
#define DAC_UPPER (240)
#define DEFAULT_BRIGHTNESS (130)
#define BRIGHTNESS_INC (5)
#define BRIGHTNESS_MIN (30)
#define BRIGHTNESS_MAX (250)
#define TIMEOUT_STEP (10)
#define TIMEOUT_MAX (600)
#define VBUS_OFF (1000)

//CC condition thresholds
typedef enum {
    CC_VRA=0,
    CC_USB,
    CC_15,
    CC_30,
    CC_OPEN,
    CC_DUMMY
} CCstate_t;

#define CC_DIR_THRESHOLD (80)
#define CC_STATE_COUNT (4)
extern CCstate_t CC1state;
extern CCstate_t CC2state;
extern CCstate_t CCstate;
extern char CCactive;
extern char CCtestValid;
extern int icc;
extern const unsigned int CCsinkthresh[CC_OPEN];
extern const char CCsinkState[CC_DUMMY][S_TITLE_LEN];

//#define SAVE_DEFAULTS {AN_A_FACTOR,AN_I_FACTOR,AN_J_FACTOR,ANI_OFFSET,ANJ_OFFSET,UNITS_JOULES,DEFAULT_BRIGHTNESS}
#define SAVE_DEFAULTS {\
.anAfactor=AN_A_FACTOR,\
.anIfactor=AN_I_FACTOR,\
.anJfactor=AN_J_FACTOR,\
.anIoffset=ANI_OFFSET,\
.anJoffset=ANJ_OFFSET,\
.units=UNITS_JOULES,\
.brightness=DEFAULT_BRIGHTNESS,\
.timeOut=0\
}

#define DELAY_INTERVAL (10)
#define CC_TEST_DELAY (100)
//this includes diode, reg in idle mode and 10 Ohm resistor, empirical
#define BATTERY_SOURCE_VF (550)

unsigned int adjust16bitU(unsigned int a, unsigned int b);  //scale down to b as full scale
int adjust16bitS(int a, unsigned int b);           //scale down to b as full scale
void checkDAC(void);    //check status and adjust DAC as needed
void waitOrButton(int t);  //wait for t ms unless button pressed
void sleepAndWakeUp(void);  //put to sleep and wait for button
unsigned long getT0inc(void);   //return count since last call
void startUp(void); //use at boot and wakeup
void shutDown(void); //for sleep
void prepareInt(int n,char dp);   //wrapper for signed operations
CCstate_t getCCstate(unsigned int v);    //return index based on thresholds
void setCCpulldowns(char cc);   //internal Rd pulldowns
void serviceTimer(unsigned long n); //receive T0 counts and process

#endif	/* UTIL_H */

