#include "util.h"

saveData_t cur=SAVE_DEFAULTS;
__eeprom saveData_t sav=SAVE_DEFAULTS;
const saveData_t backup=SAVE_DEFAULTS;
screen_t screen=0;
settings_t settings=0;
char ccTesting=0;
unsigned long tCount=0;
char toggleFlag=0;
char settingsFlag=0;
char settingsButton=0;
unsigned int countDown=0;

const char settingsTitle[][S_TITLE_LEN]={
    "OLED BRIGHTNESS",
    "ENERGY UNITS   ",
    "V FACTOR TRIM  ",
    "HI CURRENT TRIM",
    "LO CURRENT TRIM",
    "HI CURR. OFFSET",
    "LO CURR. OFFSET",
    "DISPLAY TIMEOUT",
    "SAVE & RESTORE ",
    "???            ",
};

CCstate_t CC1state=0;
CCstate_t CC2state=0;
CCstate_t CCstate=0;
char CCactive=0;
char CCtestValid=0;
int icc=0;
const unsigned int CCsinkthresh[CC_STATE_COUNT]={200,660,1230,2600};
const char CCsinkState[CC_STATE_COUNT+1][S_TITLE_LEN]={ //thresholds listed above
    "NO CONNECTION  ",  //below [0]
    "USB 0.5A SOURCE",  //[0]-[1]
    "USB 1.5A SOURCE",  //[1]-[2]
    "USB 3A SOURCE  ",  //[2]-[3]
    "No sink        ",  //above [3]
};

unsigned int adjust16bitU(unsigned int a, unsigned int b){  //scale down to b as full scale
    unsigned long t;
    t=((unsigned long)a) * ((unsigned long)b);
    t=t/(65536UL);
    return (unsigned int)t;
}

int adjust16bitS(int a, unsigned int b){  //scale down to b as full scale
    long t;
    t=((long)a) * ((long)b);
    t=t/(65536L);
    return (int)t;
}

void checkDAC(void){    //check status and adjust DAC as needed
    unsigned char oldDAC=DAC1DATL;
    unsigned char newDAC=DAC1DATL;
    loadADCC(); //load latest
    if(external.rawJ>ADC_VALID_UPPER){newDAC=oldDAC-1;}
    if(external.rawJ<ADC_VALID_LOWER){newDAC=oldDAC+1;}
    if(external.rawI>ADC_VALID_UPPER){newDAC=DAC_LOWER;} //if hi range is at limit, then swing DAC across range
    if(external.rawI<ADC_VALID_LOWER){newDAC=DAC_UPPER;}
    if(newDAC<DAC_LOWER){newDAC=DAC_LOWER;}
    if(newDAC>DAC_UPPER){newDAC=DAC_UPPER;}
    DAC1DATL=newDAC;    
}

void waitOrButton(int t){  //wait for t ms unless button pressed
    while(t>0){
        delay(DELAY_INTERVAL);
        t=t-DELAY_INTERVAL;
        if(anyButton()){return;}    //escape
    }    
}

void sleepAndWakeUp(void){  //put to sleep and wait for button        
    IOCAF = 0;
    IOCBF = 0;
    IOCCF = 0; //ensure no flags set whatsoever
    iocxpbits.S1 = 1;
    iocxpbits.S2 = 1;
    iocxpbits.S3 = 1;
    iocxnbits.S1 = 1;
    iocxnbits.S2 = 1;
    iocxnbits.S3 = 1;
    CPUDOZE=CPU_DOZE_OFF;   //idle, doze off
    PIE0bits.IOCIE=1;
    SLEEP();
    NOP();
    PIE0bits.IOCIE=0;
    GIE=1;
}

void startUp(void){ //use at boot and wakeup
                //  7      6      5      4      3      2       1        0
    PMD0=0x06;  //TMR0MD CLKRMD IOCMD  ACTMD   SYSCMD  SCANMD  CRCMD    NVMMD       //need T0, IOC, NVM for eeprom
    PMD1=0x7F;  //PWM1MD CCP2MD CCP1MD ------  TMR4MD  TMR2MD  TMR3MD   TMR1MD      //need PWM1
    PMD2=0xFF;  //CLC3MD CLC2MD CLC1MD CWG1MD  NCO1MD  ------  ------   PWM2MD      //all off
    PMD3=0xDF;  //CM2MD  CM1MD  FVRMD  MSSP2MD MSSP1MD UART2MD UART1MD  CLC4MD      //FVR
    PMD4=0xF8;  //------ ------ ------ ZCDMD   ------  DAC2MD  DAC1MD   ADCMD       //both DACs and ADC
    ioInit();
    deInitFVR();
    initFVR_DAC(FVR_4096);
    initFVR_ADC(FVR_4096);
    DAC1CON=DAC_RA2|DAC_REF_FVR_GND;
    DAC1DATL=128;   //~2V at boot
    DAC2CON=DAC_ON|DAC_REF_VDD_GND;
    DAC2DATL=32;    //1/8 of supply
    initADCC();
    I2Cinit();
    OLEDinit();
    OLEDflip(OLED_CONNECTOR_AT_BOTTOM);
    OLEDclear(0);
    OLEDbrightness(cur.brightness);
    t0init();    
    //pwmInit();
    GIE=1;    
    startADCC();
    latbits.REGEN=1;
    delay(300);    
    countDown=cur.timeOut;
}

void shutDown(void){ //for sleep    
    accumE=0;           //stop accumulating
    screen=SCREEN_MAIN; //back to useful screen
    stopADCC();         //stop sampling
    deInitADCC();       //shut down
    deInitFVR();
    DAC1CON=DAC_OFF;
    DAC2CON=DAC_OFF;
    latbits.REGEN=0;    //boost off
    //pwmDeInit();
    T0CON0bits.EN=0;
    I2Cdeinit(); //no need to deinit OLED
    GIE=0;
                //  7      6      5      4      3      2       1        0
    PMD0=0x5F;  //TMR0MD CLKRMD IOCMD  ACTMD   SYSCMD  SCANMD  CRCMD    NVMMD       //need IOC, TMR0 stays on to retain state
    PMD1=0xFF;  //PWM1MD CCP2MD CCP1MD ------  TMR4MD  TMR2MD  TMR3MD   TMR1MD      //all off
    PMD2=0xFF;  //CLC3MD CLC2MD CLC1MD CWG1MD  NCO1MD  ------  ------   PWM2MD      //all off
    PMD3=0xFF;  //CM2MD  CM1MD  FVRMD  MSSP2MD MSSP1MD UART2MD UART1MD  CLC4MD      //all off
    PMD4=0xFF;  //------ ------ ------ ZCDMD   ------  DAC2MD  DAC1MD   ADCMD       //all off
}

unsigned long getT0inc(void){   //return count since last call
    static unsigned long last=0;
    unsigned long n=getT0long();
    unsigned long ret=n-last;
    last=n;
    serviceTimer(ret);      //general purpose timer
    return ret;
}

void prepareInt(int n,char dp){   //wrapper for signed
    OLEDscanshort((unsigned int)(abs(n)));
    OLEDlzb(dp);
    OLEDaddsign(n);
}

CCstate_t getCCstate(unsigned int v){    //return index based on thresholds
    CCstate_t i;
    for(i=0;i<CC_STATE_COUNT;i++){
        if(v<CCsinkthresh[i]){return i;}
    }
    return CC_OPEN;
}

void setCCpulldowns(char cc){
    if(cc==1){//use C/D
        latbits.AN_C=0;
        latbits.AN_D=0;
        anselbits.AN_C=0;
        trisbits.AN_C=0;                                
        anselbits.AN_D=0;
        trisbits.AN_D=0;                                
        anselbits.AN_E=1;
        trisbits.AN_E=1;
        anselbits.AN_F=1;
        trisbits.AN_F=1;             
    }else if(cc==2){ //use E/F
        latbits.AN_E=0;
        latbits.AN_F=0;
        anselbits.AN_E=0;
        trisbits.AN_E=0;                                
        anselbits.AN_F=0;
        trisbits.AN_F=0;                                
        anselbits.AN_C=1;
        trisbits.AN_C=1;
        anselbits.AN_D=1;
        trisbits.AN_D=1;                     
    }else{  //off
        anselbits.AN_C=1;
        trisbits.AN_C=1;
        anselbits.AN_D=1;
        trisbits.AN_D=1;
        anselbits.AN_E=1;
        trisbits.AN_E=1;
        anselbits.AN_F=1;
        trisbits.AN_F=1;             
    }
}

void serviceTimer(unsigned long n){ //receive T0 counts and process
    static unsigned long t0count=0;
    t0count=t0count+n;
    while(t0count>ADC_T0_HZ){
        t0count=t0count-ADC_T0_HZ;
        if(countDown){countDown--;}
    }
}