/*
 * File:   main.c
 * Author: Tim Blythman
 */

//see globalPins.h for _XTAL_FREQ and pins

#include "config.h"
#include "globalPins.h"
#include <xc.h>
#include "portbits.h"
#include "io.h"
#include "oled.h"
#include "font.h"
#include "util.h"

void main(void) {
    unsigned int i;
    cur=sav;
    TMR0L=0;
    TMR0H=0;                //reset on boot only
    startUp();
    while(1){
        toggleFlag++;
        checkDAC(); //allow to settle after adjust
        waitOrButton(300);
        loadADCC(); //update for display/use
        if(accumE){         //getT0inc() does getT0long(), so rollovers are checked 
            tCount=tCount+getT0inc();   
        }else{
            getT0inc();     //discard increment
        }        
        //enforce CC as inputs unless in CC mode
        if(ccTesting && ((screen!=SCREEN_CC_DETECT) || (settingsFlag!=0))){
            setCCpulldowns(0);
            ccTesting=0;
        }
        if(settingsFlag || (screen!=SCREEN_MAIN)){   //only time on main screen
            countDown=cur.timeOut;
        }else{
            if((countDown==0)&&(cur.timeOut)){  //don't shutdown when off
                OLEDclear(0);//refresh            
                OLEDcol=28;
                OLEDpage=2;
                OLEDchararray("SLEEPING",arial);
                delay(1000);
                shutDown();
                sleepAndWakeUp();
                startUp();                
            }
        }
        if(settingsFlag){            
            OLEDcol=0;
            OLEDpage=0;
            OLEDchararray("SETUP:",smallFont);
            OLEDchararray(settingsTitle[settings],smallFont);
            OLEDcol=0;
            OLEDpage=2;
            settingsButton=buttonPressAndHold();
            switch(settings){
                case SETTINGS_BRIGHTNESS:
                    OLEDchar(ICON_DOWN,iconSmall);
                    OLEDchar(ICON_UP,iconSmall);
                    OLEDchararray("TO ADJUST",smallFont);
                    OLEDcol=0;
                    OLEDpage=4;
                    OLEDscanshort(cur.brightness);
                    OLEDlzb(8);
                    OLEDchararray("OLED:",arial);                    
                    OLEDchararray(OLEDbuf+7,arial);                    
                    if(settingsButton==DOWN_BUTTON){
                        if(cur.brightness>BRIGHTNESS_MIN){
                            cur.brightness=cur.brightness-BRIGHTNESS_INC;
                            OLEDbrightness(cur.brightness);
                        }
                    }
                    if(settingsButton==UP_BUTTON){
                        if(cur.brightness<BRIGHTNESS_MAX){
                            cur.brightness=cur.brightness+BRIGHTNESS_INC;
                            OLEDbrightness(cur.brightness);
                        }
                    }
                    break;
                case SETTINGS_UNITS:
                    if(cur.units==UNITS_JOULES){
                        OLEDchar(ICON_DOWN,iconSmall);
                        OLEDchararray("SET TO WATTHOURS",smallFont);
                        OLEDcol=0;
                        OLEDpage=4;
                        OLEDchararray("JOULES   ",arial);                        
                        if(settingsButton==DOWN_BUTTON){cur.units=UNITS_WATTHOURS;}
                    }else{
                        OLEDchar(ICON_UP,iconSmall);
                        OLEDchararray("SET TO JOULES   ",smallFont);
                        OLEDcol=0;
                        OLEDpage=4;
                        OLEDchararray("WATTHOURS",arial);                                                
                        if(settingsButton==UP_BUTTON){cur.units=UNITS_JOULES;}
                    }
                    break;
                case SETTINGS_A_FACTOR:
                    OLEDchar(ICON_DOWN,iconSmall);
                    OLEDchar(ICON_UP,iconSmall);
                    OLEDchararray("TO TRIM:",smallFont);
                    OLEDscanshort(cur.anAfactor);
                    OLEDlzb(8);
                    OLEDchararray(OLEDbuf+4,smallFont);                    
                    OLEDcol=31;
                    OLEDpage=4;
                    OLEDscanlong(external.busV);
                    OLEDlzb(5);
                    OLEDchar(OLEDbuf[5],arial);
                    OLEDchar(OLEDbuf[6],arial);
                    OLEDchar('.',narrow);
                    OLEDchar(OLEDbuf[7],arial);
                    OLEDchar(OLEDbuf[8],arial);
                    OLEDchar(OLEDbuf[9],arial);
                    OLEDchar('V',arial);                    
                    if(settingsButton==DOWN_BUTTON){if(cur.anAfactor>AN_A_FACTOR_MIN){cur.anAfactor=cur.anAfactor-AN_A_FACTOR_INC;}}
                    if(settingsButton==UP_BUTTON){if(cur.anAfactor<AN_A_FACTOR_MAX){cur.anAfactor=cur.anAfactor+AN_A_FACTOR_INC;}}
                    break;
                case SETTINGS_I_FACTOR:
                    OLEDchar(ICON_DOWN,iconSmall);
                    OLEDchar(ICON_UP,iconSmall);
                    OLEDchararray("TO TRIM:",smallFont);
                    OLEDscanshort(cur.anIfactor);
                    OLEDlzb(8);
                    OLEDchararray(OLEDbuf+4,smallFont);                    
                    OLEDcol=31;
                    OLEDpage=4;
                    if(external.iValid){
                        prepareInt(external.busIhi,5);
                        OLEDchar(OLEDbuf[5],arial);
                        OLEDchar(OLEDbuf[6],arial);
                        OLEDchar('.',narrow);
                        OLEDchar(OLEDbuf[7],arial);                    
                        OLEDchar(OLEDbuf[8],arial);                    
                        OLEDchar(OLEDbuf[9],arial);                    
                        OLEDchar('A',arial);
                        OLEDchar(' ',arial);                                            
                    }else{
                        OLEDchararray("INVALID",arial);                                            
                    }
                    if(settingsButton==DOWN_BUTTON){if(cur.anIfactor>AN_I_FACTOR_MIN){cur.anIfactor=cur.anIfactor-AN_I_FACTOR_INC;}}
                    if(settingsButton==UP_BUTTON){if(cur.anIfactor<AN_I_FACTOR_MAX){cur.anIfactor=cur.anIfactor+AN_I_FACTOR_INC;}}
                    break;
                case SETTINGS_J_FACTOR:
                    OLEDchar(ICON_DOWN,iconSmall);
                    OLEDchar(ICON_UP,iconSmall);
                    OLEDchararray("TO TRIM:",smallFont);
                    OLEDscanshort(cur.anJfactor);
                    OLEDlzb(8);
                    OLEDchararray(OLEDbuf+4,smallFont);                    
                    OLEDcol=31;
                    OLEDpage=4;
                    if(external.iValid==IVALID_LO){
                        prepareInt(external.busIlo,6);
                        OLEDchar(OLEDbuf[6],arial);
                        OLEDchar(OLEDbuf[7],arial);
                        OLEDchar('.',narrow);
                        OLEDchar(OLEDbuf[8],arial);                    
                        OLEDchar(OLEDbuf[9],arial);                    
                        OLEDchar('m',arial);
                        OLEDchar('A',arial);                                            
                        OLEDchar(' ',arial);                                            
                    }else{
                        OLEDchararray("INVALID",arial);                                            
                    }
                    if(settingsButton==DOWN_BUTTON){if(cur.anJfactor>AN_J_FACTOR_MIN){cur.anJfactor=cur.anJfactor-AN_J_FACTOR_INC;}}
                    if(settingsButton==UP_BUTTON){if(cur.anJfactor<AN_J_FACTOR_MAX){cur.anJfactor=cur.anJfactor+AN_J_FACTOR_INC;}}
                    break;
                case SETTINGS_I_OFFSET:
                    OLEDchar(ICON_DOWN,iconSmall);
                    OLEDchar(ICON_UP,iconSmall);
                    OLEDchararray("TO TRIM:",smallFont);
                    prepareInt(cur.anIoffset,8);
                    OLEDchararray(OLEDbuf+4,smallFont);                    
                    OLEDcol=31;
                    OLEDpage=4;
                    if(external.iValid){
                        prepareInt(external.busIhi,5);
                        OLEDchar(OLEDbuf[5],arial);
                        OLEDchar(OLEDbuf[6],arial);
                        OLEDchar('.',narrow);
                        OLEDchar(OLEDbuf[7],arial);                    
                        OLEDchar(OLEDbuf[8],arial);                    
                        OLEDchar(OLEDbuf[9],arial);                    
                        OLEDchar('A',arial);
                        OLEDchar(' ',arial);                                            
                    }else{
                        OLEDchararray("INVALID",arial);                                            
                    }
                    if(settingsButton==DOWN_BUTTON){if(cur.anIoffset>OFFSET_MIN){cur.anIoffset=cur.anIoffset-1;}}
                    if(settingsButton==UP_BUTTON){if(cur.anIoffset<OFFSET_MAX){cur.anIoffset=cur.anIoffset+1;}}
                    break;
                case SETTINGS_J_OFFSET:
                    OLEDchar(ICON_DOWN,iconSmall);
                    OLEDchar(ICON_UP,iconSmall);
                    OLEDchararray("TO TRIM:",smallFont);
                    prepareInt(cur.anJoffset,8);
                    OLEDchararray(OLEDbuf+4,smallFont);                    
                    OLEDcol=31;
                    OLEDpage=4;
                    if(external.iValid==IVALID_LO){
                        prepareInt(external.busIlo,6);
                        OLEDchar(OLEDbuf[6],arial);
                        OLEDchar(OLEDbuf[7],arial);
                        OLEDchar('.',narrow);
                        OLEDchar(OLEDbuf[8],arial);                    
                        OLEDchar(OLEDbuf[9],arial);                    
                        OLEDchar('m',arial);
                        OLEDchar('A',arial);                                            
                        OLEDchar(' ',arial);                                            
                    }else{
                        OLEDchararray("INVALID",arial);                                            
                    }
                    if(settingsButton==DOWN_BUTTON){if(cur.anJoffset>OFFSET_MIN){cur.anJoffset=cur.anJoffset-1;}}
                    if(settingsButton==UP_BUTTON){if(cur.anJoffset<OFFSET_MAX){cur.anJoffset=cur.anJoffset+1;}}
                    break;
                case SETTINGS_TIMEOUT:
                    OLEDchar(ICON_DOWN,iconSmall);
                    OLEDchar(ICON_UP,iconSmall);
                    OLEDchararray("ADJUST (0 = OFF)",smallFont);
                    OLEDcol=0;
                    OLEDpage=4;
                    if(cur.timeOut){
                        OLEDscanshort(cur.timeOut);
                        OLEDlzb(8);
                        OLEDchararray(&OLEDbuf[5],arial);
                        OLEDchar('s',arial);
                    }else{
                        OLEDchararray("   OFF   ",arial);
                    }
                    if(settingsButton==UP_BUTTON){
                        cur.timeOut=cur.timeOut+TIMEOUT_STEP;
                        if(cur.timeOut>TIMEOUT_MAX){cur.timeOut=TIMEOUT_MAX;}
                    }
                    if(settingsButton==DOWN_BUTTON){
                        if(cur.timeOut<TIMEOUT_STEP){
                            cur.timeOut=0;
                        }else{
                            cur.timeOut=cur.timeOut-TIMEOUT_STEP;
                        }
                    }
                    break;
                case SETTINGS_SAVE_RESTORE:
                    OLEDchar(ICON_UP,iconSmall);
                    OLEDchararray(" SAVE SETTINGS",smallFont);
                    OLEDcol=0;
                    OLEDpage=4;
                    OLEDchar(ICON_DOWN,iconSmall);
                    OLEDchararray(" RESTORE SETTINGS",smallFont);
                    OLEDcol=0;
                    OLEDpage=6;
                    if(settingsButton==UP_BUTTON){
                        sav=cur;
                        OLEDchararray("SAVED TO EEPROM",smallFont);
                        delay(500);
                        OLEDclear(0);
                    }
                    if(settingsButton==DOWN_BUTTON){
                        cur=backup;                        
                        OLEDchararray("RESTORED FROM BACKUP",smallFont);
                        delay(500);
                        OLEDclear(0);
                    }
                    break;
                case SETTINGS_DUMMY:
                    settings=0;
                    break;
                    
            }
            if(settingsButton==MODE_BUTTON){
                countDown=cur.timeOut;
                if(checkButtonLongShort(MODE_BUTTON)==LONG_PRESS){
                    OLEDclear(0);//refresh            
                    settingsFlag=0;
                    settings=0;     //back to first screen                    
                }else{
                    settings=settings+1;
                    if(settings>=SETTINGS_DUMMY){settings=0;}
                    OLEDclear(0);//refresh            
                }
            }
        }else{
            if(external.busV>VBUS_OFF){countDown=cur.timeOut;}
            switch(screen){
                case SCREEN_MAIN:
                    OLEDcol=0;
                    OLEDpage=0;
                    OLEDscanlong(external.busV);
                    OLEDlzb(5);
                    if((external.busV>VBUS_OFF) || (cur.timeOut==0) || accumE){   //ignore if timeout disabled
                        OLEDchar(OLEDbuf[5],arial);
                        OLEDchar(OLEDbuf[6],arial);
                        OLEDchar('.',narrow);
                        OLEDchar(OLEDbuf[7],arial);
                        OLEDchar(OLEDbuf[8],arial);
                        OLEDchar('V',arial);                                                
                    }else{                        
                        //show timer if no VBUS
                        OLEDchar(' ',smallFont);
                        OLEDchar(' ',smallFont);
                        OLEDchar(OLEDbuf[5],smallFont);
                        OLEDchar(OLEDbuf[6],smallFont);
                        OLEDchar('.',smallFont);
                        OLEDchar(OLEDbuf[7],smallFont);
                        OLEDchar(OLEDbuf[8],smallFont);
                        OLEDchar('V',smallFont);                        
                        OLEDcol=0;
                        OLEDpage=2;
                        OLEDscanshort(countDown);
                        OLEDlzb(8);
                        OLEDchararray(&OLEDbuf[3],smallFont);
                        OLEDchar('s',smallFont);                        
                    }
                    OLEDcol=50;
                    OLEDpage=0;
                    if(external.busIlo<0){  //to left
                        //OLEDchar(ICON_LEFT,icons);
                        OLEDchar('<',arial);
                        OLEDchar('-',arial);
                    }else if(external.busIlo>0){    //to right
                        //OLEDchar(ICON_RIGHT,icons);
                        OLEDchar('-',arial);
                        OLEDchar('>',arial);
                    }else{          //zero
                        OLEDchar(' ',arial);
                        OLEDchar(' ',arial);
                    }
                    OLEDcol=70;
                    OLEDpage=0;
                    if(external.iValid==IVALID_LO){ //lo, show in mA
                        OLEDscanshort((unsigned int)abs(external.busIlo));
                        OLEDlzb(6);
                        //OLEDaddsign(external.busIlo);
                        //OLEDchar(OLEDbuf[5],arial);
                        OLEDchar(OLEDbuf[6],arial);
                        OLEDchar(OLEDbuf[7],arial);
                        OLEDchar('.',narrow);
                        OLEDchar(OLEDbuf[8],arial);                    
                        OLEDchar(OLEDbuf[9],arial);                    
                        OLEDchar('m',arial);
                        OLEDchar('A',arial);
                    }else{  //show in A
                        OLEDscanshort((unsigned int)abs(external.busIhi));
                        OLEDlzb(5);
                        //OLEDaddsign(external.busIhi);
                        //OLEDchar(OLEDbuf[4],arial);
                        OLEDchar(OLEDbuf[5],arial);
                        OLEDchar(OLEDbuf[6],arial);
                        OLEDchar('.',narrow);
                        OLEDchar(OLEDbuf[7],arial);                    
                        OLEDchar(OLEDbuf[8],arial);                    
                        OLEDchar(OLEDbuf[9],arial);                    
                        OLEDchar('A',arial);
                    }
                    OLEDscanlong((unsigned long)labs(external.busP));
                    OLEDlzb(5);
                    OLEDaddsign(external.busP);
                    OLEDcol=0;
                    OLEDpage=4;
                    OLEDchar(OLEDbuf[0],smallFont);
                    OLEDchar(OLEDbuf[1],smallFont);
                    OLEDchar(OLEDbuf[2],smallFont);
                    OLEDchar(OLEDbuf[3],smallFont);
                    OLEDchar(OLEDbuf[4],smallFont);
                    OLEDchar(OLEDbuf[5],smallFont);
                    OLEDchar(OLEDbuf[6],smallFont);
                    OLEDchar('.',smallFont);
                    OLEDchar(OLEDbuf[7],smallFont);                    
                    OLEDchar(OLEDbuf[8],smallFont);                    
                    OLEDchar(OLEDbuf[9],smallFont);                    
                    OLEDchar('W',smallFont);                                
                    //energy
                    OLEDcol=0;
                    OLEDpage=6;
                    switch(cur.units){        
                        case UNITS_JOULES:
                            displayEnergy=(long)(external.busE/ADC_T0_HZ);
                            OLEDscanlong((unsigned long)labs((long)displayEnergy));                
                            OLEDlzb(5);
                            OLEDaddsign(displayEnergy);
                            OLEDchar(OLEDbuf[0],smallFont);
                            OLEDchar(OLEDbuf[1],smallFont);
                            OLEDchar(OLEDbuf[2],smallFont);
                            OLEDchar(OLEDbuf[3],smallFont);
                            OLEDchar(OLEDbuf[4],smallFont);
                            OLEDchar(OLEDbuf[5],smallFont);
                            OLEDchar(OLEDbuf[6],smallFont);
                            OLEDchar('.',smallFont);
                            OLEDchar(OLEDbuf[7],smallFont);                    
                            OLEDchar(OLEDbuf[8],smallFont);                    
                            OLEDchar(OLEDbuf[9],smallFont);                    
                            OLEDchar('J',smallFont);                                
                            break;
                        case UNITS_WATTHOURS:
                            displayEnergy=(long)(external.busE/ADC_T0_WATTHOURS);  //actually mWH
                            OLEDscanlong((unsigned long)labs((long)displayEnergy));                
                            OLEDlzb(2);
                            OLEDaddsign(displayEnergy);
                            OLEDchar(OLEDbuf[0],smallFont);
                            OLEDchar(OLEDbuf[1],smallFont);
                            OLEDchar(OLEDbuf[2],smallFont);
                            OLEDchar(OLEDbuf[3],smallFont);
                            OLEDchar('.',smallFont);
                            OLEDchar(OLEDbuf[4],smallFont);
                            OLEDchar(OLEDbuf[5],smallFont);
                            OLEDchar(OLEDbuf[6],smallFont);
                            OLEDchar(OLEDbuf[7],smallFont);                    
                            OLEDchar(OLEDbuf[8],smallFont);                    
                            OLEDchar('W',smallFont);                                
                            OLEDchar('h',smallFont);                                
                            break;   
                        case UNITS_DUMMY:   //catch
                            cur.units=UNITS_JOULES;
                            break;
                    }
                    OLEDscanTimeLong(tCount/ADC_T0_HZ);                    
                    OLEDlzb(2);
                    OLEDcol=80;
                    OLEDpage=4;                
                    if(accumE){ //is running?
                        countDown=cur.timeOut;
                        OLEDchararray(OLEDbuf+2,smallFont);   
                        OLEDcol=80;
                        OLEDpage=6;
                        OLEDchar(ICON_DOWN,iconSmall);
                        OLEDchararray("PAUSE ",smallFont);
                        if(checkButton(DOWN_BUTTON)){
                            accumE=0;                            
                        }
                    }else{
                        if(toggleFlag&2){
                            OLEDchar(ICON_UP,iconSmall);
                            OLEDchararray("START ",smallFont);
                        }else{
                            OLEDchararray(OLEDbuf+2,smallFont);   
                        }
                        OLEDcol=80;
                        OLEDpage=6;
                        OLEDchar(ICON_DOWN,iconSmall);
                        OLEDchararray("RESET ",smallFont);                    
                        if(checkButton(DOWN_BUTTON)){
                            clearAccum();
                            tCount=0;     
                            countDown=cur.timeOut;
                        }
                        if(checkButton(UP_BUTTON)){
                            accumE=1;
                            countDown=cur.timeOut;
                        }
                    }                
                    break;
                case SCREEN_STATUS_SLEEP:
                    OLEDcol=0;
                    OLEDpage=4;
                    OLEDchar(ICON_DOWN,icons);
                    OLEDchararray(" TO SLEEP",arial);                
                    if(PRESSED(S2)){
                        latbits.REGEN=0;
                        while(PRESSED(S2)){
                            delay(200);
                            loadADCC();
                            OLEDscanshort(external.vcc+BATTERY_SOURCE_VF);
                            OLEDlzb(5);
                            OLEDcol=0;
                            OLEDpage=0;
                            OLEDchararray("BATTERY: ",arial);
                            OLEDchar(OLEDbuf[5],arial);
                            OLEDchar(OLEDbuf[6],arial);
                            OLEDchar('.',arial);
                            OLEDchar(OLEDbuf[7],arial);
                            OLEDchar('V',arial);                                                        
                            getT0long();
                        }
                        latbits.REGEN=1;
                    }else{
                        OLEDcol=0;
                        OLEDpage=0;
                        OLEDchar(ICON_UP,icons);
                        OLEDchararray(" BATT. CHECK",arial);                    
                    }
                    if(checkButton(DOWN_BUTTON)){   //do this check last for consistency around sleep
                        OLEDclear(0);//refresh            
                        OLEDcol=28;
                        OLEDpage=2;
                        OLEDchararray("SLEEPING",arial);
                        delay(1000);
                        shutDown();
                        sleepAndWakeUp();
                        startUp();
                    }                                    
                    break;
                case SCREEN_CC_DETECT:
                    OLEDcol=0;
                    OLEDpage=0;
                    OLEDchararray("CC CONNECTION STATE",smallFont);
                    CC1state=getCCstate(external.vCC1);
                    CC2state=getCCstate(external.vCC2);
                    if(CC1state==CC_VRA){
                        CCstate=CC2state;                        
                        CCactive=2;
                        icc=external.iCC2;
                    }else{
                        CCstate=CC1state;
                        CCactive=1;
                        icc=external.iCC1;
                    }
                    if(CCstate==CC_VRA){
                        CCactive=0;
                        icc=0;
                    }
                    OLEDcol=0;
                    OLEDpage=2;
                    switch(CCactive){
                        case 1: OLEDchararray("CC1:",smallFont);break;
                        case 2: OLEDchararray("CC2:",smallFont);break;
                        default:OLEDchararray("NC :",smallFont);break;
                    }
                    OLEDchararray(CCsinkState[CCstate],smallFont);
                    OLEDcol=0;
                    OLEDpage=4;
                    CCtestValid=0;
                    if(external.busV<4500){ //low
                        switch(CCstate){
                            case CC_OPEN:
                                OLEDchararray("SOURCE OK",smallFont);
                                CCtestValid=1;
                                break;                           
                            case CC_USB: 
                            case CC_15: 
                            case CC_30:  OLEDchararray("SOURCE LO",smallFont);break;
                            default:     OLEDchararray("NORMAL   ",smallFont);break;
                        }
                    }else if(external.busV<5500){   //normal on range
                        switch(CCstate){
                            case CC_USB: 
                            case CC_15: 
                            case CC_30:  OLEDchararray("NORMAL   ",smallFont);break;
                            default:     OLEDchararray("LEGACY   ",smallFont);break;
                        }                        
                    }else{      //PD negotiated
                        OLEDchararray("USB-PD   ",smallFont);
                    }
                    if(ccTesting){
                        OLEDchararray(" --",smallFont);     //can't determine direction if using internal pulldown
                    }else{
                        if(icc<(-CC_DIR_THRESHOLD)){    //negative
                            OLEDchararray(" ->",smallFont);                        
                        }else if(icc>CC_DIR_THRESHOLD){ //positive
                            OLEDchararray(" <-",smallFont);                        
                        }else{  //none
                            OLEDchararray(" --",smallFont);                        
                        }                        
                    }
                    OLEDcol=0;
                    OLEDpage=6;
                    if(ccTesting){
                        OLEDchar(ICON_UP,iconSmall);
                        OLEDchararray("HOLD     ",smallFont);
                        if(PRESSED(S2)==0){ //release = end
                            setCCpulldowns(0);
                            ccTesting=0;          
                        }                        
                        delay(CC_TEST_DELAY); //settle
                    }else{
                        if(CCtestValid){
                            OLEDchar(ICON_UP,iconSmall);
                            OLEDchararray("START    ",smallFont);
                            if(PRESSED(S2)){
                                ccTesting=1;                        
                                CCtestValid=0;
                                setCCpulldowns(ccTesting);
                                delay(CC_TEST_DELAY); //settle
                            }                              
                        }else{
                            OLEDchararray("SOURCE ONLY",smallFont);
                        }
                    }

                    OLEDscanlong(external.busV);
                    OLEDlzb(5);
                    OLEDcol=84;
                    OLEDpage=4;
                    OLEDchar(OLEDbuf[5],arial);
                    OLEDchar(OLEDbuf[6],arial);
                    OLEDchar('.',narrow);
                    OLEDchar(OLEDbuf[7],arial);
                    OLEDchar('V',arial);
                    break;
                case SCREEN_TRIM_OFFSET:
                    OLEDcol=0;
                    OLEDpage=0;
                    OLEDchararray("TRIM OFFSETS",smallFont);
                    OLEDcol=0;
                    OLEDpage=2;
                    OLEDchararray("ZERO: ENSURE NO LOAD.",smallFont);
                    OLEDcol=0;
                    OLEDpage=4;
                    OLEDchar(ICON_DOWN,iconSmall);
                    OLEDchararray("TO BEGIN.",smallFont);
                    OLEDcol=0;
                    OLEDpage=6;
                    prepareInt(cur.anIoffset,8);
                    OLEDchararray("HI:",smallFont);
                    OLEDchararray(OLEDbuf+4,smallFont);
                    prepareInt(cur.anJoffset,8);
                    OLEDchararray(" LO:",smallFont);
                    OLEDchararray(OLEDbuf+4,smallFont);                    
                    if(checkButton(DOWN_BUTTON)){
                        OLEDcol=0;
                        OLEDpage=4;
                        OLEDchararray("RUNNING.   ",smallFont);
                        i=doOffsetCal();
                        OLEDcol=0;
                        OLEDpage=4;
                        OLEDscanshort(i);
                        OLEDlzb(8);
                        OLEDchararray(OLEDbuf+6,smallFont);
                        OLEDchararray(" DONE  ",smallFont);
                        OLEDcol=0;
                        OLEDpage=6;
                        prepareInt(cur.anIoffset,8);
                        OLEDchararray("HI:",smallFont);
                        OLEDchararray(OLEDbuf+4,smallFont);
                        prepareInt(cur.anJoffset,8);
                        OLEDchararray(" LO:",smallFont);
                        OLEDchararray(OLEDbuf+4,smallFont);                    
                        delay(500);
                        while(anyButton()){}    //ensure all buttons are released
                    }
                    break;
                case SCREEN_DUMMY:
                    screen=0;
                    break;
            }
            //check MODE button
            switch(checkButtonLongShort(MODE_BUTTON)){
                case SHORT_PRESS:
                    screen=screen+1;
                    if(screen>=SCREEN_DUMMY){screen=0;}
                    OLEDclear(0);//refresh            
                    break;
                case LONG_PRESS:
                    OLEDclear(0);//refresh            
                    settingsFlag=1;
                    break;
            }
        }
    }
}

void __interrupt() isr() {
    isrADCC();
}
