
#define _SUPPRESS_PLIB_WARNING
#define _DISABLE_OPENADC10_CONFIGPORT_WARNING
#include <plib.h>
#include <xc.h>
#include <math.h>
#include "fix_fft32.h"

// DEVCFG3
#pragma config PMDL1WAY = OFF           // Peripheral Module Disable Configuration (Allow only one reconfiguration)
#pragma config IOL1WAY = ON             // Peripheral Pin Select Configuration (Allow only one reconfiguration)

// DEVCFG2
#pragma config FPLLIDIV = DIV_2
#pragma config FPLLMUL = MUL_24
#pragma config FPLLODIV = DIV_4

// DEVCFG1
#pragma config FNOSC = FRCPLL              // Oscillator Selection Bits (Fast RC Osc with PLL)
#pragma config FSOSCEN = OFF            // Secondary Oscillator Enable (Enabled)
#pragma config IESO = OFF               // Internal/External Switch Over (Diasbled)
#pragma config POSCMOD = OFF            // Primary Oscillator Configuration (External clock/Primary osc disabled)
#pragma config OSCIOFNC = OFF           // CLKO Output Signal Active on the OSCO Pin (Disabled)
#pragma config FPBDIV = DIV_1           // Peripheral Clock Divisor (Pb_Clk is Sys_Clk)
#pragma config FCKSM = CSECMD           // Clock Switching and Monitor Selection (Clock Switch Enabled, FSCM Disabled)
#pragma config WDTPS = PS32768          // Watchdog Timer Postscaler (1:32768)
#pragma config WINDIS = OFF             // Watchdog Timer Window Enable (Watchdog Timer is in Non-Window Mode)
#pragma config FWDTEN = OFF             // Watchdog Timer Enable (WDT Disabled (SWDTEN Bit Controls))
#pragma config FWDTWINSZ = WINSZ_25     // Watchdog Timer Window Size (Window Size is 25%)

// DEVCFG0
#pragma config DEBUG = OFF              // Background Debugger Enable (Debugger is Enabled)
#pragma config JTAGEN = OFF             // JTAG Enable (JTAG Port Disabled)
#pragma config ICESEL = ICS_PGx3        // ICE/ICD Comm Channel Select (Communicate on PGEC2/PGED2)
#pragma config PWP = OFF                // Program Flash Write Protect (Disable)
#pragma config BWP = OFF                // Boot Flash Write Protect bit (Protection Disabled)
#pragma config CP = OFF                 // Code Protect (Protection Disabled)

#define SYS_FREQ (24000000L)

#define FFT_SCALE 4096
#define FFT_SCALE_LOG 12

fixed FFTBuf[FFT_SCALE], FFTIBuf[FFT_SCALE];
int accum[FFT_SCALE/4];
unsigned int FFTBuf_Pos, FFTBuf_Samp, NumAvgs, Averaging;
enum { THD_plus_N, Harmonic_2, Harmonic_3, Harmonic_Even, Harmonic_Odd/*, THD*/ } mode;

unsigned short flattop_ampl_correction[1024] = {                        0, 9102, 5562, 5413, 5421, 5429, 5437, 5446, 5454, 5462, 5471, 5479, 5488, 5496, 5505, 5513,
                        5522, 5531, 5539, 5548, 5556, 5565, 5574, 5583, 5591, 5600, 5609, 5618, 5626, 5635, 5644, 5653,
                        5662, 5671, 5680, 5689, 5698, 5707, 5716, 5725, 5734, 5743, 5752, 5761, 5770, 5780, 5789, 5798,
                        5807, 5816, 5826, 5835, 5844, 5854, 5863, 5872, 5882, 5891, 5901, 5910, 5920, 5929, 5939, 5948,
                        5958, 5968, 5977, 5987, 5997, 6006, 6016, 6026, 6036, 6046, 6055, 6065, 6075, 6085, 6095, 6105,
                        6115, 6125, 6135, 6145, 6155, 6165, 6175, 6185, 6195, 6206, 6216, 6226, 6236, 6247, 6257, 6267,
                        6278, 6288, 6299, 6309, 6319, 6330, 6340, 6351, 6362, 6372, 6383, 6393, 6404, 6415, 6426, 6436,
                        6447, 6458, 6469, 6480, 6490, 6501, 6512, 6523, 6534, 6545, 6556, 6567, 6579, 6590, 6601, 6612,
                        6623, 6634, 6646, 6657, 6668, 6680, 6691, 6702, 6714, 6725, 6737, 6748, 6760, 6771, 6783, 6795,
                        6806, 6818, 6830, 6842, 6853, 6865, 6877, 6889, 6901, 6913, 6925, 6937, 6949, 6961, 6973, 6985,
                        6997, 7009, 7021, 7034, 7046, 7058, 7070, 7083, 7095, 7108, 7120, 7133, 7145, 7158, 7170, 7183,
                        7195, 7208, 7221, 7233, 7246, 7259, 7272, 7285, 7298, 7311, 7324, 7337, 7350, 7363, 7376, 7389,
                        7402, 7415, 7428, 7442, 7455, 7468, 7482, 7495, 7508, 7522, 7536, 7549, 7563, 7576, 7590, 7604,
                        7617, 7631, 7645, 7659, 7673, 7686, 7700, 7714, 7728, 7742, 7756, 7771, 7785, 7799, 7813, 7827,
                        7841, 7856, 7870, 7885, 7899, 7914, 7928, 7943, 7957, 7972, 7987, 8001, 8016, 8031, 8046, 8061,
                        8076, 8090, 8105, 8120, 8136, 8151, 8166, 8181, 8196, 8211, 8227, 8242, 8257, 8273, 8288, 8304,
                        8319, 8335, 8351, 8366, 8382, 8398, 8414, 8429, 8445, 8461, 8477, 8493, 8509, 8525, 8541, 8558,
                        8574, 8590, 8606, 8623, 8639, 8656, 8672, 8689, 8705, 8722, 8739, 8755, 8772, 8789, 8806, 8823,
                        8839, 8856, 8874, 8891, 8908, 8925, 8942, 8959, 8977, 8994, 9011, 9029, 9046, 9064, 9081, 9099,
                        9117, 9135, 9152, 9170, 9188, 9206, 9224, 9242, 9260, 9278, 9296, 9315, 9333, 9351, 9370, 9388,
                        9407, 9425, 9444, 9462, 9481, 9500, 9519, 9537, 9556, 9575, 9594, 9613, 9632, 9652, 9671, 9690,
                        9709, 9729, 9748, 9768, 9787, 9807, 9826, 9846, 9866, 9886, 9906, 9926, 9946, 9966, 9986, 10006,
                        10026, 10046, 10067, 10087, 10107, 10128, 10148, 10169, 10190, 10210, 10231, 10252, 10273, 10294, 10315, 10336,
                        10357, 10378, 10400, 10421, 10442, 10464, 10485, 10507, 10528, 10550, 10572, 10594, 10616, 10638, 10660, 10682,
                        10704, 10726, 10748, 10771, 10793, 10815, 10838, 10860, 10883, 10906, 10929, 10951, 10974, 10997, 11020, 11043,
                        11067, 11090, 11113, 11137, 11160, 11184, 11207, 11231, 11254, 11278, 11302, 11326, 11350, 11374, 11398, 11422,
                        11447, 11471, 11496, 11520, 11545, 11569, 11594, 11619, 11643, 11669, 11694, 11719, 11744, 11769, 11794, 11820,
                        11845, 11871, 11896, 11922, 11948, 11974, 11999, 12025, 12051, 12078, 12104, 12130, 12157, 12183, 12209, 12236,
                        12263, 12290, 12316, 12343, 12370, 12397, 12425, 12452, 12479, 12507, 12534, 12562, 12589, 12617, 12645, 12673,
                        12701, 12729, 12757, 12785, 12814, 12842, 12871, 12899, 12928, 12957, 12986, 13015, 13044, 13073, 13102, 13131,
                        13161, 13190, 13220, 13250, 13279, 13309, 13339, 13369, 13399, 13430, 13460, 13490, 13521, 13551, 13582, 13613,
                        13644, 13675, 13706, 13737, 13768, 13800, 13831, 13863, 13894, 13926, 13958, 13990, 14022, 14054, 14086, 14119,
                        14151, 14184, 14216, 14249, 14282, 14315, 14348, 14381, 14414, 14448, 14481, 14515, 14549, 14582, 14616, 14650,
                        14685, 14719, 14753, 14788, 14822, 14857, 14892, 14927, 14961, 14997, 15032, 15067, 15103, 15138, 15174, 15210,
                        15245, 15282, 15318, 15354, 15391, 15427, 15463, 15500, 15537, 15574, 15611, 15648, 15686, 15723, 15761, 15798,
                        15836, 15874, 15912, 15950, 15989, 16027, 16066, 16104, 16143, 16182, 16221, 16260, 16300, 16339, 16378, 16418,
                        16458, 16498, 16538, 16578, 16619, 16659, 16700, 16740, 16781, 16822, 16863, 16905, 16946, 16988, 17029, 17071,
                        17113, 17155, 17198, 17240, 17283, 17325, 17368, 17411, 17454, 17497, 17541, 17584, 17628, 17672, 17716, 17760,
                        17804, 17848, 17893, 17938, 17983, 18028, 18073, 18118, 18163, 18209, 18255, 18301, 18347, 18393, 18440, 18486,
                        18533, 18580, 18627, 18674, 18721, 18769, 18816, 18864, 18912, 18961, 19009, 19057, 19106, 19155, 19204, 19253,
                        19302, 19352, 19401, 19451, 19501, 19551, 19602, 19652, 19703, 19754, 19805, 19856, 19908, 19959, 20011, 20063,
                        20115, 20167, 20220, 20272, 20325, 20378, 20431, 20485, 20538, 20592, 20646, 20700, 20755, 20809, 20864, 20919,
                        20973, 21029, 21085, 21141, 21197, 21253, 21309, 21365, 21421, 21479, 21536, 21593, 21651, 21708, 21766, 21824,
                        21883, 21941, 22000, 22059, 22118, 22177, 22237, 22297, 22356, 22417, 22477, 22538, 22599, 22660, 22721, 22783,
                        22845, 22906, 22969, 23031, 23094, 23157, 23220, 23283, 23346, 23410, 23474, 23539, 23603, 23668, 23733, 23798,
                        23864, 23929, 23995, 24061, 24128, 24194, 24261, 24328, 24395, 24463, 24531, 24599, 24668, 24736, 24805, 24874,
                        24943, 25013, 25083, 25153, 25224, 25294, 25365, 25436, 25507, 25580, 25651, 25724, 25797, 25869, 25942, 26015,
                        26090, 26163, 26237, 26312, 26387, 26461, 26536, 26612, 26688, 26764, 26841, 26917, 26995, 27072, 27149, 27227,
                        27302, 27384, 27463, 27542, 27621, 27701, 27781, 27861, 27941, 28022, 28104, 28185, 28267, 28349, 28431, 28515,
                        28598, 28681, 28765, 28849, 28933, 29018, 29103, 29188, 29273, 29360, 29446, 29533, 29620, 29707, 29795, 29883,
                        29971, 30060, 30149, 30239, 30329, 30419, 30509, 30600, 30690, 30783, 30875, 30967, 31060, 31152, 31246, 31340,
                        31434, 31528, 31623, 31718, 31814, 31910, 32006, 32103, 32199, 32297, 32395, 32494, 32593, 32691, 32791, 32891,
                        32992, 33092, 33193, 33294, 33396, 33498, 33601, 33704, 33807, 33912, 34016, 34121, 34226, 34332, 34437, 34544,
                        34651, 34759, 34866, 34975, 35084, 35192, 35302, 35412, 35521, 35633, 35745, 35856, 35969, 36081, 36194, 36308,
                        36421, 36537, 36652, 36767, 36884, 37000, 37117, 37234, 37351, 37471, 37590, 37709, 37830, 37950, 38070, 38192,
                        38315, 38436, 38559, 38683, 38807, 38931, 39056, 39182, 39307, 39435, 39561, 39689, 39818, 39946, 40075, 40205,
                        40335, 40467, 40598, 40730, 40863, 40996, 41129, 41264, 41398, 41534, 41670, 41807, 41945, 42082, 42220, 42359,
                        42499, 42639, 42780, 42921, 43064, 43206, 43349, 43493, 43636, 43782, 43928, 44074, 44222, 44369, 44517, 44666,
                        44814, 44966, 45117, 45268, 45421, 45573, 45726, 45881, 46034, 46191, 46348, 46504, 46663, 46820, 46979, 47139,
                        47301, 47461, 47622, 47785, 47949, 48113, 48277, 48442, 48607, 48776, 48943, 49112, 49282, 49451, 49621, 49792,
                        49965, 50138, 50312, 50486, 50663, 50838, 51015, 51193, 51369, 51550, 51731, 51911, 52094, 52276, 52459, 52643,
                        52829, 53015, 53202, 53389, 53579, 53767, 53957, 54149, 54339, 54534, 54727, 54922, 55119, 55314, 55511, 55710,
                        55907, 56109, 56310, 56512, 56716, 56919, 57124, 57330, 57534, 57744, 57953, 58162, 58374, 58585, 58797, 59011,
                        59227, 59442, 59658, 59876, 60096, 60315, 60536, 60757, 60980, 61206, 61432, 61660, 61892, 62129, 65441, 51496 };

inline long get_amp(const fixed* real, const fixed* imag, unsigned int pos) {
  return ((((long long)real[pos] * (long long)real[pos] + (long long)imag[pos] * (long long)imag[pos]) >> 12) * flattop_ampl_correction[pos]) >> 30;
}

float sqr(float val) {
  return val * val;
}

int find_fundamental(const int* buf, int start, int n, int* result, float* fract) {
  int i, val;
  int pos = 0, max = 0;

  val = 0;
  for( i = start; i < n; ++i ) {
    val = buf[i];
    if( val > max ) {
      max = val;
      pos = i;
    }
  }
  if( result )
    *result = max;
  if( fract ) {
    int left_shift = max - buf[pos-1];
    int right_shift = max - buf[pos+1];
    if( left_shift < right_shift ) {
      *fract = -sqr((double)right_shift / (double)max)*8.1f;
    } else if( right_shift < left_shift ) {
      *fract = sqr((double)left_shift / (double)max)*8.1f;
    } else {
      *fract = 0.0f;
    }
  }
  return pos;
}

#define HARM_SPREAD 3

float calculate_thd(const int* buf, int start, int n) {
  int fundamental, fundamental_amplitude, harmonic_num, harmonic, harmonic_amplitude;
  int ret = 0, pos;
  float fract, fract_accum;

  fundamental = find_fundamental(buf, 0, n, &fundamental_amplitude, &fract);
  for( pos = fundamental*2, harmonic_num = 2, fract_accum = fract; harmonic_num <= 21; pos += fundamental, ++harmonic_num, fract_accum += fract ) {
    if( fract_accum > 0.5 ) {
      ++pos;
      fract_accum -= 1;
    }

    if( pos >= n - (HARM_SPREAD + 1) )
      break;
    harmonic = find_fundamental(buf, pos - HARM_SPREAD, pos + HARM_SPREAD+1, &harmonic_amplitude, 0);

    if( harmonic ) {
      switch(mode) {
          case Harmonic_2:
              if( harmonic_num == 2 )
                  ret += harmonic_amplitude;
              break;
          case Harmonic_3:
              if( harmonic_num == 3 )
                  ret += harmonic_amplitude;
              break;
          case Harmonic_Even:
              if( !(harmonic_num&1) )
                  ret += harmonic_amplitude;
              break;
          case Harmonic_Odd:
              if( (harmonic_num&1) )
                  ret += harmonic_amplitude;
              break;
          default:
              ret += harmonic_amplitude;
              break;
      }
      pos = harmonic;
    }
  }
  return sqrt((float)ret / (float)fundamental_amplitude);
}

float calculate_thd_plus_noise(const int* buf, int start, int n) {
  int fundamental, fundamental_amplitude, rms_amplitude, i;

  fundamental = find_fundamental(buf, 0, n, &fundamental_amplitude, 0);
  if( !fundamental )
    return 0;

  fundamental_amplitude = 0;
  for( i = fundamental - 5; i <= fundamental + 5; ++i )
    fundamental_amplitude += buf[i];

  rms_amplitude = 0;
  for( i = 5; i < n; ++i )
    rms_amplitude += buf[i];

  return sqrt((float)(rms_amplitude - fundamental_amplitude) / (float)fundamental_amplitude);
}

int main() {
  int i, max, pos, val, BattVal;
  float THD;
  int clip_timer, oversampling_fact = 0;

  SYSTEMConfigPerformance(SYS_FREQ);
  INTEnableSystemMultiVectoredInt();
  INTEnableInterrupts();

  TRISAbits.TRISA4 = 0;
  LATAbits.LATA4 = 0;
  TRISBbits.TRISB0 = 0;
  ANSELBbits.ANSB0 = 0;
  LATBbits.LATB0 = 0;

  TRISAbits.TRISA2 = 1;
  TRISAbits.TRISA3 = 1;
  TRISBbits.TRISB2 = 1;
  ANSELBbits.ANSB2 = 0;
  TRISBbits.TRISB4 = 1;
  CNPUAbits.CNPUA2 = 1;
  CNPUAbits.CNPUA3 = 1;
  CNPUBbits.CNPUB2 = 1;
  CNPUBbits.CNPUB4 = 1;

  RPB13Rbits.RPB13R = 6; // OC5
  PR2 = 3300;
  T2CONbits.TON = 1;
  OC5RS = 0;
  OC5CONbits.OCM = 6;
  OC5CONbits.ON = 1;

  TRISAbits.TRISA0 = 1;
  ANSELAbits.ANSA0 = 1;
  TRISAbits.TRISA1 = 1;
  ANSELAbits.ANSA1 = 1;
  AD1CHSbits.CH0SA = 0;
  AD1CON3bits.ADCS = 1;
  AD1CON3bits.SAMC = 1;
  AD1CON1bits.SSRC = 7;
  AD1CON1bits.FORM = 5;
  IFS0bits.AD1IF = 0;
  AD1CON1bits.ON = 1;
  AD1CON1bits.ASAM = 1;
  while(1) {
    AD1CON1bits.ON = 0;
    AD1CHSbits.CH0SA = 1;
    AD1CON1bits.ON = 1;

    BattVal = 0;
    IFS0bits.AD1IF = 0;
    for( i = 0; i < 16; ++i ) {
      while( !IFS0bits.AD1IF )
        ;
      BattVal += (short)ADC1BUF0 + 512;
      IFS0bits.AD1IF = 0;
    }
    AD1CON1bits.ON = 0;
    AD1CHSbits.CH0SA = 0;
    AD1CON1bits.ON = 1;

    memset(FFTBuf, 0, sizeof(FFTBuf));
    memset(FFTIBuf, 0, sizeof(FFTIBuf));
    IFS0bits.AD1IF = 0;
    while(1) {
      LATBbits.LATB0 = !clip_timer;
      if( clip_timer )
        --clip_timer;
      while( !IFS0bits.AD1IF )
        ;
//      AD1CON1bits.SAMP = 1;
//      while( !AD1CON1bits.DONE )
//        ;
      val = (short)ADC1BUF0;
      if( FFTBuf_Pos&1 )
        FFTIBuf[FFTBuf_Pos/2] += val;
      else
        FFTBuf[FFTBuf_Pos/2] += val;
      if( val == 511 || val == -512 )
        clip_timer = 1000;
//      AD1CON1bits.DONE = 0;
      IFS0bits.AD1IF = 0;
      if( ++FFTBuf_Samp == (1<<oversampling_fact) ) {
        FFTBuf_Samp = 0;
        if( FFTBuf_Pos&1 )
          FFTIBuf[FFTBuf_Pos/2] <<= (20-oversampling_fact);
        else
          FFTBuf[FFTBuf_Pos/2] <<= (20-oversampling_fact);
        if( ++FFTBuf_Pos == 2*sizeof(FFTBuf)/sizeof(*FFTBuf) ) {
          FFTBuf_Pos = 0;
          break;
        }
      }
    }
    window2_flattop/*hann*/(FFTBuf, FFTIBuf, FFT_SCALE);
    fix_fft(FFTBuf, FFTIBuf, FFT_SCALE_LOG, 0);
    if( NumAvgs == 0 )
        LATAbits.LATA4 = (BattVal < 400*16 ? 1 : 0); // 5.5V threshold
    fft_real_result_convolve(FFTBuf, FFTIBuf, FFT_SCALE/2);
    LATAbits.LATA4 = (BattVal < 400*16 ? 0 : 1); // 5.5V threshold
    for( i = 0; i < FFT_SCALE/4; ++i )
      accum[i] += get_amp(FFTBuf, FFTIBuf, i);
    if( ++NumAvgs == (1<<Averaging) ) {
      if( !PORTBbits.RB4 )
          mode = Harmonic_2;//THD_plus_N;
      else if( !PORTAbits.RA3 )
          mode = Harmonic_3;//Harmonic_2;
      else if( !PORTAbits.RA2 )
          mode = Harmonic_Even;//Harmonic_3;
      else if( !PORTBbits.RB2 )
          mode = Harmonic_Odd;//Harmonic_Even;
      else
          mode = THD;

      if( mode == THD_plus_N )
        THD = calculate_thd_plus_noise(accum, 0, FFT_SCALE/4);
      else
        THD = calculate_thd(accum, 0, FFT_SCALE/4);
      if( THD > 0.33 ) // maximum reading 33%
        THD = 0.33;
      OC5RS = THD * 100 * 100;

      i = find_fundamental(accum, 0, FFT_SCALE/4, &max, 0);
      if( max > 65536 ) {
          if( i < 24 ) {
              if( AD1CON3bits.ADCS < 2 ) {
                  AD1CON1bits.ON = 0;
                  ++AD1CON3bits.ADCS;
                  AD1CON1bits.ON = 1;
              } else if( oversampling_fact < 6 ) {
                  ++oversampling_fact;
              }
          } else if( i > 51 ) {
              if( AD1CON3bits.ADCS > 0 ) {
                  AD1CON1bits.ON = 0;
                  --AD1CON3bits.ADCS;
                  AD1CON1bits.ON = 1;
              } else if( oversampling_fact > 0 ) {
                --oversampling_fact;
              }
          }
      } else {
        if( oversampling_fact > 0 )
           --oversampling_fact;
      }

      memset(accum, 0, sizeof(accum));
//      Averaging = (mode == THD_plus_N ? 4 : 0);
      NumAvgs = 0;
    }
  }
  return (EXIT_SUCCESS);
}

