  'master
  option autorun on
  setpin 26,dout    'local pin 26 for error warning
  setpin 24,din
  if mm.watchdog then pin(26) = 1 'recovering from error so set signal
  open "com1:38400" as #1   'open com1
  do 'wait for pairing
  loop until pin(24) = 1
  'main program to illustrate usage. It flashes led on
  'remote pin 15;reads analog value from remote pin 26
  'and digital value from remote pins 25 & 24
  rsetpin 15,8      'set remote pin 15 dout
  rsetpin 26,1      'set remote pin 26 analog
  rsetpin 25,2      'set remote pin 25 din
  rsetpin 24,2      'set remote pin 24 din
  do                'main program loop
    outpin 15,1     ' 1st turn remote pin 15 on   
    pause 1000      ' then pause for a second
    outpin 15,0     'now turn remote pin 15 off
    u = readpin(25) 'read remote digital input pins 24&25
    w = readpin(24)
    v = readpin(26)'read analog pin value from remote pin 26
    print "pin 25 = ";u  'print digital input values
    print "pin 24 = ";w
    print "pin 26 = ";v         'print analog value
    pause 1000      'pause a second to complete flash rate
  loop              'loop forever
  
  'subroutine to set function of remote pin. pinn = pin to set
  'type: 0=not configured;1=analog;2=din;3=fin;4=pin;5=cin
  '8=dout;9=oout
sub rsetpin pinn,type
  local b$  'formulate command string
  b$ = "1"+right$("0"+str$(pinn),2)+str$(type)
  print #1,b$;    'send command string to remote MM
  gosub wait      'wait for a reply from remote
end sub
  
  'subroutine to set value of output pin
  'pinn = pin to act on;value = value to assign
sub outpin pinn,value
  local b$  'formulate command string
  b$ = "2"+right$("0"+str$(pinn),2)+str$(value)
  print #1,b$;    'send command string to remote MM
  gosub wait      'wait for a reply from remote
end sub
  
  'function to read the value of an input pin
function readpin(pinn)
  local b$  'formulate command string
  b$ = "3"+right$("0"+str$(pinn),2)+str$(0)
  print #1,b$;    'send command string to remote MM
  gosub wait      'wait for a reply from remote
  readpin = val(a$) 'assign analog value to function
end function
  
  'subroutine to wait for slave response. if no response after
  '2 secs master will reset and LED on pin 26 is lit
  
wait:
  watchdog 2000
  do        'wait for response from remote MM
    a$ = input$(1,#1)
  loop until a$ <> ""   'keep listening if nothing received yet
  watchdog off          'normal comms so turn off watchdog
  pin(26) = 0           'turn off error signal
  b$ = ""   'local MM has received a reply
  pause 100 'wait for rest of data
  do
    b$ = input$(200,#1) 'get rest of data
    a$ = a$ + b$ 'add it to a$ string. a$ contains value of read pin
  loop until b$ = ""    'loop until all data collected
return
              
