  'SLAVE
  option autorun on
  open "com1:38400,256,req,1" as #1 'use interrupt option on com1
  do              'listen for character
    watchdog 1000     'restart if unresponsive
  loop
  
req:        'a character has been received
  pause 100   'wait for a few more
  b$ = input$(25,#1)    'get all characters
  v$ = "ack"     'ack string for acknowleging receipt
  gosub decode    'decode instruction
  on com gosub rsetpin,outpin,readpin 'act on instruction
  print #1,v$;  'send acknowlege string or pin value
  do              'clear buffer
    a$ = input$(200,#1)
  loop until a$ = ""
  ireturn         'return to listening mode
  
decode:   'decodes command string
  com = val(left$(b$,1))  '1=setpin;2=output to pin;3=readpin
  pinn = val(mid$(b$,2,2))    'pin to act on
  action = val(mid$(b$,4,1))    'what to do with pin
  return
  
rsetpin:    'set function of a pin
  setpin pinn,action
  return
  
outpin:     'set value to a pin
  pin(pinn) = action
  return
  
readpin:    'read value from a pin
  v$ = str$(pin(pinn))
  return
