
'PICAXE-18A TEMP. DATALOGGER for Nov. 2003 "Silicon Chip" article.  Ver 1.01   5/9/03
'Use with DS18B20 temp sensor IC etc to Picaxe-18A In 1. Via=> s.t.swan@massey.ac.nz
'DS18B20 reads -10C to +85C to +/- 0.5C,but wider with less accuracy. Supply 3- 5.5V 
'N.B.Subzero "bug"-temps <0 C read as ascending from 128. Ex 129 = -1C, 130 = -2C etc
'Possibly address by 2's complement or subtracting value from 128. Thus 128-131= -3
'Program is "hi res" enhancement of lo res datalog8.bas as in Sept.'03 SiChip article 
'When "18A" powered up,any prior stored EEPROM values sent as pin 2 serial port data 
'-suit display via any terminal program -LCD,BananaCom,F8,StampPlot- or.csv Excel too.
'NB-Gives you 30secs to turn unit OFF before fresh storage begins & thus progressively
'wiping existing values ! For security however this data can't easily be bulk erased
'***BUT CARE - BE PROMPT ! REPROGRAMMING/RELOADING  "18A" TOTALLY WIPES DATA TOO ****.
'As set up logs direct Celsius temp every 15 secs for ~1 hr. Alter WAIT value to suit?
'A further tempting '18A" enhancement uses DS2415 or DS 1307 clock chip  for improved
'logging times. Both these & DS1820 can now be PICAXE-18A read, but not-sniff- by "08"
'-------------------------------------------------------------------------------------
'PICAXE18A has hi-res data values 0-255(via "readadc" command),but also READTEMP for
'direct DS18B20 Celsius readings! Values stored in non program space too (unlike "08")
'"Data compression" scope that'll maybe give 512 values ? 18X + I2C better if pushed 
'If power saving needed use SLEEP instead of WAIT ex. 25x2.3secs ~1min delay (+/- 1% )
'Alter to suit.Ex. Sleep 391 =256 x 1/4 hr =64 hrs.Some interpreter o'head/drift noted
'Solderless "PICNIK" breadboard setup pix => www.picaxe.orcon.net.nz/datads18.jpg 
'Sample Excel graph resulting (1 hour run)=> www.picaxe.orcon.net.nz/datads18.gif
'Program hosted=> www.picaxe.orcon.net.nz/datads18.bas  & circuit=> ... /picxds18.gif 
'-------------------------------------------------------------------------------------
'ASCII   INPUTS	  3-5V +supply    OUTPUTS	                   DS18B20 pinouts
' art    + + + + + + + + + + + + + + + + + +   		            (top view )
'        |           |	                 		              
'  DS18B20    	     |            _Serial   _Piezo                      * *
'  |    |         ---------      |         |                          *     *
'  |  0 1 2 6 7 =| PICAXE  |=0 1 2 3 4 5 6 7                         *       *          
'  |            =|  18A    |=    L  			             *       *
'  |__0V          ---------      E                                   ---------   
'                    |           D                                    /  /  /
' |||      	     |       | | | | | | | |                         /  /  /
'Prog.   - - - - - - - - - - - - - - - - - -  		           0V  |   V+
'input  Common ground for serial,DS18B20,piezo & supply               data
'---------------------------------------------------------------------------------------
					'READ/PLAYBACK ROUTINE 					 
serout 2,n2400,(12,"PICAXE-18A Temp.Datalogger  ")'ASCII values 12=FF(= cls), 44=comma  
for b0=0 to 255				'stored data values readout to terminal or LCD
read b0,b1				'polls & reads out stored eeprom values ( .csv)
serout 2,n2400,(#b1,44)			'Actual value @ pin 2,then comma for Excel .csv
pulsout 2,500				'paralled output 2 LED flashes to confirm data 
next b0					'read next stored EEPROM value serial out 
serout 2,n2400,(10,13,10)		'Forces fresh line for new data run(10=CR,13=LF)
wait 30					'30 secs "reading" delay -modify if too short etc
'----------------------------------------------------------------------------------------
					'WRITE/DATA LOGGING ROUTINE
for b0= 0 to 255			'begin 256 data readings @ time set by WAIT/SLEEP
sound 7,(75,10)		    		'Beep to alert data logging commencing
pulsout 2,500				'brief flash from pin 2 LED indicates datalogging
readtemp 1,b1				'direct Celsius reading of DS18B20 temp. returned 
serout 2,n2400,(#b1,44)			'Now allows display of data as gathered too !
write b0,b1 				'sequentially write values to EEPROM locations
wait 15 				'Checks every 15 secs (max 65)-alter to suit etc	
next b0					'Gathering automatically stops after 256 samples
'----------------------------------------------------------------------------------------

Revision history:  NOTE - article intended Oct., but held over until November issue.
----------------
Ver 1.0   1st Sept   - original
Ver 1.01  5th Sept   - added WAIT with SLEEP in routine above, since SiChip article still 
			setup for SLEEP interval. WAIT is cleaner but not power saving, 
			however overall effect is still the same
 






























