  'this program writes to and reads from a pcf8563 rtc. It
  'manipulates I2C bus using MICROMITE SYNTAX
  'to write to I2C registers use
  'I2C write &H51,0,n,data1,...,datan
  'where n = number of data bytes to send
  'data1 is starting register position
  'data2 ... datan are n-1 data bytes to send
  'register pointer is automatically updated for each byte
  'to read from I2C device:
  'first WRITE 1 byte to the device giving the register start address to read from eg
  'i2c write &H51,0,1,regaddress
  'then read data from the device eg
  'i2c read &H51,0,n,reg(0)
  'will read n bytes from device beginning from regaddress and storing bytes in array reg()
  'NOTE rtc ADDRESS to use is &H51 and NOT &HA2 as indicated in data sheet
  'subroutines available:
  '(1)  rtc gettime   sets MM time from RTC time
  '(2)  getflag   determines whether timer or alarm triggered interrupt
  '(3)  setrtctime    sets rtc time using keypad as input
  '(4)  readRTC(sec,min,hour,day,month,year) returns RTC time & date
  '(5)  readalarm(am,ah)  returns alarm data
  '(6)  setalarm    sets alarm using keypad input
  '(7)  settimer    sets timer data using keypad input
  
  option autorun on
  setpin 10,intl,timerint:setpin 9,dout:setpin 7,dout   'rtc interrupt pin
  DIM reg(15),a$(3)        'array to hold register values
  a$(0) = "timer interrupt":a$(1) = "alarm interrupt"
  a$(2) = "sec":a$(3) = "min"
  keypad keycode,keyint,2,3,4,5,14,15,16 'initialise keypad
  lcd init 23,24,25,26,21,22    'initialise LCD
  I2C open 400,100    ' Enable I2C bus
  gosub alarmoff  'clear alarm & timer functiom
  i2c write &H51,0,3,&H0E,1,0 'disable timer
  settick 86400000,resetmmclock   'reset MMclock from RTC once per day
  
  'main routine to keep reading time & alarm data from rtc
  do
    readrtc(s,m,h,d,mo,y)  'read & print time & alarm details
    tim$ = right$("0"+str$(h),2)+":"+right$("0"+str$(m),2)
    dat$ = "   "+right$("0"+str$(d),2)+"/"+right$("0"+str$(mo),2)
    'dat$ =  dat$+right$("0"+str$(s),2)
    tim$ = tim$+":"+right$("0"+str$(s),2)+dat$
    lcd 1,1,tim$
    lcd 2,1,alarm$
    lcd 2,10,timr$
    if keycode = 1 then keycode = 0:setrtctime
    if keycode = 2 then keycode = 0:settimer
    if keycode = 3 then keycode = 0:setalarm
    if keycode = 10 then pin(9) = 0:pin(7) = 0:keycode = 0 'stop alarm but retain setting
    'stop alarm & timer & cancel setting
    if keycode > 10 then pin(9) = 0:pin(7) = 0:keycode = 0:gosub alarmoff
    pause 100
  loop
  
sub readrtc(cs,cm,ch,cd,cmo,cy)
  local t,u
  '1st a write to set the start register address to read from (02)
  'then read 7 values into reg() array starting at reg address 02
  I2C write &H51,0,1,&h2
  I2C READ &H51,0,7,reg(0)
  'convert each value from BCD to decimal
  u = reg(0) and 15 'mask lower 4 bits for seconds units
  t = reg(0)\16 'get upper nibble down as lower nibble note integer division
  t = t and 7   'mask lower 3 bits for tens. 4th bit contains other unneeded info
  cs = 10*t + u  'create decimal value
  u = reg(1) and 15 'mask lower 4 bits for minutes units
  t = reg(1)\16 'get upper nibble down as lower nibble note integer division
  t = t and 7   'mask lower 3 bits for tens. 4th bit contains other unneeded info
  cm = 10*t + u
  u = reg(2) and 15 'mask lower 4 bits for hours units
  t = reg(2)\16 'get upper nibble down as lower nibble note integer division
  t = t and 3   'mask lower 2 bits for tens. 3rd &4th bit contains unneeded info
  ch = 10*t + u  'create decimal value
  
  u = reg(3) and 15 'mask lower 4 bits for days units
  t = reg(3)\16 'get upper nibble down as lower nibble note integer division
  t = t and 3   'mask lower 2 bits for tens.
  cd = 10*t + u  'create decimal value
  u = reg(5) and 15 'mask lower 4 bits for months units
  t = reg(5)\16 'get upper nibble down as lower nibble note integer division
  t = t and 1   'mask lower bit for tens.
  cmo = 10*t + u  'create decimal value
  u = reg(6) and 15 'mask lower 4 bits for years units
  t = reg(6)\16 'get upper nibble down as lower nibble note integer division
  cy = 10*t + u  'create decimal value
end sub
  
timerint:
  gosub getflag 'clear flags & determine cause of interrupt
  '1 = timer;2 = alarm;3 = both responsible for interrupt
  if flag = 1 or flag = 3 then
    pin(7) = 1                 'turn on timer alarm
    i2c write &H51,0,2,&H0E,0   'disable countdown
    timr$ = "no timr"
  endif
  if flag = 2 or flag = 3 then pin(9) = 1 'turn on alarm
  ireturn
  
  ' set RTC time & date
sub setrtctime
  local cs,cm,ch,cd,cy
  ' first set time
  l1$ = "new time? HHMMSS"
  lcd clear
  lcd 1,1,l1$
  num$ = ""
  do while len(num$) < 6
    if keycode > 10 then
      gosub alarmoff  'turn both alarms off
      goto e1
    endif
  loop
  ch = val(left$(num$,2))
  cm = val(mid$(num$,3,2))
  cs = val(right$(num$,2))
  cs = cs\10*16 + (cs mod 10)  'convert to BCD format
  cm = cm\10*16 + (cm mod 10)  'note integer division is used
  ch = ch\10*16 + (ch mod 10)
  i2c write &H51,0,4,&H02,cs,cm,ch  'write s,m,h values to reg beginning at 02
  'now set date
  l1$ = "new date? DDMMYY"
  lcd clear
  lcd 1,1,l1$
  num$ = ""
  do while len(num$) < 6
    if keycode > 10 then
      gosub alarmoff  'turn both alarms off
      goto e1
    endif
  loop
  cd = val(left$(num$,2))
  cm = val(mid$(num$,3,2))
  cy = val(right$(num$,2))
  cd = cd\10*16 + (cd mod 10)  'convert to BCD format
  cm = cm\10*16 + (cm mod 10)  'note integer division is used
  cy = cy\10*16 + (cy mod 10)
  i2c write &H51,0,5,&H05,cd,0,cm,cy  'write d,m,y values to reg beginning at 05
  rtc gettime 'write time info to micromite
e1:
  lcd clear:keycode = 0
end sub
  
keyint:
  if keycode > 10 then goto e2
  if keycode = 10 then
    if len(num$) = 0 then goto e2
    num$ = left$(num$,len(num$) - 1)
    l2$ = num$ + " "
    lcd 2,1,l2$
    goto e2
  endif
  num$ = num$ + str$(keycode)
  lcd 2,1,num$
e2:
  ireturn
  
sub setalarm
  local am,ah,ad,awkd,x
  l1$ = "new alarm? HHMM"
  lcd clear
  lcd 1,1,l1$
  num$ = ""
  i2c write &H51,0,1,1
  i2c read &H51,0,1,reg(1) 'get current state of control register 2
  do while len(num$) < 4
    if keycode > 10 then
      x = reg(1) and &B00010101 'get rtctimer info because we don't want to change that
      i2c write &H51,0,2,1,x 'cancel alarm and retain timer status
      alarm$ = "no alarm "
      goto e3
    endif
  loop
  ah = val(left$(num$,2))       'extract alarm time
  am = val(right$(num$,2))
  'now manufacture alarm string for LCD output
  alarm$  = right$("0"+str$(ah),2)+":"+right$("0"+str$(am),2)
  ah = ah\10*16 + (ah mod 10)  'convert to BCD format
  am = am\10*16 + (am mod 10)  'note integer division is used
  ad = 128     'voids date in alarm
  awkd = 128     'voids weekday in alarm
  i2c write &H51,0,5,&H09,am,ah,ad,awkd  'write alarm values to reg beginning at 09
  x = reg(1) and &B00010101 'get rtctimer info because we don't want to change that
  x = x or &B00010010   'add back alarm enable
  i2c write &H51,0,2,1,x 'set alarm, clear INT flags and retain timer status
e3:
  lcd clear:keycode = 0
end sub
  
alarmoff:
  i2c write &H51,0,2,1,0 'clear alarm & INT flag
  alarm$ = "no alarm ":timr$ = "no timr"
  return
  
getflag:
  'read AF & TF flags to determine which process caused interrupt
  'and reset that flag.
  local x
  i2c write &H51,0,1,1
  i2c read &H51,0,1,reg(1)  'read contents of control reg 2
  x = reg(1) and &B00010011 'mask out flag info
  i2c write &H51,0,2,1,x      'write back & clear AF & TF flags
  flag = (reg(1) and &B00001100)/4
  'flag = 1 --> timer triggered interrupt
  'flag = 2 --> alarm triggered interrupt;flag = 3 -->both responsibl
  return
  
sub settimer
  'this sets the countdown timer for immediate action
  'count is byte value (0 to 255)to count down from and minsec is the unit
  'of time to use for count. 2 = seconds;3 = minutes
  i2c write &H51,0,1,1
  i2c read &H51,0,1,reg(1) 'get current state of control register 2
  local x,count,unit
start:
  l1$ = "value (<256) DDD"
  lcd clear
  lcd 1,1,l1$
  num$ = ""
  do while len(num$) < 3
    if keycode > 10 then    'cancel timer function
      x = reg(1) and &B00011010 'get alarm info because we don't want to change that
      i2c write &H51,0,2,1,x 'cancel timer and retain alarm status
      timr$ = "no timr"
      goto e4
    endif
  loop
  count = val(num$)
  timr$ = num$
  if count > 255 then goto start  'invalid count
start2:
  l1$ = "units? Min=3 S=2"
  lcd clear
  lcd 1,1,l1$
  num$ = ""
  do while len(num$) < 1
    if keycode > 10 then    'cancel timer function
      x = reg(1) and &B00011010 'get alarm info because we don't want to change that
      i2c write &H51,0,2,1,x 'cancel timer and retain alarm status
      timr$ = "no timr"
      goto e4
    endif
  loop
  unit = val(num$)
  if unit <> 3 and unit <> 2 then goto start2
  'now manufacture alarm string for LCD output
  timr$  = timr$ + " "+a$(unit)
  x = reg(1) and &B00011010   'mask: keeps alarm details & rejects timer details
  x = x or &B00010001   'adds back timer enable
  i2c write &H51,0,2,1,x  'clears timer flag,enables timer interrupt
  unit = 128 + unit    'write countdown values & activate countdown timer
  i2c write &H51,0,3,&H0E,unit,count
e4:
  lcd clear:keycode = 0
end sub
  
sub readalarm(am,ah)
  local t,u
  '1st a write to set the start register address to read from (02)
  'then read 3 values into reg() array starting at reg address 02
  I2C write &H51,0,1,&h9
  I2C READ &H51,0,3,reg(9)
  'convert each value from BCD to decimal
  u = reg(9) and 15 'mask lower 4 bits for seconds units
  t = reg(9)\16 'get upper nibble down as lower nibble note integer division
  t = t and 7   'mask lower 3 bits for tens. 4th bit contains other unneeded info
  am = 10*t + u  'create decimal value
  u = reg(10) and 15 'mask lower 4 bits for hours units
  t = reg(10)\16 'get upper nibble down as lower nibble note integer division
  t = t and 3   'mask lower 2 bits for tens. 3rd &4th bit contains unneeded info
  ah = 10*t + u  'create decimal value
end sub
  
resetmmclock:
  rtc gettime
  ireturn
