  ' This program uses an EM-408 GPS module to obtain GMT.
  ' It then adds the timezone and adjusts for daylight saving
  ' The result is displayed on a 2x16 ARDUINO LCD SHIELD & a 4D LED display
  ' A 7-day alarm function has individual alarm settings for each day
  ' The ARDUINO shield buttons are used to set the alarm
  ' Alarm information is stored in non volatile memory
  'I/O 2 <-> interrupt to reset LCD display,
  'I/O 3 <-> heartbeat
  'I/O 4 <-> D4;I/O 5 <-> D5;I/O 6 <-> D6;I/O 7 <-> D7
  'I/O 9 <-> RS;I/O 10 <-> EN;I/O 14 <-> RLY control
  'I/O 15 <-> A;I/O 16 <-> B;I/O 17 <-> C;I/O 18 <-> D inputs for 4511
  'I/O 23 & I/O 24 go to 74238 to multiplex 4 LED displays
  'I/O 25 <-> A0;I/O 26 <-> alarm set
  'previous lcd used a 5.6k resistor at A0
  '& had voltages of 2.76,1.96,1.35,.77 & .23
  'current display require a 3.9k resistor at A0 to get 3.27 V
  CPU 48
  TimeZone = 10.0        ' hours from GMT (+ or -)
  DST = 1            ' set to 1 to enable daylight saving for EDST
  SetPin 2,intl,initlcd:SetPin 3,dout:setpin 14,dout
  For i = 15 To 18:SetPin i,oout:Next i
  SetPin 23,dout:SetPin 24,dout:SetPin 25,ain:SetPin 26,din
  SetTick 25,display
  Dim m(3),a(3,6),d(12), arg$(20) length 80,month(12)
  Dim day$(6),item$(4)length 5
  For i = 1 To 12: Read month(i),d(i): Next i
  For i = 0 To 3:Read item$(i),m(i):Next i
  For i = 0 To 6
    Read day$(i):for j = 0 to 2 step 2:a(j,i) = 7:a(j+1,i)=0:Next j
  next i
  Data 31,0,28,31,31,59,30,90,31,120,30,151
  Data 31,181,31,212,30,243,31,273,30,304,31,334
  Data "ON HR",25,"ON MN",60,"OFFHR",24,"OFFMN",60
  Data "SUN","MON","TUE","WED","THU","FRI","SAT"
  Restore
  month$ = "  JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC"
  initlcd         ' setup the LCD for display
  Open "COM1:4800" As #1           ' open the GPS serial interface
  a$ = "24002400240024002400240024002400240024002400240024002400"   'initial alarm data
  var restore                      'retrieve previously stored alarm info
    for j = 0 to 48 step 8:for i = 0 to 6 step 2
      a(i/2,j/8) = val(mid$(a$,i+j+1,2))
  next i:next j
  Do          ' this is the main program loop, it never exits
KeepSearching:
    Do
      GetGPSRecord                      ' get a GPS record
    Loop Until arg$(0) = "GPRMC"        ' we only want the RMC record
    If arg$(2) <> "A" Then              ' "A" means valid record
      printLCD 1, 1, "Searching"
      printLCD 2,1, "For Satellites"
      GoTo KeepSearching                ' go back and keep looking
    EndIf
    ' the GPS has the valid time
    ' first extract the elements of the date/time from the GPS record
    year = Val(Right$(arg$(9), 2))       ' extract the date
    month = Val(Mid$(arg$(9), 3, 2))
    day = Val(Left$(arg$(9), 2))
    hour = Val(Left$(arg$(1), 2))        ' extract the time
    If hour >= Abs(timezone) Or timezone >= 0 Then
      hour = hour + timezone
    Else
      hour = 24 + hour + timezone
      day = day - 1
    EndIf
    min = Val(Mid$(arg$(1), 3, 2))
    sec = Val(Mid$(arg$(1), 5, 2)) + 1    ' because we will display
    'the time at the start of the next second have to add 1 second to the current time
    am$ = " AM"
    If sec >= 60 Then sec = sec - 60 : min = min + 1
    If min >= 60 Then min = min - 60 :hour = hour + 1
    If hour >= 24 Then hour = hour - 24:day = day + 1
    If year Mod 4 = 0 Then
      month(2) = 29
    Else
      month(2) = 28
    EndIf
    If day > month(month) Then day = day - month(month):month = month + 1
    If month > 12 Then month = month - 12:year = year + 1
    If DST Then GoSub dst                   ' check daylight saving
    current = hour*60 + min
    'current$ = right$("0"+Str$(hour),2)+":"+Right$("0"+Str$(min),2) '24hr time
    If hour >= 12 Then am$ = " PM"
    If hour > 12 Then hour = hour - 12
    get_weekday (weekday,day,month,year)
    line1$ = day$(weekday)+" "+Str$(day)+"-"+Mid$(month$,3*month,3)
    line1$ = line1$ + "-" + "20" + Str$(year) + " "
    line2$ = "  "+right$("0"+Str$(hour),2)+":"+Right$("0"+Str$(min),2)+":"
    line2$ = line2$ + Right$("0"+Str$(sec),2) + am$ + "   "
    alarmon = a(0,weekday)*60 + a(1,weekday)
    alarmoff = a(2,weekday)*60 + a(3,weekday)
    'alarmon$ = right$("0"+Str$(a(0,weekday)),2)+":"+right$("0"+Str$(a(1,weekday)),2)
    'alarmoff$ = right$("0"+Str$(a(2,weekday)),2)+":"+right$("0"+Str$(a(3,weekday)),2)
    'we now have the date/time for the next second ready for display
    'we have to wait for the end of the data stream from the GPS then
    'we wait for the start of the next second and only then update the LCD
    'Do
    'Loop While Timer < 500                ' wait for the data to finish
    v = Pin(25)           'read & decode ADC pin 10
    If v <= 2.87 Then adjust_alarm      'branch on any key
    if pin(26) = 1 and a(0,weekday) < 24 then                 'check alarm state
      if current >= alarmon and current < alarmoff then
        pin(14) = 1
      else
        pin(14) = 0
      endif
    else
      pin(14) = 0
    endif
    Do
    Loop While Input$(200, #1) <> ""      ' clear the input buffer
    Do While Input$(1, #1) <> "$"
    Loop       ' wait for a new second to start
    ' display the date and time for this second
    printLCD 1, 0, Line1$
    printLCD 2, 0, Line2$
    number$ = Right$("0"+Str$(hour),2) + Right$("0"+Str$(min),2)
    pin(3) = 0
    If tick Then Pin(3) = 1             'heartbeat
    tick = Not(tick)
  Loop
Sub adjust_alarm
  Local i
  SetTick 0,display:item = 0:dy = 0
  newkey = 6
  GoSub printall
  Pause 1000
  Do
    Do
      GoSub instruction
      If newkey = 5 Then      'this is exit from alarm set condition
        SetTick 25,display      'restart interrupt
        a$ = ""
          for j = 0 to 6:for i = 0 to 3   'put alarm info into a$
            a$ = a$ + right$("0"+str$(a(i,j)),2)
        next i:next j
        var save a$             'permanently save alarm info
        Exit Sub                  'go back to clock function
      endif
    Loop Until newkey < 5
    On newkey GoSub nextitem,nextday,up 'branch appropriately
    Pause 500
  Loop
  SetTick 25,display      'restart interrupt
  exit sub
End Sub
nextitem:
  item = (item + 1) Mod 4     'go on to next item
  GoSub printall
  Return
up:      'newkey 3 = change item value
  a(item,dy) = (a(item,dy) + inc) Mod m(item)
  if a(item,dy) < 0 then a(item,dy) = m(item) - 1
  GoSub printall
  Return
nextday:    ' go to next day
  dy = (dy +1) mod 7
  item = 0
  GoSub printall
  Return
instruction:
  v = Pin(25)    'read & decode ADC pin 10
  If v > 2.89 Then newkey = 6:Return
  If v > 2.21 And v <= 2.89 Then newkey = 2     'add to memory
  If v > 1.59 And v <= 2.21 Then newkey = 1     'select item
  If v > .957 And v <= 1.59 Then newkey = 3:inc = -1   'down
  If v > .307 And v <= .957 Then newkey =3:inc = 1      'up
  If v <= .307 Then newkey = 5                  'exit
  Return
printall:
  printlcd 1,0,"set "+ item$(item) + "       " 'print instruction
  if a(0,dy) = 24 then
    line2$ = day$(dy) + "  NO ALARM   "
    a(2,dy) = 24
  else
    line2$ = day$(dy)+" "+Right$("0"+Str$(a(0,dy)),2)+":"
    line2$ = line2$+Right$("0"+Str$(a(1,dy)),2)+"  "+Right$("0"+Str$(a(2,dy)),2)
    line2$ = line2$+":"+Right$("0"+Str$(a(3,dy)),2)
  endif
  printlcd 2,0,line2$
  Return
  ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  'subroutine to adjust for DST
  ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
dst:
  local dsstart,dsend,current
  get_weekday dsstart,1,10,year       'get 1st day of month daylight saving starts
  dsstart = (7 - dsstart)            'get day of 1st Sunday
  dsstart = ((d(10) + dsstart)*24 + 2)*3600 'convert to seconds from start of year
  get_weekday dsend,1,4,year          'get 1st day of month daylight saving end
  dsend = (7 - dsend)                 'get day of 1st Sunday
  dsend = ((d(4) + dsend)*24 + 2)*3600        'convert to seconds from start of year
  current = (((d(month)+day-1)*24+hour)*60+min)*60+sec  'convert current time to seconds
  If current >= dsstart Or current < dsend Then hour=hour+1'test for DS
  If hour >= 24 Then hour = hour - 24:day = day + 1   'adjust for consequential changes
  If day > month(month) Then day = day - month(month):month = month + 1
  If month > 12 Then month = month - 12:year = year + 1
  Return
  ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' subroutine to get a GPS record into the array arg$()
  ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub GetGPSRecord
  Do
    Do While Input$(1, #1) <> "$" :Loop   ' wait for the start
    For i = 0 To 20
      arg$(i) = ""                         ' clear ready for data
      Do                                   ' loops until a specific exit
        x$ = Input$(1, #1)                 ' get the character
        If x$ = "," Then Exit Do           ' new data item, new field
        If x$ = "*" Then Exit Sub       ' end of record, so return with it
        arg$(i) = arg$(i) + x$             ' add to the data
      Loop                                 ' keep going
    Next i                                 ' increment the field
  Loop
End Sub
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  'subroutine to get day of week for a given date
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub get_weekday (wd,d,m,y)
  Local iyear,days
  iyear = 13: DAYS = 0
  While iyear < y
    If iyear Mod 4 = 0 Then DAYS = DAYS + 366 Else DAYS = DAYS + 365
    iyear = iyear + 1
  Wend
  DAYS = DAYS + D(m) + d
  If month > 2 And iyear Mod 4 = 0 Then DAYS = DAYS + 1
  wd = (DAYS + 1) Mod 7
End Sub
  'this subroutine displays number$ on LED display.
Sub display
  Local i
  For i = 1 To  4                   'get each digit in turn
    Port(15,4) = 10                 'blank display
    Port(23,2) = i-1                 'turn on current display
    Port(15,4) = Val(Mid$(number$,i,1))  'display current digit
    Pause 1                         'adjust brightness
  Next i                            'get next digit
  For i = 1 To 2:Next i             'adjust brightness of last digit
  Port(15,4) = 10                   'then turn it off
  port(23,2) = 2
End Sub
  'This program uses subroutines to print text at any position
  'on a 2x16 LCD screen
  'use printlcd (line number [1 or 2]),(place on line [0 to 15]),(text to print)
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' Initialise the LCD
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub InitLCD
  Local i
  For i = 4 To 7: SetPin i, dout : Next i     'all digital output
  SetPin 9,dout:SetPin 10,dout
  LCD1 &B0011, 0:Pause 5                  ' reset
  LCD1 &B0011, 0:Pause 5                  ' reset
  LCD1 &B0011, 0:Pause 5             ' reset
  LCD1 &B0010, 0:Pause 5                 ' 4 bit mode
  LCD1&B0010, 0:Pause 2: LCD1 &B1100,0:Pause 2 ' 4 bits, 2 lines
  LCD1 &B0000,0:Pause  2: LCD1 &B1100,0:Pause 2' display on, no cursor
  LCD1 &B0000,0:Pause 2:  LCD1 &B0110,0:Pause 2  ' increment on write
  LCD1 &B0000,0:Pause 2 : LCD1 &B0001,0:Pause 2    ' clear the disply
End Sub
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  'this subroutine can be called to clear display
  ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub clearlcd
  lcd1 0,0:Pause 2:lcd1 1,0
End Sub
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' Display a line on the LCD
  ' argument #1 is the line to be used (1 or 2)
  ' argument #2 is the position on line to start display (0-15)
  'argument #3 is text to display
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub PrintLCD (lin, place, text$ )
  Local i, c,position
  ' first send the cursor position (in two nibbles)
  position = &h80 + (lin - 1)*64 + place
  LCD1 Int(position/16),0 : LCD1 position,0
  ' then send the text character by character (two nibbles per character)
  For i = 1 To Len(text$)
    c = Asc(Mid$(text$, i, 1))
    LCD1 Int(c/16), 1 : LCD1 c, 1
  Next i
End Sub
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' Send the lower nibble to the LCD
  ' argument #1 is the nibble to send
  ' argument #2 is 1 for data, 0 for command
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub LCD1(data1, Flag )
  Pin(9) = Flag
  Port(4,4) = data1
  Pin(10) = 1 :Pause 1: Pin(10) = 0
End Sub
