  'BISTRO PAGING SYSTEM _ GUEST PAGER _ (bistropager_14m2.bas)

'Enter your own "system code" and "pager code" before programming the micro.
'Both these codes can be found at the start of the program under "power_up" 
'Use the same "system code" in in the base station and all the guest pagers.
'Use a different "pager code" for each pager - the codes 00 to 99 are valid..
'Programed guest pagers should be identified by adding a pager number label.


power_up:'----- setup micro - save local code numbers - latch relay 
pause 2
b11=1: b12=2: b13=3: b14=4: b15=5: b16=6' (system code "123456") 
b17=0: b18=1' (pager code "01")
pause 2
let dirsB = %00111111 : let pinsB = %00000000
let dirsC = %00010011 : let pinsC = %00000011
pullup %0000010000000000
'goto start_up

start_up:'----- two beeps and flash LED0 and LED5 as pager turns on
pause 2 
high C.4: high B.0
pause 1200
low C.4: low B.0
pause 800
high C.4: high B.5
pause 1200
low C.4: low B.5
'goto stand_by

stand_by:'----- wait untill codes are received from the base station
pause 2
rfin C.3,b1,b2,b3,b4,b5,b6,b7,b8
'goto check_codes

check_codes:'-- check that the received and saved code numbers match
b10 = 0
if b1=b11 and b2=b12 and b3=b13 and b4=b14 then: b10=2: endif
if b5=b15 and b6=b16 and b7=b17 and b8=b18 and b10=2 then goto alarm_a
goto stand_by

alarm_a:'------ run the first alarm sequence driving LEDs and buzzer
low C.1
if pinC.2 = 0 then: b10=3: else b10=6: endif' (check test link) 
for b0 = 1 to b10
high C.4
high B.0: pause 250: low B.0
high B.1: pause 250: low B.1
high B.2: pause 250: low B.2
low C.4
high B.3: pause 250: low B.3
high B.4: pause 250: low B.4
high B.5: pause 250: low B.5
next b0
'goto alarm_b

alarm_b:'------ run the second alarm sequence driving only six LEDs
pause 2
if pinC.2 = 0 then: b10=3: else b10=22: endif' (check test link)  
for b0 = 1 to b10
high B.0: pause 250: low B.0
high B.1: pause 250: low B.1
high B.2: pause 250: low B.2
high B.3: pause 250: low B.3
high B.4: pause 250: low B.4
high B.5: pause 250: low B.5
next b0
'goto pager_off

pager_off:'---- turn off the relay coil to shut down the pager unit
low C.0
sleep 2



'Definition of Variables

'b1 to b8 = received codes (system/pager)
'b11 to b18 = local codes (system/pager) 
'b0 & b10 = temp variables