'BISTRO PAGING SYSTEM _ BASE STATION _ (bistrobase_20m2.bas)

'You may wish to select your own "system code" before programming the micro.
'The "system code" can be found at the start of the program under "power_up". 
'Use the same "system code" in in the base station and all the guest pagers.
'The guest pagers also include an additional "pager code" (between 00 to 99).
'Refer to the (bistropager_14m2) program notes for details on setting codes.  


power_up:' --------- initalise micro and load the defalt system code
pause 2
b1 = 1: b2 = 2: b3 = 3: b4 = 4: b5 = 5: b6 = 6'(system code 123456)
setfreq m16
let dirsB = %11111000: let pinsB = %00000000
let dirsC = %10111111: let pinsC = %00000000
pullup %0100000000000000
'goto display_mode


display_mode:'------ drive 7 segment displays and detect any key press
'(units)
on b8 gosub zero,one,two,three,four,five,six,seven,eight,nine,blank
high B.6
pause 14
readadc B.1,b11
readadc B.2,b12
readadc B.3,b13
low B.6

'(tens)
on b7 gosub zero,one,two,three,four,five,six,seven,eight,nine,blank
high B.7
pause 14
if b11 > 15 then: goto keypad_mode: endif
if b12 > 15 then: goto keypad_mode: endif 
if b13 > 15 then: goto keypad_mode: endif
low B.7
goto display_mode

'(segment data)
blank: pinsC = %00000000: return
one:   pinsC = %00000110: return
two:   pinsC = %10011011: return
three: pinsC = %10001111: return
four:  pinsC = %10100110: return
five:  pinsC = %10101101: return
six:   pinsC = %10111100: return
seven: pinsC = %00000111: return
eight: pinsC = %10111111: return 
nine:  pinsC = %10100111: return
zero:  pinsC = %00111111: return


keypad_mode:'------ decode each key press with de-bounce and beep sound  
low B.7
high B.0

'(star * key)
if b11 > 36 and b11 < 66 then: b7 = 10: b8 = 10: goto de_bounce: endif' (blank key)

'(hash # key)
if b13 > 36 and b13 < 66 then goto transmit_mode' (call key)

'(0 to 9 keys)
b7 = b8
if b11 > 87 then: b8 = 7: endif
if b11 >138 then: b8 = 4: endif
if b11 >189 then: b8 = 1: endif
if b12 > 36 then: b8 = 0: endif
if b12 > 87 then: b8 = 8: endif
if b12 >138 then: b8 = 5: endif 
if b12 >189 then: b8 = 2: endif
if b13 > 87 then: b8 = 9: endif
if b13 >138 then: b8 = 6: endif 
if b13 >189 then: b8 = 3: endif
goto de_bounce



transmit_mode:'---- power the TX module and send 8 bytes of data (3 times) 
high B.4
rfout B.5,(b1,b2,b3,b4,b5,b6,b7,b8)
pause 100
rfout B.5,(b1,b2,b3,b4,b5,b6,b7,b8)
pause 100
rfout B.5,(b1,b2,b3,b4,b5,b6,b7,b8)
low B.4
'goto de_bounce


de_bounce:'--------  wait for "000" on the keypad inputs before continuing 
readadc B.1,b11
readadc B.2,b12
readadc B.3,b13
if b11 = 0 and b12 = 0 and b13 = 0 then:low B.0: goto display_mode: endif
goto de_bounce




'Definition of Variables

'b1 - b6 = system code
'b7 & b8 = pager code
'b11-b13 = keypad sense