
 
; Courtesy Lights


;	ERRORLEVEL -302
;	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_CLKOUT	



; RAM 

STORE1			equ	H'20'	; delay counter	
STORE2			equ	H'21'	; delay counter
TIMER			equ	H'22'	; run timer



; ******************************************************************

; start at memory 0

	org		0			; reset vector
	nop					; 0
	nop					; 1
	nop					; 2
	nop					; 3
	goto	MAIN		; 4

; *********************************************
; pot non-linearisation part of from A/D readings from 192 to 255
NON_LIN
	addwf 	PCL,f			; lookup table for feedback control

;  A/D readings 192 to 255 

	retlw	D'129'			; 192
	retlw	D'131'			; 193 
	retlw	D'133'			; 194 
	retlw	D'135'			; 195
	retlw	D'137'			; 196
	retlw	D'139'			; 197
	retlw	D'141'			; 198
	retlw	D'143'			; 199  
	retlw	D'145'			; 200
	retlw	D'147'			; 201
	retlw	D'149'			; 202
	retlw	D'151'			; 203 
	retlw	D'153'			; 204 
	retlw	D'155'			; 205
	retlw	D'157'			; 206
	retlw	D'159'			; 207
	retlw	D'161'			; 208
	retlw	D'163'			; 209  
	retlw	D'165'			; 210
	retlw	D'167'			; 211
	retlw	D'169'			; 212
	retlw	D'171'			; 213 
	retlw	D'173'			; 214 
	retlw	D'175'			; 215
	retlw	D'177'			; 216
	retlw	D'179'			; 217
	retlw	D'181'			; 218
	retlw	D'183'			; 219  
	retlw	D'185'			; 220
	retlw	D'187'			; 221
	retlw	D'189'			; 222
	retlw	D'191'			; 223 
	retlw	D'193'			; 224 
	retlw	D'195'			; 225
	retlw	D'197'			; 226
	retlw	D'199'			; 227
	retlw	D'201'			; 228
	retlw	D'203'			; 229  
	retlw	D'205'			; 230
	retlw	D'207'			; 231
	retlw	D'209'			; 232
	retlw	D'211'			; 233 
	retlw	D'213'			; 234 
	retlw	D'215'			; 235
	retlw	D'217'			; 236
	retlw	D'219'			; 237
	retlw	D'221'			; 238
	retlw	D'223'			; 239  
	retlw	D'225'			; 240
	retlw	D'227'			; 241
	retlw	D'229'			; 242
	retlw	D'231'			; 243 
	retlw	D'233'			; 244 
	retlw	D'235'			; 245
	retlw	D'237'			; 246
	retlw	D'239'			; 247
	retlw	D'241'			; 248
	retlw	D'243'			; 249  
	retlw	D'245'			; 250
	retlw	D'247'			; 251
	retlw	D'249'			; 252
	retlw	D'251'			; 253 
	retlw	D'253'			; 254 
	retlw	D'255'			; 255
	retlw	D'255'			; 256


	
MAIN
; set oscillator calibration
	bsf		STATUS,RP0	; bank 1
	call	H'3FF'		; get oscillator calibration value
	movwf	OSCCAL
	bcf		STATUS,RP0	; select memory bank 0

; set inputs/outputs
	clrf	GPIO		; outputs low
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00100100'	; pullup on GP5 and GP2
	movwf	WPU
	movlw	B'00101110'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'00000000'	; settings (pullups enabled) falling edge interrupt for GP2
	movwf	OPTION_REG
	
; analog inputs, A/D
	movlw	B'01010010'	; AN1 analog input 
	movwf	ANSEL
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00000100'	; channel 1 left justified, VDD ref etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
; TIMER1
	movlw	B'00110000'	; /8 prescaler. timer1 1MHz/(8 x 65536)(overflow @ 524ms)
	movwf	T1CON

	
; initial conditions
; power up settings
; powered settings
END_OF_COURTESY			; courtesy lights out
	call 	DELAY
	bsf		GPIO,0		; power off timer trimpot

; falling edge interrupt
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000000'	; settings (pullups enabled) falling edge interrupt for GP2
	movwf	OPTION_REG
	bcf		STATUS,RP0	; select memory bank 0

; set initial door switch closing interrupt operation

	bsf		PIR1,TMR1IE	; timer1 interrupt flag enable
	bcf		INTCON,INTF	; clear interrupt flag
	bsf		INTCON,INTE	; enable interrupt

; waits here for falling level on GP2
	sleep				; wakes on interrupt
	nop
; processor runs and clock out drives Mosfet on via isolation transformer


; rising edge interrupt
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01000000'	; settings (pullups enabled) rising edge interrupt for GP2
	movwf	OPTION_REG
	bcf		STATUS,RP0	; select memory bank 0

; set initial door switch opening interrupt operation

	bsf		PIR1,TMR1IE	; timer1 interrupt flag enable
	bcf		INTCON,INTF	; clear interrupt flag
	bsf		INTCON,INTE	; enable interrupt

; waits here for rising level on GP2
	sleep				; wakes on interrupt
	nop
; processor runs and clock out drives Mosfet on via isolation transformer

	bcf		INTCON,INTE	; disable interrupt


; measure timer potentiometer
; channel 1 
	bcf		GPIO,0		; power timer trimpot
	call 	DELAY

; routine to wait for A/D conversion
A_D
	bsf		ADCON0,GO_DONE	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,GO_DONE	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	bcf		STATUS,C	; clear carry	
	movf	ADRESH,w
	sublw	D'2'		; minimum 1s
	movlw	D'2'		; set 2 ready to load
	btfss	STATUS,C	; if negative use ADRESH value. Otherwise set at 2 minimum	
	movf	ADRESH,w
	movwf	TIMER		; load timer


; non-linearise trimpot for easier adjustment at lower time periods
; if from 0-127 divide by 2
; check for <128
	movlw	D'128'
	subwf	TIMER,w
; if negative A/D < 127
	btfsc	STATUS,C
	goto	NEXT_RANGE1
	bcf		STATUS,C
	rrf		TIMER,w		; divide by 2 for 0-63 0.524s per count =(1-33s)
	goto	SET_TIMER		

NEXT_RANGE1
; if from 128 to 191 take 64 away
; check for <192
	movlw	D'192'
	subwf	TIMER,w
; if negative is A/D < 191
	btfsc	STATUS,C
	goto	NEXT_RANGE2
	movlw	D'64'
	subwf	TIMER,w		; subtract 64 for a range of 64 to 127 (33-66s)
	goto	SET_TIMER

NEXT_RANGE2
; if 192 to 255 use lookup table
	call	NON_LIN		; lookup table (66-133s)		
	
SET_TIMER
	movwf	TIMER		; non-linearised timer value	

	bsf		GPIO,0		; power off timer trimpot
	bcf		PIR1,TMR1IF	; clear timer1 flag
	clrf	TMR1L		; clear timer1
	clrf	TMR1H
	bsf		T1CON,0		; timer 1 on

; wait for timer1 flag
TIMING
	btfss	PIR1,TMR1IF
	goto	TEST_OFF
	bsf		GPIO,0
	bcf		PIR1,TMR1IF	; clear timer overflow flag
	decfsz	TIMER,f		; decrease timer
	goto	TEST_OFF
	goto	END_OF_COURTESY; timed out

TEST_OFF
; test if ignition or headlights are on or off

	btfss	GPIO,5		; if low, ignition or headlights are on so end timer
	goto	END_OF_COURTESY; end of courtesy lights due to ign. or headlights
	goto 	TIMING	; continue with timeout

; delay loop 

DELAY
	movlw	D'255'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	D'255'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	clrwdt
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

                

	end
