/* ****************************************************************************
 * File:      i2c
 * Date:      6 Jan 2025
 * Author:    Andrew Levido
 *
 * Copyright 2025 Imbrius Pty Ltd - All Rights Reserved
 *
 *****************************************************************************/
#ifndef _i2c_H
#define _i2c_H

#ifdef __cplusplus
extern "C" {
#endif

/* Description ---------------------------------------------------------------*/

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include <stdbool.h>

/* Defines -------------------------------------------------------------------*/

/* Typedefs & Enumerations ---------------------------------------------------*/
typedef enum { I2C_OK, I2C_ERR_PARAM, I2C_ERR_NACK, I2C_ERR_TIMEOUT } i2c_result_t; 

/* Public Functions Declarations ---------------------------------------------*/

/** Write data to device
 * 
 *  Writes a leading byte (register address or control byte) then n bits
 *  of data to the nominated device.
 * 
 *  @param device       7-bit device address
 *  @param reg          register address/control leading byte
 *  @param data         pointer to data to write
 *  @param data_len     length of data in bytes 0-254
 *  @returns            enumerated result type
 */
i2c_result_t i2c_write(uint8_t device, uint8_t reg, uint8_t * data, 
                      uint8_t data_len);

 /** Read data from device
 * 
 *  Optionally writes a register address then reads n data bytes from the device
 * 
 *  @param device       7-bit device address
 *  @param reg          register address/control leading byte
 *  @param data         pointer to storage for read data
 *  @param data_len     length of data in bytes (min 1)
 *  @param skip_reg     skip sending reg address if true
 *  @returns            enumerated result type
 */
i2c_result_t i2c_read(uint8_t device, uint8_t reg, uint8_t * data, 
                      uint8_t data_len, bool skip_reg);

/* Interrupt Service Routine Declarations ------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif

/* End i2c */