/* *****************************************************************************
 * File:      beep.c
 * Date:      26 Dec 2024
 * Author:    Andrew Levido
 *
 * Copyright 2025 Imbrius Pty Ltd - All Rights Reserved
 *
 ******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "beep.h"
#include <stdbool.h>

/* Defines -------------------------------------------------------------------*/


/* Typedefs & Enumerations ---------------------------------------------------*/

/* Global Variables ----------------------------------------------------------*/
static struct {
  volatile uint16_t note_counter;
} bp;

/* Private Functions ---------------------------------------------------------*/

/* Public Functions ----------------------------------------------------------*/
void beep(note_t freq, uint16_t period)
{
  if(freq == 0) { return;}

  beep_stop();
  
  // calculate period of carrier freq
  uint16_t carrier_period = 3000000L/freq;
  LL_TIM_SetAutoReload(TIM2, carrier_period);
  LL_TIM_OC_SetCompareCH1(TIM2, carrier_period/8);  // 12.5% duty cycle);


  // start timer 
  bp.note_counter = period - 1;
  LL_TIM_CC_EnableChannel(TIM2, LL_TIM_CHANNEL_CH1);
  LL_TIM_EnableCounter(TIM2);
} 

void beep_stop(void)
{
  bp.note_counter = 0;
  LL_TIM_CC_DisableChannel(TIM2, LL_TIM_CHANNEL_CH1);
  LL_TIM_DisableCounter(TIM2);
}

/* Interrupt Service Routines ------------------------------------------------*/
void beep_1ms_tick(void)
{
  if(bp.note_counter != 0) { 
    if(bp.note_counter != BEEP_FOREVER) { bp.note_counter--; }
    if(bp.note_counter == 0) {
      beep_stop();
    }
  }
}

/* End beep */