/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.h
  * @brief          : Header for main.c file.
  *                   This file contains the common defines of the application.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2025 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32l0xx_ll_adc.h"
#include "stm32l0xx_ll_comp.h"
#include "stm32l0xx_ll_exti.h"
#include "stm32l0xx_ll_i2c.h"
#include "stm32l0xx_ll_crs.h"
#include "stm32l0xx_ll_rcc.h"
#include "stm32l0xx_ll_bus.h"
#include "stm32l0xx_ll_system.h"
#include "stm32l0xx_ll_cortex.h"
#include "stm32l0xx_ll_utils.h"
#include "stm32l0xx_ll_pwr.h"
#include "stm32l0xx_ll_dma.h"
#include "stm32l0xx_ll_tim.h"
#include "stm32l0xx_ll_gpio.h"

#if defined(USE_FULL_ASSERT)
#include "stm32_assert.h"
#endif /* USE_FULL_ASSERT */

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Exported types ------------------------------------------------------------*/
/* USER CODE BEGIN ET */

/* USER CODE END ET */

/* Exported constants --------------------------------------------------------*/
/* USER CODE BEGIN EC */

/* USER CODE END EC */

/* Exported macro ------------------------------------------------------------*/
/* USER CODE BEGIN EM */

/* USER CODE END EM */

/* Exported functions prototypes ---------------------------------------------*/
void Error_Handler(void);

/* USER CODE BEGIN EFP */

/* USER CODE END EFP */

/* Private defines -----------------------------------------------------------*/
#define PWR_ON_Pin LL_GPIO_PIN_14
#define PWR_ON_GPIO_Port GPIOC
#define DSP_RST_Pin LL_GPIO_PIN_15
#define DSP_RST_GPIO_Port GPIOC
#define VIN_HI_Pin LL_GPIO_PIN_0
#define VIN_HI_GPIO_Port GPIOA
#define VIN_LO_Pin LL_GPIO_PIN_1
#define VIN_LO_GPIO_Port GPIOA
#define VIN_OFFS_Pin LL_GPIO_PIN_2
#define VIN_OFFS_GPIO_Port GPIOA
#define VIN_LOGIC_Pin LL_GPIO_PIN_3
#define VIN_LOGIC_GPIO_Port GPIOA
#define CONT_OUT_Pin LL_GPIO_PIN_4
#define CONT_OUT_GPIO_Port GPIOA
#define BEEPER_Pin LL_GPIO_PIN_5
#define BEEPER_GPIO_Port GPIOA
#define SET_OFFS_Pin LL_GPIO_PIN_6
#define SET_OFFS_GPIO_Port GPIOA
#define I2C_PU_Pin LL_GPIO_PIN_7
#define I2C_PU_GPIO_Port GPIOA
#define ACC_INT_Pin LL_GPIO_PIN_1
#define ACC_INT_GPIO_Port GPIOB
#define ACC_INT_EXTI_IRQn EXTI0_1_IRQn
#define SCL_Pin LL_GPIO_PIN_9
#define SCL_GPIO_Port GPIOA
#define SDA_Pin LL_GPIO_PIN_10
#define SDA_GPIO_Port GPIOA
#ifndef NVIC_PRIORITYGROUP_0
#define NVIC_PRIORITYGROUP_0         ((uint32_t)0x00000007) /*!< 0 bit  for pre-emption priority,
                                                                 4 bits for subpriority */
#define NVIC_PRIORITYGROUP_1         ((uint32_t)0x00000006) /*!< 1 bit  for pre-emption priority,
                                                                 3 bits for subpriority */
#define NVIC_PRIORITYGROUP_2         ((uint32_t)0x00000005) /*!< 2 bits for pre-emption priority,
                                                                 2 bits for subpriority */
#define NVIC_PRIORITYGROUP_3         ((uint32_t)0x00000004) /*!< 3 bits for pre-emption priority,
                                                                 1 bit  for subpriority */
#define NVIC_PRIORITYGROUP_4         ((uint32_t)0x00000003) /*!< 4 bits for pre-emption priority,
                                                                 0 bit  for subpriority */
#endif

/* USER CODE BEGIN Private defines */

/* USER CODE END Private defines */

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */
