/* ****************************************************************************
 * File:      adc
 * Date:      4 Feb 2025
 * Author:    Andrew Levido
 *
 * Copyright 2025 Imbrius Pty Ltd - All Rights Reserved
 *
 *****************************************************************************/
#ifndef _adc_H
#define _adc_H

#ifdef __cplusplus
extern "C" {
#endif

/* Description -----------------------------------------------------------------
*
*  Hardware and ADC Configuration: Convert ADC0 (IN_HI), ADC1 (IN_LO), 
*  ADC2 (IN_MID) and VREF_INT (IN_REF) in sequence with 256x oversampling. With
*  ADC Clock at 750kHz and 160.5 clocks sample time. This results in a 
*  conversion every 230.66 µs, so 59.05 ms per sample. This is almost 3 full
*  mains cycles (98.4%) so most mains hum is cancelled
*/

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Defines -------------------------------------------------------------------*/


/* Typedefs & Enumerations ---------------------------------------------------*/

/* Public Functions Declarations ---------------------------------------------*/
/** Initialises & starts ADC driver 
 * 
 *  The callback function returns the voltages (IN_HI - IN_MID) and (IN_LO - 
 *  IN_MID) in uints of millivolts.
 * 
 * @param adc_callback          Callback function provides results every 500ms
 */
void adc_start(void(*adc_callback)(int32_t result_hi, int32_t result_lo));

/** Stop ADC driver
 */
void adc_stop(void);

/* Task Function -------------------------------------------------------------*/

/* Interrupt Service Routine Declarations ------------------------------------*/

void adc_ISR(void);

#ifdef __cplusplus
}
#endif

#endif

/* End adc */