/* *****************************************************************************
 * File:      comparator.c
 * Date:      3 Mar 2025
 * Author:    Andrew Levido
 *
 * Copyright 2025 Imbrius Pty Ltd - All Rights Reserved
 *
 ******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "comparator.h"
#include "beep.h"

/* Defines -------------------------------------------------------------------*/

/* Typedefs & Enumerations ---------------------------------------------------*/

/* Global Variables ----------------------------------------------------------*/

/* Private Functions ---------------------------------------------------------*/

/* Public Functions ----------------------------------------------------------*/

void comp_set_threshold(comp_threshold_t thresh)
{
  if(thresh == COMP_THRESH_LOW) {
    LL_COMP_SetInputMinus(COMP2, LL_COMP_INPUT_MINUS_1_4VREFINT);
  }
  else {
    LL_COMP_SetInputMinus(COMP2, LL_COMP_INPUT_MINUS_1_2VREFINT);
  }
  LL_COMP_Enable(COMP2);
}

comp_output_t comp_read(void)
{
  if(LL_COMP_ReadOutputLevel(COMP2) == LL_COMP_OUTPUT_LEVEL_LOW) {
    return(COMP_VIN_LOW);
  }
  else {
    return(COMP_VIN_HI);
  }
}

/* Interrupt Service Routines ------------------------------------------------*/

/* End comparator.c */