/* ****************************************************************************
 * File:      acc_LIS2DW12_Regs
 * Date:      29 Jan 2024
 * Author:    Andrew Levido
 *
 * Copyright 2025
 *  Imbrius Pty Ltd - All Rights Reserved
 *
 *****************************************************************************/
#ifndef _acc_LIS2DW12_Regs_H
#define _acc_LIS2DW12_Regs_H

#ifdef __cplusplus
extern "C" {
#endif

/* Description ---------------------------------------------------------------*/

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>


/* Registers  ----------------------------------------------------------------*/

#define LIS2DW12_OUT_T_L                     0x0DU
#define LIS2DW12_OUT_T_H                     0x0EU
#define LIS2DW12_WHO_AM_I                    0x0FU

#define LIS2DW12_CTRL1                       0x20U
typedef union {
  struct {
    uint8_t lp_mode                    : 2; 
    uint8_t pwr_mode                   : 2;
    uint8_t odr                        : 4;
  } bits;
  uint8_t byte;
} lis2dw12_ctrl1_t;

#define LIS2DW12_CTRL2                       0x21U
typedef union {
  struct {
    uint8_t sim                        : 1;
    uint8_t i2c_disable                : 1;
    uint8_t if_add_inc                 : 1;
    uint8_t bdu                        : 1;
    uint8_t cs_pu_disc                 : 1;
    uint8_t not_used_01                : 1;
    uint8_t soft_reset                 : 1;
    uint8_t boot                       : 1;
  } bits;
  uint8_t byte;
} lis2dw12_ctrl2_t;

#define LIS2DW12_CTRL3                       0x22U
typedef union {
  struct {
  uint8_t slp_mode                   : 2; // slp_mode + slp_mode_sel
  uint8_t not_used_01                : 1;
  uint8_t h_lactive                  : 1;
  uint8_t lir                        : 1;
  uint8_t pp_od                      : 1;
  uint8_t st                         : 2;
} bits;
 uint8_t byte;
} lis2dw12_ctrl3_t;

#define LIS2DW12_CTRL4                        0x23U
typedef union {
  struct {
    uint8_t int1_drdy                  : 1;
    uint8_t int1_fth                   : 1;
    uint8_t int1_diff5                 : 1;
    uint8_t int1_tap                   : 1;
    uint8_t int1_ff                    : 1;
    uint8_t int1_wu                    : 1;
    uint8_t int1_single_tap            : 1;
    uint8_t int1_6d                    : 1;
  } bits;
  uint8_t byte;
} lis2dw12_ctrl4_t;

#define LIS2DW12_CTRL5                       0x24U
typedef union {
  struct {
    uint8_t int2_drdy                  : 1;
    uint8_t int2_fth                   : 1;
    uint8_t int2_diff5                 : 1;
    uint8_t int2_ovr                   : 1;
    uint8_t int2_drdy_t                : 1;
    uint8_t int2_boot                  : 1;
    uint8_t int2_sleep_chg             : 1;
    uint8_t int2_sleep_state           : 1;
  } bits;
  uint8_t byte;
} lis2dw12_ctrl5_t;

#define LIS2DW12_CTRL6                       0x25U
typedef union {
  struct {
    uint8_t not_used_01                : 2;
    uint8_t low_noise                  : 1;
    uint8_t fds                        : 1;
    uint8_t fs                         : 2;
    uint8_t bw_filt                    : 2;
  } bits;
  uint8_t byte;
} lis2dw12_ctrl6_t;

#define LIS2DW12_OUT_T                       0x26U

#define LIS2DW12_STATUS                      0x27U
typedef union {
  struct {
    uint8_t drdy                       : 1;
    uint8_t ff_ia                      : 1;
    uint8_t _6d_ia                     : 1;
    uint8_t single_tap                 : 1;
    uint8_t double_tap                 : 1;
    uint8_t sleep_state                : 1;
    uint8_t wu_ia                      : 1;
    uint8_t fifo_ths                   : 1;
  } bits;
  uint8_t byte;
} lis2dw12_status_t;

#define LIS2DW12_OUT_X_L                     0x28U
#define LIS2DW12_OUT_X_H                     0x29U

#define LIS2DW12_OUT_Y_L                     0x2AU
#define LIS2DW12_OUT_Y_H                     0x2BU

#define LIS2DW12_OUT_Z_L                     0x2CU
#define LIS2DW12_OUT_Z_H                     0x2DU

#define LIS2DW12_FIFO_CTRL                   0x2EU
typedef union {
  struct {
    uint8_t fth                        : 5;
    uint8_t fmode                      : 3;
  } bits;
  uint8_t byte;
} lis2dw12_fifo_ctrl_t;

#define LIS2DW12_FIFO_SAMPLES                0x2FU
typedef union {
  struct {
    uint8_t diff                       : 6;
    uint8_t fifo_ovr                   : 1;
    uint8_t fifo_fth                   : 1;
  } bits;
  uint8_t byte;
} lis2dw12_fifo_samples_t;

#define LIS2DW12_TAP_THS_X                   0x30U
typedef union {
  struct {
    uint8_t tap_thsx                    : 5;
    uint8_t _6d_ths                     : 2;
    uint8_t _4d_en                      : 1;
  } bits;
  uint8_t byte;
} lis2dw12_tap_ths_x_t;

#define LIS2DW12_TAP_THS_Y                   0x31U
typedef union {
  struct {
    uint8_t tap_thsy                   : 5;
    uint8_t tap_prior                  : 3;
  } bits;
  uint8_t byte;
} lis2dw12_tap_ths_y_t;

#define LIS2DW12_TAP_THS_Z                   0x32U
typedef union {
  struct {
    uint8_t tap_thsz                   : 5;
    uint8_t tap_z_en                   : 1;
    uint8_t tap_y_en                   : 1;
    uint8_t tap_x_en                   : 1;
  } bits;
  uint8_t byte;
} lis2dw12_tap_ths_z_t;

#define LIS2DW12_INT_DUR                     0x33U
typedef union {
  struct {
    uint8_t shock                      : 2;
    uint8_t quiet                      : 2;
    uint8_t latency                    : 4;
  } bits;
  uint8_t byte;
} lis2dw12_int_dur_t;

#define LIS2DW12_WAKE_UP_THS                 0x34U
typedef union {
  struct {
  uint8_t wk_ths                     : 6;
    uint8_t sleep_on                   : 1;
    uint8_t single_double_tap          : 1;
  } bits;
  uint8_t byte;
} lis2dw12_wake_up_ths_t;

#define LIS2DW12_WAKE_UP_DUR                 0x35U
typedef union {
  struct {
    uint8_t sleep_dur                  : 4;
    uint8_t stationary                 : 1;
    uint8_t wake_dur                   : 2;
    uint8_t ff_dur                     : 1;
  } bits;
  uint8_t byte;
} lis2dw12_wake_up_dur_t;

#define LIS2DW12_FREE_FALL                   0x36U
typedef union {
  struct {
    uint8_t ff_ths                     : 3;
    uint8_t ff_dur                     : 5;
  } bits;
  uint8_t byte;
} lis2dw12_free_fall_t;

#define LIS2DW12_STATUS_DUP                  0x37U
typedef union {
  struct {
    uint8_t drdy                       : 1;
    uint8_t ff_ia                      : 1;
    uint8_t _6d_ia                     : 1;
    uint8_t single_tap                 : 1;
    uint8_t double_tap                 : 1;
    uint8_t sleep_state_ia             : 1;
    uint8_t drdy_t                     : 1;
    uint8_t ovr                        : 1;
  } bits;
  uint8_t byte;
} lis2dw12_status_dup_t;

#define LIS2DW12_WAKE_UP_SRC                 0x38U
typedef union {
  struct {
    uint8_t z_wu                       : 1;
    uint8_t y_wu                       : 1;
    uint8_t x_wu                       : 1;
    uint8_t wu_ia                      : 1;
    uint8_t sleep_state_ia             : 1;
    uint8_t ff_ia                      : 1;
    uint8_t not_used_01                : 2;
  } bits;
  uint8_t byte;
} lis2dw12_wake_up_src_t;

#define LIS2DW12_TAP_SRC                     0x39U
typedef union {
  struct {
    uint8_t z_tap                      : 1;
    uint8_t y_tap                      : 1;
    uint8_t x_tap                      : 1;
    uint8_t tap_sign                   : 1;
    uint8_t double_tap                 : 1;
    uint8_t single_tap                 : 1;
    uint8_t tap_ia                     : 1;
    uint8_t not_used_01                : 1;
  } bits;
  uint8_t byte;
} lis2dw12_tap_src_t;

#define LIS2DW12_SIXD_SRC                    0x3AU
typedef union {
  struct {
    uint8_t xl                         : 1;
    uint8_t xh                         : 1;
    uint8_t yl                         : 1;
    uint8_t yh                         : 1;
    uint8_t zl                         : 1;
    uint8_t zh                         : 1;
    uint8_t _6d_ia                     : 1;
    uint8_t not_used_01                : 1;
  } bits;
  uint8_t byte;
} lis2dw12_sixd_src_t;

#define LIS2DW12_ALL_INT_SRC                 0x3BU
typedef union {
  struct {
    uint8_t ff_ia                      : 1;
    uint8_t wu_ia                      : 1;
    uint8_t single_tap                 : 1;
    uint8_t double_tap                 : 1;
    uint8_t _6d_ia                     : 1;
    uint8_t sleep_change_ia            : 1;
    uint8_t not_used_01                : 2;
  } bits;
  uint8_t byte;
} lis2dw12_all_int_src_t;

#define LIS2DW12_X_OFS_USR                   0x3CU

#define LIS2DW12_Y_OFS_USR                   0x3DU

#define LIS2DW12_Z_OFS_USR                   0x3EU

#define LIS2DW12_CTRL7                       0x3FU
typedef union {
  struct {
    uint8_t lpass_on6d                 : 1;
    uint8_t hp_ref_mode                : 1;
    uint8_t usr_off_w                  : 1;
    uint8_t usr_off_on_wu              : 1;
    uint8_t usr_off_on_out             : 1;
    uint8_t interrupts_enable          : 1;
    uint8_t int2_on_int1               : 1;
    uint8_t drdy_pulsed                : 1;
  } bits;
  uint8_t byte;
} lis2dw12_ctrl7_t;

/* Public Functions Declarations ---------------------------------------------*/

/* Task Function -------------------------------------------------------------*/

/* Interrupt Service Routine Declarations ------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif

/* End acc_LIS2DW12_Regs */