/* *****************************************************************************
 * File:      resources.c
 * Date:      18 Jan 2025
 * Author:    Andrew Levido
 *
 * Copyright 2025 Imbrius Pty Ltd - All Rights Reserved
 *
 ******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "resources.h"

/* Global Variables ----------------------------------------------------------*/
/* All defined in the excel file 9054-Resources.xls */

const uint8_t digit_glyph[10][16][3] =
{
    {  // Numeral 0
      { 0xE0, 0xFF, 0x07 },
      { 0xF8, 0xFF, 0x1F },
      { 0xFE, 0xFF, 0x7F },
      { 0x1E, 0x00, 0x78 },
      { 0x0F, 0x00, 0xF0 },
      { 0x07, 0x00, 0xE0 },
      { 0x07, 0x00, 0xE0 },
      { 0x07, 0x00, 0xE0 },
      { 0x07, 0x00, 0xE0 },
      { 0x07, 0x00, 0xE0 },
      { 0x07, 0x00, 0xE0 },
      { 0x0F, 0x00, 0xF0 },
      { 0x1E, 0x00, 0x78 },
      { 0xFE, 0xFF, 0x7F },
      { 0xF8, 0xFF, 0x1F },
      { 0xE0, 0xFF, 0x07 },
    },
    {  // Numeral 1
      { 0x00, 0x00, 0x00 },
      { 0x00, 0x00, 0x00 },
      { 0x00, 0x00, 0x00 },
      { 0x08, 0x00, 0x00 },
      { 0x0C, 0x00, 0x00 },
      { 0x0E, 0x00, 0x00 },
      { 0x0F, 0x00, 0x00 },
      { 0xFF, 0xFF, 0xFF },
      { 0xFF, 0xFF, 0xFF },
      { 0xFF, 0xFF, 0xFF },
      { 0x00, 0x00, 0x00 },
      { 0x00, 0x00, 0x00 },
      { 0x00, 0x00, 0x00 },
      { 0x00, 0x00, 0x00 },
      { 0x00, 0x00, 0x00 },
      { 0x00, 0x00, 0x00 },
    },
    {  // Numeral 2
      { 0x60, 0x00, 0x00 },
      { 0x78, 0x00, 0xF0 },
      { 0x7E, 0x00, 0xF8 },
      { 0x1E, 0x00, 0xFC },
      { 0x0F, 0x00, 0xFE },
      { 0x07, 0x00, 0xEF },
      { 0x07, 0x80, 0xE7 },
      { 0x07, 0xC0, 0xE3 },
      { 0x07, 0xE0, 0xE1 },
      { 0x07, 0xF0, 0xE0 },
      { 0x07, 0x78, 0xE0 },
      { 0x0F, 0x3C, 0xE0 },
      { 0x1E, 0x1E, 0xE0 },
      { 0xFE, 0x0F, 0xE0 },
      { 0xF8, 0x07, 0xE0 },
      { 0xE0, 0x03, 0xE0 },
    },
    {  // Numeral 3
      { 0x60, 0x00, 0x06 },
      { 0x78, 0x00, 0x1E },
      { 0x7E, 0x00, 0x7E },
      { 0x1E, 0x00, 0x78 },
      { 0x0F, 0x00, 0xF0 },
      { 0x07, 0x00, 0xE0 },
      { 0x07, 0x1C, 0xE0 },
      { 0x07, 0x1C, 0xE0 },
      { 0x07, 0x1C, 0xE0 },
      { 0x07, 0x1C, 0xE0 },
      { 0x07, 0x1C, 0xE0 },
      { 0x0F, 0x1C, 0xF0 },
      { 0x1E, 0x3E, 0x78 },
      { 0xFE, 0xFF, 0x7F },
      { 0xF8, 0xF7, 0x1F },
      { 0xE0, 0xC1, 0x07 },
    },
    {  // Numeral 4
      { 0x00, 0x80, 0x03 },
      { 0x00, 0xE0, 0x03 },
      { 0x00, 0xF8, 0x03 },
      { 0x00, 0xFE, 0x03 },
      { 0x80, 0x9F, 0x03 },
      { 0xE0, 0x87, 0x03 },
      { 0xF8, 0x81, 0x03 },
      { 0x7E, 0x80, 0x03 },
      { 0x1F, 0x80, 0x03 },
      { 0x07, 0x80, 0x03 },
      { 0xFF, 0xFF, 0xFF },
      { 0xFF, 0xFF, 0xFF },
      { 0xFF, 0xFF, 0xFF },
      { 0x00, 0x80, 0x03 },
      { 0x00, 0x80, 0x03 },
      { 0x00, 0x80, 0x03 },
    },
    {  // Numeral 5
      { 0x00, 0x00, 0x06 },
      { 0xFF, 0x07, 0x1E },
      { 0xFF, 0x07, 0x7E },
      { 0xFF, 0x07, 0x78 },
      { 0x07, 0x07, 0xF0 },
      { 0x07, 0x07, 0xE0 },
      { 0x07, 0x07, 0xE0 },
      { 0x07, 0x07, 0xE0 },
      { 0x07, 0x07, 0xE0 },
      { 0x07, 0x07, 0xE0 },
      { 0x07, 0x07, 0xE0 },
      { 0x07, 0x0F, 0xF0 },
      { 0x07, 0x1E, 0x78 },
      { 0x07, 0xFE, 0x7F },
      { 0x07, 0xFC, 0x1F },
      { 0x00, 0xF0, 0x07 },
    },
    {  // Numeral 6
      { 0xE0, 0xFF, 0x07 },
      { 0xF8, 0xFF, 0x1F },
      { 0xFE, 0xFF, 0x7F },
      { 0x1E, 0x1E, 0x78 },
      { 0x0F, 0x0E, 0xF0 },
      { 0x07, 0x07, 0xE0 },
      { 0x07, 0x07, 0xE0 },
      { 0x07, 0x07, 0xE0 },
      { 0x07, 0x07, 0xE0 },
      { 0x07, 0x07, 0xE0 },
      { 0x07, 0x07, 0xE0 },
      { 0x00, 0x0F, 0xF0 },
      { 0x00, 0x1E, 0x78 },
      { 0x00, 0xFE, 0x7F },
      { 0x00, 0xFC, 0x1F },
      { 0x00, 0xF0, 0x07 },
    },
    {  // Numeral 7
      { 0x00, 0x00, 0x00 },
      { 0x07, 0x00, 0x00 },
      { 0x07, 0x00, 0x00 },
      { 0x07, 0x00, 0xC0 },
      { 0x07, 0x00, 0xF0 },
      { 0x07, 0x00, 0xFC },
      { 0x07, 0x00, 0x7F },
      { 0x07, 0xC0, 0x1F },
      { 0x07, 0xF0, 0x07 },
      { 0x07, 0xFC, 0x01 },
      { 0x07, 0x7F, 0x00 },
      { 0xC7, 0x1F, 0x00 },
      { 0xF7, 0x07, 0x00 },
      { 0xFF, 0x01, 0x00 },
      { 0x7F, 0x00, 0x00 },
      { 0x1F, 0x00, 0x00 },
    },
    {  // Numeral 8
      { 0xE0, 0xC1, 0x07 },
      { 0xF8, 0xF7, 0x1F },
      { 0xFE, 0xFF, 0x7F },
      { 0x1E, 0x7F, 0x78 },
      { 0x0F, 0x3E, 0xF0 },
      { 0x07, 0x1C, 0xE0 },
      { 0x07, 0x1C, 0xE0 },
      { 0x07, 0x1C, 0xE0 },
      { 0x07, 0x1C, 0xE0 },
      { 0x07, 0x1C, 0xE0 },
      { 0x07, 0x1C, 0xE0 },
      { 0x0F, 0x3E, 0xF0 },
      { 0x1E, 0x7F, 0x78 },
      { 0xFE, 0xF7, 0x7F },
      { 0xF8, 0xF7, 0x1F },
      { 0xE0, 0xC1, 0x07 },
    },
    {  // Numeral 9
      { 0xE0, 0x07, 0x00 },
      { 0xF8, 0x1F, 0x00 },
      { 0xFE, 0x7F, 0x00 },
      { 0x1E, 0x78, 0x00 },
      { 0x0F, 0xF0, 0x00 },
      { 0x07, 0xE0, 0xE0 },
      { 0x07, 0xE0, 0xE0 },
      { 0x07, 0xE0, 0xE0 },
      { 0x07, 0xE0, 0xE0 },
      { 0x07, 0xE0, 0xE0 },
      { 0x07, 0xE0, 0xE0 },
      { 0x0F, 0x70, 0xF0 },
      { 0x1E, 0x78, 0x78 },
      { 0xFE, 0xFF, 0x7F },
      { 0xF8, 0xFF, 0x1F },
      { 0xE0, 0xFF, 0x07 },
    },
};

const uint8_t dp_glyph[8][1] =
{  // Decimal
  { 0x00 }, { 0x00 }, { 0x60 }, { 0xF0 }, { 0xF0 }, { 0x60 }, { 0x00 }, { 0x00 }
};

const uint8_t plus_glyph[8][1] =
{  // Plus
  { 0x18 }, { 0x18 }, { 0x18 }, { 0xFF }, { 0xFF }, { 0x18 }, { 0x18 }, { 0x18 }
};

const uint8_t minus_glyph[8][1] =
{  // Minus
  { 0x18 }, { 0x18 }, { 0x18 }, { 0x18 }, { 0x18 }, { 0x18 }, { 0x18 }, { 0x18 }
};

const uint8_t units_glyph[16][3] = 
{  // Letter V
  { 0x0F, 0x00, 0x00 },
  { 0xFF, 0x00, 0x00 },
  { 0xFF, 0x0F, 0x00 },
  { 0xF0, 0xFF, 0x00 },
  { 0x00, 0xFF, 0x0F },
  { 0x00, 0xF0, 0x7F },
  { 0x00, 0x00, 0xFF },
  { 0x00, 0x00, 0xF0 },
  { 0x00, 0x00, 0xF0 },
  { 0x00, 0x00, 0xFF },
  { 0x00, 0xF0, 0x7F },
  { 0x00, 0xFF, 0x0F },
  { 0xF0, 0xFF, 0x00 },
  { 0xFF, 0x0F, 0x00 },
  { 0xFF, 0x00, 0x00 },
  { 0x0F, 0x00, 0x00 },
};



const uint8_t error_msg[4][16][1] =
{
    {  // SYS!
      { 0x7F }, { 0x51 }, { 0x55 }, { 0x45 }, { 0x7F }, { 0x71 }, { 0x47 }, { 0x71 },
      { 0x7F }, { 0x51 }, { 0x55 }, { 0x45 }, { 0x7F }, { 0x7F }, { 0x51 }, { 0x7F },
    },
    {  // DIS!
      { 0x7F }, { 0x41 }, { 0x5D }, { 0x63 }, { 0x7F }, { 0x5D }, { 0x41 }, { 0x5D },
      { 0x7F }, { 0x51 }, { 0x55 }, { 0x45 }, { 0x7F }, { 0x7F }, { 0x51 }, { 0x7F },
    },
    {  // ACC!
      { 0x7F }, { 0x41 }, { 0x75 }, { 0x41 }, { 0x7F }, { 0x41 }, { 0x5D }, { 0x5D },
      { 0x7F }, { 0x41 }, { 0x5D }, { 0x5D }, { 0x7F }, { 0x7F }, { 0x51 }, { 0x7F },
    },
    {  // Spacey
      { 0x00 }, { 0x00 }, { 0x70 }, { 0x18 }, { 0x7D }, { 0xB6 }, { 0xBC }, { 0x3C },
      { 0xBC }, { 0xB6 }, { 0x7D }, { 0x18 }, { 0x70 }, { 0x00 }, { 0x00 }, { 0x00 },
    },

};

const uint8_t continuity_msg[80][2] =
  {  // Continuity_Icon
    { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00}, { 0xE0, 0x0F }, { 0xF0, 0x1F }, { 0x10, 0x10 }, { 0x10, 0x10 },
    { 0x10, 0x10 }, { 0x20, 0x08 }, { 0x00, 0x00 }, { 0x00, 0x00}, { 0xE0, 0x0F }, { 0xF0, 0x1F }, { 0x10, 0x10 }, { 0x10, 0x10 },
    { 0xF0, 0x1F }, { 0xE0, 0x0F }, { 0x00, 0x00 }, { 0x00, 0x00}, { 0xF0, 0x1F }, { 0xE0, 0x00 }, { 0xC0, 0x01 }, { 0x80, 0x03 },
    { 0x00, 0x07 }, { 0x00, 0x0E }, { 0xF0, 0x1F }, { 0x00, 0x00}, { 0x10, 0x00 }, { 0x10, 0x00 }, { 0xF0, 0x1F }, { 0xF0, 0x1F },
    { 0x10, 0x00 }, { 0x10, 0x00 }, { 0x00, 0x00 }, { 0x10, 0x10}, { 0xF0, 0x1F }, { 0xF0, 0x1F }, { 0x10, 0x10 }, { 0x00, 0x00 },
    { 0x00, 0x00 }, { 0xF0, 0x1F }, { 0xE0, 0x00 }, { 0xC0, 0x01}, { 0x80, 0x03 }, { 0x00, 0x07 }, { 0x00, 0x0E }, { 0xF0, 0x1F },
    { 0x00, 0x00 }, { 0x00, 0x00 }, { 0xF0, 0x0F }, { 0xF0, 0x1F}, { 0x00, 0x10 }, { 0x00, 0x10 }, { 0xF0, 0x1F }, { 0xF0, 0x0F },
    { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x10, 0x10 }, { 0xF0, 0x1F}, { 0xF0, 0x1F }, { 0x10, 0x10 }, { 0x00, 0x00 }, { 0x10, 0x00 },
    { 0x10, 0x00 }, { 0xF0, 0x1F }, { 0xF0, 0x1F }, { 0x10, 0x00}, { 0x10, 0x00 }, { 0x00, 0x00 }, { 0xF0, 0x00 }, { 0xF0, 0x01 },
    { 0x00, 0x1F }, { 0x00, 0x1F }, { 0xF0, 0x01 }, { 0xF0, 0x00}, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 },
 };
 
 const uint8_t voltage_msg[80][2] =
  {  // Voltage_Icon
    { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00}, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 },
    { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00}, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0xF0, 0x0F },
    { 0xF0, 0x1F }, { 0x00, 0x10 }, { 0x00, 0x10 }, { 0xF0, 0x0F}, { 0xF0, 0x07 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0xE0, 0x0F },
    { 0xF0, 0x1F }, { 0x10, 0x10 }, { 0x10, 0x10 }, { 0xF0, 0x1F}, { 0xE0, 0x0F }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0xF0, 0x1F },
    { 0xF0, 0x1F }, { 0x00, 0x10 }, { 0x00, 0x10 }, { 0x00, 0x10}, { 0x00, 0x10 }, { 0x10, 0x00 }, { 0x10, 0x00 }, { 0xF0, 0x1F },
    { 0xF0, 0x1F }, { 0x10, 0x00 }, { 0x10, 0x00 }, { 0x00, 0x00}, { 0xE0, 0x1F }, { 0xF0, 0x1F }, { 0x10, 0x01 }, { 0x10, 0x01 },
    { 0xF0, 0x1F }, { 0xE0, 0x1F }, { 0x00, 0x00 }, { 0x00, 0x00}, { 0xE0, 0x0F }, { 0xF0, 0x1F }, { 0x10, 0x10 }, { 0x10, 0x10 },
    { 0x10, 0x1E }, { 0x20, 0x0E }, { 0x00, 0x00 }, { 0x00, 0x00}, { 0xF0, 0x1F }, { 0xF0, 0x1F }, { 0x10, 0x11 }, { 0x10, 0x11 },
    { 0x10, 0x10 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00}, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 },
    { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00}, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 },
 };

 const uint8_t overvoltage_msg[80][2] =
  {  // OverVolt_Icon
    { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0xFF, 0xFF}, { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0x1F, 0xF0 },
    { 0x0F, 0xE0 }, { 0xEF, 0xEF }, { 0xEF, 0xEF }, { 0x0F, 0xE0}, { 0x1F, 0xF0 }, { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0x0F, 0xF0 },
    { 0x0F, 0xE0 }, { 0xFF, 0xEF }, { 0xFF, 0xEF }, { 0x0F, 0xF0}, { 0x0F, 0xF8 }, { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0x0F, 0xE0 },
    { 0x0F, 0xE0 }, { 0xEF, 0xEE }, { 0xEF, 0xEE }, { 0xEF, 0xEF}, { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0x0F, 0xE0 }, { 0x0F, 0xE0 },
    { 0xEF, 0xFE }, { 0xEF, 0xFE }, { 0x0F, 0xE0 }, { 0x1F, 0xE1}, { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0x7F, 0xFE }, { 0x7F, 0xFE },
    { 0x7F, 0xFE }, { 0x7F, 0xFE }, { 0x7F, 0xFE }, { 0xFF, 0xFF}, { 0xFF, 0xFF }, { 0x0F, 0xF0 }, { 0x0F, 0xE0 }, { 0xFF, 0xEF },
    { 0xFF, 0xEF }, { 0x0F, 0xF0 }, { 0x0F, 0xF8 }, { 0xFF, 0xFF}, { 0xFF, 0xFF }, { 0x1F, 0xF0 }, { 0x0F, 0xE0 }, { 0xEF, 0xEF },
    { 0xEF, 0xEF }, { 0x0F, 0xE0 }, { 0x1F, 0xF0 }, { 0xFF, 0xFF}, { 0xFF, 0xFF }, { 0x0F, 0xE0 }, { 0x0F, 0xE0 }, { 0xFF, 0xEF },
    { 0xFF, 0xEF }, { 0xFF, 0xEF }, { 0xFF, 0xEF }, { 0xEF, 0xFF}, { 0xEF, 0xFF }, { 0x0F, 0xE0 }, { 0x0F, 0xE0 }, { 0xEF, 0xFF },
    { 0xEF, 0xFF }, { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0xFF, 0xFF}, { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0xFF, 0xFF },
 };
 const uint8_t open_msg[80][2] =
   {  // OpenIcon
    { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00}, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 },
    { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00}, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 },
    { 0xFC, 0x3F }, { 0xFE, 0x7F }, { 0xFF, 0xFF }, { 0x07, 0xE0}, { 0x07, 0xE0 }, { 0x07, 0xE0 }, { 0x07, 0xE0 }, { 0xFF, 0xFF },
    { 0xFE, 0x7F }, { 0xFC, 0x3F }, { 0x00, 0x00 }, { 0x00, 0x00}, { 0x00, 0x00 }, { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0xFF, 0xFF },
    { 0x87, 0x03 }, { 0x87, 0x03 }, { 0x87, 0x03 }, { 0x87, 0x03}, { 0xFF, 0x03 }, { 0xFE, 0x01 }, { 0xFC, 0x00 }, { 0x00, 0x00 },
    { 0x00, 0x00 }, { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0xFF, 0xFF}, { 0xC7, 0xE1 }, { 0xC7, 0xE1 }, { 0xC7, 0xE1 }, { 0x07, 0xE0 },
    { 0x07, 0xE0 }, { 0x07, 0xE0 }, { 0x00, 0x00 }, { 0x00, 0x00}, { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0xF8, 0x00 },
    { 0xE0, 0x03 }, { 0x80, 0x0F }, { 0x00, 0x3E }, { 0xFF, 0xFF}, { 0xFF, 0xFF }, { 0xFF, 0xFF }, { 0x00, 0x00 }, { 0x00, 0x00 },
    { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00}, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 },
    { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00}, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 }, { 0x00, 0x00 },
 };

/* Private Functions ---------------------------------------------------------*/

/* Public Functions ----------------------------------------------------------*/

/* Interrupt Service Routines ------------------------------------------------*/

/* End resources */