SetPin 2,ain 'read capacitor
anlg = Pin(2)

Num = 7 'sequence length
Data 1,1,0,0,1,1,0,0 'Lamp 1 sequence
Data 1,0,1,0,1,0,1,0 'Lamp 2 sequence
Data 1,0,0,1,0,1,1,0 'Lamp 3 sequence
'Read sequences into L1, L2 and L3
Dim L1(8),L2(8),L3(8)
For i = 0 To Num:Read L1(i):Next
For i = 0 To Num:Read L2(i):Next
For i = 0 To Num:Read L3(i):Next

disp = 0
VAR restore 'Restore last state

SetPin 2,dout
Pin(2) = 1 'Charge capacitor
SetPin 14,oout 'Outputs are open collector
SetPin 15,oout
SetPin 16,oout

If anlg > 0.8 Then GoTo Program
Display
End

Program: 'Program mode - cycle through all combinations 3 times
d = 0
For i = 0 To 21
  disp = Num 'turn all off while saving EEPROM
  Display
  disp = d 'save to EEPROM
  VAR Save disp
  display ' turn on current value
  Pause 3000
  d = d + 1
  If d >= Num Then d = 0
Next
disp = Num
Display
disp = 0
VAR Save disp
Display
End

Sub Display
  If disp > Num Then disp = 0
  Pin(14) = 1 - L1(disp) 'Invert (open collector output)
  Pin(15) = 1 - L2(disp)
  Pin(16) = 1 - L3(disp)
End Sub