
#ifndef DMASAMP_H
#define	DMASAMP_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#define DMA_ASYNC_IDLE (0)
#define DMA_ASYNC_RUNNING (1)
#define DMA_ASYNC_DONE (2)
#define GETADCOS (16)

extern int dmaAsyncState;

void dmaSampInit();
void dmaSampRun(int anchan, uint16_t* capture_buf, unsigned int capture_depth);
int dmaSampRunAsync(int anchan, uint16_t* capture_buf, unsigned int capture_depth); //start async sampling and report state (also in dmaAsyncState)
int checkDmaSampRunAsync(); //check and update state (also in dmaAsyncState)
int resetDmaSampRunAsync(); //check and update state from done to idle (also in dmaAsyncState)
int getADC(int anchan);     //get a single result

#ifdef __cplusplus
}
#endif
#endif	/* DMASAMP_H */
