//pins:
//GP16  (21)  DOUT
//GP17  (22)  S4
//GP18  (24)  S3
//GP19  (25)  S2
//GP20  (26)  SDA I2C0
//GP21  (27)  SCL I2C0
//GP22  (29)  S1
//GP26  (31)  AIN       (ADC0)
//GP27  (32)  1V65      (ADC1)
//GP28  (34)  BATSENSE  (ADC2)
//GP29  (NC)  VSYS/3    (ADC3)

#define BACKSPACE (8)
#define SCAN_LEN (256)
char* s=NULL;						//for input scanning
char b[SCAN_LEN]="";
int p=0;
int dumpFlag=0;
#define ADC_DEPTH (4096)
int histFlag=0;   //get histogram
unsigned int histMap[ADC_DEPTH];

#define S1 (22)
#define S2 (19)
#define S3 (18)
#define S4 (17)
#define DOUT (16)
#define AIN (26)
#define VMID (27)
#define BATSENSE (28)
#define VSYSSENSE (29)

#define BUTTON_DELAY 4
#define BUTTON_REPEAT 1
volatile int holdCount[4]={0,0,0,0};  
volatile int repeatCount[4]={0,0,0,0};  

//from setup conditions, in Hz
#define BIN_WIDTH (9.96492346938775)
//volts per ADC step (nominally 6.6V/4096)
#define BAT_RATIO (0.001611328125)

typedef enum{
  SINE_WAVE,
  TRI_WAVE,
  SQU_WAVE,
  SAW_WAVE,
  WHITE_WAVE,
  DUMMY_WAVE
} wavemode_t;
const char waveModes[][16]={"SINE","TRIANGLE","SQUARE","SAWTOOTH","WHITE"};
const float pkToRMS[DUMMY_WAVE]={1.4142135,1.7320508,1,1.7320508,1.7320508};    //note peak=RMS for square
wavemode_t waveMode=SINE_WAVE;

#include "fix_fft32.h"
#define SWEEP_COUNT 30
int sweepSteps=10; //changeable to do smaller/faster sweeps
int sweepFreqs[SWEEP_COUNT]={10,20,50,100,200,500,1000,2000,5000,10000};
int sweepAmp[SWEEP_COUNT];
int sweepEnergy[SWEEP_COUNT]; //for THDN
float sweepDB[SWEEP_COUNT];   //for sweep freq response
const int decades[10]={1,10,100,1000,10000,100000,1000000,10000000,100000000,1000000000};
int sweepPhase=0; //setup, run, show results and wait

#include "audio.h"
//match the native frequency exactly (133MHz/256/8)
#define OUTSAMPLERATE (64941)
//this gives a max sample duration of 0.2s, ie good for down to 5Hz
#define OUTSAMPLESIZE (13000)
int16_t outSamp[2][OUTSAMPLESIZE];
int outSampActive=0;
int outSampSize=0;
int newF=500;
int sweepF=500;
int newAmp=16000;
int curSweepAmp=16000;
int newV=500;    //in mV
float newPkPk=2*pkToRMS[0]*newV;
const fixed* newWave=Sinewave;
int waveIndex=0;
int outputOn=0;
unsigned int ftmr=0;
#define WAVE_AMP_STEPS (50)
#define SPEC_FREQ_STEPS (500)

#include "dmasamp.h"
#define SUBSAMPDEPTH (12)
#define SUBSAMPSIZE (1<<SUBSAMPDEPTH)
fixed subSamp[SUBSAMPSIZE];
fixed subSampI[SUBSAMPSIZE];
#define OVERSAMP (12)
#define SAMPSIZE (SUBSAMPSIZE*OVERSAMP)
uint16_t samp[SAMPSIZE];
#define RAWSAMPLERATE (OVERSAMP*SUBSAMPSIZE*BIN_WIDTH)
#define SAMPRATE (489795.9183673)
#define FFT_SCALING (sqrt(2)/OVERSAMP)
#define FLAT_TOP_SCALING (1.0/0.41853738488018)
#define FLAT_TOP_SCALING_2 (FLAT_TOP_SCALING*FLAT_TOP_SCALING)

#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SH110X.h>
Adafruit_SH1106G OLED = Adafruit_SH1106G(128, 64, &Wire, -1); //no reset pin

#define sgn(x) ((x) < 0 ? -1 : ((x) > 0 ? 1 : 0))

typedef enum{
  WAVE_OUT,   //Wave output setup
  SPECTRUM,   //frequency spectrum
  SCOPE,      //scope display
  HARMONIC,   //harmonic analysis
  SWEEP,      //sweep/freq response
  SETTINGS,   //setup/cal
  DUMMY
} screenmode_t;
screenmode_t mode=WAVE_OUT;

#include <EEPROM.h>
typedef struct {  //something we can easily get/put to EEPROM
  float vCalLo;
  float vCalHi;
  float wavCal;
  int sampOffset;
}saveData_t;

saveData_t cur;

float vCal;               //set to vCalHi or vCalLo to suit switch
const fixed *wavePtr[5];  //these are the available waveforms
int inMult=1;             //to match switch

typedef enum{
  SET_START,
  SET_INOFFSET,
  SET_OUTAMP,
  SET_INAMPLO,
  SET_INAMPHI,
  SET_SAVE,
  SET_DUMMY
} settingmode_t;
settingmode_t setMode=SET_START;
int refRunning=0;         //reference waveform is active
#define REF_LEVEL (500)
#define REF_FREQ (1000)

const unsigned char splashBitmap[]  = {
0x00, 0x7f, 0xf0, 0x1f, 0xe7, 0xf8, 0x03, 0xfc, 0x07, 0xff, 0x00, 0x1f, 0xfc, 0x07, 0xf0, 0x7f, 
0x00, 0xff, 0xf8, 0x1f, 0xc7, 0xf8, 0x03, 0xfc, 0x1f, 0xff, 0x80, 0x7f, 0xfe, 0x07, 0xf0, 0x7f, 
0x03, 0xff, 0xfe, 0x3f, 0xc7, 0xf8, 0x03, 0xfc, 0x7f, 0xff, 0xc1, 0xff, 0xff, 0x0f, 0xf0, 0xfe, 
0x07, 0xff, 0xff, 0x3f, 0xc7, 0xf0, 0x07, 0xf8, 0xff, 0xff, 0xe3, 0xff, 0xff, 0x8f, 0xf0, 0xfe, 
0x0f, 0xf1, 0xff, 0x3f, 0x8f, 0xf0, 0x07, 0xf9, 0xfe, 0x1f, 0xe7, 0xf8, 0x7f, 0x8f, 0xf0, 0xfe, 
0x0f, 0xf1, 0xfe, 0x7f, 0x8f, 0xf0, 0x07, 0xf9, 0xfe, 0x1f, 0xc7, 0xf8, 0x7f, 0x1f, 0xf9, 0xfc, 
0x0f, 0xe0, 0x00, 0x7f, 0x8f, 0xe0, 0x07, 0xf1, 0xfe, 0x1f, 0xc7, 0xf8, 0xff, 0x1f, 0xf9, 0xfc, 
0x1f, 0xf0, 0x00, 0x7f, 0x1f, 0xe0, 0x0f, 0xf3, 0xfc, 0x0f, 0x0f, 0xf0, 0xff, 0x1f, 0xf9, 0xfc, 
0x1f, 0xff, 0x80, 0xff, 0x1f, 0xe0, 0x0f, 0xf3, 0xfc, 0x00, 0x0f, 0xf0, 0xff, 0x3f, 0xff, 0xf8, 
0x0f, 0xff, 0xe0, 0xff, 0x1f, 0xe0, 0x0f, 0xe3, 0xfc, 0x00, 0x0f, 0xf0, 0xfe, 0x3f, 0xff, 0xf8, 
0x03, 0xff, 0xf0, 0xff, 0x3f, 0xc0, 0x1f, 0xe3, 0xf8, 0x00, 0x0f, 0xe1, 0xfe, 0x3f, 0xff, 0xf8, 
0x01, 0xff, 0xf9, 0xfe, 0x3f, 0xc0, 0x1f, 0xe7, 0xf8, 0x00, 0x1f, 0xe1, 0xfe, 0x7f, 0xff, 0xf8, 
0x00, 0x07, 0xf9, 0xfe, 0x3f, 0xc0, 0x1f, 0xe7, 0xf8, 0x7f, 0x1f, 0xe1, 0xfc, 0x7f, 0xbf, 0xf0, 
0x00, 0x07, 0xf9, 0xfe, 0x7f, 0x80, 0x3f, 0xc7, 0xf0, 0xff, 0x1f, 0xc3, 0xfc, 0x7f, 0x3f, 0xf0, 
0x7f, 0x87, 0xf1, 0xfc, 0x7f, 0x80, 0x3f, 0xcf, 0xf0, 0xff, 0x3f, 0xc3, 0xfc, 0x7f, 0x1f, 0xf0, 
0xff, 0x8f, 0xf3, 0xfc, 0x7f, 0x80, 0x3f, 0xcf, 0xf0, 0xfe, 0x3f, 0xc7, 0xf8, 0xff, 0x1f, 0xf0, 
0xff, 0xff, 0xf3, 0xfc, 0x7f, 0xfc, 0x7f, 0x8f, 0xff, 0xfe, 0x3f, 0xff, 0xf8, 0xfe, 0x1f, 0xe0, 
0x7f, 0xff, 0xe3, 0xf8, 0xff, 0xff, 0x7f, 0x8f, 0xff, 0xfc, 0x3f, 0xff, 0xf0, 0xfe, 0x1f, 0xe0, 
0x1f, 0xff, 0x07, 0xf8, 0xff, 0xfe, 0x7f, 0x83, 0xff, 0xf0, 0x0f, 0xff, 0xc1, 0xfe, 0x0f, 0xe0, 
0x0f, 0xfc, 0x07, 0xf8, 0xff, 0xfe, 0x7f, 0x00, 0xff, 0x80, 0x03, 0xff, 0x01, 0xfc, 0x0f, 0xc0, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x1f, 0xe0, 0x0f, 0xc1, 0xf8, 0x7f, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0xff, 0xf8, 0x1f, 0xc3, 0xfc, 0xff, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x03, 0xff, 0xfe, 0x3f, 0xc3, 0xf8, 0xff, 0x1f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x07, 0xff, 0xfe, 0x3f, 0xc7, 0xf8, 0xfe, 0x3f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x0f, 0xf1, 0xfe, 0x3f, 0x87, 0xf9, 0xfe, 0x3f, 0xc7, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x0f, 0xe1, 0xfe, 0x7f, 0x87, 0xf1, 0xfe, 0x3f, 0x87, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x1f, 0xe1, 0xfc, 0x7f, 0x8f, 0xf1, 0xfc, 0x7f, 0x8f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x1f, 0xe0, 0x00, 0x7f, 0x8f, 0xf3, 0xfc, 0x7f, 0x8f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x1f, 0xc0, 0x00, 0xff, 0xff, 0xe3, 0xfc, 0x7f, 0x9f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x3f, 0xc0, 0x00, 0xff, 0xff, 0xe3, 0xf8, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x3f, 0xc0, 0x00, 0xff, 0xff, 0xe7, 0xf8, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x3f, 0x87, 0xf9, 0xfe, 0x3f, 0xe7, 0xf8, 0xff, 0xfc, 0x00, 0x00, 0x1f, 0x86, 0x0f, 0x83, 0xf0, 
0x7f, 0x87, 0xf1, 0xfe, 0x3f, 0xc7, 0xf1, 0xff, 0x00, 0x00, 0x00, 0x3f, 0xcf, 0x1f, 0xcf, 0xf8, 
0x7f, 0x87, 0xf1, 0xfc, 0x3f, 0xcf, 0xf1, 0xfe, 0x00, 0x00, 0x00, 0x3f, 0xee, 0x3f, 0xcf, 0xfc, 
0xff, 0x8f, 0xf3, 0xfc, 0x3f, 0xcf, 0xf1, 0xfc, 0x00, 0x00, 0x00, 0x39, 0xee, 0x78, 0x1e, 0x3c, 
0xff, 0xff, 0xe3, 0xfc, 0x3f, 0x8f, 0xe3, 0xfc, 0x00, 0x00, 0x00, 0x79, 0xee, 0xf0, 0x3c, 0x1c, 
0x3f, 0xff, 0xc3, 0xf8, 0x7f, 0x9f, 0xe3, 0xfc, 0x00, 0x00, 0x00, 0x7b, 0xde, 0xf0, 0x3c, 0x1c, 
0x1f, 0xfe, 0x03, 0xf8, 0x7f, 0x1f, 0xe3, 0xf8, 0x00, 0x00, 0x00, 0x7f, 0xde, 0xe0, 0x38, 0x1c, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x9c, 0xe0, 0x38, 0x3c, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x1c, 0xe0, 0x38, 0x38, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x1c, 0xf0, 0x38, 0x78, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3c, 0xff, 0x3f, 0xf0, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x3c, 0x7f, 0x1f, 0xe0, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x18, 0x3e, 0x0f, 0xc0, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0c, 0x00, 0x18, 0x08, 0x10, 0x21, 0xe1, 0xf8, 0x78, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x1e, 0x18, 0x3c, 0x1c, 0x38, 0x77, 0xf3, 0xfc, 0xff, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x1e, 0x38, 0x7e, 0x1c, 0x3c, 0xf7, 0xf3, 0xfd, 0xff, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x3f, 0x38, 0x7e, 0x1c, 0x1d, 0xef, 0x03, 0x81, 0xef, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x3f, 0x38, 0xfe, 0x3c, 0x1f, 0xcf, 0x03, 0x81, 0xc7, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x3f, 0x38, 0xfe, 0x38, 0x1f, 0xcf, 0x87, 0xe1, 0xcf, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xce, 0x3f, 0xf9, 0xee, 0x38, 0x0f, 0x87, 0xc7, 0xf1, 0xfe, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xce, 0x3b, 0xf1, 0xce, 0x38, 0x0f, 0x03, 0xe7, 0xf3, 0xfc, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xfe, 0x73, 0xf3, 0xfe, 0x38, 0x0f, 0x01, 0xe7, 0x03, 0xfc, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xfe, 0x73, 0xf3, 0xff, 0x78, 0x0e, 0x00, 0xe7, 0x03, 0x9e, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0x71, 0xf7, 0xff, 0x78, 0x0e, 0x19, 0xef, 0x03, 0x9e, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x71, 0xf7, 0x0f, 0x7f, 0x0e, 0x1f, 0xef, 0xf3, 0x9e, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x07, 0x61, 0xee, 0x07, 0x7f, 0x0e, 0x1f, 0xcf, 0xf3, 0x8e, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00
};

int dataInvalid(saveData_t* a){
  if(a->vCalLo<0.0001){return 1;}  
  if(a->vCalLo>0.002){return 1;}
  if(a->vCalHi<0.001){return 1;}
  if(a->vCalHi>0.02){return 1;}
  if(a->wavCal<10000){return 1;}
  if(a->wavCal>30000){return 1;}
  if(a->sampOffset<1024){return 1;}
  if(a->sampOffset>3072){return 1;}  
  return 0;
}

void setDefaults(saveData_t* a){
  a->vCalLo=0.001;         //approx 3.0/4096, ie 12bits into nearly 3.3V
  a->vCalHi=0.01;          //approx 30/4096
  a->wavCal=20524;       //approx 65536/3.1, ie 16bits into nearly 3.3V
  a->sampOffset=2048;
}

bool timerCallback(repeating_timer_t *rt){
  if(digitalRead(S1)==0){if(holdCount[0]==0){repeatCount[0]++;}holdCount[0]++;}else{holdCount[0]=0;}
  if(digitalRead(S2)==0){if(holdCount[1]==0){repeatCount[1]++;}holdCount[1]++;}else{holdCount[1]=0;}
  if(digitalRead(S3)==0){if(holdCount[2]==0){repeatCount[2]++;}holdCount[2]++;}else{holdCount[2]=0;}
  if(digitalRead(S4)==0){if(holdCount[3]==0){repeatCount[3]++;}holdCount[3]++;}else{holdCount[3]=0;}
  if(holdCount[0]>BUTTON_DELAY){holdCount[0]=holdCount[0]-BUTTON_REPEAT;repeatCount[0]++;}
  if(holdCount[1]>BUTTON_DELAY){holdCount[1]=holdCount[1]-BUTTON_REPEAT;repeatCount[1]++;}
  if(holdCount[2]>BUTTON_DELAY){holdCount[2]=holdCount[2]-BUTTON_REPEAT;repeatCount[2]++;}
  if(holdCount[3]>BUTTON_DELAY){holdCount[3]=holdCount[3]-BUTTON_REPEAT;repeatCount[3]++;}
  return true;  //keep repeating the timer
}

int getButton(int b){   //pull a button event if available
  int n;
  switch(b){
    case S1: n=0;break;
    case S2: n=1;break;
    case S3: n=2;break;
    case S4: n=3;break;
    default: n=0;break;
  }
  int res=0;
  noInterrupts();
  if(repeatCount[n]>0){res=1;repeatCount[n]--;}
  interrupts();
  return res;
}

void buttonSetup(void){
  static repeating_timer_t timer;
  add_repeating_timer_us(-60000, timerCallback, NULL, &timer);    //time in us
}

char* scanSerial(void){
	int d;
	if(p==0){b[p]=0;} //if data has been read out, reset
	while(Serial.available()){
		d=Serial.read();
    if((d==3)||(d==27)){  //Ctrl-C/ESC
      b[0]=3;
      b[1]=0;
      p=0;    
      Serial.println("\r\nCancelled\r\n");
      return b;//return empty, caller can see cancel
    }
    if((d==',')||(d=='<')){
      repeatCount[0]++;
      return 0;
    }
    if((d=='.')||(d=='>')){
      repeatCount[1]++;
      return 0;
    }
    if(d=='/'){
      repeatCount[2]++;
      return 0;
    }
    if((d=='m')||(d=='M')){
      repeatCount[3]++;
      return 0;
    }
    if(d>=' '){
      if(p<SCAN_LEN-2){
      b[p]=d;
      p++;
      b[p]=0; //null term
      Serial.write(d);  //echo
      }
    }else{
      if(d==BACKSPACE){  //backspace
        if(p){
          p--;
          b[p]=0; //delete last
          Serial.write(BACKSPACE);    //back up
          Serial.write(' ');  		 //blank
          Serial.write(BACKSPACE);    //back up again
        }
      }
      if(d==13){Serial.println("");p=0;return b;}
    }
	}
  return 0;
}

const int ADCADJ[ADC_DEPTH]={ //this best so far, based on the three error codes getting x10 hits on histogram
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,
-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,
-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,
-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,0,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,
-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,
-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,
-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,0,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,
-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,
-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,
-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,0,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,
-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,
-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,
-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,0,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};
