; VFD222v8.ASM: using a PIC10F222 for 2 measures, with Vdd=5.12V 

	List P = 10F222
#include <p10F222.inc>

	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _MCPU_OFF & _IOFSCS_4MHZ

;------------------------------ define hardware -------------------------------

#define		Clk4017	  GPIO, 2
;#define		BTN		  GPIO, 3

#define		NDGTS		.4 ; two display of 4 digits (grille #5 not used) 

;------------------------------ define constants ------------------------------

	CONSTANT  CBLOCK16 = 0x10 ; 16 bytes RAM for PIC10F200/204/220
	CONSTANT  CBLOCK23 = 0x09 ; 23 bytes RAM for PIC10F222
	CONSTANT  CBLOCK24 = 0x08 ; 24 bytes RAM for PIC10F202/206

;------------------------------ define variables ------------------------------

	;CBLOCK	CBLOCK16	; beginning of RAM (PIC10F200/204/220)
	CBLOCK	CBLOCK23	; beginning of RAM (PIC10F222)
	;CBLOCK	CBLOCK24	; beginning of RAM (PIC10F202/206)

;delay
	cnt1, cnt2, cnt3 ; counters
;digits
	units, tens, hunds
	valeur			 ; value (= 0,1,...,9) to be displayed...
	grille			 ; onto grille = G1, G2, ..., G9 of the VFD
;measure
	meas			; true 8-bit value from internal ADC module
;others
	tmp1, tmp2	 	; temporary values
	doWelcome		; =0, only at power on
	ENDC

;------------------------------------------------------------------------------
; macro to put a literal value (constant) into a register
;------------------------------------------------------------------------------
MOVLF	macro	literal, file	; literal -> file
	MOVLW	literal
	MOVWF	file
	endm
;------------------------------------------------------------------------------
; macro to copy value of register file1 to register file2
;------------------------------------------------------------------------------
MOVFF	macro	file1, file2	; file1 -> file2
	MOVF	file1, W
	MOVWF	file2
	endm
;------------------------------------------------------------------------------
; macro test: if (file <> 0) goto jmpOk ;
;------------------------------------------------------------------------------
SIregNOTNUL  macro file, jmpOk
	MOVF	file, w
	BTFSS	STATUS, Z	; file == 0 ?
	GOTO    jmpOk		; no, i.e. file <> 0
	endm
;-----------------------------------------------------------------------------
; macro to reset the 4033
;-----------------------------------------------------------------------------
RST_4033	 macro
	MOVLW	b'11001111'	; <6>=1, no pull-up => transistor T1 off
	OPTION

	MOVLF	.14, cnt1
	CALL	Delay10us	; 14 * 10 = 140 us, delay min. to charge C4
	DECFSZ	cnt1, f 
	GOTO	$-2

	MOVLW	b'10001111'	; <6>=0, pull-up => transistor T1 on
	OPTION
	endm
;-----------------------------------------------------------------------------
; macro to clock the 4033
;-----------------------------------------------------------------------------
CLK_4033	 macro
	MOVLW	b'11001111'	; <6>=1, no pull-up => transistor T1 off
	OPTION
	GOTO	$+1			; +2 us delay to clock the 4033
	MOVLW	b'10001111'	; <6>=0, pull-up => transistor T1 on
	OPTION
	endm
;-----------------------------------------------------------------------------
; macro to reset the 4017
;-----------------------------------------------------------------------------
RST_4017	 macro
	BSF		Clk4017		; GPIO<2> = 1 => Clk=0
	GOTO	$+1			; +2 us delay
	GOTO	$+1			; +2 us delay

	MOVLF	.14, cnt1
	CALL	Delay10us	; 14 * 10 = 140 us, delay min. to charge C5
	DECFSZ	cnt1, f 
	GOTO	$-2

	BCF		Clk4017		; GPIO<2> = 0 => Clk=1
	endm
;-----------------------------------------------------------------------------
; macro to clock the 4017
;-----------------------------------------------------------------------------
CLK_4017	 macro
	BSF		Clk4017		; GPIO<2> = 1 => Clk=0
	GOTO	$+1			; +2 us delay to clock the 4017
	BCF		Clk4017		; GPIO<2> = 0 => Clk=1
	endm

;//////////////////////////////////////////////////////////////////////////////
;	MAIN PROGRAM
;//////////////////////////////////////////////////////////////////////////////
	ORG   0
	GOTO  Main

;//////////////////////////////////////////////////////////////////////////////

#include "16b3dgt.inc"		; routine SP_DIGBYTE to convert 16-bit to 3 dgts

;//////////////////////////////////////////////////////////////////////////////

;------------------------------------------------------------------------------
Delay05s
	CLRW
	CALL	Delay_ms	; 256 ms delay
	;CALL	Delay_ms	; 256 ms delay
	GOTO	Delay_ms	; 256 ms delay
	;RETLW	0
;------------------------------------------------------------------------------
Delay_ms
	MOVWF	cnt2
	MOVLF	.249, cnt1	; optional, if 1024 us # 1 ms acceptable
	
	NOP					; 1us
	DECFSZ	cnt1, f		; 1us 
	GOTO	$-2			; 2us => 4*249 = 996 us internal delay loop
	DECFSZ	cnt2, f
	GOTO	$-4			; 1.000 ms * cnt2
	RETLW	0
;------------------------------------------------------------------------------
Delay10us				; 2 us for CALL
	GOTO	$+1			; 2 us
	GOTO	$+1			; 2 us
	GOTO	$+1			; 2 us
	RETLW	0			; 2 us for RETURN
;------------------------------------------------------------------------------
Value2dgt				; display value = 0<=valeur<=9, on digit = 1<=grille<=9
	MOVWF	valeur
	INCF	grille, f
	RST_4033

	MOVFF	grille, tmp1 ; grille -> tmp1
	MOVFF	valeur, tmp2 ; valeur -> tmp2
	BTFSS	STATUS, Z	; valeur == 0 ?
	GOTO	proceed		; no
	MOVLF	.10, tmp2	; clock 10 times to output 7-segment code for 0

proceed
	CLK_4033			; idle display 1 (to avoid shadow in multiplexing)

digit					; now, activate digit = grille
	CLK_4017

	MOVLF	.9, cnt1
	CALL	Delay10us	; 9 * 10 = 90 us ; SANS CE DELAI, CA NE DEFILE PAS !
	DECFSZ	cnt1, f 
	GOTO	$-2

value					; at last, display value = valeur
	CLK_4033
	DECFSZ	tmp2, f 
	GOTO	value
rtn
	MOVLF	.5, cnt2
	;CALL	Delay_ms	; 5 ms delay for persistence of each digit
	GOTO	Delay_ms	; 5 ms delay for persistence of each digit
	;RETLW	0
;-----------------------------------------------------------------------------
meas8bit
	;bsf	ADCON0, ADON	; switch on ADC module
	MOVWF	ADCON0

	MOVLF	.8, cnt1	; cnt1 = 32 us delai interne (quartz 4 MHz)
	NOP
	DECFSZ	cnt1, F		; 1us
	GOTO	$-2			; boucle interne = 4 * 8 = 32 us

	bsf		ADCON0, GO	; initiate one A/D conversion
	btfsc	ADCON0, GO	; A/D conversion complete ?
	goto	$-1			; no

	movf	ADRES, W	; yes, then retreive measure
	movwf	meas		; store it in meas

	;bcf	ADCON0, ADON	; switch off ADC module
	CLRF	ADCON0		; AN0, AN1 digitals, ADC off => lower power consumption

;conv.8bit to decimal
	MOVF	meas, W
	MOVWF	tmp1
	CLRF	tmp2
	BCF		STATUS, C	; 8-bit resolution on Vdd=5.12V ...
	RLF		tmp1, F		; ... then, CN=1 => 20 mV...
	RLF		tmp2, F		; ... upto CN=255 => 5120 mV. 
	CALL	SP_DIGBYTE

;after CLRWDT, prescaler is cleared ; so reconfig. OPTION for WDT 1:128
 	CLRWDT
	MOVLW  b'10001111'	; no wake-up, enable pull-up, <5>=0:use GP2, not TOCKI
	OPTION				; and WDT prescaler 1:128 => timeout # 2.3 s

	RETLW	0

;//////////////////////////////////////////////////////////////////////////////
Main                    ; Beginning of the program
	CLRF	doWelcome
	BTFSS	STATUS, NOT_TO	; <4> cleared upon a WDT reset
	INCF	doWelcome, F	; doWelcome = 1, if a WDT reset happens
	;GOTO	fromReset

fromReset ;---------------------------------------------
; trim the internal oscillator accuracy to 1% at 4 MHz
	MOVLW	.52			; particular calibration value for my PIC10F222 sample
	MOVWF	OSCCAL		; trim the internal oscillator accuracy to 1% at 4 MHz

;turn off ADC (and set ditigal AN0 & AN1)
	CLRF	ADCON0		; AN0, AN1 digitals, ADC off => lower power consumption

;cfg GPIO
	MOVLW	b'11111011'	; W = 1111 1011 => GP0,GP1 inputs, GP2 output
	TRIS	GPIO

;config. OPTION (CAUTION, PARTICULAR CASE OF GP2, in the PIC10F2xx series)
	MOVLW  b'10001111'	; no wake-up, enable pull-up, <5>=0:use GP2, not TOCKI
	OPTION				; and WDT prescaler 1:128 => timeout # 2.3 s

;default state for GP2 & GP3
	MOVLW	b'11111011'
	MOVWF	GPIO		; GP2=0 => Clk4017=1 (idle) ; GP3=1 => Clk4033=0 (idle)

;reset the two I.C.
	RST_4017
	RST_4033

	SIregNOTNUL  doWelcome, measure1 ; if (doWelcome != 0) goto measure1

;a small delay, heating filament please...
	CALL	Delay05s	; 0.5s delay

;-------------------
;welcome2 (without using lamp test (pin14=LT=1) of the 4033) 
	MOVLF	.9, cnt3
	CLRF	grille
hello2
	MOVLW	.8
	CALL	Value2dgt
 	CALL	Delay05s	; 0.5s delay
	;after CLRWDT, prescaler is cleared ; so reconfig. OPTION for WDT 1:128
 	CLRWDT
	MOVLW  b'10001111'	; no wake-up, enable pull-up, <5>=0:use GP2, not TOCKI
	OPTION				; and WDT prescaler 1:128 => timeout # 2.3 s
	DECFSZ	cnt3, f
	GOTO	hello2
;endof welcome2

;measures ;---------------------------------------------
measure1
	MOVLW	b'01000001'	; AN0 only, channel 0 only, ADC on
	CALL	meas8bit
;--------------------
;display first number
	MOVLF	.55, cnt3
loop1
	CLRF	grille
	RST_4017
;digit1
	MOVLW	.0
	call	Value2dgt
;digit2
	MOVF	units, W
	CALL	Value2dgt
;digit3
	MOVF	tens, W
	call	Value2dgt
;digit4
	MOVF	hunds, W
	call	Value2dgt
	DECFSZ	cnt3, f 
	GOTO	loop1

	RST_4017

;---------------------
measure2
	MOVLW	b'10000101'	; AN1 only, channel 1 only, ADC on
	CALL	meas8bit
;---------------------
;display second number
	MOVLF	.55, cnt3
loop2
	MOVLF	.5, grille
	RST_4017

	RST_4033
	CALL	Delay10us
	CLK_4033			; idle display 1 (to avoid shadow in multiplexing)
	CALL	Delay10us

	MOVFF	grille, tmp1 ; grille -> tmp1
number2
	CLK_4017
	MOVLF	.9, cnt1
	CALL	Delay10us	; 9 * 10 = 90 us ; SANS CE DELAI, CA NE DEFILE PAS !
	DECFSZ	cnt1, f 
	GOTO	$-2
	DECFSZ	tmp1, f 
	GOTO	number2

;digit6
	MOVLW	.0
	call	Value2dgt
;digit7
	MOVF	units, W
	CALL	Value2dgt
;digit8
	MOVF	tens, W
	call	Value2dgt
;digit9
	MOVF	hunds, W
	call	Value2dgt
	DECFSZ	cnt3, f
	GOTO	loop2
;-------------------
;veilleuse
	RST_4017
	sleep

;-------------------
	END
