*************************************************************************

HWS timer 

To run on PICAXE 08M			251 bytes used

#endrem


;**************************************************************************
;define pins and variables

symbol pushbut = pin3			;i/p push button, active low
symbol delay = pin4			;i/p for delayed start switch, active low
symbol led = 1				;led on output #1
symbol relay = 2			;relay on output #2

symbol delhrs = 6			;define delay period

symbol rstflag = b0			;used to reset timer
let rstflag = 0

symbol delflag = b1			;delayed start active
let delflag = 0

symbol hours = b2			;hours count
let hours = 0

symbol n = b3				;counter for time loop

symbol deltime = b4			;delayed start time

symbol hrloop = w6			;loop counter for hours

;interrupt settings
symbol inlvl = %00000000		;interrupt on push button press to zero
symbol pinmask  = %00001000		;set bit for pin3 


;**************************************************************************
Main:	
	setint inlvl,pinmask		;turn interrupts on for pin3 
    
	if delay = 0 then delst		;if delay button pressed, set flag and acknowledge
	
	if hours = 0 then main		;no hours have been set so loop
	
timer:					;enter with hours = 1, 2 or 3
	if delflag = 0 then nodel	;no delay set
	
	gosub delper			;waste time for the delay period

	if rstflag = 1 then quittimer	;if reset, return to main loop

nodel:					;no delay selected

	high relay			;turn relay on
	if hours = 3 then goto locked

	do				;loop for required time
	
					;one hour time loop
	for hrloop = 1 to 360		;360 x 10 sec = 1 hr
	
		gosub flashrs		;flash LED for hours 
	
		pause  10000		;10 sec
		if rstflag = 1 then quittimer	
		if hours = 3 then goto locked
		
		setint inlvl,pinmask	;turn interrupts on     
		if rstflag = 1 then quittimer
	next hrloop
					;end of one hour time loop
					
	dec hours			;if was 2 hrs, do second hour
	loop while hours > 0

quittimer:
	low relay			;turn relay off at end of time
	hours = 0
	rstflag = 0
	low led				;make sure led is off

	goto main
		
locked:
	high led			;turn on LED, turned off in int routine
	if rstflag = 0 then locked	;stay locked until reset

	goto quittimer

delst:
	delflag = 1			;delayed start is active
	hours = 1			;this causes one quick flash
	gosub flashrs			;flash LED to acknowledge
	hours =0


del_st:
	if delay = 0 then  del_st	;wait until button released	
	
	for n = 1 to 50			;wait 5 sec for hours to be set
	pause 100			
	if hours >0 then quitwait
	if rstflag = 1 then quitwt	;resetflag set so no delay or time
	next n
	
quitwt:
	delflag =0			;hours not set, reset flag
	hours = 0
	
quitwait:
	goto main
	
	end
	
;*************************************************************************
;Interrupt service routine

interrupt:	
	rstflag = 0			;make sure reset flag is cleared on entry
	low led				;make sure LED is off

	pause 10			;debounce switch 10ms
	

timelp:					;loop for 1 sec,  
	for n = 0 to 100		;100 x 10 ms
	if pushbut = 1 then sw_open	;switch is open again
	pause 10			;pause 10 ms
	next n				;button held 1 sec if timed out

	if hours = 0 and delflag = 0 then sw_closed
					;nothing to reset
						
	gosub flash300			;acknowledge reset
	
	rstflag = 1			;set reset flag
	
sw_closed:	
	if pushbut = 0 then sw_closed	;wait for switch to open
	goto quit				

sw_open:
	hours = 1			;button pressed once & was not a reset

swopen:
	for n = n to 200		;look for another pulse 
	if pushbut = 0 then hrs		;in 2 seconds
	pause 10
	next n
	goto quit				
	
hrs:	inc hours 				

sw_closed1:	
	if pushbut = 0 then sw_closed1	;wait for switch to open
	
	if hours > 2 then goto quit
	
	if n < 200  then goto swopen	;look for third pulse
	
quit:	setint inlvl,pinmask		;re enable interrupt
	return
	
;********************************************************
delper:					;loop around and waste time

	deltime = delhrs		;delay time 
	
	do				;loop for required time
	for hrloop = 1 to 360		;360 x 10 sec = 1 hr

		gosub flash300		;this flash indicates delay
		pause 300
		gosub flashrs		;flash LED for hours 

		pause  9600		;to give a 10 sec loop 

		if rstflag = 1 then quitdel
	next hrloop
	dec deltime
	loop while deltime > 0
	
quitdel:
	delflag =0			;reset flag	
	return
;*************************************************************
flashrs:	;flash LED 1 or 2 times depending on time set
		;3 flashes is delayed start and lock on
			
	for n = 1 to hours
	high led
	pause 50			
	low led
	pause 200
	next n
	
	return
;**************************************************************
flash300:
	high led				
	pause 300				
	low led
	
	return
;**************************************************************
