#!/bin/bash
#                           Digital Alarm Clock
#                Copyright (C) 2023 - Stefan Keller-Tuberg
#                       skt@keller-tuberg.homeip.net
#
# This file is part of the Digital Alarm Clock project.
#
# The Digital Alarm Clock project is free software: you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published by the
# Free Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# The Digital Alarm Clock project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# the Digital Alarm Clock project.  If not, see <http://www.gnu.org/licenses/>.
####################################################################################################################
# make POST and GET stings available as bash variables
if [[ ! -z $CONTENT_LENGTH ]] && [[ "$CONTENT_LENGTH" -gt 0 ]] && [[ $CONTENT_TYPE != "multipart/form-data" ]] ; then
  read -n $CONTENT_LENGTH POST_STRING <&0
  eval `echo "${POST_STRING//;}"|tr '&' ';'`
fi

eval `echo "${QUERY_STRING//;}"|tr '&' ';'`
####################################################################################################################
# Note: we have not called common.sh, so the variable EXE which normally points to alarm-clock has not been set
if [[ -n "${bright}" ]] && (( $(echo "${bright} >= 0.0" | bc -l) )) && (( $(echo "${bright} <= 1.0" | bc -l) )) ; then
  alarm-clock -p "${bright}"

elif [[ -n "${volume}" ]] && [[ ${volume} -ge 0 ]] && [[ ${volume} -le 31 ]] ; then
  alarm-clock -v "${volume}"

elif [[ -n "${default_media_duration}" ]] && [[ ${default_media_duration} -ge 0 ]] && [[ ${default_media_duration} -le 180 ]] ; then
  alarm-clock -t "${default_media_duration}"

else
  # Spot errors in /var/log/apache/errors
  this is an error
fi
####################################################################################################################
# We need to output some HTML just to shut the apache warnings. Let's make it simple.
echo 'Content-type: text/html'
echo
echo '<html>'
echo ' <body>'
echo '   <p>hello world</p>'
echo ' </body>'
echo '</html>'

exit 0
