#!/bin/bash
#                           Digital Alarm Clock
#                Copyright (C) 2023,2024 - Stefan Keller-Tuberg
#                       skt@keller-tuberg.homeip.net
#
# This file is part of the Digital Alarm Clock project.
#
# The Digital Alarm Clock project is free software: you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published by the
# Free Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# The Digital Alarm Clock project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# the Digital Alarm Clock project.  If not, see <http://www.gnu.org/licenses/>.
####################################################################################################################
# Load common functions and data
INCLUDE_COMMON="common.sh"

if test -f "${INCLUDE_COMMON}" ; then
  . ${INCLUDE_COMMON}
fi

Emit_HTML_Headers

####################################################################################################################
echo ' <body>'
echo '  <div class="background">'
echo '   <fieldset>'
echo '    <legend><b>Information about the alarm-clock buttons</b></legend>'

echo "    <p>There are three kinds of buttons on the alarm-clock / media-player.</p>"
echo '    <ul>'
echo '     <li>Three <b>action</b> buttons</li>'
echo '     <li>Five <b>information / selection</b> buttons</li>'
echo '     <li>One <b>information / action</b> button</li>'
echo '    </ul>'

echo "    <p>The three 'action' buttons are used to <i>change</i> a setting and may be used either on their own or in conjunction with information / selection buttons.</p>"
echo "    <p>There are five 'information / selection' functions and these buttons may be used on their own, or in combination with each other. They will display information about an alarm time, or a duration etc, but will not change the current setting or value unless used in combination with an 'action' button.</p>"
echo "    <p>The final 'information / action' button does both of the above.</p>"
echo '   </fieldset>'
echo '   <br>'

echo '   <fieldset>'
echo '    <legend><b>Action buttons</b></legend>'

echo '    <ul>'
echo '     <li>'
echo "      <p><b>+</b> (plus)</p>"
echo "      <p>Used to increase volume or duration, or time.</p>"
echo '     </li>'

echo '     <li>'
echo "      <p><b>-</b> (minus)</p>"
echo "      <p>Used to decrease volume or duration, or time.</p>"
echo '     </li>'

echo '     <li>'
echo "      <p><b>Snooze / Pause / Stop / Toggle</b></p>"
echo "      <p>Used to pause or stop media, suspend or enable alarms and toggle settings.</p>"
echo '     </li>'

echo '     <li>'
echo "      <p><b>Duration</b></p>"
echo "      <p>If pressed and no media is currently playing, the default media stream or file will start playing.</p>"
echo '     </li>'

echo '    </ul>'
echo '   </fieldset>'
echo '   <br>'

echo '   <fieldset>'
echo '    <legend><b>Information / Selection buttons</b></legend>'

echo '    <ul>'
echo '     <li>'
echo "      <p><b>Alarms 1..4</b></p>"
echo "      <p>Used to select one of the first four alarms. The alarm clock supports many more than four alarms. Configuration and viewing of the additional alarms may be done via the web GUI.</p>"
echo '     </li>'

echo '     <li>'
echo "      <p><b>Duration</b></p>"
echo "      <p>This button is also used to select the duration of an alarm, snooze, or playback time.</p>"
echo '     </li>'

echo '     <li>'
echo "      <p><b>Media</b></p>"
echo "      <p>Used to select different media functions.</p>"
echo '     </li>'

echo '    </ul>'
echo '   </fieldset>'
echo '   <br>'

echo '   <fieldset>'
echo '    <legend><b>Alarm functions</b></legend>'
echo '    <ul>'
echo "     <li>Pressing any alarm button on its own will display the time for the associated alarm. The time will flash if the alarm is suspended.</li>"
echo "     <li>Pressing any alarm button and STOP/TOGGLE will toggle the alarm between suspended and active states.</li>"
echo "     <li>Pressing any alarm button and DURATION will display the duration of the alarm.</li>"
echo "     <li>Pressing any alarm button and MEDIA will display the volume offset for this alarm. The display flashes if the volume offset is negative.</li>"
echo "     <li>When either the alarm 1 and 3 selection buttons, or the alarm 2 and 4 selection buttons are simultaneoulsly pressed, the clock's LED display will show the HH:MM:SS countdown that remains until the next scheduled alarm. This button sequence also initiates bluetooth discovery mode.</li>"
echo "     <br>"
echo "     <li>Pressing any alarm button and either '+' or '-' will increment or decrement the alarm time. Press and hold + / - for auto-repeat.</li>"
echo "     <li>Pressing any alarm button and DURATION and either '+' or '-' will increment or decrement the duration of the alarm time.</li>"
echo "     <li>Pressing any alarm button and MEDIA and either '+' or '-' will increment or decrement the volume offset. The display flashes if the volume offset is negative.</li>"
echo '    </ul>'
echo '   </fieldset>'
echo '   <br>'

echo '   <fieldset>'
echo '    <legend><b>The Media button</b></legend>'
echo "    <p>The MEDIA button is always used in conjunction with other buttons.</p>"
echo '    <ul>'
echo "     <li>Pressing MEDIA and either '+' or '-' will skip back or forwards within the current track or playlist item.</li>"
echo "     <li>Pressing MEDIA and long pressing either '+' or '-' will will skip to next track or restart the current track or playlist item.</li>"
echo "     <li>Pressing MEDIA and very long pressing '-' will skip to previous track or playlist item.</li>"
echo "     <li>Pressing MEDIA and STOP/TOGGLE will initiate the default media stream, which is the same functionality as pressing the DURATION button. Holding down MEDIA with additional presses of the STOP/TOGGLE will rotate through the fallback stream, the radio and then back to the default media stream.</li>"
echo '    </ul>'
echo '   </fieldset>'
echo '   <br>'

echo '   <fieldset>'
echo '    <legend><b>Other media functions excluding bluetooth</b></legend>'
echo "     <p>If no media is playing yet:</p>"
echo '    <ul>'
echo "     <li>Pressing DURATION on its own will display the default media duration. Upon release of the DURATION button, the default media stream will be played.</li>"
echo "     <li>Pressing DURATION and either '+' or '-' will increment or decrement the default media duration (and will auto repeat if held down). Upon release of the DURATION button, the default media stream will be played.</li>"
echo '    </ul>'

echo "     <p>If media is currently playing:</p>"
echo '    <ul>'
echo "     <li>Pressing either '+' or '-' on its own will increase or decrease the volume.</li>"
echo "     <li>Pressing STOP/TOGGLE on its own will toggle snooze on and off. A long press will cancel the alarm or stop the stream.</li>"
echo "     <li>Pressing DURATION on its own will display the minutes of play remaining.</li>"
echo "     <li>Pressing DURATION and either '+' or '-' will increment or decrement the remaining playing time (and will auto repeat if held down).</li>"
echo "     <li>Pressing DURATION and STOP/TOGGLE will display the minutes of snooze remaining (or flash 0 if snooze not active)</li>"
echo "     <li>Pressing DURATION and STOP/TOGGLE and either '+' or '-' will increase or decrease the remaining snooze time (and will auto repeat if held down).</li>"
echo '    </ul>'

echo "    <p>The media buttons do not control bluetooth streams. Control bluetooth streams directly on the device from which the audio is streaming.</p>"
echo '   </fieldset>'
echo '   <br>'

echo '   <fieldset>'
echo '    <legend><b>Bluetooth</b></legend>'
echo "    <p>The clock will enter bluetooth discovery and pairing mode when you simultaneously press either the alarm 1 and 3 selection buttons, or the alarm 2 and 4 selection buttons. This button sequence also displays a count down until the next alarm.</p>"
echo '    <ul>'
echo "     <li>Bluetooth discovery and pairing mode lasts for three minutes. After this, you will need to reinitiate the discovery and pairing mode.</li>"
echo "     <li>After initiating discovery and pairing mode, open the bluetooth settings screen on your phone or tablet and wait until the name of the clock appears as a new device.</li>"
echo "     <li>Select the clock's name on your phone or tablet's bluetooth pairing screen to complete the pairing.</li>"
echo "     <li>The pairing procedure need only be done once. After pairing, the clock will remember your device and you can subsequently reconnect it to the clock without repeating the pairing procedure.</li>"
echo '    </ul>'

echo "    <p>If the clock and your device ever become confused and won't reconnect, use the forget pairing function on the web setup screen to reset the bluetooth pairing associations and start over.</p>"
echo "    <p>Bluetooth media is controlled on the device from which the audio is streaming. In other words, to pause and restart, or to change tracks etc, do so using the media controls on your connected device.</p>"
echo '   </fieldset>'
echo '   <br>'

echo '   <fieldset>'
echo "    <legend><b>Displaying the clock's IP address</b></legend>"
echo "    <p>The clock will display its current IP address when you simultaneously press either the alarm 1 and 4 selection buttons, or the alarm 2 and 3 selection buttons.</p>"
echo '    <ul>'
echo "     <li>An IP address consists of four dot-separated numbers, each between 0 and 255. For example '10.3.2.1' or '192.168.1.10'</li>"
echo "     <li>The clock will display each of the four numbers one at a time, for approximately two seconds each.</li>"
echo "     <li>Continue to hold the alarm selection buttons for the four-number sequence to be repeated.</li>"
echo '    </ul>'
echo "    <p>Knowing the clock's current IP address may be useful if your home router does not resolve the clock's name (eg '`hostname`.local') and you have no other simple way to determine your clock's current IP address.</p>"
echo      "<p>If you know your clock's current IP address, its web page will be accessible at 'http://[CURRENT IP ADDRESS]'. You can also ssh to your clock's current IP address or mount your clock's network share filesystem using its current IP address.</p>"
echo '   </fieldset>'

echo '  </div>'
echo ' </body>'
echo '</html>'
