///////////////////////////////////////////////////////////////////////////////////////
//                           Digital Alarm Clock
//                Copyright (C) 2023 - Stefan Keller-Tuberg
//                       skt@keller-tuberg.homeip.net
//
// This file is part of the Digital Alarm Clock project.
//
// The Digital Alarm Clock project is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the
// Free Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// The Digital Alarm Clock project is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// the Digital Alarm Clock project.  If not, see <http://www.gnu.org/licenses/>.
///////////////////////////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
///////////////////////////////////////////////////////////////////////////////////////////
// This programme will initiate a 'shutdown -r now' - but after a defined number of seconds.
// Why write a programme like this when the shutdown command already does something similar?
// Because shutdown (for some reason known only to its authors) will only accept multiples
// of minutes when specifying the delay. Sometimes, that is too long when you want to reboot
// with a small warning. It is used within the makefile, to ensure that the Pi reboots every
// time new clock software is installed. If you don't reboot, the audio sometimes screws up.
// I've not found the root cause, but assume there's a problem with pigpiod - perhaps because
// when stopping and restarting the alarm clock, the previous reference from alarm-clock to
// pigpiod is not cleaned up cleanly?

int
main (int argc, char **argv)
{
  int		i ;

  if (argc != 3)
    goto show_usage ;

  // Read the value
  if ((i = atoi(argv[1])) <= 0)
  {
    printf ("The time before reboot must be a positive integer.\n\n") ;

  show_usage:
    printf ("Usage: %s [time-in-seconds] 'Reboot message'\n", argv[0]) ;
    printf ("Display message, then reboot the Pi in the specified number of seconds.\n") ;
    return EXIT_FAILURE ;
  }

  // Display the message supplied as the second command line parameter.
  fprintf (stderr, "\n\n%s\n\n", argv[2]) ;

  // Wait the required number of seconds
  for (; i > 0 ; i--)
  {
    fprintf (stderr, "System rebooting in %d seconds. <CTRL-C> to abort!      \r", i) ;
    sleep (1) ;
  }

  fprintf (stderr, "System rebooting NOW                                   \n") ;
  system ("sudo shutdown -r now") ; // Reboot immediately, because we have already waited

  // Maybe there's no point in returning, but we will do so anyway
  return EXIT_SUCCESS ;
}
