#!/bin/bash
#                           Digital Alarm Clock
#                Copyright (C) 2023 - Stefan Keller-Tuberg
#                       skt@keller-tuberg.homeip.net
#
# This file is part of the Digital Alarm Clock project.
#
# The Digital Alarm Clock project is free software: you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published by the
# Free Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# The Digital Alarm Clock project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# the Digital Alarm Clock project.  If not, see <http://www.gnu.org/licenses/>.
####################################################################################################################
# Load common functions and data
INCLUDE_COMMON="common.sh"

if test -f "${INCLUDE_COMMON}" ; then
  . ${INCLUDE_COMMON}
fi

Emit_HTML_Headers

####################################################################################################################
echo ' <body>'
echo '  <div class="background">'
echo '   <fieldset>'
echo '    <legend><b>Streaming radio information</b></legend>'
echo "    <p>The easiest streaming links to get working will be playlist style links. These URLs generally end with <i>.pls</i>, <i>.m3u</i> or <i>.m3u8</i>.</p>"
echo "    <p>Some radio stations and indexing sites publish playlist style URLs on their web sites, and there are links to some sites below. Otherwise, you can frequently find playlist URLs embedded within the HTML code of a radio station's web site. Guidance for finding the playlist link within a radio station's web site is provided below.</p>"
echo "    <p>Some radio stations, for example some of the BBC stations, will not stream to Australian IP addresses. If you have a VPN, then choose a British IP gateway.</p>"
echo "    <p>It may be possible to stream different kinds of link to the Raspberry Pi. The alarm-clock is written around the mpv media player, so ultimately the streaming link will need to work with mpv.</p>"
echo '   </fieldset>'

echo '   <br>'
echo '   <fieldset>'
echo '    <legend><b>Links</b></legend>'
echo "    <a href='https://help.abc.net.au/hc/en-us/articles/4402927208079-Where-can-I-find-direct-stream-URLs-for-ABC-Radio-stations-'>Australian ABC Radio streams</a><br>"
echo "    <a href='https://directory.shoutcast.com/Search#'>Shoutcast</a><br>"
echo "    <a href='https://en.everybodywiki.com/List_of_BBC_radio_stream_URLs'>BBC streaming links</a><br>"
echo "    <a href='https://www.internet-radio.com'>https://www.internet-radio.com</a><br>"
echo '   </fieldset>'

echo '   <br>'
echo '   <fieldset>'
echo "    <legend><b>Tips for finding playlist links embedded in a radio station's web site</b></legend>"
echo "    <p>You may be able to discover the correct playlist link for your favourite radio station by opening a web browser to the radio station's web site and navigating to find the link or button to ‘Listen Live’ or 'Stream Live'. If its a link, just copy it into another browser URL bar and verify that the stream starts. You won’t need to follow the process outlined below if that’s the case. Otherwise, generally when the streaming site has a button such as in the example below, you’ll need to discover how the web site launches the stream and determine its URL.</p>"
echo "    <p>Most browsers support the functionality you’ll need to use to discover the streaming URL: it will be called something like Web Connection Logging (or similar) within the browser’s menus, and you’ll probably find it within the Web Development Tools (or similar) area. Review the instructions below and then, if you need, do a web search for where to find this functionality in the browser you use.</p>"
echo "    <p>The screen grab below shows a typical radio station home page with a ‘Listen Live’ button.</p>"
echo "    <img src='/00_Typical_Streaming_Site.png' class='centre'>"
echo "    <p>Once you’ve got the radio station web page that you’re interested in displayed similar to above, click on its Listen Live link just to see what happens. In the case of this particular example, the button on the home page doesn’t actually start a live stream as its label would have you believe: it instead takes you through to another web page. Not all radio streaming stations take you on such an odyssey: but to discover that hidden URL they use to start their internet stream, you’re going to need to keep clicking through their web site until your browser actually starts to play the live stream.</p>"
echo "    <img src='/01_Second_Listen_Live.png' class='centre'>"
echo "    <p>When I clicked play icon on the specific screen above, the media did actually start playing. Great! Now you know what web page hides the URL you’ll need for the clock.</p>"
echo "    <p>To work out that URL, we don’t yet actually want the media to be playing. So kill your browser window now and open a fresh window to start all over. This time, navigate to the page that started the internet stream, but stop <b>before you actually click on the play button</b> that starts the stream.</p"
echo "    <p>I mentioned the web developer functions of your browser earlier. You’ll now need to invoke them.</p>"
echo "    <p>In Firefox, this function sits under the Tools pull down menu. For the version of Firefox I am running, its then under 'Browser Tools' and then under ‘Web Developer Tools’ as you see in the screen grab below.</p>"
echo "    <img src='/02_Web_Developer_Menu.png' class='centre'>"
echo "    <p>We’re not finished yet! After you enable the Web Developer tool (or whatever its called on your browser), you’ll still need to navigate to the function that logs network connections. For Firefox, its a tab called ‘Network’ within the Web Developer section. See the screen grab below.</p>"
echo "    <img src='/03_Web_Developer_Network.png' class='centre'>"
echo "    <p>This ‘Network’ tool (or whatever its called on your browser) performs a kind-of real-time logging of the web activity as the web page opens new links. It will display those links as a list or log. For radio streams, there’s generally lots of links being opened on an ongoing basis – continuously – and so the log can become long very quickly.</p>"
echo "    <p>Keep this in mind because now its time to click on the play icon to initiate the live audio stream and your Network activity log may expand rapidly! When you can hear the beginning of the radio stream starting to play, stop or pause it to stop the log continuing to grow.</p>"
echo "    <p>Scroll through the list of URL objects <i><b>starting at the top</b></i> (i.e. from the first link that was opened). Look for a reference to a playlist file, which may have an extension such as <i><b>.pls</b></i>, <i><b>.m3u</b></i> or <i><b>.m3u8</b></i>. You may find several such playlist objects (along with possibly many different images, scripts and other non-streaming-media links) The link to the URL you are seeking will likely be in the <i><b>first</b></i> of these playlist links. That’s why its important to start at the top and work your way downwards!</p>"
echo "    <p>The screen grab below highlights the link we're interested in. I clicked on it so that it highlights in blue, and then hovered my mouse over the same place so that the full URL is revealed in a call out box so I could verify that this looked correct.</p>"
echo "    <img src='/04_Highlighted_Link.png' class='centre'>"
echo "    <p>After copying, paste the URL into a new browser window to verify that it works. If you copied the right streaming URL, you'll now hear the radio station again in the new browser window. When playing the plain vanilla streaming URL on its own, you should not expect to see any graphics or advertisements or any other information at all.</p>"
echo "    <img src='/05_Shortened_URL.png' class='centre'>"
echo "    <p>You’ll see that I shortened the URL above. All the characters in the copied URL including and after the question mark are superfluous. You can leave them there, but the internet stream will commence without all those extra characters.</p"
echo '   </fieldset>'

echo '  </div>'
echo ' </body>'
echo '</html>'
